/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.io.IOException;
import ptolemy.actor.gui.BrowserEffigy;
import ptolemy.actor.gui.BrowserLauncher;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.JNLPUtilities;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TableauFactory;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InvalidStateException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class BrowserTableau
extends Tableau {
    public BrowserTableau(BrowserEffigy container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public void setEditable(boolean flag) {
        super.setEditable(flag);
    }

    public void show() {
        String url = ((Effigy)this.getContainer()).uri.getURI().toString();
        try {
            String inBrowser;
            if (url.startsWith("jar:")) {
                String temporaryURL = null;
                try {
                    temporaryURL = JNLPUtilities.saveJarURLInClassPath(url);
                }
                catch (Exception ex) {
                    System.out.println("Failed to save '" + url + ": " + ex);
                }
                url = temporaryURL != null ? temporaryURL : JNLPUtilities.saveJarURLAsTempFile(url, "tmp", null, null);
            }
            if (url.endsWith(inBrowser = "#in_browser")) {
                url = url.substring(0, url.length() - inBrowser.length());
            }
            BrowserLauncher.openURL(url);
            try {
                this.setContainer(null);
            }
            catch (KernelException ex2) {
                throw new InvalidStateException(null, (Throwable)ex2, "setContainer(null) failed, url was " + url);
            }
        }
        catch (IOException ex) {
            throw new InvalidStateException(null, (Throwable)ex, "Failed to handle '" + url + "': ");
        }
    }

    public static class Factory
    extends TableauFactory {
        public Factory(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
        }

        public Tableau createTableau(Effigy effigy) throws Exception {
            if (effigy instanceof BrowserEffigy) {
                BrowserTableau tableau = (BrowserTableau)effigy.getEntity("browserTableau");
                if (tableau == null) {
                    tableau = new BrowserTableau((BrowserEffigy)effigy, "browserTableau");
                }
                tableau.setEditable(effigy.isModifiable());
                return tableau;
            }
            return null;
        }
    }
}

