/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Vector;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.ObjectData;
import oracle.jdbc.internal.OracleCallableStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeBFILE;
import oracle.jdbc.oracore.OracleTypeBINARY_DOUBLE;
import oracle.jdbc.oracore.OracleTypeBINARY_FLOAT;
import oracle.jdbc.oracore.OracleTypeBLOB;
import oracle.jdbc.oracore.OracleTypeCHAR;
import oracle.jdbc.oracore.OracleTypeCLOB;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeDATE;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeINTERVAL;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.jdbc.oracore.OracleTypeRAW;
import oracle.jdbc.oracore.OracleTypeREF;
import oracle.jdbc.oracore.OracleTypeSINT32;
import oracle.jdbc.oracore.OracleTypeTIMESTAMP;
import oracle.jdbc.oracore.OracleTypeTIMESTAMPLTZ;
import oracle.jdbc.oracore.OracleTypeTIMESTAMPTZ;
import oracle.jdbc.oracore.OracleTypeUPT;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSPatch;
import oracle.jdbc.oracore.TDSReader;
import oracle.jdbc.oracore.TypeTreeElement;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.jdbc.oracore.Util;
import oracle.sql.BLOB;
import oracle.sql.Datum;
import oracle.sql.JAVA_STRUCT;
import oracle.sql.NUMBER;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

public class OracleTypeADT
extends OracleNamedType
implements Serializable {
    static final long serialVersionUID = 3031304012507165702L;
    static final int S_TOP = 1;
    static final int S_EMBEDDED = 2;
    static final int S_UPT_ADT = 4;
    static final int S_JAVA_OBJECT = 16;
    static final int S_FINAL_TYPE = 32;
    static final int S_SUB_TYPE = 64;
    static final int S_ATTR_TDS = 128;
    static final int S_HAS_METADATA = 256;
    static final int S_TDS_PARSED = 512;
    private int statusBits = 1;
    int tdsVersion = -9999;
    static final int KOPT_V80 = 1;
    static final int KOPT_V81 = 2;
    static final int KOPT_VNFT = 3;
    static final int KOPT_VERSION = 3;
    boolean endOfAdt = false;
    int typeVersion = -1;
    byte[] lds = null;
    long[] ldsOffsetArray = null;
    long fixedDataSize = -1L;
    int alignmentRequirement = -1;
    OracleType[] attrTypes = null;
    String[] attrNames;
    String[] attrTypeNames;
    public long tdoCState = 0L;
    byte[] toid = null;
    byte[] fdo;
    int charSetId;
    int charSetForm;
    boolean bigEndian;
    int flattenedAttrNum;
    transient int opcode;
    transient int idx = 1;
    static final int CURRENT_USER_OBJECT = 0;
    static final int CURRENT_USER_SYNONYM = 1;
    static final int CURRENT_USER_PUBLIC_SYNONYM = 2;
    static final int OTHER_USER_OBJECT = 3;
    static final int OTHER_USER_SYNONYM = 4;
    static final int PUBLIC_SYNONYM = 5;
    static final int BREAK = 6;
    static final String[] sqlString = new String[]{"SELECT /*+ RULE */ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM USER_TYPE_ATTRS WHERE TYPE_NAME = :1 ORDER BY ATTR_NO", "SELECT /*+ RULE */ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM USER_TYPE_ATTRS WHERE TYPE_NAME in (SELECT TABLE_NAME FROM USER_SYNONYMS START WITH SYNONYM_NAME = :1 CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME UNION SELECT :1 FROM DUAL) ORDER BY ATTR_NO", "SELECT /*+RULE*/ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM USER_TYPE_ATTRS WHERE TYPE_NAME IN (SELECT TABLE_NAME FROM ALL_SYNONYMS START WITH SYNONYM_NAME = :1 AND  OWNER = 'PUBLIC' CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER UNION SELECT :2  FROM DUAL) ORDER BY ATTR_NO", "SELECT /*+ RULE */ ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM ALL_TYPE_ATTRS WHERE OWNER = :1 AND TYPE_NAME = :2 ORDER BY ATTR_NO", "SELECT /*+ RULE */ ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM ALL_TYPE_ATTRS WHERE OWNER = (SELECT TABLE_OWNER FROM ALL_SYNONYMS WHERE SYNONYM_NAME=:1) AND TYPE_NAME = (SELECT TABLE_NAME FROM ALL_SYNONYMS WHERE SYNONYM_NAME=:2) ORDER BY ATTR_NO", "DECLARE /*+RULE*/  the_owner VARCHAR2(100);   the_type  VARCHAR2(100); begin  SELECT /*+ RULE */TABLE_NAME, TABLE_OWNER INTO THE_TYPE, THE_OWNER  FROM ALL_SYNONYMS  WHERE TABLE_NAME IN (SELECT TYPE_NAME FROM ALL_TYPES)  START WITH SYNONYM_NAME = :1 AND OWNER = 'PUBLIC'  CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER; OPEN :2 FOR SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME,  ATTR_TYPE_OWNER FROM ALL_TYPE_ATTRS  WHERE TYPE_NAME = THE_TYPE and OWNER = THE_OWNER; END;"};
    static final int TDS_SIZE = 4;
    static final int TDS_NUMBER = 1;
    static final int KOPM_OTS_SQL_CHAR = 1;
    static final int KOPM_OTS_DATE = 2;
    static final int KOPM_OTS_DECIMAL = 3;
    static final int KOPM_OTS_DOUBLE = 4;
    static final int KOPM_OTS_FLOAT = 5;
    static final int KOPM_OTS_NUMBER = 6;
    static final int KOPM_OTS_SQL_VARCHAR2 = 7;
    static final int KOPM_OTS_SINT32 = 8;
    static final int KOPM_OTS_REF = 9;
    static final int KOPM_OTS_VARRAY = 10;
    static final int KOPM_OTS_UINT8 = 11;
    static final int KOPM_OTS_SINT8 = 12;
    static final int KOPM_OTS_UINT16 = 13;
    static final int KOPM_OTS_UINT32 = 14;
    static final int KOPM_OTS_LOB = 15;
    static final int KOPM_OTS_CANONICAL = 17;
    static final int KOPM_OTS_OCTET = 18;
    static final int KOPM_OTS_RAW = 19;
    static final int KOPM_OTS_ROWID = 20;
    static final int KOPM_OTS_STAMP = 21;
    static final int KOPM_OTS_TZSTAMP = 23;
    static final int KOPM_OTS_INTERVAL = 24;
    static final int KOPM_OTS_PTR = 25;
    static final int KOPM_OTS_SINT16 = 26;
    static final int KOPM_OTS_UPT = 27;
    static final int KOPM_OTS_COLLECTION = 28;
    static final int KOPM_OTS_CLOB = 29;
    static final int KOPM_OTS_BLOB = 30;
    static final int KOPM_OTS_BFILE = 31;
    static final int KOPM_OTS_BINARY_INTEGE = 32;
    static final int KOPM_OTS_IMPTZSTAMP = 33;
    static final int KOPM_OTS_BFLOAT = 37;
    static final int KOPM_OTS_BDOUBLE = 45;
    static final int KOTTCOPQ = 58;
    static final int KOPT_OP_STARTEMBADT = 39;
    static final int KOPT_OP_ENDEMBADT = 40;
    static final int KOPT_OP_STARTADT = 41;
    static final int KOPT_OP_ENDADT = 42;
    static final int KOPT_OP_SUBTYPE_MARKER = 43;
    static final int KOPT_OP_EMBADT_INFO = 44;
    static final int KOPT_OPCODE_START = 38;
    static final int KOPT_OP_VERSION = 38;
    static final int REGULAR_PATCH = 0;
    static final int SIMPLE_PATCH = 1;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Tue_Jan_24_08:54:26_PST_2006";

    protected OracleTypeADT() {
    }

    public OracleTypeADT(byte[] byArray, int n, int n2, short s, String string) throws SQLException {
        this(string, (Connection)null);
        this.toid = byArray;
        this.typeVersion = n;
        this.charSetId = n2;
        this.charSetForm = s;
    }

    public OracleTypeADT(String string, Connection connection) throws SQLException {
        super(string, (OracleConnection)connection);
    }

    public OracleTypeADT(String string, Connection connection, byte[] byArray) throws SQLException {
        this(string, connection);
        this.fdo = byArray;
        this.initEndianess(byArray);
    }

    public OracleTypeADT(OracleTypeADT oracleTypeADT, int n, Connection connection) throws SQLException {
        super(oracleTypeADT, n, (OracleConnection)connection);
    }

    public OracleTypeADT(OracleTypeADT oracleTypeADT, int n, Connection connection, byte[] byArray) throws SQLException {
        this(oracleTypeADT, n, connection);
        this.fdo = byArray;
        this.initEndianess(byArray);
    }

    public OracleTypeADT(SQLName sQLName, byte[] byArray, int n, byte[] byArray2, byte[] byArray3, OracleConnection oracleConnection, byte[] byArray4) throws SQLException {
        this.fdo = byArray4;
        this.init(byArray2, oracleConnection);
        this.toid = byArray;
        this.typeVersion = n;
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        if (object != null) {
            if (object instanceof STRUCT) {
                return (STRUCT)object;
            }
            if (object instanceof SQLData || object instanceof ObjectData) {
                return STRUCT.toSTRUCT(object, oracleConnection);
            }
            if (object instanceof Object[]) {
                StructDescriptor structDescriptor = this.createStructDescriptor();
                STRUCT sTRUCT = this.createObjSTRUCT(structDescriptor, (Object[])object);
                return sTRUCT;
            }
            DatabaseError.throwSqlException(59, object);
        }
        return null;
    }

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l, int n) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                int n2 = (int)(n == -1 ? (long)objectArray.length : Math.min((long)objectArray.length - l + 1L, (long)n));
                datumArray = new Datum[n2];
                for (int i = 0; i < n2; ++i) {
                    datumArray[i] = this.toDatum(objectArray[(int)l + i - 1], oracleConnection);
                }
            } else {
                DatabaseError.throwSqlException(59, object);
            }
        }
        return datumArray;
    }

    public int getTypeCode() throws SQLException {
        if ((this.getStatus() & 0x10) != 0) {
            return 2008;
        }
        return 2002;
    }

    public OracleType[] getAttrTypes() throws SQLException {
        if (this.attrTypes == null) {
            this.init(this.connection);
        }
        return this.attrTypes;
    }

    public boolean isInHierarchyOf(OracleType oracleType) throws SQLException {
        if (oracleType == null) {
            return false;
        }
        if (!oracleType.isObjectType()) {
            return false;
        }
        StructDescriptor structDescriptor = (StructDescriptor)oracleType.getTypeDescriptor();
        return this.descriptor.isInHierarchyOf(structDescriptor.getName());
    }

    public boolean isInHierarchyOf(StructDescriptor structDescriptor) throws SQLException {
        if (structDescriptor == null) {
            return false;
        }
        return this.descriptor.isInHierarchyOf(structDescriptor.getName());
    }

    public boolean isObjectType() {
        return true;
    }

    public TypeDescriptor getTypeDescriptor() {
        return this.descriptor;
    }

    public synchronized void init(OracleConnection oracleConnection) throws SQLException {
        byte[] byArray = this.initMetadata(oracleConnection);
        this.init(byArray, oracleConnection);
    }

    public synchronized void init(byte[] byArray, OracleConnection oracleConnection) throws SQLException {
        this.statusBits = 1;
        this.connection = oracleConnection;
        if (byArray != null) {
            this.parseTDS(byArray, 0L);
        }
        this.bigEndian = this.connection.getBigEndian();
        this.setStatusBits(256);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] initMetadata(OracleConnection oracleConnection) throws SQLException {
        byte[] byArray = null;
        if ((this.statusBits & 0x100) != 0) {
            return null;
        }
        if (this.sqlName == null) {
            this.getFullName();
        }
        OracleConnection oracleConnection2 = oracleConnection;
        synchronized (oracleConnection2) {
            OracleTypeADT oracleTypeADT = this;
            synchronized (oracleTypeADT) {
                if ((this.statusBits & 0x100) == 0) {
                    Statement statement = null;
                    try {
                        if (this.tdoCState == 0L) {
                            this.tdoCState = this.connection.getTdoCState(this.sqlName.getSchema(), this.sqlName.getSimpleName());
                        }
                        String string = null;
                        this.fdo = this.connection.getFDO(false);
                        boolean bl = this.fdo == null;
                        string = !bl ? "begin :1 := dbms_pickler.get_type_shape(:2,:3,:4,:5,:6,:7); end;" : "begin :1 := dbms_pickler.get_type_shape(:2,:3,:4,:5,:6,:7);       :8 := dbms_pickler.get_format(:9); end;";
                        boolean bl2 = false;
                        statement = this.connection.prepareCall(string);
                        statement.registerOutParameter(1, 2);
                        statement.registerOutParameter(4, -4);
                        statement.registerOutParameter(5, 4);
                        statement.registerOutParameter(6, -4);
                        statement.registerOutParameter(7, -4);
                        if (bl) {
                            statement.registerOutParameter(8, 2);
                            statement.registerOutParameter(9, -4);
                        }
                        statement.setString(2, this.sqlName.getSchema());
                        statement.setString(3, this.sqlName.getSimpleName());
                        statement.execute();
                        int n = statement.getInt(1);
                        if (n != 0) {
                            if (n != 24331) {
                                DatabaseError.throwSqlException(74, this.sqlName.toString());
                            }
                            if (n == 24331) {
                                bl2 = true;
                                statement.registerOutParameter(6, 2004);
                                statement.execute();
                                n = statement.getInt(1);
                                if (n != 0) {
                                    DatabaseError.throwSqlException(74, this.sqlName.toString());
                                }
                            }
                        }
                        if (bl && statement.getInt(8) != 0) {
                            DatabaseError.throwSqlException(1, "dbms_pickler.get_format()");
                        }
                        this.toid = statement.getBytes(4);
                        this.typeVersion = NUMBER.toInt(statement.getBytes(5));
                        if (!bl2) {
                            byArray = statement.getBytes(6);
                        } else {
                            try {
                                Blob blob = ((OracleCallableStatement)statement).getBlob(6);
                                InputStream inputStream = blob.getBinaryStream();
                                byArray = new byte[(int)blob.length()];
                                inputStream.read(byArray);
                                inputStream.close();
                                ((BLOB)blob).freeTemporary();
                            }
                            catch (IOException iOException) {
                                DatabaseError.throwSqlException(iOException);
                            }
                        }
                        if (bl) {
                            this.fdo = statement.getBytes(9);
                            this.connection.setFDO(this.fdo);
                        }
                        this.flattenedAttrNum = Util.getUnsignedByte(byArray[8]) * 256 + Util.getUnsignedByte(byArray[9]);
                        statement.getBytes(7);
                    }
                    finally {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                }
                this.setStatusBits(256);
            }
        }
        return byArray;
    }

    private void initEndianess(byte[] byArray) {
        int[] nArray = Util.toJavaUnsignedBytes(byArray);
        int n = nArray[6 + nArray[5] + nArray[6] + 5];
        int n2 = n & 0x10;
        if (n2 < 0) {
            n2 += 256;
        }
        this.bigEndian = n2 > 0;
    }

    void parseLDS(InputStream inputStream) throws SQLException {
        long l = Util.readLong(inputStream);
        this.fixedDataSize = Util.readLong(inputStream);
        this.ldsOffsetArray = new long[this.flattenedAttrNum];
        for (int i = 0; i < this.flattenedAttrNum; ++i) {
            this.ldsOffsetArray[i] = Util.readLong(inputStream);
        }
    }

    public void generateLDS() throws SQLException {
        Vector vector = this.generateLDSrec();
        this.ldsOffsetArray = new long[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            Integer n = (Integer)vector.elementAt(i);
            this.ldsOffsetArray[i] = n.longValue();
        }
    }

    private Vector generateLDSrec() throws SQLException {
        int n = 0;
        int n2 = 0;
        Vector<Integer> vector = new Vector<Integer>();
        int n3 = this.getNumAttrs();
        for (int i = 0; i < n3; ++i) {
            int n4;
            int n5;
            Vector vector2 = null;
            OracleType oracleType = this.getAttrTypeAt(i);
            if (oracleType instanceof OracleTypeADT && !(oracleType instanceof OracleTypeCOLLECTION) && !(oracleType instanceof OracleTypeUPT)) {
                vector2 = ((OracleTypeADT)oracleType).generateLDSrec();
                n5 = ((OracleTypeADT)oracleType).getAlignmentReq();
                n4 = (int)((OracleTypeADT)oracleType).getFixedDataSize();
            } else {
                n4 = oracleType.getSizeLDS(this.fdo);
                n5 = oracleType.getAlignLDS(this.fdo);
            }
            if ((n & n5) > 0) {
                n = Util.ldsRound(n, n5);
            }
            if (oracleType instanceof OracleTypeADT && !(oracleType instanceof OracleTypeCOLLECTION) && !(oracleType instanceof OracleTypeUPT)) {
                for (int j = 0; j < vector2.size(); ++j) {
                    Integer n6 = (Integer)vector2.elementAt(j);
                    Integer n7 = new Integer(n6 + n);
                    vector.addElement(n7);
                }
            } else {
                vector.addElement(new Integer(n));
            }
            n += n4;
            if (n5 <= n2) continue;
            n2 = n5;
        }
        if ((n & n2) > 0) {
            n = Util.ldsRound(n, n2);
        }
        this.alignmentRequirement = n2;
        this.fixedDataSize = n;
        return vector;
    }

    TDSReader parseTDS(byte[] byArray, long l) throws SQLException {
        if (this.attrTypes != null) {
            return null;
        }
        TDSReader tDSReader = new TDSReader(byArray, l);
        long l2 = tDSReader.readLong() + tDSReader.offset();
        tDSReader.checkNextByte((byte)38);
        this.tdsVersion = tDSReader.readByte();
        tDSReader.skipBytes(2);
        this.flattenedAttrNum = tDSReader.readShort();
        if ((tDSReader.readByte() & 0xFF) == 255) {
            this.setStatusBits(128);
        }
        long l3 = tDSReader.offset();
        tDSReader.checkNextByte((byte)41);
        if (tDSReader.readShort() != 0) {
            DatabaseError.throwSqlException(47, "parseTDS");
        }
        long l4 = tDSReader.readLong();
        this.parseTDSrec(tDSReader);
        if (this.tdsVersion >= 3) {
            tDSReader.skip_to(l3 + l4 + 2L);
            tDSReader.skipBytes(2 * this.flattenedAttrNum);
            byte by = tDSReader.readByte();
            if (tDSReader.isJavaObject(this.tdsVersion, by)) {
                this.setStatusBits(16);
            }
            if (tDSReader.isFinalType(this.tdsVersion, by)) {
                this.setStatusBits(32);
            }
            if (tDSReader.readByte() != 1) {
                this.setStatusBits(64);
            }
        } else {
            this.setStatusBits(32);
        }
        tDSReader.skip_to(l2);
        return tDSReader;
    }

    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        Vector<OracleType> vector = new Vector<OracleType>(5);
        OracleType oracleType = null;
        this.nullOffset = tDSReader.nullOffset++;
        this.ldsOffset = tDSReader.ldsOffset;
        this.idx = 1;
        while ((oracleType = this.getNextTypeObject(tDSReader)) != null) {
            vector.addElement(oracleType);
        }
        if (this.opcode == 42) {
            this.endOfAdt = true;
            this.applyTDSpatches(tDSReader);
        }
        this.attrTypes = new OracleType[vector.size()];
        vector.copyInto(this.attrTypes);
    }

    private void applyTDSpatches(TDSReader tDSReader) throws SQLException {
        TDSPatch tDSPatch = tDSReader.getNextPatch();
        while (tDSPatch != null) {
            tDSReader.moveToPatchPos(tDSPatch);
            int n = tDSPatch.getType();
            if (n == 0) {
                tDSReader.readByte();
                byte by = tDSPatch.getUptTypeCode();
                switch (by) {
                    case -6: {
                        tDSReader.readLong();
                    }
                    case -5: {
                        OracleNamedType oracleNamedType = tDSPatch.getOwner();
                        OracleTypeADT oracleTypeADT = null;
                        oracleTypeADT = oracleNamedType.hasName() ? new OracleTypeADT(oracleNamedType.getFullName(), this.connection, this.fdo) : new OracleTypeADT(oracleNamedType.getParent(), oracleNamedType.getOrder(), this.connection, this.fdo);
                        oracleTypeADT.setUptADT();
                        TDSReader tDSReader2 = oracleTypeADT.parseTDS(tDSReader.tds(), tDSReader.absoluteOffset());
                        tDSReader.skipBytes((int)tDSReader2.offset());
                        tDSPatch.apply(oracleTypeADT.cleanup());
                        break;
                    }
                    case 58: {
                        OracleNamedType oracleNamedType = tDSPatch.getOwner();
                        OracleTypeADT oracleTypeADT = null;
                        oracleTypeADT = oracleNamedType.hasName() ? new OracleTypeOPAQUE(oracleNamedType.getFullName(), this.connection) : new OracleTypeOPAQUE(oracleNamedType.getParent(), oracleNamedType.getOrder(), this.connection);
                        ((OracleTypeOPAQUE)oracleTypeADT).parseTDSrec(tDSReader);
                        tDSPatch.apply(oracleTypeADT);
                        break;
                    }
                    default: {
                        DatabaseError.throwSqlException(1);
                        break;
                    }
                }
            } else if (n == 1) {
                OracleType oracleType = this.getNextTypeObject(tDSReader);
                tDSPatch.apply(oracleType, this.opcode);
            } else {
                DatabaseError.throwSqlException(47, "parseTDS");
            }
            tDSPatch = tDSReader.getNextPatch();
        }
    }

    public synchronized OracleNamedType cleanup() {
        if (this.attrTypes.length == 1 && this.attrTypes[0] instanceof OracleTypeCOLLECTION) {
            OracleTypeCOLLECTION oracleTypeCOLLECTION = (OracleTypeCOLLECTION)this.attrTypes[0];
            oracleTypeCOLLECTION.copy_properties(this);
            return oracleTypeCOLLECTION;
        }
        if (this.attrTypes.length == 1 && (this.statusBits & 0x80) != 0 && this.attrTypes[0] instanceof OracleTypeUPT && ((OracleTypeUPT)this.attrTypes[0]).realType instanceof OracleTypeOPAQUE) {
            OracleTypeOPAQUE oracleTypeOPAQUE = (OracleTypeOPAQUE)((OracleTypeUPT)this.attrTypes[0]).realType;
            oracleTypeOPAQUE.copy_properties(this);
            return oracleTypeOPAQUE;
        }
        return this;
    }

    void copy_properties(OracleTypeADT oracleTypeADT) {
        this.sqlName = oracleTypeADT.sqlName;
        this.parent = oracleTypeADT.parent;
        this.idx = oracleTypeADT.idx;
        this.connection = oracleTypeADT.connection;
        this.lds = oracleTypeADT.lds;
        this.toid = oracleTypeADT.toid;
        this.fdo = oracleTypeADT.fdo;
        this.tdsVersion = oracleTypeADT.tdsVersion;
        this.typeVersion = oracleTypeADT.typeVersion;
        this.tdoCState = oracleTypeADT.tdoCState;
        this.nullOffset = oracleTypeADT.nullOffset;
        this.bigEndian = oracleTypeADT.bigEndian;
        this.endOfAdt = oracleTypeADT.endOfAdt;
    }

    OracleType getNextTypeObject(TDSReader tDSReader) throws SQLException {
        while (true) {
            this.opcode = tDSReader.readByte();
            if (this.opcode == 43) continue;
            if (this.opcode != 44) break;
            byte by = tDSReader.readByte();
            if (!tDSReader.isJavaObject(3, by)) continue;
            this.setStatusBits(16);
        }
        switch (this.opcode) {
            case 40: 
            case 42: {
                return null;
            }
            case 2: {
                OracleTypeDATE oracleTypeDATE = new OracleTypeDATE();
                oracleTypeDATE.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeDATE;
            }
            case 7: {
                OracleTypeCHAR oracleTypeCHAR = new OracleTypeCHAR(this.connection, 12);
                oracleTypeCHAR.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeCHAR;
            }
            case 1: {
                OracleTypeCHAR oracleTypeCHAR = new OracleTypeCHAR(this.connection, 1);
                oracleTypeCHAR.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeCHAR;
            }
            case 39: {
                OracleTypeADT oracleTypeADT = new OracleTypeADT(this, this.idx, this.connection, this.fdo);
                oracleTypeADT.setEmbeddedADT();
                oracleTypeADT.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeADT;
            }
            case 6: {
                OracleTypeNUMBER oracleTypeNUMBER = new OracleTypeNUMBER(2);
                oracleTypeNUMBER.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeNUMBER;
            }
            case 3: {
                OracleTypeNUMBER oracleTypeNUMBER = new OracleTypeNUMBER(3);
                oracleTypeNUMBER.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeNUMBER;
            }
            case 4: {
                OracleTypeNUMBER oracleTypeNUMBER = new OracleTypeNUMBER(8);
                oracleTypeNUMBER.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeNUMBER;
            }
            case 5: {
                OracleTypeFLOAT oracleTypeFLOAT = new OracleTypeFLOAT();
                oracleTypeFLOAT.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeFLOAT;
            }
            case 37: {
                OracleTypeBINARY_FLOAT oracleTypeBINARY_FLOAT = new OracleTypeBINARY_FLOAT();
                oracleTypeBINARY_FLOAT.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeBINARY_FLOAT;
            }
            case 45: {
                OracleTypeBINARY_DOUBLE oracleTypeBINARY_DOUBLE = new OracleTypeBINARY_DOUBLE();
                oracleTypeBINARY_DOUBLE.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeBINARY_DOUBLE;
            }
            case 8: {
                OracleTypeSINT32 oracleTypeSINT32 = new OracleTypeSINT32();
                oracleTypeSINT32.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeSINT32;
            }
            case 9: {
                OracleTypeREF oracleTypeREF = new OracleTypeREF(this, this.idx, this.connection);
                oracleTypeREF.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeREF;
            }
            case 31: {
                OracleTypeBFILE oracleTypeBFILE = new OracleTypeBFILE(this.connection);
                oracleTypeBFILE.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeBFILE;
            }
            case 19: {
                OracleTypeRAW oracleTypeRAW = new OracleTypeRAW();
                oracleTypeRAW.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeRAW;
            }
            case 29: {
                OracleTypeCLOB oracleTypeCLOB = new OracleTypeCLOB(this.connection);
                oracleTypeCLOB.parseTDSrec(tDSReader);
                if (this.sqlName != null && !this.endOfAdt) {
                    this.connection.getForm(this, oracleTypeCLOB, this.idx);
                }
                ++this.idx;
                return oracleTypeCLOB;
            }
            case 30: {
                OracleTypeBLOB oracleTypeBLOB = new OracleTypeBLOB(this.connection);
                oracleTypeBLOB.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeBLOB;
            }
            case 21: {
                OracleTypeTIMESTAMP oracleTypeTIMESTAMP = new OracleTypeTIMESTAMP(this.connection);
                oracleTypeTIMESTAMP.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeTIMESTAMP;
            }
            case 23: {
                OracleTypeTIMESTAMPTZ oracleTypeTIMESTAMPTZ = new OracleTypeTIMESTAMPTZ(this.connection);
                oracleTypeTIMESTAMPTZ.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeTIMESTAMPTZ;
            }
            case 33: {
                OracleTypeTIMESTAMPLTZ oracleTypeTIMESTAMPLTZ = new OracleTypeTIMESTAMPLTZ(this.connection);
                oracleTypeTIMESTAMPLTZ.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeTIMESTAMPLTZ;
            }
            case 24: {
                OracleTypeINTERVAL oracleTypeINTERVAL = new OracleTypeINTERVAL(this.connection);
                oracleTypeINTERVAL.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeINTERVAL;
            }
            case 28: {
                OracleTypeCOLLECTION oracleTypeCOLLECTION = new OracleTypeCOLLECTION(this, this.idx, this.connection);
                oracleTypeCOLLECTION.bigEndian = this.bigEndian;
                oracleTypeCOLLECTION.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeCOLLECTION;
            }
            case 27: {
                OracleTypeUPT oracleTypeUPT = new OracleTypeUPT(this, this.idx, this.connection);
                oracleTypeUPT.bigEndian = this.bigEndian;
                oracleTypeUPT.parseTDSrec(tDSReader);
                ++this.idx;
                return oracleTypeUPT;
            }
        }
        Object var2_25 = null;
        DatabaseError.throwSqlException(48, "get_next_type: " + this.opcode);
        return null;
    }

    public synchronized byte[] linearize(Datum datum) throws SQLException {
        return this.pickle81(datum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum unlinearize(byte[] byArray, long l, Datum datum, int n, Map map) throws SQLException {
        OracleConnection oracleConnection = this.getConnection();
        Datum datum2 = null;
        if (oracleConnection == null) {
            datum2 = this._unlinearize(byArray, l, datum, n, map);
        } else {
            OracleConnection oracleConnection2 = oracleConnection;
            synchronized (oracleConnection2) {
                datum2 = this._unlinearize(byArray, l, datum, n, map);
            }
        }
        return datum2;
    }

    public synchronized Datum _unlinearize(byte[] byArray, long l, Datum datum, int n, Map map) throws SQLException {
        if (byArray == null) {
            return null;
        }
        if (PickleContext.is81format(byArray[0])) {
            PickleContext pickleContext = new PickleContext(byArray, l);
            return this.unpickle81(pickleContext, (STRUCT)datum, 1, n, map);
        }
        UnpickleContext unpickleContext = new UnpickleContext(byArray, (int)l, null, null, this.bigEndian);
        return this.unpickle80(unpickleContext, (STRUCT)datum, 1, n, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected STRUCT unpickle80(UnpickleContext unpickleContext, STRUCT sTRUCT, int n, int n2, Map map) throws SQLException {
        long l;
        STRUCT sTRUCT2 = sTRUCT;
        if (n == 3) {
            if (sTRUCT2 == null) {
                StructDescriptor structDescriptor = this.createStructDescriptor();
                sTRUCT2 = this.createByteSTRUCT(structDescriptor, null);
            }
            sTRUCT2.setImage(unpickleContext.image(), unpickleContext.absoluteOffset(), 0L);
        }
        if ((l = unpickleContext.readLong()) == 0L) {
            return null;
        }
        if (n == 9) {
            unpickleContext.skipBytes((int)l);
            return sTRUCT2;
        }
        if (n == 3) {
            sTRUCT2.setImageLength(l + 4L);
            unpickleContext.skipBytes((int)l);
            return sTRUCT2;
        }
        unpickleContext.skipBytes(1);
        byte by = unpickleContext.readByte();
        boolean[] blArray = this.unpickle_nulls(unpickleContext);
        long l2 = unpickleContext.readLong();
        long l3 = (long)unpickleContext.offset() + l2;
        try {
            if (!blArray[0]) {
                UnpickleContext unpickleContext2 = new UnpickleContext(unpickleContext.image(), unpickleContext.absoluteOffset(), blArray, this.getLdsOffsetArray(), this.bigEndian);
                STRUCT sTRUCT3 = this.unpickle80rec(unpickleContext2, sTRUCT2, n2, map);
                return sTRUCT3;
            }
        }
        finally {
            unpickleContext.skipTo(l3);
        }
        return sTRUCT2;
    }

    protected Object unpickle80rec(UnpickleContext unpickleContext, int n, int n2, Map map) throws SQLException {
        STRUCT sTRUCT = this.unpickle80rec(unpickleContext, null, 1, map);
        return this.toObject(sTRUCT, n2, map);
    }

    private STRUCT unpickle80rec(UnpickleContext unpickleContext, STRUCT sTRUCT, int n, Map map) throws SQLException {
        Object[] objectArray;
        if (unpickleContext.isNull(this.nullOffset)) {
            return null;
        }
        unpickleContext.skipTo(unpickleContext.ldsOffsets[this.ldsOffset]);
        int n2 = this.getNumAttrs();
        STRUCT sTRUCT2 = sTRUCT;
        if (sTRUCT2 == null) {
            objectArray = this.createStructDescriptor();
            sTRUCT2 = this.createByteSTRUCT((StructDescriptor)objectArray, null);
        }
        switch (n) {
            case 1: {
                objectArray = new Datum[n2];
                for (int i = 0; i < n2; ++i) {
                    objectArray[i] = (Datum)this.getAttrTypeAt(i).unpickle80rec(unpickleContext, 1, n, map);
                }
                sTRUCT2.setDatumArray((Datum[])objectArray);
                break;
            }
            case 2: {
                objectArray = new Object[n2];
                for (int i = 0; i < n2; ++i) {
                    objectArray[i] = this.getAttrTypeAt(i).unpickle80rec(unpickleContext, 1, n, map);
                }
                sTRUCT2.setObjArray(objectArray);
                break;
            }
            default: {
                DatabaseError.throwSqlException(1);
            }
        }
        return sTRUCT2;
    }

    private boolean[] unpickle_nulls(UnpickleContext unpickleContext) throws SQLException {
        unpickleContext.skipBytes(4);
        byte[] byArray = unpickleContext.readLengthBytes();
        boolean[] blArray = new boolean[(byArray.length - 2) * 4];
        int n = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (i % 4 == 0) {
                n = byArray[2 + i / 4];
            }
            blArray[i] = (n & 3) != 0;
            n = (byte)(n >> 2);
        }
        return blArray;
    }

    protected STRUCT unpickle81(PickleContext pickleContext, STRUCT sTRUCT, int n, int n2, Map map) throws SQLException {
        STRUCT sTRUCT2 = sTRUCT;
        long l = pickleContext.offset();
        byte by = pickleContext.readByte();
        if (!PickleContext.is81format(by)) {
            DatabaseError.throwSqlException(1, "Image is not in 8.1 format");
        }
        if (PickleContext.isCollectionImage_pctx(by)) {
            DatabaseError.throwSqlException(1, "Image is a collection image, expecting ADT");
        }
        if (!pickleContext.readAndCheckVersion()) {
            DatabaseError.throwSqlException(1, "Image version is not recognized");
        }
        block0 : switch (n) {
            case 9: {
                pickleContext.skipBytes(pickleContext.readLength(true) - 2);
                break;
            }
            case 3: {
                long l2 = pickleContext.readLength();
                sTRUCT2 = this.unpickle81Prefix(pickleContext, sTRUCT2, by);
                if (sTRUCT2 == null) {
                    StructDescriptor structDescriptor = this.createStructDescriptor();
                    sTRUCT2 = this.createByteSTRUCT(structDescriptor, null);
                }
                sTRUCT2.setImage(pickleContext.image(), l, 0L);
                sTRUCT2.setImageLength(l2);
                pickleContext.skipTo(l + l2);
                break;
            }
            default: {
                OracleType[] oracleTypeArray;
                pickleContext.skipLength();
                sTRUCT2 = this.unpickle81Prefix(pickleContext, sTRUCT2, by);
                if (sTRUCT2 == null) {
                    oracleTypeArray = this.createStructDescriptor();
                    sTRUCT2 = this.createByteSTRUCT((StructDescriptor)oracleTypeArray, null);
                }
                oracleTypeArray = sTRUCT2.getDescriptor().getOracleTypeADT().getAttrTypes();
                switch (n2) {
                    case 1: {
                        Datum[] datumArray = new Datum[oracleTypeArray.length];
                        for (int i = 0; i < oracleTypeArray.length; ++i) {
                            datumArray[i] = (Datum)oracleTypeArray[i].unpickle81rec(pickleContext, n2, map);
                        }
                        sTRUCT2.setDatumArray(datumArray);
                        break block0;
                    }
                    case 2: {
                        Object[] objectArray = new Object[oracleTypeArray.length];
                        for (int i = 0; i < oracleTypeArray.length; ++i) {
                            objectArray[i] = oracleTypeArray[i].unpickle81rec(pickleContext, n2, map);
                        }
                        sTRUCT2.setObjArray(objectArray);
                        break block0;
                    }
                }
                DatabaseError.throwSqlException(1);
            }
        }
        return sTRUCT2;
    }

    protected STRUCT unpickle81Prefix(PickleContext pickleContext, STRUCT sTRUCT, byte by) throws SQLException {
        STRUCT sTRUCT2 = sTRUCT;
        if (PickleContext.hasPrefix(by)) {
            boolean bl;
            long l = pickleContext.readLength() + pickleContext.absoluteOffset();
            byte by2 = pickleContext.readByte();
            byte by3 = (byte)(by2 & 0xC);
            boolean bl2 = by3 == 0;
            boolean bl3 = by3 == 4;
            boolean bl4 = by3 == 8;
            boolean bl5 = by3 == 12;
            boolean bl6 = bl = (by2 & 0x10) != 0;
            if (bl3) {
                byte[] byArray = pickleContext.readBytes(16);
                String string = OracleTypeADT.toid2typename(this.connection, byArray);
                StructDescriptor structDescriptor = (StructDescriptor)TypeDescriptor.getTypeDescriptor(string, this.connection);
                if (sTRUCT2 == null) {
                    sTRUCT2 = this.createByteSTRUCT(structDescriptor, null);
                } else {
                    sTRUCT2.setDescriptor(structDescriptor);
                }
            }
            this.typeVersion = bl ? pickleContext.readLength() : 1;
            if (bl4 | bl5) {
                DatabaseError.throwSqlException(23);
            }
            pickleContext.skipTo(l);
        }
        return sTRUCT2;
    }

    protected Object unpickle81rec(PickleContext pickleContext, int n, Map map) throws SQLException {
        byte by = pickleContext.readByte();
        byte by2 = 0;
        if (PickleContext.isAtomicNull(by)) {
            return null;
        }
        if (PickleContext.isImmediatelyEmbeddedNull(by)) {
            by2 = pickleContext.readByte();
        }
        STRUCT sTRUCT = this.unpickle81datum(pickleContext, by, by2);
        return this.toObject(sTRUCT, n, map);
    }

    protected Object unpickle81rec(PickleContext pickleContext, byte by, int n, Map map) throws SQLException {
        STRUCT sTRUCT = this.unpickle81datum(pickleContext, by, (byte)0);
        return this.toObject(sTRUCT, n, map);
    }

    private STRUCT unpickle81datum(PickleContext pickleContext, byte by, byte by2) throws SQLException {
        int n = this.getNumAttrs();
        StructDescriptor structDescriptor = this.createStructDescriptor();
        STRUCT sTRUCT = this.createByteSTRUCT(structDescriptor, null);
        OracleType oracleType = this.getAttrTypeAt(0);
        Object object = null;
        object = PickleContext.isImmediatelyEmbeddedNull(by) && by2 == 1 ? null : (PickleContext.isImmediatelyEmbeddedNull(by) ? ((OracleTypeADT)oracleType).unpickle81datum(pickleContext, by, (byte)(by2 - 1)) : (PickleContext.isElementNull(by) ? (oracleType.getTypeCode() == 2002 || oracleType.getTypeCode() == 2008 ? oracleType.unpickle81datumAsNull(pickleContext, by, by2) : null) : oracleType.unpickle81rec(pickleContext, by, 1, null)));
        Datum[] datumArray = new Datum[n];
        datumArray[0] = (Datum)object;
        for (int i = 1; i < n; ++i) {
            oracleType = this.getAttrTypeAt(i);
            datumArray[i] = (Datum)oracleType.unpickle81rec(pickleContext, 1, null);
        }
        sTRUCT.setDatumArray(datumArray);
        return sTRUCT;
    }

    protected Datum unpickle81datumAsNull(PickleContext pickleContext, byte by, byte by2) throws SQLException {
        int n = this.getNumAttrs();
        StructDescriptor structDescriptor = this.createStructDescriptor();
        STRUCT sTRUCT = this.createByteSTRUCT(structDescriptor, null);
        Datum[] datumArray = new Datum[n];
        for (int i = 0; i < n; ++i) {
            OracleType oracleType = this.getAttrTypeAt(i);
            datumArray[i] = oracleType.getTypeCode() == 2002 || oracleType.getTypeCode() == 2008 ? oracleType.unpickle81datumAsNull(pickleContext, by, by2) : (Datum)(i == 0 ? null : oracleType.unpickle81rec(pickleContext, 1, null));
        }
        sTRUCT.setDatumArray(datumArray);
        return sTRUCT;
    }

    public byte[] pickle81(Datum datum) throws SQLException {
        PickleContext pickleContext = new PickleContext();
        pickleContext.initStream();
        this.pickle81(pickleContext, datum);
        byte[] byArray = pickleContext.stream2Bytes();
        datum.setShareBytes(byArray);
        return byArray;
    }

    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        int n = pickleContext.offset() + 2;
        int n2 = 0;
        n2 += pickleContext.writeImageHeader(this.shouldHavePrefix());
        n2 += this.pickle81Prefix(pickleContext);
        pickleContext.patchImageLen(n, n2 += this.pickle81rec(pickleContext, datum, 0));
        return n2;
    }

    private boolean hasTypeVersion() {
        return this.typeVersion > 1;
    }

    private boolean needsToid() {
        return (this.statusBits & 0x40) != 0 || (this.statusBits & 0x20) == 0 || this.hasTypeVersion();
    }

    private boolean shouldHavePrefix() {
        return this.hasTypeVersion() || this.needsToid();
    }

    protected int pickle81Prefix(PickleContext pickleContext) throws SQLException {
        if (this.shouldHavePrefix()) {
            int n = 0;
            int n2 = 1;
            int n3 = 1;
            if (this.needsToid()) {
                n3 += this.getTOID().length;
                n2 |= 4;
            }
            if (this.hasTypeVersion()) {
                n2 |= 0x10;
                n3 = this.typeVersion > PickleContext.KOPI20_LN_MAXV ? (n3 += 5) : ++n3;
            }
            n = pickleContext.writeLength(n3);
            n += pickleContext.writeData((byte)n2);
            if (this.needsToid()) {
                n += pickleContext.writeData(this.toid);
            }
            if (this.hasTypeVersion()) {
                n += pickleContext.writeLength(this.typeVersion);
            }
            return n;
        }
        return 0;
    }

    private int pickle81rec(PickleContext pickleContext, Datum datum, int n) throws SQLException {
        int n2 = 0;
        Datum[] datumArray = ((STRUCT)datum).getOracleAttributes();
        int n3 = datumArray.length;
        int n4 = 0;
        OracleType oracleType = this.getAttrTypeAt(0);
        if (oracleType instanceof OracleTypeADT && !(oracleType instanceof OracleTypeCOLLECTION) && !(oracleType instanceof OracleTypeUPT)) {
            n4 = 1;
            n2 = datumArray[0] == null ? (n > 0 ? (n2 += pickleContext.writeImmediatelyEmbeddedElementNull((byte)n)) : (n2 += pickleContext.writeAtomicNull())) : (n2 += ((OracleTypeADT)oracleType).pickle81rec(pickleContext, datumArray[0], n + 1));
        }
        while (n4 < n3) {
            oracleType = this.getAttrTypeAt(n4);
            n2 = datumArray[n4] == null ? (oracleType instanceof OracleTypeADT && !(oracleType instanceof OracleTypeCOLLECTION) && !(oracleType instanceof OracleTypeUPT) ? (n2 += pickleContext.writeAtomicNull()) : (n2 += pickleContext.writeElementNull())) : (oracleType instanceof OracleTypeADT && !(oracleType instanceof OracleTypeCOLLECTION) && !(oracleType instanceof OracleTypeUPT) ? (n2 += ((OracleTypeADT)oracleType).pickle81rec(pickleContext, datumArray[n4], 1)) : (n2 += oracleType.pickle81(pickleContext, datumArray[n4])));
            ++n4;
        }
        return n2;
    }

    private Object toObject(STRUCT sTRUCT, int n, Map map) throws SQLException {
        switch (n) {
            case 1: {
                return sTRUCT;
            }
            case 2: {
                if (sTRUCT == null) break;
                return sTRUCT.toJdbc(map);
            }
            default: {
                DatabaseError.throwSqlException(1);
            }
        }
        return null;
    }

    public String getAttributeType(int n) throws SQLException {
        if (this.sqlName == null) {
            this.getFullName();
        }
        if (this.attrNames == null) {
            this.initADTAttrNames();
        }
        if (n < 1 || n > this.attrTypeNames.length) {
            DatabaseError.throwSqlException(1, "Invalid index");
        }
        return this.attrTypeNames[n - 1];
    }

    public String getAttributeType(int n, boolean bl) throws SQLException {
        if (bl) {
            return this.getAttributeType(n);
        }
        if (n < 1 || this.attrTypeNames != null && n > this.attrTypeNames.length) {
            DatabaseError.throwSqlException(1, "Invalid index");
        }
        if (this.attrTypeNames != null) {
            return this.attrTypeNames[n - 1];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttributeName(int n) throws SQLException {
        if (this.attrNames == null) {
            this.initADTAttrNames();
        }
        OracleTypeADT oracleTypeADT = this;
        synchronized (oracleTypeADT) {
            if (n < 1 || n > this.attrNames.length) {
                DatabaseError.throwSqlException(1, "Invalid index");
            }
        }
        return this.attrNames[n - 1];
    }

    public String getAttributeName(int n, boolean bl) throws SQLException {
        if (bl) {
            return this.getAttributeName(n);
        }
        if (n < 1 || this.attrNames != null && n > this.attrNames.length) {
            DatabaseError.throwSqlException(1, "Invalid index");
        }
        if (this.attrNames != null) {
            return this.attrNames[n - 1];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initADTAttrNames() throws SQLException {
        CallableStatement callableStatement = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String[] stringArray = new String[this.attrTypes.length];
        String[] stringArray2 = new String[this.attrTypes.length];
        int n = 0;
        int n2 = 0;
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OracleTypeADT oracleTypeADT = this;
            synchronized (oracleTypeADT) {
                if (this.attrNames == null) {
                    int n3 = n = this.sqlName.getSchema().equalsIgnoreCase(this.connection.getUserName()) ? 0 : 3;
                    block18: while (n != 6) {
                        block31: {
                            Object var12_11;
                            switch (n) {
                                case 0: {
                                    preparedStatement = this.connection.prepareStatement(sqlString[n]);
                                    preparedStatement.setString(1, this.sqlName.getSimpleName());
                                    resultSet = preparedStatement.executeQuery();
                                    n = 1;
                                    break;
                                }
                                case 1: {
                                    preparedStatement = this.connection.prepareStatement(sqlString[n]);
                                    preparedStatement.setString(1, this.sqlName.getSimpleName());
                                    preparedStatement.setString(2, this.sqlName.getSimpleName());
                                    n = 2;
                                    try {
                                        resultSet = preparedStatement.executeQuery();
                                        break;
                                    }
                                    catch (SQLException sQLException) {
                                        if (sQLException.getErrorCode() == 1436) continue block18;
                                        throw sQLException;
                                    }
                                }
                                case 2: {
                                    preparedStatement = this.connection.prepareStatement(sqlString[n]);
                                    preparedStatement.setString(1, this.sqlName.getSimpleName());
                                    preparedStatement.setString(2, this.sqlName.getSimpleName());
                                    resultSet = preparedStatement.executeQuery();
                                    n = 4;
                                    break;
                                }
                                case 3: {
                                    preparedStatement = this.connection.prepareStatement(sqlString[n]);
                                    preparedStatement.setString(1, this.sqlName.getSchema());
                                    preparedStatement.setString(2, this.sqlName.getSimpleName());
                                    resultSet = preparedStatement.executeQuery();
                                    n = 4;
                                    break;
                                }
                                case 4: {
                                    preparedStatement = this.connection.prepareStatement(sqlString[n]);
                                    preparedStatement.setString(1, this.sqlName.getSimpleName());
                                    preparedStatement.setString(2, this.sqlName.getSimpleName());
                                    resultSet = preparedStatement.executeQuery();
                                    n = 5;
                                    break;
                                }
                                case 5: {
                                    callableStatement = this.connection.prepareCall(sqlString[n]);
                                    callableStatement.setString(1, this.sqlName.getSimpleName());
                                    callableStatement.registerOutParameter(2, -10);
                                    callableStatement.execute();
                                    resultSet = ((OracleCallableStatement)callableStatement).getCursor(2);
                                    n = 6;
                                }
                            }
                            try {
                                if (preparedStatement != null) {
                                    preparedStatement.setFetchSize(this.idx);
                                }
                                for (n2 = 0; n2 < this.attrTypes.length && resultSet.next(); ++n2) {
                                    if (resultSet.getInt(1) != n2 + 1) {
                                        DatabaseError.throwSqlException(1, "inconsistent ADT attribute");
                                    }
                                    stringArray[n2] = resultSet.getString(2);
                                    stringArray2[n2] = resultSet.getString(4) + "." + resultSet.getString(3);
                                }
                                if (n2 != 0) {
                                    this.attrTypeNames = stringArray2;
                                    this.attrNames = stringArray;
                                    n = 6;
                                } else {
                                    if (resultSet != null) {
                                        resultSet.close();
                                    }
                                    if (preparedStatement != null) {
                                        preparedStatement.close();
                                    }
                                }
                                var12_11 = null;
                                if (resultSet == null) break block31;
                            }
                            catch (Throwable throwable) {
                                var12_11 = null;
                                if (resultSet != null) {
                                    resultSet.close();
                                }
                                if (preparedStatement != null) {
                                    preparedStatement.close();
                                }
                                if (callableStatement != null) {
                                    callableStatement.close();
                                }
                                throw throwable;
                            }
                            resultSet.close();
                        }
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                        if (callableStatement == null) continue;
                        callableStatement.close();
                        {
                        }
                    }
                }
            }
        }
    }

    StructDescriptor createStructDescriptor() throws SQLException {
        return new StructDescriptor(this, (Connection)this.connection);
    }

    STRUCT createObjSTRUCT(StructDescriptor structDescriptor, Object[] objectArray) throws SQLException {
        if ((this.statusBits & 0x10) != 0) {
            return new JAVA_STRUCT(structDescriptor, (Connection)this.connection, objectArray);
        }
        return new STRUCT(structDescriptor, (Connection)this.connection, objectArray);
    }

    STRUCT createByteSTRUCT(StructDescriptor structDescriptor, byte[] byArray) throws SQLException {
        if ((this.statusBits & 0x10) != 0) {
            return new JAVA_STRUCT(structDescriptor, byArray, this.connection);
        }
        return new STRUCT(structDescriptor, byArray, this.connection);
    }

    public static String getSubtypeName(Connection connection, byte[] byArray, long l) throws SQLException {
        byte by;
        PickleContext pickleContext;
        block6: {
            block5: {
                pickleContext = new PickleContext(byArray, l);
                by = pickleContext.readByte();
                if (!PickleContext.is81format(by)) break block5;
                if (PickleContext.isCollectionImage_pctx(by)) break block5;
                if (PickleContext.hasPrefix(by)) break block6;
            }
            return null;
        }
        if (!pickleContext.readAndCheckVersion()) {
            DatabaseError.throwSqlException(1, "Image version is not recognized");
        }
        pickleContext.skipLength();
        pickleContext.skipLength();
        by = pickleContext.readByte();
        if ((by & 4) != 0) {
            byte[] byArray2 = pickleContext.readBytes(16);
            return OracleTypeADT.toid2typename(connection, byArray2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toid2typename(Connection connection, byte[] byArray) throws SQLException {
        String string = (String)((OracleConnection)connection).getDescriptor(byArray);
        if (string == null) {
            PreparedStatement preparedStatement;
            block8: {
                preparedStatement = null;
                ResultSet resultSet = null;
                try {
                    preparedStatement = connection.prepareStatement("select owner, type_name from all_types where type_oid = :1");
                    preparedStatement.setBytes(1, byArray);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        string = resultSet.getString(1) + "." + resultSet.getString(2);
                        ((OracleConnection)connection).putDescriptor(byArray, (Object)string);
                    } else {
                        DatabaseError.throwSqlException(1, "Invalid type oid");
                    }
                    Object var6_5 = null;
                    if (resultSet == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return string;
    }

    public int getTdsVersion() {
        return this.tdsVersion;
    }

    public void printDebug() {
    }

    private String debugText() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("OracleTypeADT = " + this);
        printWriter.println("sqlName = " + this.sqlName);
        printWriter.println("OracleType[] : ");
        if (this.attrTypes != null) {
            for (int i = 0; i < this.attrTypes.length; ++i) {
                printWriter.println("[" + i + "] = " + this.attrTypes[i]);
            }
        } else {
            printWriter.println("null");
        }
        printWriter.println("LDS : ");
        if (this.lds != null) {
            this.printUnsignedByteArray(this.lds, printWriter);
        } else {
            printWriter.println("null");
        }
        printWriter.println("toid : ");
        if (this.toid != null) {
            this.printUnsignedByteArray(this.toid, printWriter);
        } else {
            printWriter.println("null");
        }
        printWriter.println("fdo : ");
        if (this.fdo != null) {
            this.printUnsignedByteArray(this.fdo, printWriter);
        } else {
            printWriter.println("null");
        }
        printWriter.println("tds version : " + this.tdsVersion);
        printWriter.println("type version : " + this.typeVersion);
        printWriter.println("type version : " + this.typeVersion);
        printWriter.println("bigEndian : " + (this.bigEndian ? "true" : "false"));
        printWriter.println("opcode : " + this.opcode);
        printWriter.println("tdoCState : " + this.tdoCState);
        return stringWriter.toString();
    }

    public byte[] getTOID() {
        try {
            if (this.toid == null) {
                this.initMetadata(this.connection);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.toid;
    }

    public int getImageFormatVersion() {
        return PickleContext.KOPI20_VERSION;
    }

    public int getTypeVersion() {
        try {
            if (this.typeVersion == -1) {
                this.initMetadata(this.connection);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.typeVersion;
    }

    public int getCharSet() {
        return this.charSetId;
    }

    public int getCharSetForm() {
        return this.charSetForm;
    }

    public synchronized long getTdoCState() {
        try {
            if (this.tdoCState == 0L) {
                this.getFullName();
                this.tdoCState = this.connection.getTdoCState(this.sqlName.getSchema(), this.sqlName.getSimpleName());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.tdoCState;
    }

    public long getFIXED_DATA_SIZE() {
        try {
            return this.getFixedDataSize();
        }
        catch (SQLException sQLException) {
            return 0L;
        }
    }

    public long[] getLDS_OFFSET_ARRAY() {
        try {
            return this.getLdsOffsetArray();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    synchronized long[] getLdsOffsetArray() throws SQLException {
        if (this.ldsOffsetArray == null && this.connection != null) {
            this.generateLDS();
        }
        return this.ldsOffsetArray;
    }

    public long getFixedDataSize() throws SQLException {
        return this.fixedDataSize;
    }

    public int getAlignmentReq() throws SQLException {
        return this.alignmentRequirement;
    }

    public int getNumAttrs() throws SQLException {
        if (this.attrTypes == null && this.connection != null) {
            this.init(this.connection);
        }
        return this.attrTypes.length;
    }

    public OracleType getAttrTypeAt(int n) throws SQLException {
        if (this.attrTypes == null && this.connection != null) {
            this.init(this.connection);
        }
        return this.attrTypes[n];
    }

    public boolean isEmbeddedADT() throws SQLException {
        return (this.statusBits & 2) != 0;
    }

    public boolean isUptADT() throws SQLException {
        return (this.statusBits & 4) != 0;
    }

    public boolean isTopADT() throws SQLException {
        return (this.statusBits & 1) != 0;
    }

    public void setStatus(int n) throws SQLException {
        this.statusBits = n;
    }

    void setEmbeddedADT() throws SQLException {
        this.maskAndSetStatusBits(-16, 2);
    }

    void setUptADT() throws SQLException {
        this.maskAndSetStatusBits(-16, 4);
    }

    public boolean isSubType() throws SQLException {
        return (this.statusBits & 0x40) != 0;
    }

    public boolean isFinalType() throws SQLException {
        return (this.statusBits & 0x20) != 0 | (this.statusBits & 2) != 0;
    }

    public boolean isJavaObject() throws SQLException {
        return (this.statusBits & 0x10) != 0;
    }

    public int getStatus() throws SQLException {
        if ((this.statusBits & 1) != 0 && (this.statusBits & 0x100) == 0) {
            this.init(this.connection);
        }
        return this.statusBits;
    }

    public static OracleTypeADT shallowClone(OracleTypeADT oracleTypeADT) throws SQLException {
        OracleTypeADT oracleTypeADT2 = new OracleTypeADT();
        OracleTypeADT.shallowCopy(oracleTypeADT, oracleTypeADT2);
        return oracleTypeADT2;
    }

    public static void shallowCopy(OracleTypeADT oracleTypeADT, OracleTypeADT oracleTypeADT2) throws SQLException {
        oracleTypeADT2.connection = oracleTypeADT.connection;
        oracleTypeADT2.sqlName = oracleTypeADT.sqlName;
        oracleTypeADT2.parent = oracleTypeADT.parent;
        oracleTypeADT2.idx = oracleTypeADT.idx;
        oracleTypeADT2.descriptor = oracleTypeADT.descriptor;
        oracleTypeADT2.statusBits = oracleTypeADT.statusBits;
        oracleTypeADT2.nullOffset = oracleTypeADT.nullOffset;
        oracleTypeADT2.ldsOffset = oracleTypeADT.ldsOffset;
        oracleTypeADT2.sizeForLds = oracleTypeADT.sizeForLds;
        oracleTypeADT2.alignForLds = oracleTypeADT.alignForLds;
        oracleTypeADT2.typeCode = oracleTypeADT.typeCode;
        oracleTypeADT2.dbTypeCode = oracleTypeADT.dbTypeCode;
        oracleTypeADT2.tdsVersion = oracleTypeADT.tdsVersion;
        oracleTypeADT2.typeVersion = oracleTypeADT.typeVersion;
        oracleTypeADT2.lds = oracleTypeADT.lds;
        oracleTypeADT2.ldsOffsetArray = oracleTypeADT.ldsOffsetArray;
        oracleTypeADT2.fixedDataSize = oracleTypeADT.fixedDataSize;
        oracleTypeADT2.alignmentRequirement = oracleTypeADT.alignmentRequirement;
        oracleTypeADT2.attrTypes = oracleTypeADT.attrTypes;
        oracleTypeADT2.sqlName = oracleTypeADT.sqlName;
        oracleTypeADT2.tdoCState = oracleTypeADT.tdoCState;
        oracleTypeADT2.toid = oracleTypeADT.toid;
        oracleTypeADT2.fdo = oracleTypeADT.fdo;
        oracleTypeADT2.charSetId = oracleTypeADT.charSetId;
        oracleTypeADT2.charSetForm = oracleTypeADT.charSetForm;
        oracleTypeADT2.bigEndian = oracleTypeADT.bigEndian;
        oracleTypeADT2.flattenedAttrNum = oracleTypeADT.flattenedAttrNum;
        oracleTypeADT2.statusBits = oracleTypeADT.statusBits;
        oracleTypeADT2.attrNames = oracleTypeADT.attrNames;
        oracleTypeADT2.attrTypeNames = oracleTypeADT.attrTypeNames;
        oracleTypeADT2.opcode = oracleTypeADT.opcode;
        oracleTypeADT2.idx = oracleTypeADT.idx;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.statusBits);
        objectOutputStream.writeInt(this.tdsVersion);
        objectOutputStream.writeInt(this.typeVersion);
        objectOutputStream.writeObject(this.lds);
        objectOutputStream.writeObject(this.ldsOffsetArray);
        objectOutputStream.writeLong(this.fixedDataSize);
        objectOutputStream.writeInt(this.alignmentRequirement);
        objectOutputStream.writeObject(this.attrTypes);
        objectOutputStream.writeObject(this.attrNames);
        objectOutputStream.writeObject(this.attrTypeNames);
        objectOutputStream.writeLong(this.tdoCState);
        objectOutputStream.writeObject(this.toid);
        objectOutputStream.writeObject(this.fdo);
        objectOutputStream.writeInt(this.charSetId);
        objectOutputStream.writeInt(this.charSetForm);
        objectOutputStream.writeBoolean(this.bigEndian);
        objectOutputStream.writeInt(this.flattenedAttrNum);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.statusBits = objectInputStream.readInt();
        this.tdsVersion = objectInputStream.readInt();
        this.typeVersion = objectInputStream.readInt();
        objectInputStream.readObject();
        objectInputStream.readObject();
        objectInputStream.readLong();
        objectInputStream.readInt();
        this.attrTypes = (OracleType[])objectInputStream.readObject();
        this.attrNames = (String[])objectInputStream.readObject();
        this.attrTypeNames = (String[])objectInputStream.readObject();
        objectInputStream.readLong();
        this.toid = (byte[])objectInputStream.readObject();
        this.fdo = (byte[])objectInputStream.readObject();
        this.charSetId = objectInputStream.readInt();
        this.charSetForm = objectInputStream.readInt();
        this.bigEndian = objectInputStream.readBoolean();
        this.flattenedAttrNum = objectInputStream.readInt();
    }

    public synchronized void setConnection(OracleConnection oracleConnection) throws SQLException {
        this.connection = oracleConnection;
        for (int i = 0; i < this.attrTypes.length; ++i) {
            this.attrTypes[i].setConnection(this.connection);
        }
    }

    private synchronized void setStatusBits(int n) {
        this.statusBits |= n;
    }

    private synchronized void maskAndSetStatusBits(int n, int n2) {
        this.statusBits &= n;
        this.statusBits |= n2;
    }

    private void printUnsignedByteArray(byte[] byArray, PrintWriter printWriter) {
        int n;
        int n2 = byArray.length;
        int[] nArray = Util.toJavaUnsignedBytes(byArray);
        for (n = 0; n < n2; ++n) {
            printWriter.print("0x" + Integer.toHexString(nArray[n]) + " ");
        }
        printWriter.println();
        for (n = 0; n < n2; ++n) {
            printWriter.print(nArray[n] + " ");
        }
        printWriter.println();
    }

    public void initChildNamesRecursively(Map map) throws SQLException {
        TypeTreeElement typeTreeElement = (TypeTreeElement)map.get(this.sqlName);
        if (this.attrTypes != null && this.attrTypes.length > 0) {
            for (int i = 0; i < this.attrTypes.length; ++i) {
                OracleType oracleType = this.attrTypes[i];
                oracleType.setNames(typeTreeElement.getChildSchemaName(i + 1), typeTreeElement.getChildTypeName(i + 1));
                oracleType.initChildNamesRecursively(map);
                oracleType.cacheDescriptor();
            }
        }
    }

    public void cacheDescriptor() throws SQLException {
        this.descriptor = StructDescriptor.createDescriptor(this);
    }

    public void printXML(PrintWriter printWriter, int n) throws SQLException {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            printWriter.print("  ");
        }
        printWriter.print("<OracleTypeADT sqlName=\"" + this.sqlName + "\" " + " hashCode=\"" + this.hashCode() + "\" " + " toid=\"");
        if (this.toid != null) {
            this.printUnsignedByteArray(this.toid, printWriter);
        } else {
            printWriter.print("null");
        }
        printWriter.println(" \"  typecode=\"" + this.typeCode + "\"" + " tds version=\"" + this.tdsVersion + "\"" + " is embedded=\"" + this.isEmbeddedADT() + "\"" + " is top level=\"" + this.isTopADT() + "\"" + " is upt=\"" + this.isUptADT() + "\"" + " finalType=\"" + this.isFinalType() + "\"" + " subtype=\"" + this.isSubType() + "\"" + " ldsOffset=\"" + this.ldsOffset + "\"" + " sizeForLds=\"" + this.sizeForLds + "\"" + " alignForLds=\"" + this.alignForLds + "\"" + " ldsOffsetArray size=\"" + (this.ldsOffsetArray == null ? "null" : Integer.toString(this.ldsOffsetArray.length)) + "\"" + ">");
        if (this.attrTypes != null && this.attrTypes.length > 0) {
            for (n2 = 0; n2 < this.attrTypes.length; ++n2) {
                this.attrTypes[n2].printXML(printWriter, n + 1);
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            printWriter.print("  ");
        }
        printWriter.println("</OracleTypeADT>");
    }
}

