/*
 * Decompiled with CFR 0.152.
 */
package org.edna.passerelle.actors;

import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.Transformer;
import com.isencia.passerelle.message.ManagedMessage;
import java.io.File;
import java.io.FileNotFoundException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import uk.ac.gda.common.rcp.util.EclipseUtils;

public class JythonNode
extends Transformer {
    private static Logger logger = LoggerFactory.getLogger(JythonNode.class);
    private static final long serialVersionUID = -5053674282429774593L;
    private StringParameter pyFileParam = new StringParameter((NamedObj)this, "Python File");
    private StringParameter projectNameParam;
    private String pyFilePath;
    private String projectName;

    public JythonNode(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.registerConfigurableParameter((Parameter)this.pyFileParam);
        this.projectNameParam = new StringParameter((NamedObj)this, "Project Name");
        this.registerConfigurableParameter((Parameter)this.projectNameParam);
        this.projectNameParam.setVisibility(Settable.NOT_EDITABLE);
    }

    protected void doFire() throws ProcessingException {
    }

    protected void doFire(ManagedMessage managedMessage) throws ProcessingException {
        File file = new File(String.valueOf(System.getProperty("eclipse.workspace.home")) + "/" + this.projectName + "/" + this.pyFilePath);
        if (!file.exists()) {
            throw new ProcessingException("File " + file.getAbsolutePath() + " does not exist! Is eclipse.workspace.home set correctly?", (Object)this, (Throwable)new FileNotFoundException());
        }
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        IProject iProject;
        super.attributeChanged(attribute);
        if (attribute == this.pyFileParam) {
            if (PlatformUI.isWorkbenchRunning()) {
                this.createPythonFile();
            }
            this.pyFilePath = this.pyFileParam.getExpression();
        } else if (attribute == this.projectNameParam) {
            this.projectName = this.projectNameParam.getExpression();
        }
        if (PlatformUI.isWorkbenchRunning() && (this.projectName == null || "".equals(this.projectName)) && (iProject = EclipseUtils.getActiveProject()) != null) {
            this.projectNameParam.setExpression(iProject.getName());
            this.projectName = iProject.getName();
        }
    }

    private void createPythonFile() {
        IFile iFile;
        IProject iProject = this.projectName == null ? EclipseUtils.getActiveProject() : ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
        String string = this.pyFileParam.getExpression();
        if (string != null && !"".equals(string) && !(iFile = iProject.getFile(string)).exists()) {
            this.createPythonFile(iProject, iFile);
        }
    }

    private void createPythonFile(IProject iProject, IFile iFile) {
        try {
            iFile.touch(null);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    protected String getExtendedInfo() {
        return "Execute Python " + this.pyFilePath;
    }
}

