/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.views;

import gda.analysis.io.ScanFileHolderException;
import gda.data.nexus.tree.INexusTree;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IProgressService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.rcp.nexus.NexusTreeExplorer;
import uk.ac.diamond.scisoft.analysis.rcp.util.NexusUtils;

public class NexusTreeView
extends ViewPart {
    NexusTreeExplorer ntxp;
    Display display;
    FileDialog fileDialog = null;
    public static final String ID = "uk.ac.diamond.scisoft.analysis.rcp.views.NexusTreeView";
    private static final Logger logger = LoggerFactory.getLogger(NexusTreeView.class);

    public void createPartControl(Composite composite) {
        this.display = composite.getDisplay();
        this.ntxp = new NexusTreeExplorer(composite, 0, this.getSite());
        this.createActions();
        this.initializeToolBar();
        this.initializeMenu();
    }

    public void loadTree(final String string) {
        IProgressService iProgressService = (IProgressService)this.getSite().getService(IProgressService.class);
        try {
            iProgressService.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            NexusTreeView.this.loadTree(string, iProgressMonitor);
                        }
                        catch (ScanFileHolderException scanFileHolderException) {
                            logger.error("Could not load NeXus file: {}", (Throwable)scanFileHolderException);
                            iProgressMonitor.done();
                        }
                        catch (Exception exception) {
                            logger.error("Problem with NeXus loader: is the library path set correctly?", (Throwable)exception);
                            iProgressMonitor.done();
                        }
                    }
                    finally {
                        iProgressMonitor.done();
                    }
                }
            });
        }
        catch (Exception exception) {
            logger.error("Could not open NeXus file", (Throwable)exception);
        }
    }

    public void loadTree(final String string, IProgressMonitor iProgressMonitor) throws Exception {
        iProgressMonitor.beginTask("Opening NeXus file " + string, 10);
        iProgressMonitor.worked(1);
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        final INexusTree iNexusTree = NexusUtils.loadTree(string, NexusUtils.getSel(), iProgressMonitor).getNexusTree();
        long l = System.nanoTime();
        if (iNexusTree != null) {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    NexusTreeView.this.ntxp.setNexusTree(iNexusTree);
                    NexusTreeView.this.setPartName(new File(string).getName());
                }
            });
        }
        logger.info("Setting tree took {}s", (Object)((double)(System.nanoTime() - l) * 1.0E-9));
    }

    public void loadTreeUsingFileDialog() {
        if (this.fileDialog == null) {
            this.fileDialog = new FileDialog(this.getSite().getShell(), 4096);
        }
        String[] stringArray = new String[]{"NeXus files", "All Files (*)"};
        String[] stringArray2 = new String[]{"*.nxs;*.h5", "*"};
        this.fileDialog.setFilterNames(stringArray);
        this.fileDialog.setFilterExtensions(stringArray2);
        String string = this.fileDialog.open();
        if (string != null) {
            this.loadTree(string);
        }
    }

    public void setFocus() {
    }

    private void createActions() {
    }

    private void initializeToolBar() {
        this.getViewSite().getActionBars().getToolBarManager();
    }

    private void initializeMenu() {
        this.getViewSite().getActionBars().getMenuManager();
    }

    public void expandAll() {
        this.ntxp.expandAll();
    }
}

