/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.views;

import gda.observable.IObserver;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.PlotServer;
import uk.ac.diamond.scisoft.analysis.plotserver.FileOperationBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GridImageEntry;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiPlotMode;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiUpdate;
import uk.ac.diamond.scisoft.analysis.rcp.imagegrid.SWTGridEntry;
import uk.ac.diamond.scisoft.analysis.rcp.imagegrid.SWTImageGrid;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.actions.ImageExplorerDirectoryChooseAction;
import uk.ac.diamond.scisoft.analysis.rcp.views.PlotServerProvider;

public class ImageExplorerView
extends ViewPart
implements IObserver {
    private static final transient Logger logger = LoggerFactory.getLogger(ImageExplorerView.class);
    public static final String ID = "uk.ac.diamond.scisoft.analysis.rcp.views.ImageExplorerView";
    public static final Object FOLDER_UPDATE_MARKER = new Object();
    public String plotViewName = "ImageExplorer View";
    private PlotServer plotServer = null;
    private Canvas canvas;
    SWTImageGrid imageGrid;
    private GuiBean guiBean = null;
    private UUID plotID = null;
    private final Semaphore locker = new Semaphore(1);
    private String dirPath;

    public ImageExplorerView() {
        this.plotServer = PlotServerProvider.getPlotServer();
        this.plotID = UUID.randomUUID();
        logger.info("Image explorer view uuid: {}", (Object)this.plotID);
    }

    public void createPartControl(Composite composite) {
        this.plotViewName = this.getViewSite().getRegisteredName();
        if (this.plotServer != null) {
            this.plotServer.addIObserver((IObserver)this);
        }
        this.setPartName(this.plotViewName);
        composite.setLayout((Layout)new FillLayout());
        this.canvas = new Canvas(composite, 0x20000300);
        this.imageGrid = new SWTImageGrid(this.canvas, this.plotViewName);
        if (this.plotServer != null) {
            this.retainStateFromServer();
        }
        if (this.dirPath != null) {
            Job job = new Job("Update directory"){

                protected IStatus run(IProgressMonitor iProgressMonitor) {
                    ImageExplorerDirectoryChooseAction.setImageFolder(ImageExplorerView.this.dirPath);
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.setPriority(50);
            job.schedule(1000L);
        }
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        this.init(iViewSite);
        if (iMemento != null) {
            this.dirPath = iMemento.getString("DIR");
        }
    }

    public void saveState(IMemento iMemento) {
        if (this.dirPath != null && iMemento != null) {
            iMemento.putString("DIR", this.dirPath);
        }
    }

    public void setDirPath(String string) {
        this.dirPath = string;
    }

    public String getDirPath() {
        return this.dirPath;
    }

    public void setFocus() {
    }

    public void setOverviewMode(boolean bl) {
        if (this.imageGrid != null) {
            this.imageGrid.setOverviewMode(bl);
        }
    }

    public boolean getOverviewMode() {
        if (this.imageGrid != null) {
            return this.imageGrid.getOverviewMode();
        }
        return false;
    }

    public ArrayList<String> getSelection() {
        return this.imageGrid.getSelections();
    }

    private void processNewFile(GuiBean guiBean) {
        try {
            this.locker.acquire();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        SWTGridEntry sWTGridEntry = new SWTGridEntry((String)guiBean.get((Object)GuiParameters.FILENAME), null, this.canvas);
        Integer n = (Integer)guiBean.get((Object)GuiParameters.IMAGEGRIDXPOS);
        Integer n2 = (Integer)guiBean.get((Object)GuiParameters.IMAGEGRIDYPOS);
        if (n != null && n2 != null) {
            this.imageGrid.addEntry(sWTGridEntry, n, n2);
        } else {
            this.imageGrid.addEntry(sWTGridEntry);
        }
        this.locker.release();
    }

    private void processNewGrid(GuiBean guiBean) {
        final Integer[] integerArray = (Integer[])guiBean.get((Object)GuiParameters.IMAGEGRIDSIZE);
        if (integerArray != null && integerArray.length > 0) {
            try {
                this.locker.acquire();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.canvas.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ImageExplorerView.this.imageGrid.dispose();
                    ImageExplorerView.this.imageGrid = integerArray.length == 1 ? new SWTImageGrid(integerArray[0], integerArray[0], ImageExplorerView.this.canvas, ImageExplorerView.this.plotViewName) : new SWTImageGrid(integerArray[1], integerArray[0], ImageExplorerView.this.canvas, ImageExplorerView.this.plotViewName);
                    ImageExplorerView.this.locker.release();
                    ImageExplorerView.this.canvas.redraw();
                }
            });
        }
        if (this.plotServer != null) {
            this.cleanUpOnServer();
        }
    }

    private void processGUIUpdate(GuiUpdate guiUpdate) {
        GuiBean guiBean;
        UUID uUID;
        if (guiUpdate.getGuiName().contains(this.plotViewName) && ((uUID = (UUID)(guiBean = guiUpdate.getGuiData()).get((Object)GuiParameters.PLOTID)) == null || this.plotID.compareTo(uUID) != 0)) {
            GuiPlotMode guiPlotMode;
            if (this.guiBean == null) {
                this.guiBean = guiBean.copy();
            } else {
                this.guiBean.merge(guiBean);
            }
            if (guiBean.containsKey((Object)GuiParameters.PLOTMODE) && (guiPlotMode = (GuiPlotMode)guiBean.get((Object)GuiParameters.PLOTMODE)).equals((Object)GuiPlotMode.MULTI2D)) {
                this.imageGrid.setLocalProcessing(false);
                if (guiBean.containsKey((Object)GuiParameters.FILENAME)) {
                    this.processNewFile(guiBean);
                } else if (guiBean.containsKey((Object)GuiParameters.IMAGEGRIDSIZE)) {
                    this.processNewGrid(guiBean);
                    if (this.imageGrid != null) {
                        this.imageGrid.setLocalProcessing(false);
                    }
                }
            }
        }
    }

    private void processClientLocalUpdate(ArrayList<?> arrayList) {
        GuiBean guiBean = new GuiBean();
        int n = (int)Math.ceil(Math.sqrt(arrayList.size()));
        if (this.imageGrid != null) {
            this.imageGrid.dispose();
        }
        this.imageGrid = new SWTImageGrid(n, n, this.canvas, this.plotViewName);
        this.imageGrid.setLocalProcessing(true);
        for (String string : arrayList) {
            guiBean.put((Object)GuiParameters.FILENAME, (Object)string);
            this.processNewFile(guiBean);
        }
    }

    public void update(Object object, Object object2) {
        if (object == FOLDER_UPDATE_MARKER) {
            if (object2 instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)object2;
                this.processClientLocalUpdate(arrayList);
            }
        } else if (object2 instanceof GuiUpdate) {
            GuiUpdate guiUpdate = (GuiUpdate)object2;
            this.processGUIUpdate(guiUpdate);
        }
    }

    private void cleanUpOnServer() {
        FileOperationBean fileOperationBean = new FileOperationBean(7);
        GuiBean guiBean = new GuiBean();
        guiBean.put((Object)GuiParameters.FILEOPERATION, (Object)fileOperationBean);
        try {
            this.plotServer.updateGui(this.plotViewName, guiBean);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void retainStateFromServer() {
        try {
            GuiBean guiBean = this.plotServer.getGuiState(this.plotViewName);
            if (guiBean != null && guiBean.containsKey((Object)GuiParameters.IMAGEGRIDSTORE)) {
                ArrayList arrayList = (ArrayList)guiBean.get((Object)GuiParameters.IMAGEGRIDSTORE);
                for (GridImageEntry gridImageEntry : arrayList) {
                    SWTGridEntry sWTGridEntry = new SWTGridEntry(gridImageEntry.getFilename(), null, this.canvas);
                    this.imageGrid.addEntry(sWTGridEntry, gridImageEntry.getGridColumnPos(), gridImageEntry.getGridRowPos());
                }
            }
        }
        catch (Exception exception) {
            logger.warn("Problem with getting GUI data from plot server");
        }
    }

    private GuiBean saveStateToServer() {
        this.plotServer.deleteIObserver((IObserver)this);
        ArrayList<GridImageEntry> arrayList = this.imageGrid.getListOfEntries();
        GuiBean guiBean = new GuiBean();
        guiBean.put((Object)GuiParameters.PLOTMODE, (Object)GuiPlotMode.MULTI2D);
        guiBean.put((Object)GuiParameters.IMAGEGRIDSTORE, arrayList);
        return guiBean;
    }

    public void dispose() {
        GuiBean guiBean = null;
        if (this.plotServer != null) {
            guiBean = this.saveStateToServer();
        }
        if (this.imageGrid != null) {
            this.imageGrid.dispose();
        }
        if (guiBean != null) {
            try {
                this.plotServer.updateGui(this.plotViewName, guiBean);
            }
            catch (Exception exception) {
                logger.warn("Problem with updating plot server with GUI data");
                exception.printStackTrace();
            }
        }
    }

    public void pushGUIUpdate(GuiParameters guiParameters, Serializable serializable) {
        if (this.plotServer != null) {
            if (this.guiBean == null) {
                try {
                    this.guiBean = this.plotServer.getGuiState(this.plotViewName);
                }
                catch (Exception exception) {
                    logger.warn("Problem with getting GUI data from plot server");
                }
                if (this.guiBean == null) {
                    this.guiBean = new GuiBean();
                }
            }
            this.guiBean.put((Object)GuiParameters.PLOTID, (Object)this.plotID);
            this.guiBean.put((Object)guiParameters, (Object)serializable);
            try {
                logger.info("Pushing bean to server: {}", (Object)this.guiBean);
                this.plotServer.updateGui(this.plotViewName, this.guiBean);
            }
            catch (Exception exception) {
                logger.warn("Problem with updating plot server with GUI data");
                exception.printStackTrace();
            }
        }
    }

    public void pushSelectedFiles(ArrayList<String> arrayList) {
        this.pushGUIUpdate(GuiParameters.FILESELECTEDLIST, arrayList);
    }
}

