/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.results.navigator.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IProgressService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.rcp.results.navigator.AsciiTextView;
import uk.ac.diamond.scisoft.analysis.rcp.views.NexusTreeView;
import uk.ac.diamond.scisoft.analysis.rcp.views.nexus.DataSetPlotView;

public class OpenDataFileAction
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(OpenDataFileAction.class);
    private boolean openView;

    public OpenDataFileAction() {
        this(false);
    }

    public OpenDataFileAction(boolean bl) {
        this.openView = bl;
    }

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iWorkbenchPage.getSelection();
        if (iStructuredSelection == null) {
            return Boolean.FALSE;
        }
        if (iStructuredSelection.getFirstElement() == null) {
            return Boolean.FALSE;
        }
        if (iStructuredSelection.toArray().length != 1) {
            return Boolean.FALSE;
        }
        File file = iStructuredSelection.getFirstElement() instanceof File ? (File)iStructuredSelection.getFirstElement() : (iStructuredSelection.getFirstElement() instanceof IFile ? ((IFile)iStructuredSelection.getFirstElement()).getLocation().toFile() : new File(iStructuredSelection.getFirstElement().toString()));
        return this.openViewForFile(file);
    }

    public Object openViewForFile(final File file) throws ExecutionException {
        final IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (file == null) {
            return Boolean.FALSE;
        }
        if (!file.exists()) {
            return Boolean.FALSE;
        }
        if (file.isDirectory()) {
            return Boolean.FALSE;
        }
        if (file.isHidden()) {
            return Boolean.FALSE;
        }
        if (file.getName() == null) {
            return Boolean.FALSE;
        }
        if (file.getName().toLowerCase().endsWith(".nxs")) {
            IProgressService iProgressService = (IProgressService)PlatformUI.getWorkbench().getService(IProgressService.class);
            try {
                iProgressService.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                        ViewPart viewPart;
                        try {
                            viewPart = (NexusTreeView)OpenDataFileAction.this.getView("uk.ac.diamond.scisoft.analysis.rcp.views.NexusTreeView", iWorkbenchPage);
                            if (viewPart != null) {
                                viewPart.loadTree(file.getAbsolutePath(), iProgressMonitor);
                            }
                        }
                        catch (Exception exception) {
                            logger.error("Cannot open nexus", (Throwable)exception);
                        }
                        try {
                            viewPart = (DataSetPlotView)OpenDataFileAction.this.getView("uk.ac.gda.views.nexus.NexusPlotView", iWorkbenchPage);
                            if (viewPart != null) {
                                viewPart.setFile(file.getAbsolutePath(), iProgressMonitor);
                            }
                        }
                        catch (Exception exception) {
                            logger.error("Cannot open nexus", (Throwable)exception);
                        }
                    }
                });
            }
            catch (Exception exception) {
                throw new ExecutionException("Cannot find nexus view to open file " + file, (Throwable)exception);
            }
        }
        try {
            AsciiTextView asciiTextView = (AsciiTextView)this.getView("uk.ac.diamond.scisoft.analysis.rcp.results.navigator.AsciiTextView", iWorkbenchPage);
            if (asciiTextView == null) {
                return Boolean.FALSE;
            }
            asciiTextView.load(file);
            iWorkbenchPage.activate((IWorkbenchPart)asciiTextView);
            asciiTextView.setFocus();
        }
        catch (Exception exception) {
            throw new ExecutionException("Cannot find nexus view to open file " + file, (Throwable)exception);
        }
        return Boolean.TRUE;
    }

    private IViewPart getView(String string, IWorkbenchPage iWorkbenchPage) {
        try {
            IViewPart iViewPart = iWorkbenchPage.findView(string);
            if (iViewPart != null) {
                return iViewPart;
            }
            if (this.openView) {
                return iWorkbenchPage.showView(string);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

