/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.results.navigator.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotWindow;
import uk.ac.diamond.scisoft.analysis.rcp.results.navigator.DataSetComparisionDialog;
import uk.ac.diamond.scisoft.analysis.rcp.util.PlotMode;
import uk.ac.diamond.scisoft.analysis.rcp.util.PlotUtils;
import uk.ac.diamond.scisoft.analysis.rcp.views.PlotView;
import uk.ac.diamond.scisoft.analysis.rcp.views.nexus.DataSetPlotView;
import uk.ac.gda.common.rcp.util.EclipseUtils;

public class CompareDataSetsHandler
extends AbstractHandler
implements IHandler,
IObjectActionDelegate {
    private static final Logger logger = LoggerFactory.getLogger(CompareDataSetsHandler.class);

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        return this.doCompare();
    }

    public void run(IAction iAction) {
        this.doCompare();
    }

    private Object doCompare() {
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        final IStructuredSelection iStructuredSelection = (IStructuredSelection)iWorkbenchPage.getSelection();
        if (iStructuredSelection == null || iStructuredSelection.toArray().length <= 1) {
            MessageDialog.openConfirm((Shell)iWorkbenchPage.getActivePart().getSite().getShell(), (String)"Please Select Files to Compare", (String)"Please select more than one file by holding down 'Control' (or 'Ctrl') and choosing two or more files.");
            return Boolean.FALSE;
        }
        try {
            DataSetPlotView dataSetPlotView = (DataSetPlotView)iWorkbenchPage.findView("uk.ac.gda.views.nexus.NexusPlotView");
            IWorkbenchPartSite iWorkbenchPartSite = dataSetPlotView != null ? dataSetPlotView.getSite() : iWorkbenchPage.getActivePart().getSite();
            final DataSetComparisionDialog dataSetComparisionDialog = new DataSetComparisionDialog(iWorkbenchPartSite, iStructuredSelection.toArray());
            if (dataSetComparisionDialog.open() == 1) {
                return Boolean.FALSE;
            }
            final PlotWindow plotWindow = this.getPlotWindow();
            IProgressService iProgressService = (IProgressService)PlatformUI.getWorkbench().getService(IProgressService.class);
            final PlotMode plotMode = dataSetComparisionDialog.getDataSetPlotView().getPlotMode();
            iProgressService.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    iProgressMonitor.beginTask("Extracting and Plotting Comparison Data", 100);
                    try {
                        PlotUtils.createComparisionPlot(iStructuredSelection.toArray(), dataSetComparisionDialog.getSelections(), plotMode, plotWindow, iProgressMonitor);
                    }
                    catch (Exception exception) {
                        logger.error("Cannot plot selected Data Sets", (Throwable)exception);
                    }
                    iProgressMonitor.done();
                }
            });
            return Boolean.TRUE;
        }
        catch (Exception exception) {
            logger.error("Cannot determine data sets from selected files", (Throwable)exception);
            return Boolean.FALSE;
        }
    }

    protected PlotWindow getPlotWindow() {
        PlotView plotView;
        try {
            IWorkbenchPage iWorkbenchPage = EclipseUtils.getActivePage();
            plotView = (PlotView)iWorkbenchPage.showView("uk.ac.diamond.scisoft.analysis.rcp.plotViewNT1", null, 1);
        }
        catch (PartInitException partInitException) {
            logger.error("Cannot open uk.ac.diamond.scisoft.analysis.rcp.plotViewNT1", (Throwable)partInitException);
            return null;
        }
        return plotView.getPlotWindow();
    }

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }
}

