/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.results.navigator;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.rcp.results.navigator.actions.OpenDataFileAction;
import uk.ac.gda.common.rcp.util.IFileUtils;
import uk.ac.gda.common.rcp.util.PathUtils;
import uk.ac.gda.ui.file.AlphaNumericFileSorter;
import uk.ac.gda.ui.file.DateFileSorter;
import uk.ac.gda.ui.file.IFileTreeColumnProvider;
import uk.ac.gda.ui.file.IFileTreeContentProvider;
import uk.ac.gda.ui.file.IFileTreeLabelProvider;
import uk.ac.gda.ui.file.SizeFileSorter;
import uk.ac.gda.ui.viewer.ViewerFilterFactory;

public class DataNavigator
extends ViewPart {
    public static final String DATA_PROJECT_NAME = "Data";
    public static final String DATA_WORKINGSET_NAME = "Data";
    private static final Logger logger = LoggerFactory.getLogger(DataNavigator.class);
    private static String DEFAULT_FILE_PATH = PathUtils.createFromDefaultProperty();
    public static final String ID = "uk.ac.diamond.scisoft.analysis.rcp.results.navigator.ResultsNavigator";
    private TreeViewer resultsViewer;
    private IProject project;
    private ViewerFilter nexusFilter;
    private ViewerFilter datFilter;

    public DataNavigator() {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.project = iWorkspaceRoot.getProject("Data");
    }

    public void createPartControl(Composite composite) {
        this.resultsViewer = new TreeViewer(composite, 68354);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.resultsViewer);
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.resultsViewer, 0, 0);
        treeViewerColumn.setLabelProvider((CellLabelProvider)new IFileTreeColumnProvider());
        treeViewerColumn.getColumn().setText("Name");
        treeViewerColumn.getColumn().setWidth(350);
        treeViewerColumn.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DataNavigator.this.resultsViewer.setComparator((ViewerComparator)new AlphaNumericFileSorter());
            }
        });
        TreeViewerColumn treeViewerColumn2 = new TreeViewerColumn(this.resultsViewer, 0, 1);
        treeViewerColumn2.getColumn().setText("Size");
        treeViewerColumn2.getColumn().setWidth(100);
        treeViewerColumn2.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DataNavigator.this.resultsViewer.setComparator((ViewerComparator)new SizeFileSorter());
            }
        });
        TreeViewerColumn treeViewerColumn3 = new TreeViewerColumn(this.resultsViewer, 0, 2);
        treeViewerColumn3.getColumn().setText("Date Modified");
        treeViewerColumn3.getColumn().setWidth(250);
        treeViewerColumn3.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DataNavigator.this.resultsViewer.setComparator((ViewerComparator)new DateFileSorter());
            }
        });
        this.resultsViewer.setColumnProperties(new String[]{"Name", "Size", "Date Modified"});
        this.resultsViewer.setUseHashlookup(true);
        this.resultsViewer.setContentProvider((IContentProvider)new IFileTreeContentProvider((IResource)this.project));
        this.resultsViewer.setLabelProvider((IBaseLabelProvider)new IFileTreeLabelProvider());
        this.resultsViewer.getTree().setHeaderVisible(true);
        try {
            this.setupProject(this.project, null);
        }
        catch (Exception exception) {
            logger.error("Cannot create project", (Throwable)exception);
        }
        IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        if (iWorkingSetManager.getWorkingSet("Data") == null) {
            iWorkingSetManager.addWorkingSet(iWorkingSetManager.createWorkingSet("Data", new IAdaptable[]{this.project}));
        }
        this.getSite().setSelectionProvider((ISelectionProvider)this.resultsViewer);
        this.createRightClickMenu();
        this.createDragSupport(this.resultsViewer);
        this.createActions();
        this.initializeToolBar();
        this.initializeMenu();
        this.addSelectionListener(this.resultsViewer);
    }

    public void dispose() {
        super.dispose();
        if (this.getSite().getSelectionProvider() != null) {
            ((Viewer)this.getSite().getSelectionProvider()).getControl().dispose();
        }
    }

    private void createDragSupport(final TreeViewer treeViewer) {
        int n = 19;
        Transfer[] transferArray = new Transfer[]{FileTransfer.getInstance()};
        treeViewer.addDragSupport(n, transferArray, new DragSourceListener(){

            public void dragStart(DragSourceEvent dragSourceEvent) {
            }

            public void dragSetData(DragSourceEvent dragSourceEvent) {
                dragSourceEvent.doit = false;
                if (FileTransfer.getInstance().isSupportedType(dragSourceEvent.dataType)) {
                    IResource iResource = (IResource)((IStructuredSelection)treeViewer.getSelection()).getFirstElement();
                    if (iResource == null) {
                        return;
                    }
                    if (!iResource.exists()) {
                        return;
                    }
                    if (iResource instanceof IContainer) {
                        return;
                    }
                    String[] stringArray = new String[]{iResource.getLocation().toOSString()};
                    dragSourceEvent.data = stringArray;
                    dragSourceEvent.doit = true;
                }
            }

            public void dragFinished(DragSourceEvent dragSourceEvent) {
            }
        });
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
    }

    private void addSelectionListener(TreeViewer treeViewer) {
        treeViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                try {
                    new OpenDataFileAction(true).execute(null);
                }
                catch (ExecutionException executionException) {
                    logger.error("Cannot open nexus file", (Throwable)executionException);
                }
            }
        });
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                try {
                    new OpenDataFileAction().execute(null);
                }
                catch (ExecutionException executionException) {
                    logger.error("Cannot open nexus file", (Throwable)executionException);
                }
            }
        });
    }

    private void createRightClickMenu() {
        MenuManager menuManager = new MenuManager();
        Control control = ((Viewer)this.getSite().getSelectionProvider()).getControl();
        control.setMenu(menuManager.createContextMenu(control));
        this.getSite().registerContextMenu(menuManager, this.getSite().getSelectionProvider());
    }

    private void createActions() {
    }

    private void initializeToolBar() {
        this.getViewSite().getActionBars().getToolBarManager();
    }

    private void initializeMenu() {
        this.getViewSite().getActionBars().getMenuManager();
    }

    public void setFocus() {
        if (this.getSite().getShell().isDisposed()) {
            return;
        }
        ((TreeViewer)this.getSite().getSelectionProvider()).getControl().setFocus();
    }

    public void refresh() {
        ((TreeViewer)this.getSite().getSelectionProvider()).refresh();
    }

    public void refreshFolder() {
        TreeViewer treeViewer = (TreeViewer)this.getSite().getSelectionProvider();
        IStructuredSelection iStructuredSelection = (IStructuredSelection)treeViewer.getSelection();
        if (iStructuredSelection == null) {
            return;
        }
        if (iStructuredSelection.getFirstElement() == null) {
            return;
        }
        if (iStructuredSelection.getFirstElement() instanceof IResource) {
            IResource iResource = (IResource)iStructuredSelection.getFirstElement();
            if (!(iResource instanceof IContainer)) {
                iResource = iResource.getParent();
            }
            try {
                iResource.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                logger.error("Cannot refresh " + iResource, (Throwable)coreException);
            }
            treeViewer.refresh((Object)iResource, true);
        }
    }

    public void setSelectedPath(String string) {
        TreeViewer treeViewer = (TreeViewer)this.getSite().getSelectionProvider();
        try {
            this.setupProject(this.project, string);
            treeViewer.refresh();
        }
        catch (Exception exception) {
            logger.error("Cannot set project " + string, (Throwable)exception);
        }
    }

    public void setSelected(ISelection iSelection) {
        this.resultsViewer.setSelection(iSelection);
    }

    public static void setDefaultDataFolder(String string) {
        DEFAULT_FILE_PATH = string;
    }

    public void setSelected(String string) throws Exception {
        IResource iResource = this.getResource(string);
        if (!iResource.exists()) {
            throw new Exception("Cannot find file " + iResource);
        }
        TreeViewer treeViewer = (TreeViewer)this.getSite().getSelectionProvider();
        treeViewer.setSelection((ISelection)new StructuredSelection((Object)iResource));
    }

    public void setNexusFilter(boolean bl) {
        if (this.nexusFilter == null) {
            this.nexusFilter = ViewerFilterFactory.createFileExtensionFilter((String)".nxs");
        }
        if (bl) {
            this.resultsViewer.addFilter(this.nexusFilter);
        } else {
            this.resultsViewer.removeFilter(this.nexusFilter);
        }
    }

    public void setAsciiFilter(boolean bl) {
        if (this.datFilter == null) {
            this.datFilter = ViewerFilterFactory.createFileExtensionFilter((String)".dat");
        }
        if (bl) {
            this.resultsViewer.addFilter(this.datFilter);
        } else {
            this.resultsViewer.removeFilter(this.datFilter);
        }
    }

    public void resetFilters() {
        this.resultsViewer.resetFilters();
    }

    public void setupProject(final IProject iProject, String string) throws Exception {
        Object object;
        IResource[] iResourceArray;
        if (string == null) {
            if (iProject.exists()) {
                iResourceArray = this.project.members();
                int n = 0;
                while (n < iResourceArray.length) {
                    if (iResourceArray[n] instanceof IContainer) {
                        string = iResourceArray[n].getLocation().toOSString();
                    }
                    ++n;
                }
            } else {
                string = DEFAULT_FILE_PATH;
            }
        }
        iResourceArray = new Path(string);
        if (iProject.exists()) {
            IFolder iFolder = iProject.getFolder(iResourceArray.toFile().getName());
            object = iFolder.getLocation().toOSString();
            String string2 = iResourceArray.toOSString();
            if (iFolder.exists() && ((String)object).equals(string2)) {
                this.resultsViewer.setInput((Object)iProject);
                return;
            }
        }
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        object = new IWorkspaceRunnable((Path)iResourceArray, iWorkspace){
            private final /* synthetic */ Path val$path;
            private final /* synthetic */ IWorkspace val$workspace;
            {
                this.val$path = path;
                this.val$workspace = iWorkspace;
            }

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                if (!iProject.exists()) {
                    iProject.create(iProgressMonitor);
                    iProject.open(iProgressMonitor);
                }
                IResource[] iResourceArray = DataNavigator.this.project.members();
                int n = 0;
                while (n < iResourceArray.length) {
                    if (iResourceArray[n] instanceof IContainer) {
                        iResourceArray[n].delete(false, iProgressMonitor);
                    }
                    ++n;
                }
                IFolder iFolder = iProject.getFolder(this.val$path.lastSegment());
                IPath iPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
                if (!this.val$path.isPrefixOf(iPath)) {
                    iFolder.createLink((IPath)this.val$path, 2, iProgressMonitor);
                } else {
                    iFolder.create(false, true, iProgressMonitor);
                    IFileUtils.createLinks((IFolder)iFolder, (Path)this.val$path, (IProgressMonitor)iProgressMonitor);
                }
                DataNavigator.this.project.refreshLocal(2, null);
                this.val$workspace.validateProjectLocation(DataNavigator.this.project, DataNavigator.this.project.getFullPath());
                DataNavigator.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DataNavigator.this.resultsViewer.setInput((Object)iProject);
                    }
                });
            }
        };
        iWorkspace.run((IWorkspaceRunnable)object, iWorkspace.getRuleFactory().modifyRule((IResource)iWorkspace.getRoot()), 0, null);
    }

    private IResource getResource(String string) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject iProject = iWorkspaceRoot.getProject("Data");
        if (iProject == null || !iProject.exists()) {
            return null;
        }
        Path path = new Path(string);
        IResource iResource = iProject.findMember((IPath)path);
        return iResource;
    }

    public static String getDefaultFilePath() {
        return DEFAULT_FILE_PATH;
    }
}

