/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot;

import java.awt.Color;
import java.io.Serializable;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.function.Downsample;
import uk.ac.diamond.scisoft.analysis.dataset.function.DownsampleMode;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiPlotMode;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay2DConsumer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay2DProvider;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.OverlayProvider;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ROIData;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ROIDataList;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ROIHandles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ROITableViewer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.SidePlot;
import uk.ac.diamond.scisoft.analysis.rcp.views.PlotView;
import uk.ac.diamond.scisoft.analysis.roi.ROIBase;
import uk.ac.diamond.scisoft.analysis.roi.ROIList;

public abstract class SidePlotProfile
extends SidePlot
implements Overlay2DConsumer,
SelectionListener,
ICellEditorListener {
    private static Logger logger = LoggerFactory.getLogger(SidePlotProfile.class);
    protected AbstractDataset data;
    protected AbstractDataset subData;
    protected double subFactor;
    private static final int DMAXDIM = 500;
    protected ROIBase roi = null;
    protected ROIData roiData = null;
    protected ROIDataList roiDataList = null;
    protected Overlay2DProvider oProvider;
    protected boolean dragging = false;
    protected Color oColour;
    protected Color dColour = new Color(255, 0, 0);
    protected Color cColour;
    protected double oThickness = 2.0;
    protected double oTransparency = 0.6;
    protected int[] cpt = new int[2];
    protected List<Integer> dragIDs;
    protected List<Integer> roiIDs;
    protected List<Integer> roisIDs;
    protected ROIHandles roiHandler;
    protected int dragHandle = -1;
    private static final int HSIZEMIN = 10;
    private static final double HSIZEFRACTION = 0.05;
    protected ROITableViewer tViewer;
    protected SelectionListener copyButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            SidePlotProfile.this.roi = null;
            SidePlotProfile.this.roiData.setPlot(false);
            SidePlotProfile.this.roiDataList.add(SidePlotProfile.this.roiData);
            SidePlotProfile.this.roisIDs.add(-1);
            SidePlotProfile.this.removeCurrentROI();
            SidePlotProfile.this.sendROIs();
            SidePlotProfile.this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    (this).SidePlotProfile.this.tViewer.refresh();
                    SidePlotProfile.this.hideCurrent();
                    SidePlotProfile.this.removeIDs((this).SidePlotProfile.this.roiIDs);
                    SidePlotProfile.this.removeHandles();
                    SidePlotProfile.this.drawOverlays();
                    SidePlotProfile.this.updatePlot();
                }
            });
        }
    };
    protected SelectionListener brightnessButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            SidePlotProfile.this.oColour = ((Button)selectionEvent.widget).getSelection() ? SidePlotProfile.this.cColour : SidePlotProfile.this.dColour;
            SidePlotProfile.this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SidePlotProfile.this.drawOverlays();
                    SidePlotProfile.this.drawCurrentOverlay();
                }
            });
        }
    };

    public int calcHandleSize(int[] nArray) {
        int n = nArray.length < 2 ? nArray[0] : Math.min(nArray[0], nArray[1]);
        int n2 = (int)((double)n * 0.05);
        if (n2 < 10) {
            n2 = 10;
        }
        if ((double)n2 > (double)n * 0.25 && (n2 = n / 4) < 1) {
            n2 = 1;
        }
        return n2;
    }

    @Override
    public void registerProvider(OverlayProvider overlayProvider) {
        this.oProvider = (Overlay2DProvider)overlayProvider;
    }

    @Override
    public void unregisterProvider() {
        this.hideOverlays();
        this.removePrimitives();
        this.oProvider = null;
    }

    @Override
    public void hideOverlays() {
        if (this.oProvider == null) {
            return;
        }
        this.hideIDs(this.dragIDs);
        this.hideCurrent();
        this.hideIDs(this.roisIDs);
    }

    @Override
    public void showOverlays() {
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                SidePlotProfile.this.drawOverlays();
                SidePlotProfile.this.drawCurrentOverlay();
            }
        });
    }

    @Override
    public void showSidePlot() {
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                SidePlotProfile.this.updatePlot();
                SidePlotProfile.this.tViewer.setInput(SidePlotProfile.this.roiDataList);
            }
        });
        int n = 0;
        if (this.guiUpdateManager != null) {
            n = this.updateGUI(this.guiUpdateManager.getGUIInfo());
        }
        if (n & true) {
            this.sendCurrentROI(this.roi);
        }
        if ((n & 2) != 0) {
            this.sendROIs();
        }
        if (n != 0) {
            this.updateDataList();
        }
        if (this.roi == null && this.roiDataList.size() == 0) {
            return;
        }
        this.showOverlays();
    }

    protected void hideCurrent() {
        this.hideIDs(this.roiIDs);
        int n = 0;
        int n2 = this.roiHandler.size();
        while (n < n2) {
            if ((Integer)this.roiHandler.get(n) != -1) {
                this.oProvider.setPrimitiveVisible((Integer)this.roiHandler.get(n), false);
            }
            ++n;
        }
    }

    protected void hideIDs(List<Integer> list) {
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            int n3 = list.get(n);
            if (n3 != -1) {
                this.oProvider.setPrimitiveVisible(n3, false);
            }
            ++n;
        }
    }

    @Override
    public void removePrimitives() {
        if (this.oProvider == null) {
            return;
        }
        this.removeIDs(this.dragIDs);
        this.removeIDs(this.roiIDs);
        this.removeHandles();
        this.removeIDs(this.roisIDs);
    }

    protected void removeHandles() {
        int n = this.roiHandler.size();
        if (n > 0) {
            this.oProvider.unregisterPrimitive(this.roiHandler);
            int n2 = 0;
            while (n2 < n) {
                this.roiHandler.set(n2, -1);
                ++n2;
            }
        }
    }

    protected void removeIDs(List<Integer> list) {
        int n = list.size();
        if (n > 0) {
            this.oProvider.unregisterPrimitive(list);
            int n2 = 0;
            while (n2 < n) {
                list.set(n2, -1);
                ++n2;
            }
        }
    }

    protected void updatePlot() {
        this.updatePlot(this.roi);
    }

    protected abstract void updatePlot(ROIBase var1);

    protected abstract void drawCurrentOverlay();

    protected abstract void drawOverlays();

    protected abstract void updateAllSpinners(ROIBase var1);

    protected abstract void updateDataList();

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.tViewer.getSelection();
        if (iStructuredSelection != null && selectionEvent.widget instanceof MenuItem) {
            ROIData rOIData = (ROIData)iStructuredSelection.getFirstElement();
            int n = this.roiDataList.indexOf(rOIData);
            switch (this.tViewer.getContextMenu().indexOf((MenuItem)selectionEvent.widget)) {
                case 0: {
                    this.roi = rOIData.getROI();
                    this.roiHandler.setROI(this.roi);
                    this.removeIDs(this.roiIDs);
                    this.roiIDs.set(0, this.roisIDs.get(n));
                    this.roisIDs.remove(n);
                    this.roiDataList.remove(rOIData);
                    this.sendCurrentROI(this.roi);
                    this.sendROIs();
                    this.updateAllSpinners(this.roi);
                    this.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SidePlotProfile.this.tViewer.refresh();
                            SidePlotProfile.this.removeHandles();
                            SidePlotProfile.this.drawOverlays();
                            SidePlotProfile.this.drawCurrentOverlay();
                            SidePlotProfile.this.updatePlot();
                        }
                    });
                    break;
                }
                case 1: {
                    this.roi = rOIData.getROI().copy();
                    this.roiHandler.setROI(this.roi);
                    this.sendCurrentROI(this.roi);
                    this.updateAllSpinners(this.roi);
                    this.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SidePlotProfile.this.drawOverlays();
                            SidePlotProfile.this.drawCurrentOverlay();
                            SidePlotProfile.this.updatePlot();
                        }
                    });
                    break;
                }
                case 2: {
                    this.oProvider.unregisterPrimitive(this.roisIDs.get(n));
                    this.roisIDs.remove(n);
                    this.roiDataList.remove(rOIData);
                    this.sendROIs();
                    this.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SidePlotProfile.this.tViewer.refresh();
                            SidePlotProfile.this.drawOverlays();
                            SidePlotProfile.this.updatePlot();
                        }
                    });
                }
            }
        }
    }

    public void applyEditorValue() {
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                SidePlotProfile.this.updatePlot();
            }
        });
    }

    public void cancelEditor() {
    }

    public void editorValueChanged(boolean bl, boolean bl2) {
    }

    protected void sendCurrentROI(ROIBase rOIBase) {
        if (rOIBase == null) {
            return;
        }
        if (this.guiUpdateManager != null) {
            this.guiUpdateManager.putGUIInfo(GuiParameters.ROIDATA, (Serializable)rOIBase.copy());
        }
    }

    protected void sendROIs() {
        if (this.roiDataList.size() == 0) {
            this.removeROIs();
            return;
        }
        ROIList rOIList = new ROIList();
        for (ROIData rOIData : this.roiDataList) {
            rOIList.add((Object)rOIData.getROI());
        }
        if (this.guiUpdateManager != null) {
            this.guiUpdateManager.putGUIInfo(GuiParameters.ROIDATALIST, (Serializable)rOIList);
        }
    }

    protected void removeCurrentROI() {
        if (this.guiUpdateManager != null) {
            this.guiUpdateManager.removeGUIInfo(GuiParameters.ROIDATA);
        }
    }

    protected void removeROIs() {
        if (this.guiUpdateManager != null) {
            this.guiUpdateManager.removeGUIInfo(GuiParameters.ROIDATALIST);
        }
    }

    private void createDownsampledDataset() {
        int[] nArray = this.data.getShape();
        int n = Math.max(nArray[0], nArray[1]);
        this.subFactor = Math.ceil((double)n / 500.0);
        if (this.subFactor > 1.0) {
            nArray[0] = (int)this.subFactor;
            nArray[1] = (int)this.subFactor;
            Downsample downsample = new Downsample(DownsampleMode.MAXIMUM, nArray);
            this.subData = (AbstractDataset)downsample.value(new IDataset[]{this.data}).get(0);
        } else {
            this.subData = null;
        }
    }

    public boolean getDataset() {
        AbstractDataset abstractDataset = DatasetUtils.convertToAbstractDataset((IDataset)this.mainPlotter.getCurrentDataSet());
        if (abstractDataset != null) {
            if (!abstractDataset.equals((Object)this.data)) {
                this.data = abstractDataset;
                this.createDownsampledDataset();
                return true;
            }
            if (this.data != null && this.subData == null) {
                this.createDownsampledDataset();
            }
        }
        return false;
    }

    @Override
    public void processPlotUpdate() {
        this.updateDataList();
        if (this.oProvider != null) {
            this.updatePlot();
            this.sendCurrentROI(this.roi);
            this.sendROIs();
            this.tViewer.setInput(this.roiDataList);
            this.drawOverlays();
            this.drawCurrentOverlay();
        }
    }

    public void pushPlottingData(IWorkbenchPartSite iWorkbenchPartSite, String string, int n) {
        if (this.roiData != null) {
            PlotView plotView = null;
            try {
                plotView = (PlotView)iWorkbenchPartSite.getPage().showView("uk.ac.diamond.scisoft.analysis.rcp.plotView" + string);
            }
            catch (PartInitException partInitException) {
                logger.error("All over now! Cannot find plotview: {} ", (Object)string);
                logger.error(partInitException.toString());
                return;
            }
            if (plotView == null) {
                return;
            }
            plotView.updatePlotMode(GuiPlotMode.ONED);
            DataBean dataBean = this.getPlottingData(n);
            if (dataBean != null) {
                plotView.processPlotUpdate(dataBean);
            }
        }
    }

    DataBean getPlottingData(int n) {
        return null;
    }

    @Override
    public void generateMenuActions(IMenuManager iMenuManager, IWorkbenchPartSite iWorkbenchPartSite) {
    }

    @Override
    public void generateToolActions(IToolBarManager iToolBarManager) {
        Action action = new Action(){

            public void run() {
                SidePlotProfile.this.addToHistory();
            }
        };
        action.setText("Add current profiles to history");
        action.setToolTipText("Adds the current profiles to the plot history");
        action.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/basket_put.png"));
        Action action2 = new Action(){

            public void run() {
                SidePlotProfile.this.removeFromHistory();
            }
        };
        action2.setText("Remove last profiles from history");
        action2.setToolTipText("Remove the last profiles from the plot history");
        action2.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/basket_remove.png"));
        iToolBarManager.add((IAction)action);
        iToolBarManager.add((IAction)action2);
    }
}

