/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotException;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlottingMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.OverlayType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.PrimitiveType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.VectorOverlayStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.fitting.FittedPeakData;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay1DConsumer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay1DProvider;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.OverlayProvider;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.AreaSelectEvent;

class PlotFittedPeaks
implements Overlay1DConsumer {
    private static final transient Logger logger = LoggerFactory.getLogger(PlotFittedPeaks.class);
    private DataSetPlotter plotter;
    private Overlay1DProvider sideProvider;
    private List<Integer> sidePrimID;
    private int sideID;
    double MaxY = Double.MAX_VALUE;
    double MinY = -1.7976931348623157E308;

    public PlotFittedPeaks(SashForm sashForm) {
        Composite composite = new Composite((Composite)sashForm, 0);
        composite.setLayout((Layout)new FillLayout());
        this.plotter = new DataSetPlotter(PlottingMode.ONED, composite);
        this.plotter.setAxisModes(AxisMode.CUSTOM, AxisMode.LINEAR, AxisMode.LINEAR);
    }

    public void plotDataSets(DoubleDataset doubleDataset, DoubleDataset doubleDataset2, AxisValues axisValues) {
        this.MaxY = doubleDataset2.max().doubleValue();
        this.MinY = doubleDataset2.min().doubleValue();
        ArrayList<IDataset> arrayList = new ArrayList<IDataset>();
        ArrayList<AxisValues> arrayList2 = new ArrayList<AxisValues>();
        arrayList.add((IDataset)doubleDataset);
        arrayList.add((IDataset)doubleDataset2);
        arrayList2.add(axisValues);
        arrayList2.add(axisValues);
        try {
            this.plotter.replaceAllPlots(arrayList, arrayList2);
        }
        catch (PlotException plotException) {
            plotException.printStackTrace();
        }
        this.plotter.refresh(false);
    }

    public void clearPeakPlotter() {
        if (this.plotter != null) {
            try {
                this.plotter.replaceAllPlots(new ArrayList());
                this.removePrimitives();
            }
            catch (PlotException plotException) {
                logger.warn("The plot could not be cleared in fitting1D sideplot");
            }
            this.plotter.refresh(false);
        }
    }

    public void dispose() {
        if (this.plotter != null) {
            this.plotter.cleanUp();
        }
    }

    public void drawCurrentOverlay(FittedPeakData fittedPeakData) {
        double d = fittedPeakData.getFittedPeak().getPeakFitted().getFWHM();
        double d2 = fittedPeakData.getFittedPeak().getPeakFitted().getPosition();
        if (this.sideProvider == null) {
            this.plotter.registerOverlay(this);
        }
        this.sideProvider.begin(OverlayType.VECTOR2D);
        this.sideID = this.sideProvider.registerPrimitive(PrimitiveType.BOX);
        this.sideProvider.setColour(this.sideID, Color.RED);
        this.sideProvider.setStyle(this.sideID, VectorOverlayStyles.FILLED_WITH_OUTLINE);
        this.sideProvider.setTransparency(this.sideID, 0.8);
        this.sideProvider.setOutlineTransparency(this.sideID, 0.0);
        this.sideProvider.drawBox(this.sideID, d2 - d / 2.0, this.MaxY / 2.0, d2 + d / 2.0, this.MinY);
        this.sidePrimID.add(this.sideID);
        this.sideID = this.sideProvider.registerPrimitive(PrimitiveType.LINE);
        this.sideProvider.setColour(this.sideID, Color.GREEN);
        this.sideProvider.drawLine(this.sideID, d2, this.MinY, d2, this.MaxY);
        this.sidePrimID.add(this.sideID);
        this.sideProvider.end(OverlayType.VECTOR2D);
    }

    @Override
    public void registerProvider(OverlayProvider overlayProvider) {
        this.sideProvider = (Overlay1DProvider)overlayProvider;
        this.sidePrimID = new ArrayList<Integer>();
    }

    @Override
    public void removePrimitives() {
        if (this.sideProvider != null) {
            for (int n : this.sidePrimID) {
                this.sideProvider.unregisterPrimitive(n);
            }
        }
    }

    @Override
    public void unregisterProvider() {
        if (this.sideProvider != null) {
            this.sideProvider = null;
        }
    }

    @Override
    public void areaSelected(AreaSelectEvent areaSelectEvent) {
    }
}

