/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot;

import java.awt.Color;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DAppearance;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DGraphTable;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotColorUtility;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotException;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlottingMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.OverlayType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.Plot1DStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.PrimitiveType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.VectorOverlayStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ROIData;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ROIDataList;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.RectangularROIData;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.RectangularROIHandler;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.RectangularROITableViewer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.SidePlotProfile;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.IImagePositionEvent;
import uk.ac.diamond.scisoft.analysis.roi.ROIBase;
import uk.ac.diamond.scisoft.analysis.roi.ROIList;
import uk.ac.diamond.scisoft.analysis.roi.RectangularROI;
import uk.ac.gda.richbeans.components.wrappers.FloatSpinnerWrapper;

public class BoxProfile
extends SidePlotProfile {
    private static Logger logger = LoggerFactory.getLogger(BoxProfile.class);
    private DataSetPlotter majPlotter;
    private DataSetPlotter minPlotter;
    private HandleStatus hStatus = HandleStatus.NONE;
    private Spinner spsx;
    private Spinner spsy;
    private FloatSpinnerWrapper splmaj;
    private FloatSpinnerWrapper splmin;
    private FloatSpinnerWrapper spang;
    private Text txSum;
    private SelectionListener clippingButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            RectangularROI rectangularROI = (RectangularROI)BoxProfile.this.roi;
            if (((Button)selectionEvent.widget).getSelection()) {
                rectangularROI.setClippingCompensation(true);
            } else {
                rectangularROI.setClippingCompensation(false);
            }
            BoxProfile.this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    BoxProfile.this.updatePlot();
                }
            });
        }
    };
    private SelectionListener startPosListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            BoxProfile.this.roi.setPoint(BoxProfile.this.spsx.getSelection(), BoxProfile.this.spsy.getSelection());
            BoxProfile.this.sendCurrentROI(BoxProfile.this.roi);
            BoxProfile.this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    BoxProfile.this.updatePlot();
                    BoxProfile.this.drawCurrentOverlay();
                }
            });
        }
    };
    private SelectionListener lensListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            final RectangularROI rectangularROI = (RectangularROI)BoxProfile.this.roi;
            if (rectangularROI != null) {
                rectangularROI.setLengths(BoxProfile.this.splmaj.getFloat(), BoxProfile.this.splmin.getFloat());
                BoxProfile.this.sendCurrentROI(BoxProfile.this.roi);
                BoxProfile.this.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        BoxProfile.this.splmaj.setFloat(rectangularROI.getLengths()[0]);
                        BoxProfile.this.splmin.setFloat(rectangularROI.getLengths()[1]);
                        BoxProfile.this.updatePlot();
                        BoxProfile.this.drawCurrentOverlay();
                    }
                });
            }
        }
    };
    private SelectionListener angListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            RectangularROI rectangularROI = (RectangularROI)BoxProfile.this.roi;
            if (rectangularROI != null) {
                rectangularROI.setAngleDegrees(BoxProfile.this.spang.getFloat());
                BoxProfile.this.sendCurrentROI(BoxProfile.this.roi);
                BoxProfile.this.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        BoxProfile.this.updatePlot();
                        BoxProfile.this.drawCurrentOverlay();
                    }
                });
            }
        }
    };

    @Override
    public void createPartControl(Composite composite) {
        this.container = new Composite(composite, 0);
        this.container.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm(this.container, 512);
        this.majPlotter = new DataSetPlotter(PlottingMode.ONED, (Composite)sashForm, false);
        this.majPlotter.setAxisModes(AxisMode.CUSTOM, AxisMode.LINEAR, AxisMode.LINEAR);
        this.majPlotter.setXAxisLabel("Distance along major axis");
        this.minPlotter = new DataSetPlotter(PlottingMode.ONED, (Composite)sashForm, false);
        this.minPlotter.setAxisModes(AxisMode.CUSTOM, AxisMode.LINEAR, AxisMode.LINEAR);
        this.minPlotter.setXAxisLabel("Distance along minor axis");
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)sashForm, 768);
        Composite composite2 = new Composite((Composite)scrolledComposite, 0);
        composite2.setLayout((Layout)new FillLayout(512));
        Group group = new Group(composite2, 0);
        group.setLayout((Layout)new GridLayout(6, false));
        group.setText("Current ROI");
        new Label((Composite)group, 0).setText("Start x:");
        this.spsx = new Spinner((Composite)group, 2048);
        this.spsx.setMinimum(-10000);
        this.spsx.setMaximum(10000);
        this.spsx.setIncrement(1);
        this.spsx.setPageIncrement(5);
        this.spsx.addSelectionListener(this.startPosListener);
        new Label((Composite)group, 0).setText("Length major:");
        this.splmaj = new FloatSpinnerWrapper((Composite)group, 2048, 6, 2);
        this.splmaj.addSelectionListener(this.lensListener);
        new Label((Composite)group, 0).setText("Angle:");
        this.spang = new FloatSpinnerWrapper((Composite)group, 2048, 7, 2);
        this.spang.setMinimum(0.0);
        this.spang.setMaximum(360.0);
        this.spang.addSelectionListener(this.angListener);
        new Label((Composite)group, 0).setText("Start y:");
        this.spsy = new Spinner((Composite)group, 2048);
        this.spsy.setMinimum(-10000);
        this.spsy.setMaximum(10000);
        this.spsy.setIncrement(1);
        this.spsy.setPageIncrement(5);
        this.spsy.addSelectionListener(this.startPosListener);
        new Label((Composite)group, 0).setText("Length minor:");
        this.splmin = new FloatSpinnerWrapper((Composite)group, 2048, 6, 2);
        this.splmin.addSelectionListener(this.lensListener);
        new Label((Composite)group, 0).setText("Sum:");
        this.txSum = new Text((Composite)group, 2056);
        this.txSum.setTextLimit(12);
        Object object = new GridData();
        object.horizontalSpan = 2;
        Button button = new Button((Composite)group, 8);
        button.setLayoutData(object);
        button.setText("Copy current to table");
        button.addSelectionListener(this.copyButtonListener);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        Button button2 = new Button((Composite)group, 32);
        button2.setLayoutData((Object)gridData);
        button2.setText("Invert brightness");
        button2.setToolTipText("Invert overlay brightness");
        button2.addSelectionListener(this.brightnessButtonListener);
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 2;
        Button button3 = new Button((Composite)group, 32);
        button3.setLayoutData((Object)gridData2);
        button3.setText("Clipping comp");
        button3.setToolTipText("Compensate for clipping of region of interests");
        button3.addSelectionListener(this.clippingButtonListener);
        group = new Composite((Composite)sashForm, 0);
        sashForm.setWeights(new int[]{25, 25, 30, 20});
        group.setLayout((Layout)new FillLayout());
        this.tViewer = new RectangularROITableViewer((Composite)group, this, this);
        scrolledComposite.setContent((Control)composite2);
        composite2.setSize(composite2.computeSize(-1, -1));
        this.majPlotter.refresh(false);
        this.minPlotter.refresh(false);
        this.updateAllSpinners(this.roi);
        this.roiIDs = new ArrayList();
        this.dragIDs = new ArrayList();
        if (this.roiDataList == null) {
            this.roiDataList = new ROIDataList();
        }
        this.roisIDs = new ArrayList();
        this.tViewer.setInput(this.roiDataList);
        this.roiHandler = new RectangularROIHandler((RectangularROI)this.roi);
        this.dColour = new Color(0, 255, 0);
        object = Color.RGBtoHSB(this.dColour.getRed(), this.dColour.getGreen(), this.dColour.getBlue(), null);
        this.cColour = Color.getHSBColor((float)object[0], (float)object[1], (float)(1.0 - 0.7 * (double)object[2]));
        this.oColour = this.dColour;
    }

    @Override
    public void dispose() {
        if (this.majPlotter != null) {
            this.majPlotter.cleanUp();
        }
        if (this.minPlotter != null) {
            this.minPlotter.cleanUp();
        }
    }

    @Override
    protected void updatePlot(ROIBase rOIBase) {
        RectangularROIData rectangularROIData;
        Plot1DAppearance plot1DAppearance;
        RectangularROI rectangularROI = (RectangularROI)rOIBase;
        this.getDataset();
        if (this.data == null) {
            logger.warn("No data");
            return;
        }
        if (rectangularROI != null) {
            this.roiData = this.dragging && this.subData != null ? new RectangularROIData(rectangularROI, this.subData, this.subFactor, true) : new RectangularROIData(rectangularROI, this.data, true);
            if (!this.roiData.isPlot()) {
                return;
            }
            this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    BoxProfile.this.txSum.setText(String.format("%.3e", BoxProfile.this.roiData.getProfileSum()));
                }
            });
        }
        ArrayList<IDataset> arrayList = new ArrayList<IDataset>();
        ArrayList<AxisValues> arrayList2 = new ArrayList<AxisValues>();
        int n = 0;
        int n2 = 0;
        Plot1DGraphTable plot1DGraphTable = this.majPlotter.getColourTable();
        int n3 = this.majPlotter.getNumHistory();
        if (rectangularROI != null) {
            if (n2 + n3 >= plot1DGraphTable.getLegendSize()) {
                plot1DAppearance = new Plot1DAppearance(PlotColorUtility.getDefaultColour(n), Plot1DStyles.SOLID, "Line 1");
                plot1DGraphTable.addEntryOnLegend(n2, plot1DAppearance);
            } else {
                plot1DAppearance = plot1DGraphTable.getLegendEntry(n2);
                plot1DAppearance.setColour(PlotColorUtility.getDefaultColour(n));
                plot1DAppearance.setStyle(Plot1DStyles.SOLID);
                plot1DAppearance.setName("Line 1");
            }
            arrayList.add((IDataset)this.roiData.getProfileData(0));
            arrayList2.add(this.roiData.getXAxis(0));
            ++n2;
            ++n;
        }
        int n4 = 0;
        int n5 = this.roiDataList.size();
        while (n4 < n5) {
            rectangularROIData = (RectangularROIData)this.roiDataList.get(n4);
            Color color = PlotColorUtility.getDefaultColour(n4 + 1);
            RGB rGB = new RGB(color.getRed(), color.getGreen(), color.getBlue());
            rectangularROIData.setPlotColourRGB(rGB);
            if (rectangularROIData.isPlot()) {
                arrayList.add((IDataset)rectangularROIData.getProfileData(0));
                arrayList2.add(rectangularROIData.getXAxis(0));
                if (n2 + n3 >= plot1DGraphTable.getLegendSize()) {
                    plot1DAppearance = new Plot1DAppearance(color, Plot1DStyles.SOLID, "Line " + (n + 1));
                    plot1DGraphTable.addEntryOnLegend(n2, plot1DAppearance);
                } else {
                    plot1DAppearance = plot1DGraphTable.getLegendEntry(n2);
                    plot1DAppearance.setColour(color);
                    plot1DAppearance.setStyle(Plot1DStyles.SOLID);
                    plot1DAppearance.setName("Line " + (n + 1));
                }
                ++n2;
                ++n;
            }
            ++n4;
        }
        while (n3-- > 0) {
            plot1DAppearance = plot1DGraphTable.getLegendEntry(n2++);
            plot1DAppearance.setColour(PlotColorUtility.getDefaultColour(n++));
        }
        try {
            this.majPlotter.replaceAllPlots(arrayList, arrayList2);
        }
        catch (PlotException plotException) {
            plotException.printStackTrace();
        }
        arrayList.clear();
        arrayList2.clear();
        n = 0;
        n2 = 0;
        plot1DGraphTable = this.minPlotter.getColourTable();
        n3 = this.minPlotter.getNumHistory();
        if (rectangularROI != null) {
            if (n2 + n3 >= plot1DGraphTable.getLegendSize()) {
                plot1DAppearance = new Plot1DAppearance(PlotColorUtility.getDefaultColour(n), Plot1DStyles.SOLID, "Line 1");
                plot1DGraphTable.addEntryOnLegend(n2, plot1DAppearance);
            } else {
                plot1DAppearance = plot1DGraphTable.getLegendEntry(n2);
                plot1DAppearance.setColour(PlotColorUtility.getDefaultColour(n));
                plot1DAppearance.setStyle(Plot1DStyles.SOLID);
                plot1DAppearance.setName("Line 1");
            }
            arrayList.add((IDataset)this.roiData.getProfileData(1));
            arrayList2.add(this.roiData.getXAxis(1));
            ++n2;
            ++n;
        }
        int n6 = 0;
        n5 = this.roiDataList.size();
        while (n6 < n5) {
            rectangularROIData = (RectangularROIData)this.roiDataList.get(n6);
            if (rectangularROIData.isPlot()) {
                arrayList.add((IDataset)rectangularROIData.getProfileData(1));
                arrayList2.add(rectangularROIData.getXAxis(1));
                if (n >= plot1DGraphTable.getLegendSize()) {
                    plot1DAppearance = new Plot1DAppearance(rectangularROIData.getPlotColour(), Plot1DStyles.SOLID, "Line " + (n + 1));
                    plot1DGraphTable.addEntryOnLegend(n2, plot1DAppearance);
                } else {
                    plot1DAppearance = plot1DGraphTable.getLegendEntry(n2);
                    plot1DAppearance.setColour(rectangularROIData.getPlotColour());
                    plot1DAppearance.setStyle(Plot1DStyles.SOLID);
                    plot1DAppearance.setName("Line " + (n + 1));
                }
                ++n2;
                ++n;
            }
            ++n6;
        }
        while (n3-- > 0) {
            plot1DAppearance = plot1DGraphTable.getLegendEntry(n2++);
            plot1DAppearance.setColour(PlotColorUtility.getDefaultColour(n++));
        }
        try {
            this.minPlotter.replaceAllPlots(arrayList, arrayList2);
        }
        catch (PlotException plotException) {
            plotException.printStackTrace();
        }
        this.majPlotter.updateAllAppearance();
        this.majPlotter.refresh(false);
        this.minPlotter.updateAllAppearance();
        this.minPlotter.refresh(false);
    }

    private void drawDraggedOverlay(ROIBase rOIBase) {
        int n;
        int n2;
        if (this.oProvider == null) {
            return;
        }
        if (this.dragIDs.isEmpty()) {
            this.dragIDs.add(-1);
        }
        if ((n2 = ((Integer)this.dragIDs.get(n = 0)).intValue()) == -1) {
            n2 = this.oProvider.registerPrimitive(PrimitiveType.BOX);
            this.dragIDs.set(n, n2);
            if (n2 == -1) {
                return;
            }
        } else {
            this.oProvider.setPrimitiveVisible(n2, true);
        }
        ++n;
        RectangularROI rectangularROI = (RectangularROI)rOIBase;
        int[] nArray = rectangularROI.getIntPoint();
        int[] nArray2 = rectangularROI.getIntLengths();
        this.oProvider.begin(OverlayType.VECTOR2D);
        this.oProvider.drawBox(n2, nArray[0], nArray[1], nArray[0] + nArray2[0], nArray[1] + nArray2[1]);
        this.oProvider.rotatePrimitive(n2, -rectangularROI.getAngle(), nArray[0], nArray[1]);
        this.oProvider.setColour(n2, this.oColour);
        this.oProvider.setTransparency(n2, this.oTransparency);
        this.oProvider.end(OverlayType.VECTOR2D);
    }

    @Override
    protected void drawCurrentOverlay() {
        if (this.oProvider == null || this.roi == null) {
            return;
        }
        if (this.roiIDs.isEmpty()) {
            this.roiIDs.add(-1);
            this.roiIDs.add(-1);
            this.roiIDs.add(-1);
        }
        int n = 0;
        RectangularROI rectangularROI = (RectangularROI)this.roi;
        int[] nArray = this.roi.getIntPoint();
        int[] nArray2 = rectangularROI.getIntLengths();
        this.oProvider.begin(OverlayType.VECTOR2D);
        int n2 = (Integer)this.roiIDs.get(n);
        if (n2 == -1) {
            n2 = this.oProvider.registerPrimitive(PrimitiveType.BOX);
            this.roiIDs.set(n, n2);
            if (n2 == -1) {
                return;
            }
        } else {
            this.oProvider.setPrimitiveVisible(n2, true);
        }
        ++n;
        this.oProvider.drawBox(n2, nArray[0], nArray[1], nArray[0] + nArray2[0], nArray[1] + nArray2[1]);
        this.oProvider.rotatePrimitive(n2, -rectangularROI.getAngle(), nArray[0], nArray[1]);
        this.oProvider.setColour(n2, this.oColour);
        this.oProvider.setTransparency(n2, 0.9);
        this.oProvider.setStyle(n2, VectorOverlayStyles.FILLED);
        n2 = (Integer)this.roiIDs.get(n);
        if (n2 == -1) {
            n2 = this.oProvider.registerPrimitive(PrimitiveType.ARROW);
            this.roiIDs.set(n, n2);
            if (n2 == -1) {
                return;
            }
        } else {
            this.oProvider.setPrimitiveVisible(n2, true);
        }
        ++n;
        this.oProvider.drawArrow(n2, nArray[0], nArray[1], nArray[0] + nArray2[0], nArray[1], 0.6666666666666666);
        this.oProvider.rotatePrimitive(n2, -rectangularROI.getAngle(), nArray[0], nArray[1]);
        this.oProvider.setColour(n2, this.oColour);
        this.oProvider.setTransparency(n2, this.oTransparency);
        n2 = (Integer)this.roiIDs.get(n);
        if (n2 == -1) {
            n2 = this.oProvider.registerPrimitive(PrimitiveType.ARROW);
            this.roiIDs.set(n, n2);
            if (n2 == -1) {
                return;
            }
        } else {
            this.oProvider.setPrimitiveVisible(n2, true);
        }
        ++n;
        this.oProvider.drawArrow(n2, nArray[0], nArray[1], nArray[0], nArray[1] + nArray2[1], 0.3333333333333333);
        this.oProvider.rotatePrimitive(n2, -rectangularROI.getAngle(), nArray[0], nArray[1]);
        this.oProvider.setColour(n2, this.oColour);
        this.oProvider.setTransparency(n2, this.oTransparency);
        this.getDataset();
        int n3 = this.calcHandleSize(this.data.getShape());
        int n4 = 0;
        int n5 = this.roiHandler.size();
        while (n4 < n5) {
            int n6 = (Integer)this.roiHandler.get(n4);
            if (n6 == -1) {
                n6 = this.oProvider.registerPrimitive(PrimitiveType.BOX, true);
                this.roiHandler.set(n4, n6);
            } else {
                this.oProvider.setPrimitiveVisible(n6, true);
            }
            nArray = this.roiHandler.getHandlePoint(n4, n3);
            if (nArray == null) {
                this.oProvider.setPrimitiveVisible(n6, false);
            } else {
                this.oProvider.drawBox(n6, nArray[0], nArray[1], nArray[0] + n3, nArray[1] + n3);
                nArray = this.roiHandler.getAnchorPoint(n4, n3);
                this.oProvider.rotatePrimitive(n6, -rectangularROI.getAngle(), nArray[0], nArray[1]);
                this.oProvider.setAnchorPoints(n6, nArray[0], nArray[1]);
                this.oProvider.setStyle(n6, VectorOverlayStyles.FILLED_WITH_OUTLINE);
                this.oProvider.setColour(n6, this.oColour);
                this.oProvider.setOutlineColour(n6, this.oColour);
                this.oProvider.setLineThickness(n6, this.oThickness);
                this.oProvider.setTransparency(n6, 0.9);
                this.oProvider.setOutlineTransparency(n6, this.oTransparency);
            }
            ++n4;
        }
        this.oProvider.end(OverlayType.VECTOR2D);
    }

    @Override
    protected void drawOverlays() {
        if (this.oProvider == null) {
            return;
        }
        if (this.roiDataList.size() == 0) {
            return;
        }
        if (this.roisIDs.size() != this.roiDataList.size()) {
            logger.warn("Mismatch in number of primitives and ROIs!");
        }
        this.oProvider.begin(OverlayType.VECTOR2D);
        int n = 0;
        int n2 = this.roiDataList.size();
        while (n < n2) {
            int n3 = -1;
            try {
                n3 = (Integer)this.roisIDs.get(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.roisIDs.add(n, -1);
            }
            if (n3 == -1) {
                n3 = this.oProvider.registerPrimitive(PrimitiveType.BOX);
                this.roisIDs.set(n, n3);
            } else {
                this.oProvider.setPrimitiveVisible(n3, true);
            }
            RectangularROI rectangularROI = (RectangularROI)((ROIData)this.roiDataList.get(n)).getROI();
            int[] nArray = rectangularROI.getIntPoint();
            int[] nArray2 = rectangularROI.getIntLengths();
            this.oProvider.drawBox(n3, nArray[0], nArray[1], nArray[0] + nArray2[0], nArray[1] + nArray2[1]);
            this.oProvider.rotatePrimitive(n3, -rectangularROI.getAngle(), nArray[0], nArray[1]);
            this.oProvider.setColour(n3, this.oColour);
            this.oProvider.setTransparency(n3, this.oTransparency);
            ++n;
        }
        this.oProvider.end(OverlayType.VECTOR2D);
    }

    @Override
    public void imageStart(IImagePositionEvent iImagePositionEvent) {
        this.hStatus = HandleStatus.NONE;
        if (this.roi == null) {
            this.roi = new RectangularROI();
            this.roiHandler.setROI(this.roi);
        }
        int n = iImagePositionEvent.getPrimitiveID();
        short s = iImagePositionEvent.getFlags();
        this.cpt = iImagePositionEvent.getImagePosition();
        if ((s & 1) != 0) {
            if (n == -1 || !this.roiHandler.contains(n)) {
                this.roi.setPoint(this.cpt);
                if (this.oProvider != null) {
                    this.oProvider.setPlotAreaCursor(2);
                }
                this.hideCurrent();
                this.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        BoxProfile.this.spsx.setSelection(BoxProfile.this.roi.getIntPoint()[0]);
                        BoxProfile.this.spsy.setSelection(BoxProfile.this.roi.getIntPoint()[1]);
                    }
                });
                this.hStatus = HandleStatus.RESIZE;
                this.dragging = true;
            } else if (this.roiHandler.contains(n)) {
                int n2 = this.roiHandler.indexOf(n);
                if (n2 != 4) {
                    if ((s & 8) != 0) {
                        if (n2 % 2 == 1) {
                            this.hStatus = HandleStatus.ROTATE;
                            this.oProvider.setPlotAreaCursor(3);
                        } else {
                            this.hStatus = HandleStatus.REORIENT;
                            this.oProvider.setPlotAreaCursor(19);
                        }
                    } else {
                        this.hStatus = HandleStatus.RESIZE;
                        this.oProvider.setPlotAreaCursor(5);
                    }
                } else if (n2 == 4) {
                    if ((s & 8) != 0) {
                        this.hStatus = HandleStatus.ROTATE;
                        this.oProvider.setPlotAreaCursor(3);
                    } else {
                        this.hStatus = HandleStatus.MOVE;
                        this.oProvider.setPlotAreaCursor(21);
                    }
                }
                this.hideCurrent();
                this.drawDraggedOverlay(this.roi);
                this.dragging = true;
                this.dragHandle = n2;
                logger.debug("Selected handle {}", (Object)n2);
            }
        } else if ((s & 2) != 0 && this.roiHandler.contains(n)) {
            int n3 = this.roiHandler.indexOf(n);
            if (n3 != 4) {
                if (n3 % 2 == 1) {
                    this.hStatus = HandleStatus.ROTATE;
                    this.oProvider.setPlotAreaCursor(3);
                } else {
                    this.hStatus = HandleStatus.REORIENT;
                    this.oProvider.setPlotAreaCursor(19);
                }
            } else if (n3 == 4) {
                this.hStatus = HandleStatus.ROTATE;
                this.oProvider.setPlotAreaCursor(3);
            }
            this.hideCurrent();
            this.drawDraggedOverlay(this.roi);
            this.dragging = true;
            this.dragHandle = n3;
        }
    }

    private RectangularROI interpretMouseDragging(int[] nArray) {
        RectangularROI rectangularROI = (RectangularROI)this.roi;
        RectangularROI rectangularROI2 = null;
        switch (this.hStatus) {
            case MOVE: {
                rectangularROI2 = rectangularROI.copy();
                nArray[0] = nArray[0] - this.cpt[0];
                nArray[1] = nArray[1] - this.cpt[1];
                rectangularROI2.addPoint(nArray);
                break;
            }
            case NONE: {
                rectangularROI2 = rectangularROI.copy();
                rectangularROI2.setEndPoint(nArray);
                break;
            }
            case REORIENT: {
                rectangularROI2 = ((RectangularROIHandler)this.roiHandler).reorient(this.dragHandle, nArray);
                break;
            }
            case RESIZE: {
                rectangularROI2 = ((RectangularROIHandler)this.roiHandler).resize(this.dragHandle, this.cpt, nArray);
                break;
            }
            case ROTATE: {
                rectangularROI2 = rectangularROI.copy();
                double d = rectangularROI2.getAngleRelativeToMidPoint(nArray);
                double[] dArray = rectangularROI2.getMidPoint();
                rectangularROI2.setAngle(d);
                rectangularROI2.setMidPoint(dArray);
            }
        }
        return rectangularROI2;
    }

    @Override
    public void imageDragged(IImagePositionEvent iImagePositionEvent) {
        RectangularROI rectangularROI;
        if (this.dragging && (rectangularROI = this.interpretMouseDragging(iImagePositionEvent.getImagePosition())) != null) {
            this.drawDraggedOverlay((ROIBase)rectangularROI);
            if (System.currentTimeMillis() >= this.nextTime) {
                this.nextTime = System.currentTimeMillis() + this.updateInterval;
                this.updatePlot((ROIBase)rectangularROI);
                this.sendCurrentROI((ROIBase)rectangularROI);
                this.updateAllSpinners((ROIBase)rectangularROI);
            }
        }
    }

    @Override
    public void imageFinished(IImagePositionEvent iImagePositionEvent) {
        if (this.dragging) {
            this.dragging = false;
            this.hideIDs(this.dragIDs);
            this.oProvider.restoreDefaultPlotAreaCursor();
            this.roi = this.interpretMouseDragging(iImagePositionEvent.getImagePosition());
            this.roiHandler.setROI(this.roi);
            this.dragHandle = -1;
            this.hStatus = HandleStatus.NONE;
            this.drawCurrentOverlay();
            this.sendCurrentROI(this.roi);
            this.updateAllSpinners(this.roi);
            this.updatePlot();
        }
    }

    @Override
    protected void updateAllSpinners(ROIBase rOIBase) {
        if (rOIBase == null) {
            return;
        }
        final RectangularROI rectangularROI = (RectangularROI)rOIBase;
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                BoxProfile.this.spsx.setSelection(rectangularROI.getIntPoint()[0]);
                BoxProfile.this.spsy.setSelection(rectangularROI.getIntPoint()[1]);
                BoxProfile.this.splmaj.setFloat(rectangularROI.getLengths()[0]);
                BoxProfile.this.splmin.setFloat(rectangularROI.getLengths()[1]);
                BoxProfile.this.spang.setFloat(rectangularROI.getAngleDegrees());
            }
        });
    }

    @Override
    public int updateGUI(GuiBean guiBean) {
        Object object;
        int n = 0;
        if (guiBean == null) {
            return n;
        }
        logger.debug("Bean: {}", (Object)guiBean);
        if (guiBean.containsKey((Object)GuiParameters.ROIDATA) && (object = guiBean.get((Object)GuiParameters.ROIDATA)) instanceof RectangularROI) {
            this.hideCurrent();
            this.roi = (RectangularROI)object;
            this.roiHandler.setROI(this.roi);
            this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    BoxProfile.this.updatePlot();
                    BoxProfile.this.drawOverlays();
                    BoxProfile.this.drawCurrentOverlay();
                }
            });
            this.updateAllSpinners(this.roi);
            n |= 1;
        }
        if (guiBean.containsKey((Object)GuiParameters.ROIDATALIST)) {
            object = guiBean.get((Object)GuiParameters.ROIDATALIST);
            if (this.data != null && object instanceof ROIList) {
                ROIList rOIList = (ROIList)object;
                boolean bl = false;
                for (ROIBase rOIBase : rOIList) {
                    if (!(rOIBase instanceof RectangularROI)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    this.getDataset();
                    this.removeIDs(this.roisIDs);
                    this.roisIDs.clear();
                    this.roiDataList.clear();
                    for (ROIBase rOIBase : rOIList) {
                        if (!(rOIBase instanceof RectangularROI)) continue;
                        this.roiDataList.add(new RectangularROIData((RectangularROI)rOIBase, this.data, false));
                        this.roisIDs.add(-1);
                    }
                    this.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            BoxProfile.this.updatePlot();
                            BoxProfile.this.tViewer.setInput(BoxProfile.this.roiDataList);
                            BoxProfile.this.hideCurrent();
                            BoxProfile.this.removeIDs(BoxProfile.this.roiIDs);
                            BoxProfile.this.removeHandles();
                            BoxProfile.this.drawOverlays();
                            BoxProfile.this.drawCurrentOverlay();
                        }
                    });
                    n |= 2;
                }
            }
        }
        return n;
    }

    @Override
    public Action createSwitchAction(int n, IPlotUI iPlotUI) {
        Action action = super.createSwitchAction(n, iPlotUI);
        action.setText("Box profile");
        action.setToolTipText("Switch side plot to box profile mode");
        action.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/ProfileBox.png"));
        return action;
    }

    @Override
    protected void updateDataList() {
        if (this.getDataset()) {
            int n = 0;
            int n2 = this.roiDataList.size();
            while (n < n2) {
                RectangularROIData rectangularROIData = (RectangularROIData)this.roiDataList.get(n);
                RectangularROI rectangularROI = rectangularROIData.getROI();
                this.roiDataList.set(n, new RectangularROIData(rectangularROI, this.data, rectangularROIData.isPlot()));
                ++n;
            }
        }
    }

    @Override
    public void addToHistory() {
        Plot1DAppearance plot1DAppearance = new Plot1DAppearance(PlotColorUtility.getDefaultColour(this.majPlotter.getColourTable().getLegendSize()), Plot1DStyles.SOLID, "History " + this.majPlotter.getNumHistory());
        this.majPlotter.getColourTable().addEntryOnLegend(plot1DAppearance);
        this.majPlotter.pushGraphOntoHistory();
        plot1DAppearance = new Plot1DAppearance(PlotColorUtility.getDefaultColour(this.minPlotter.getColourTable().getLegendSize()), Plot1DStyles.SOLID, "History " + this.minPlotter.getNumHistory());
        this.minPlotter.getColourTable().addEntryOnLegend(plot1DAppearance);
        this.minPlotter.pushGraphOntoHistory();
    }

    @Override
    public void removeFromHistory() {
        if (this.majPlotter.getNumHistory() > 0) {
            this.majPlotter.getColourTable().deleteLegendEntry(this.majPlotter.getColourTable().getLegendSize() - 1);
            this.majPlotter.popGraphFromHistory();
            this.majPlotter.refresh(true);
        }
        if (this.minPlotter.getNumHistory() > 0) {
            this.minPlotter.getColourTable().deleteLegendEntry(this.minPlotter.getColourTable().getLegendSize() - 1);
            this.minPlotter.popGraphFromHistory();
            this.minPlotter.refresh(true);
        }
    }

    private static enum HandleStatus {
        NONE,
        MOVE,
        RESIZE,
        REORIENT,
        ROTATE;

    }
}

