/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.roi;

import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ROITableViewer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.RectangularROIData;
import uk.ac.diamond.scisoft.analysis.roi.RectangularROI;

public final class RectangularROITableViewer
extends ROITableViewer {
    public RectangularROITableViewer(Composite composite, SelectionListener selectionListener, ICellEditorListener iCellEditorListener) {
        super(composite, selectionListener, iCellEditorListener);
    }

    @Override
    public String content(Object object, int n) {
        String string = null;
        RectangularROIData rectangularROIData = (RectangularROIData)object;
        if (rectangularROIData != null) {
            RectangularROI rectangularROI = rectangularROIData.getROI();
            switch (n) {
                case 1: {
                    string = Integer.toString(rectangularROI.getIntPoint()[0]);
                    break;
                }
                case 2: {
                    string = Integer.toString(rectangularROI.getIntPoint()[1]);
                    break;
                }
                case 3: {
                    string = String.format("%.2f", rectangularROI.getLengths()[0]);
                    break;
                }
                case 4: {
                    string = String.format("%.2f", rectangularROI.getLengths()[1]);
                    break;
                }
                case 5: {
                    string = String.format("%.2f", rectangularROI.getAngleDegrees());
                    break;
                }
                case 6: {
                    if (rectangularROI.isClippingCompensation()) {
                        string = "Y";
                        break;
                    }
                    string = "N";
                    break;
                }
                case 7: {
                    string = String.format("%.2f", rectangularROIData.getProfileSum());
                }
            }
        }
        return string;
    }

    @Override
    public String[] getTitles() {
        return new String[]{"Plot", "x_s", "y_s", "w", "h", "phi", "Clip", "Sum"};
    }

    @Override
    public int[] getWidths() {
        return new int[]{40, 50, 50, 70, 70, 70, 40, 80};
    }

    @Override
    public String[] getTipTexts() {
        return new String[]{"Plot", "Start x", "Start y", "Width", "Height", "Angle", "Clipping compensation", "Sum of profile"};
    }
}

