/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay;

import de.jreality.geometry.IndexedFaceSetFactory;
import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.scene.Appearance;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.shader.DefaultGeometryShader;
import de.jreality.shader.DefaultLineShader;
import de.jreality.shader.DefaultPolygonShader;
import de.jreality.shader.ShaderUtility;
import java.awt.Color;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.VectorOverlayStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.OverlayPrimitive;

public class TrianglePrimitive
extends OverlayPrimitive {
    private double[][] coords;
    private int[][] faces;
    private int[][] edges;
    private DefaultLineShader dls = null;
    private DefaultGeometryShader dgs = null;
    private DefaultPolygonShader dps = null;
    private VectorOverlayStyles currentStyle = VectorOverlayStyles.FILLED;
    private Color outlineColour;
    private IndexedFaceSetFactory factory = null;
    private double lineThickness = 1.0;

    public TrianglePrimitive(SceneGraphComponent sceneGraphComponent) {
        this(sceneGraphComponent, false);
    }

    public TrianglePrimitive(SceneGraphComponent sceneGraphComponent, boolean bl) {
        super(sceneGraphComponent, bl);
        this.ap = new Appearance();
        sceneGraphComponent.setAppearance(this.ap);
        this.ap.setAttribute("pointShader.spheresDraw", false);
        this.ap.setAttribute("lineShader.tubeDraw", false);
        this.ap.setAttribute("lightingEnabled", false);
        this.ap.setAttribute("useGLSL", false);
        this.dgs = ShaderUtility.createDefaultGeometryShader((Appearance)this.ap, (boolean)true);
        this.dls = (DefaultLineShader)this.dgs.createLineShader("default");
        this.dls.setDiffuseColor(Color.WHITE);
        this.dps = (DefaultPolygonShader)this.dgs.createPolygonShader("default");
        this.dps.setDiffuseColor(Color.WHITE);
        this.dgs.setShowFaces(Boolean.valueOf(true));
        this.dgs.setShowLines(Boolean.valueOf(false));
        this.dgs.setShowPoints(Boolean.valueOf(false));
        this.factory = new IndexedFaceSetFactory();
        this.coords = new double[3][3];
        this.faces = new int[1][3];
        this.edges = new int[3][2];
        this.faces[0][0] = 0;
        this.faces[0][1] = 1;
        this.faces[0][2] = 2;
        this.edges[0][0] = 0;
        this.edges[0][1] = 1;
        this.edges[1][0] = 1;
        this.edges[1][1] = 2;
        this.edges[2][0] = 2;
        this.edges[2][1] = 0;
    }

    @Override
    public void setOutlineColour(Color color) {
        if (this.outlineColour != color) {
            this.outlineColour = color;
            this.needToUpdateApp = true;
        }
    }

    @Override
    public void setStyle(VectorOverlayStyles vectorOverlayStyles) {
        if (this.currentStyle != vectorOverlayStyles) {
            this.needToUpdateApp = true;
            this.currentStyle = vectorOverlayStyles;
        }
    }

    public void setTriangleCoords(double d, double d2, double d3, double d4, double d5, double d6) {
        this.coords[0][0] = d;
        this.coords[0][1] = d2;
        this.coords[0][2] = 5.0E-4;
        this.coords[1][0] = d3;
        this.coords[1][1] = d4;
        this.coords[1][2] = 5.0E-4;
        this.coords[2][0] = d5;
        this.coords[2][1] = d6;
        this.coords[2][2] = 5.0E-4;
        this.needToUpdateGeom = true;
    }

    private IndexedFaceSet createTriangleGeometry() {
        this.factory.setEdgeCount(3);
        this.factory.setFaceCount(1);
        this.factory.setVertexCount(3);
        this.factory.setVertexCoordinates(this.coords);
        this.factory.setEdgeIndices(this.edges);
        this.factory.setFaceIndices(this.faces);
        this.factory.update();
        return this.factory.getIndexedFaceSet();
    }

    @Override
    public void updateNode() {
        if (this.needToUpdateTrans) {
            MatrixBuilder.euclidean((Matrix)this.transformMatrix).assignTo(this.comp);
        }
        if (this.needToUpdateGeom) {
            this.comp.setGeometry((Geometry)this.createTriangleGeometry());
        }
        if (this.needToUpdateApp) {
            this.dls.setDiffuseColor(this.colour);
            this.dps.setDiffuseColor(this.colour);
            this.dls.setLineWidth(Double.valueOf(this.lineThickness));
            switch (this.currentStyle) {
                case FILLED: {
                    this.dgs.setShowFaces(Boolean.valueOf(true));
                    this.dgs.setShowLines(Boolean.valueOf(false));
                    break;
                }
                case OUTLINE: {
                    this.dgs.setShowFaces(Boolean.valueOf(false));
                    this.dgs.setShowLines(Boolean.valueOf(true));
                    break;
                }
                case FILLED_WITH_OUTLINE: {
                    this.dgs.setShowFaces(Boolean.valueOf(true));
                    this.dgs.setShowLines(Boolean.valueOf(true));
                    this.dls.setDiffuseColor(this.outlineColour);
                }
            }
        }
        this.needToUpdateApp = false;
        this.needToUpdateGeom = false;
        this.needToUpdateTrans = false;
        this.transformMatrix = null;
    }

    @Override
    public void setLineThickness(double d) {
        this.lineThickness = d;
        this.needToUpdateApp = true;
    }

    @Override
    public void setOutlineTransparency(double d) {
        if (d > 0.0) {
            this.ap.setAttribute("lineShader.transparencyEnabled", true);
        } else {
            this.ap.setAttribute("lineShader.transparencyEnabled", false);
        }
        this.ap.setAttribute("lineShader.transparency", d);
        this.ap.setAttribute("additiveBlendingEnabled", true);
    }

    @Override
    public void setTransparency(double d) {
        if (d > 0.0) {
            this.ap.setAttribute("transparencyEnabled", true);
        } else {
            this.ap.setAttribute("transparencyEnabled", false);
        }
        this.ap.setAttribute("polygonShader.transparency", d);
        this.ap.setAttribute("additiveBlendingEnabled", true);
    }
}

