/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay;

import de.jreality.geometry.IndexedFaceSetFactory;
import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.scene.Appearance;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.shader.DefaultGeometryShader;
import de.jreality.shader.DefaultLineShader;
import de.jreality.shader.DefaultPolygonShader;
import de.jreality.shader.ShaderUtility;
import java.awt.Color;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.VectorOverlayStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.OverlayPrimitive;

public class RingPrimitive
extends OverlayPrimitive {
    private double[] coords;
    private int[][] faces;
    private int[][] edges;
    private DefaultLineShader dls = null;
    private DefaultGeometryShader dgs = null;
    private DefaultPolygonShader dps = null;
    private VectorOverlayStyles currentStyle = VectorOverlayStyles.FILLED;
    private static final int NUMOFSEGMENTS = 72;
    private Color outlineColour;
    private double lineThickness = 1.0;

    public RingPrimitive(SceneGraphComponent sceneGraphComponent) {
        this(sceneGraphComponent, false);
    }

    public RingPrimitive(SceneGraphComponent sceneGraphComponent, boolean bl) {
        super(sceneGraphComponent, bl);
        this.ap = new Appearance();
        sceneGraphComponent.setAppearance(this.ap);
        this.ap.setAttribute("pointShader.spheresDraw", false);
        this.ap.setAttribute("lineShader.tubeDraw", false);
        this.ap.setAttribute("lightingEnabled", false);
        this.ap.setAttribute("useGLSL", false);
        this.dgs = ShaderUtility.createDefaultGeometryShader((Appearance)this.ap, (boolean)true);
        this.dls = (DefaultLineShader)this.dgs.createLineShader("default");
        this.dls.setDiffuseColor(Color.WHITE);
        this.dps = (DefaultPolygonShader)this.dgs.createPolygonShader("default");
        this.dps.setDiffuseColor(Color.WHITE);
        this.dgs.setShowFaces(Boolean.valueOf(true));
        this.dgs.setShowLines(Boolean.valueOf(false));
        this.dgs.setShowPoints(Boolean.valueOf(false));
        this.coords = new double[432];
        this.faces = new int[142][3];
        this.edges = new int[144][2];
    }

    @Override
    public void setLineThickness(double d) {
        this.lineThickness = d;
        this.needToUpdateApp = true;
    }

    @Override
    public void setOutlineColour(Color color) {
        if (this.outlineColour != color) {
            this.outlineColour = color;
            this.needToUpdateApp = true;
        }
    }

    @Override
    public void setOutlineTransparency(double d) {
        if (d > 0.0) {
            this.ap.setAttribute("lineShader.transparencyEnabled", true);
        } else {
            this.ap.setAttribute("lineShader.transparencyEnabled", false);
        }
        this.ap.setAttribute("lineShader.transparency", d);
        this.ap.setAttribute("additiveBlendingEnabled", true);
    }

    @Override
    public void setStyle(VectorOverlayStyles vectorOverlayStyles) {
        if (this.currentStyle != vectorOverlayStyles) {
            this.needToUpdateApp = true;
            this.currentStyle = vectorOverlayStyles;
        }
    }

    @Override
    public void setTransparency(double d) {
        if (d > 0.0) {
            this.ap.setAttribute("transparencyEnabled", true);
        } else {
            this.ap.setAttribute("transparencyEnabled", false);
        }
        this.ap.setAttribute("polygonShader.transparency", d);
        this.ap.setAttribute("additiveBlendingEnabled", true);
    }

    public void setRingParameters(double d, double d2, double d3, double d4) {
        double d5 = 0.08849556770675474;
        int n = 0;
        while (n < 72) {
            double d6 = (double)n * d5;
            this.coords[n * 3] = d + d4 * Math.cos(d6);
            this.coords[n * 3 + 1] = d2 + d4 * Math.sin(d6);
            this.coords[n * 3 + 2] = 5.0E-4;
            this.coords[(n + 72) * 3] = d + d3 * Math.cos(d6);
            this.coords[(n + 72) * 3 + 1] = d2 + d3 * Math.sin(d6);
            this.coords[(n + 72) * 3 + 2] = 5.0E-4;
            ++n;
        }
        n = 0;
        while (n < 71) {
            this.faces[n * 2][0] = n;
            this.faces[n * 2][1] = n + 72;
            this.faces[n * 2][2] = n + 72 + 1;
            this.faces[n * 2 + 1][0] = n;
            this.faces[n * 2 + 1][1] = n + 72 + 1;
            this.faces[n * 2 + 1][2] = n + 1;
            ++n;
        }
        n = 0;
        while (n < 71) {
            this.edges[n][0] = n;
            this.edges[n][1] = n + 1;
            this.edges[n + 72][0] = n + 72;
            this.edges[n + 72][1] = n + 72 + 1;
            ++n;
        }
        this.needToUpdateGeom = true;
    }

    private IndexedFaceSet createRingGeometry() {
        IndexedFaceSetFactory indexedFaceSetFactory = new IndexedFaceSetFactory();
        indexedFaceSetFactory.setVertexCount(144);
        indexedFaceSetFactory.setFaceCount(142);
        indexedFaceSetFactory.setEdgeCount(144);
        indexedFaceSetFactory.setVertexCoordinates(this.coords);
        indexedFaceSetFactory.setFaceIndices(this.faces);
        indexedFaceSetFactory.setEdgeIndices(this.edges);
        indexedFaceSetFactory.setGenerateFaceNormals(false);
        indexedFaceSetFactory.update();
        return indexedFaceSetFactory.getIndexedFaceSet();
    }

    @Override
    public void updateNode() {
        if (this.needToUpdateTrans) {
            MatrixBuilder.euclidean((Matrix)this.transformMatrix).assignTo(this.comp);
        }
        if (this.needToUpdateGeom) {
            this.comp.setGeometry((Geometry)this.createRingGeometry());
        }
        if (this.needToUpdateApp) {
            this.dls.setDiffuseColor(this.colour);
            this.dls.setLineWidth(Double.valueOf(this.lineThickness));
            this.dps.setDiffuseColor(this.colour);
            switch (this.currentStyle) {
                case FILLED: {
                    this.dgs.setShowFaces(Boolean.valueOf(true));
                    this.dgs.setShowLines(Boolean.valueOf(false));
                    this.dgs.setShowPoints(Boolean.valueOf(false));
                    break;
                }
                case OUTLINE: {
                    this.dgs.setShowFaces(Boolean.valueOf(false));
                    this.dgs.setShowLines(Boolean.valueOf(true));
                    break;
                }
                case FILLED_WITH_OUTLINE: {
                    this.dgs.setShowFaces(Boolean.valueOf(true));
                    this.dgs.setShowLines(Boolean.valueOf(true));
                    this.dls.setDiffuseColor(this.outlineColour);
                }
            }
        }
        this.needToUpdateApp = false;
        this.needToUpdateGeom = false;
        this.needToUpdateTrans = false;
        this.transformMatrix = null;
    }
}

