/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay;

import de.jreality.geometry.IndexedFaceSetFactory;
import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.scene.Appearance;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.shader.DefaultGeometryShader;
import de.jreality.shader.DefaultLineShader;
import de.jreality.shader.DefaultPolygonShader;
import de.jreality.shader.ShaderUtility;
import java.awt.Color;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.VectorOverlayStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.OverlayPrimitive;

public class EllipsePrimitive
extends OverlayPrimitive {
    private DefaultLineShader dls = null;
    private DefaultGeometryShader dgs = null;
    private DefaultPolygonShader dps = null;
    private VectorOverlayStyles currentStyle = VectorOverlayStyles.FILLED;
    private Color outlineColour;
    private static final int NUMOFSEGMENTS = 72;
    private double lineThickness = 1.0;
    private double[] coords;
    private int[][] faces;
    private int[][] edges;

    public EllipsePrimitive(SceneGraphComponent sceneGraphComponent) {
        this(sceneGraphComponent, false);
    }

    public EllipsePrimitive(SceneGraphComponent sceneGraphComponent, boolean bl) {
        super(sceneGraphComponent, bl);
        this.ap = new Appearance();
        sceneGraphComponent.setAppearance(this.ap);
        this.ap.setAttribute("pointShader.spheresDraw", true);
        this.ap.setAttribute("lineShader.tubeDraw", false);
        this.ap.setAttribute("lightingEnabled", false);
        this.ap.setAttribute("useGLSL", false);
        this.dgs = ShaderUtility.createDefaultGeometryShader((Appearance)this.ap, (boolean)true);
        this.dls = (DefaultLineShader)this.dgs.createLineShader("default");
        this.dls.setDiffuseColor(Color.WHITE);
        this.dps = (DefaultPolygonShader)this.dgs.createPolygonShader("default");
        this.dps.setDiffuseColor(Color.WHITE);
        this.dgs.setShowFaces(Boolean.valueOf(true));
        this.dgs.setShowLines(Boolean.valueOf(false));
        this.dgs.setShowPoints(Boolean.valueOf(false));
        this.coords = new double[219];
        this.faces = new int[72][3];
        this.edges = new int[72][2];
        int n = 0;
        while (n < 72) {
            this.faces[n][0] = 0;
            this.faces[n][1] = n + 1;
            this.faces[n][2] = n + 2;
            if (this.faces[n][2] > 72) {
                this.faces[n][2] = 1;
            }
            this.edges[n][0] = n + 1;
            this.edges[n][1] = n + 2;
            if (this.edges[n][1] > 72) {
                this.edges[n][1] = 1;
            }
            ++n;
        }
    }

    @Override
    public void setLineThickness(double d) {
        this.lineThickness = d;
        this.needToUpdateApp = true;
    }

    @Override
    public void setOutlineColour(Color color) {
        if (this.outlineColour != color) {
            this.outlineColour = color;
            this.needToUpdateApp = true;
        }
    }

    @Override
    public void setOutlineTransparency(double d) {
        if (d > 0.0) {
            this.ap.setAttribute("lineShader.transparencyEnabled", true);
        } else {
            this.ap.setAttribute("lineShader.transparencyEnabled", false);
        }
        this.ap.setAttribute("lineShader.transparency", d);
        this.ap.setAttribute("additiveBlendingEnabled", true);
    }

    @Override
    public void setStyle(VectorOverlayStyles vectorOverlayStyles) {
        if (this.currentStyle != vectorOverlayStyles) {
            this.needToUpdateApp = true;
            this.currentStyle = vectorOverlayStyles;
        }
    }

    @Override
    public void setTransparency(double d) {
        if (d > 0.0) {
            this.ap.setAttribute("transparencyEnabled", true);
        } else {
            this.ap.setAttribute("transparencyEnabled", false);
        }
        this.ap.setAttribute("polygonShader.transparency", d);
        this.ap.setAttribute("additiveBlendingEnabled", true);
    }

    private IndexedFaceSet createElipseGeometry() {
        IndexedFaceSetFactory indexedFaceSetFactory = new IndexedFaceSetFactory();
        indexedFaceSetFactory.setVertexCount(73);
        indexedFaceSetFactory.setFaceCount(72);
        indexedFaceSetFactory.setEdgeCount(72);
        indexedFaceSetFactory.setVertexCoordinates(this.coords);
        indexedFaceSetFactory.setFaceIndices(this.faces);
        indexedFaceSetFactory.setEdgeIndices(this.edges);
        indexedFaceSetFactory.update();
        return indexedFaceSetFactory.getIndexedFaceSet();
    }

    public void setEllipseParameters(double d, double d2, double d3, double d4, double d5) {
        this.coords[0] = d;
        this.coords[1] = d2;
        this.coords[2] = 5.0E-4;
        int n = 0;
        while (n < 72) {
            double d6 = d + d3 * Math.cos((double)n * 2.0 * Math.PI / 72.0) * Math.cos(d5) - d4 * Math.sin((double)n * 2.0 * Math.PI / 72.0) * Math.sin(d5);
            double d7 = d2 + d3 * Math.sin((double)n * 2.0 * Math.PI / 72.0) * Math.sin(d5) + d4 * Math.sin((double)n * 2.0 * Math.PI / 72.0) * Math.cos(d5);
            this.coords[(n + 1) * 3] = d6;
            this.coords[(n + 1) * 3 + 1] = d7;
            this.coords[(n + 1) * 3 + 2] = 5.0E-4;
            ++n;
        }
        this.needToUpdateGeom = true;
    }

    @Override
    public void updateNode() {
        if (this.needToUpdateTrans) {
            MatrixBuilder.euclidean((Matrix)this.transformMatrix).assignTo(this.comp);
        }
        if (this.needToUpdateGeom) {
            this.comp.setGeometry((Geometry)this.createElipseGeometry());
        }
        if (this.needToUpdateApp) {
            this.dls.setDiffuseColor(this.colour);
            this.dps.setDiffuseColor(this.colour);
            this.dls.setLineWidth(Double.valueOf(this.lineThickness));
            switch (this.currentStyle) {
                case FILLED: {
                    this.dgs.setShowFaces(Boolean.valueOf(true));
                    this.dgs.setShowLines(Boolean.valueOf(false));
                    break;
                }
                case OUTLINE: {
                    this.dgs.setShowFaces(Boolean.valueOf(false));
                    this.dgs.setShowLines(Boolean.valueOf(true));
                    break;
                }
                case FILLED_WITH_OUTLINE: {
                    this.dgs.setShowFaces(Boolean.valueOf(true));
                    this.dgs.setShowLines(Boolean.valueOf(true));
                    this.dls.setDiffuseColor(this.outlineColour);
                }
            }
        }
        this.needToUpdateApp = false;
        this.needToUpdateGeom = false;
        this.needToUpdateTrans = false;
        this.transformMatrix = null;
    }
}

