/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.fitting;

import gda.analysis.functions.APeak;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.fitting.FittedPeakData;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ROITableViewer;

public final class FittedPeakTableViewer
extends ROITableViewer {
    public FittedPeakTableViewer(Composite composite, SelectionListener selectionListener, ICellEditorListener iCellEditorListener, ISelectionChangedListener iSelectionChangedListener) {
        super(composite, selectionListener, iCellEditorListener);
        this.addLeftClickListener(iSelectionChangedListener);
    }

    @Override
    public String content(Object object, int n) {
        String string = null;
        FittedPeakData fittedPeakData = (FittedPeakData)object;
        if (fittedPeakData != null) {
            APeak aPeak = fittedPeakData.getFittedPeak().getPeakFitted();
            switch (n) {
                case 1: {
                    string = String.format("%.2f", aPeak.getPosition());
                    break;
                }
                case 2: {
                    string = String.format("%.2f", aPeak.getFWHM());
                    break;
                }
                case 3: {
                    string = String.format("%.2f", aPeak.getArea());
                    break;
                }
                case 4: {
                    string = aPeak.getClass().getSimpleName();
                    break;
                }
                case 5: {
                    string = Integer.toString(fittedPeakData.getPeakColour().getRGB());
                }
            }
        }
        return string;
    }

    @Override
    public String[] getTitles() {
        return new String[]{"Visible", "Peak Position", "FWHM", "Area", "Name", "Colour"};
    }

    @Override
    public int[] getWidths() {
        return new int[]{50, 100, 70, 60, 150, 100};
    }

    @Override
    public String[] getTipTexts() {
        return new String[]{"Visible", "Peak position", "Full width at half maximum", "Area under peak", "Name of distribution", "Colour of peak on plot"};
    }
}

