/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.axis;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Text;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.axis.LabelledSlider;

public class AxisSliders {
    Composite slidersComp;
    List<Label> labels;
    List<LabelledSlider> sliders;
    List<Text> values;

    public AxisSliders(Composite composite) {
        this.slidersComp = composite;
        this.labels = new ArrayList<Label>();
        this.sliders = new ArrayList<LabelledSlider>();
        this.values = new ArrayList<Text>();
    }

    public void createSliders(int n, SelectionListener selectionListener) {
        int n2 = this.sliders.size();
        if (n > n2) {
            int n3 = 0;
            while (n3 < n2) {
                this.sliders.get(n3).setVisible(true);
                ++n3;
            }
            n3 = n2;
            while (n3 < n) {
                this.labels.add(new Label(this.slidersComp, 0));
                this.labels.get(n3).setText("" + (n3 + 1));
                this.sliders.add(new LabelledSlider(this.slidersComp, 256));
                this.sliders.get(n3).addSelectionListener(selectionListener);
                this.values.add(new Text(this.slidersComp, 2056));
                this.values.get(n3).setText("                    ");
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n) {
                this.labels.get(n4).setVisible(true);
                this.sliders.get(n4).setVisible(true);
                this.values.get(n4).setVisible(true);
                ++n4;
            }
            n4 = n;
            while (n4 < n2) {
                this.labels.get(n4).setVisible(false);
                this.sliders.get(n4).setVisible(false);
                this.values.get(n4).setVisible(false);
                ++n4;
            }
        }
    }

    public void enableActiveSliders(boolean[] blArray) {
        int n = this.sliders.size();
        if (blArray.length >= n) {
            int n2 = 0;
            while (n2 < n) {
                this.sliders.get(n2).setEnabled(blArray[n2]);
                this.values.get(n2).setEnabled(blArray[n2]);
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < blArray.length) {
                this.sliders.get(n3).setEnabled(blArray[n3]);
                this.values.get(n3).setEnabled(blArray[n3]);
                ++n3;
            }
            n3 = blArray.length;
            while (n3 < n) {
                this.sliders.get(n3).setEnabled(false);
                this.values.get(n3).setEnabled(false);
                ++n3;
            }
        }
    }

    public void enableActiveSlider(int n, boolean bl) {
        int n2 = this.sliders.size();
        if (n < n2) {
            this.sliders.get(n).setEnabled(bl);
            this.values.get(n).setEnabled(bl);
        }
    }

    public void setSliderParameters(int n, int n2, String string, String string2) {
        LabelledSlider labelledSlider = this.sliders.get(n);
        labelledSlider.setMinMax(0, n2, string, string2);
        labelledSlider.setThumb(1);
        labelledSlider.setIncrements(1, 5);
    }

    public int getSlider(Slider slider) {
        int n = 0;
        while (n < this.sliders.size()) {
            if (this.sliders.get(n).equals(slider)) break;
            ++n;
        }
        return n;
    }

    public void redraw() {
        int n = 0;
        while (n < this.sliders.size()) {
            this.sliders.get(n).redraw();
            ++n;
        }
    }

    public void setValue(int n, String string) {
        if (n < 0 || n > this.values.size()) {
            return;
        }
        this.values.get(n).setText(string);
    }

    public void clear(int n) {
        if (n < 0 || n > this.values.size()) {
            return;
        }
        this.values.get(n).setText("");
        this.sliders.get(n).setValue(0);
    }

    public Composite getComposite() {
        return this.slidersComp;
    }
}

