/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.axis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;

public class AxisSelection {
    private int length;
    private HashMap<String, AxisSelData> asData;
    private List<String> names;
    private List<Integer> orders;

    public AxisSelection(int n) {
        this.length = n;
        this.asData = new HashMap();
        this.names = new ArrayList<String>();
        this.orders = new ArrayList<Integer>();
    }

    public AxisSelection(int n, String[] stringArray, AbstractDataset[] abstractDatasetArray) {
        this(n);
        this.setSelection(stringArray, abstractDatasetArray);
    }

    public int getLength() {
        return this.length;
    }

    public void setSelection(String[] stringArray, AbstractDataset[] abstractDatasetArray) {
        this.asData.clear();
        this.names.clear();
        this.orders.clear();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            this.asData.put(string, new AxisSelData(abstractDatasetArray[n], false));
            this.names.add(string);
            this.orders.add(0);
            ++n;
        }
    }

    public void addSelection(String string, AbstractDataset abstractDataset, int n) {
        if (this.asData.containsKey(string)) {
            if (abstractDataset != this.asData.get(string).getData()) {
                this.asData.put(string, new AxisSelData(abstractDataset, false));
            }
            this.orders.set(this.names.indexOf(string), n);
        } else {
            this.asData.put(string, new AxisSelData(abstractDataset, false));
            this.names.add(string);
            this.orders.add(n);
        }
    }

    public boolean containsAxis(String string) {
        return this.asData.containsKey(string);
    }

    public void selectAxis(String string) {
        for (String string2 : this.asData.keySet()) {
            this.asData.get(string2).setSelected(false);
        }
        this.asData.get(string).setSelected(true);
    }

    public void selectAxis(int n) {
        this.selectAxis(this.names.get(n));
    }

    public String getName(int n) {
        return this.names.get(n);
    }

    public AbstractDataset getAxis(int n) {
        return this.asData.get(this.names.get(n)).getData();
    }

    public int size() {
        return this.names.size();
    }

    public boolean isSelected(int n) {
        return this.asData.get(this.names.get(n)).isSelected();
    }

    public int getSelectedIndex() {
        int n = 0;
        while (n < this.names.size()) {
            if (this.isSelected(n)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public AbstractDataset getSelectedAxis() {
        for (AxisSelData axisSelData : this.asData.values()) {
            if (!axisSelData.selected) continue;
            return axisSelData.data;
        }
        return null;
    }

    public void reorderNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = Collections.max(this.orders);
        int n2 = 1;
        while (n2 <= n) {
            int n3 = 0;
            while (n3 < this.orders.size()) {
                if (this.orders.get(n3) == n2) {
                    arrayList.add(this.names.get(n3));
                }
                ++n3;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.orders.size()) {
            if (this.orders.get(n2) == 0) {
                arrayList.add(this.names.get(n2));
            }
            ++n2;
        }
        this.names = arrayList;
    }

    public int getMaxOrder() {
        return this.orders.size() > 0 ? Collections.max(this.orders) : 0;
    }

    class AxisSelData {
        private boolean selected;
        private AbstractDataset data;

        public AxisSelData(AbstractDataset abstractDataset, boolean bl) {
            this.setData(abstractDataset);
            this.setSelected(bl);
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setData(AbstractDataset abstractDataset) {
            this.data = abstractDataset;
        }

        public AbstractDataset getData() {
            return this.data;
        }
    }
}

