/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.actions;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.rcp.views.ImageExplorerView;
import uk.ac.gda.common.rcp.util.EclipseUtils;

public class ImageExplorerDirectoryChooseAction
extends AbstractHandler {
    private static final String[] LISTOFSUFFIX = new String[]{".png", ".jpg", ".tif", ".tiff", ".mar", ".cbf", ".dat", ".img", ".raw", ".mccd", ".cif", ".imgcif"};
    private static final Logger logger = LoggerFactory.getLogger(ImageExplorerDirectoryChooseAction.class);

    private static ArrayList<String> filterImages(File[] fileArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < fileArray.length) {
            int n2 = 0;
            while (n2 < LISTOFSUFFIX.length) {
                if (fileArray[n].getAbsolutePath().toLowerCase().endsWith(LISTOFSUFFIX[n2])) {
                    arrayList.add(fileArray[n].getAbsolutePath());
                }
                ++n2;
            }
            ++n;
        }
        return arrayList;
    }

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        ImageExplorerView imageExplorerView = (ImageExplorerView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("uk.ac.diamond.scisoft.analysis.rcp.views.ImageExplorerView");
        if (imageExplorerView != null) {
            DirectoryDialog directoryDialog = new DirectoryDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 4096);
            directoryDialog.setFilterPath(imageExplorerView.getDirPath());
            String string = directoryDialog.open();
            if (string != null) {
                ImageExplorerDirectoryChooseAction.setImageFolder(string);
            }
        } else {
            logger.info("Couldn't find view to load for");
        }
        return Boolean.FALSE;
    }

    public static void setImageFolder(String string) {
        IWorkbenchPage iWorkbenchPage = EclipseUtils.getPage();
        if (iWorkbenchPage == null) {
            return;
        }
        final ImageExplorerView imageExplorerView = (ImageExplorerView)iWorkbenchPage.findView("uk.ac.diamond.scisoft.analysis.rcp.views.ImageExplorerView");
        if (imageExplorerView != null) {
            imageExplorerView.setDirPath(string);
            File file = new File(string);
            File[] fileArray = file.listFiles();
            final ArrayList<String> arrayList = ImageExplorerDirectoryChooseAction.filterImages(fileArray);
            if (arrayList.size() > 0) {
                imageExplorerView.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        imageExplorerView.update(ImageExplorerView.FOLDER_UPDATE_MARKER, arrayList);
                    }
                });
            }
            System.gc();
        }
    }
}

