/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionComplexEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.SelectedWindow;

public class PlotDataTableDialog
extends Dialog {
    private Shell shell;
    private PlotActionComplexEvent eventObj;
    private Table tblData;
    private Color grey;

    public PlotDataTableDialog(Shell shell) {
        super(shell);
    }

    public PlotDataTableDialog(Shell shell, PlotActionComplexEvent plotActionComplexEvent) {
        this(shell);
        this.eventObj = plotActionComplexEvent;
    }

    private void fillTable(IDataset iDataset, SelectedWindow selectedWindow) {
        int n = 0;
        while (n < iDataset.getSize()) {
            double d = iDataset.getDouble(new int[]{n});
            TableItem tableItem = new TableItem(this.tblData, 0);
            tableItem.setText(0, "" + n);
            tableItem.setText(1, "" + d);
            if ((double)n < selectedWindow.getStartWindowX() || (double)n > selectedWindow.getEndWindowX()) {
                tableItem.setForeground(0, this.grey);
                tableItem.setForeground(1, this.grey);
            }
            ++n;
        }
    }

    private void fillTable(IDataset iDataset, AxisValues axisValues, SelectedWindow selectedWindow) {
        Iterator<Double> iterator = axisValues.getIterator();
        int n = 0;
        while (n < iDataset.getSize()) {
            double d = iterator.next();
            double d2 = iDataset.getDouble(new int[]{n});
            TableItem tableItem = new TableItem(this.tblData, 0);
            tableItem.setText(0, "" + d);
            tableItem.setText(1, "" + d2);
            if (d < selectedWindow.getStartWindowX() || d > selectedWindow.getEndWindowX()) {
                tableItem.setForeground(0, this.grey);
                tableItem.setForeground(1, this.grey);
            }
            ++n;
        }
    }

    public boolean open() {
        Object object;
        Shell shell = this.getParent();
        this.shell = new Shell(shell, 16);
        this.shell.setSize(418, 280);
        this.shell.setText("Data table");
        this.shell.setImage(AnalysisRCPActivator.getImageDescriptor("icons/information.png").createImage());
        this.shell.setLayout((Layout)new GridLayout());
        this.tblData = new Table((Composite)this.shell, 268503042);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 280;
        this.tblData.setLayoutData((Object)gridData);
        this.tblData.setLinesVisible(true);
        this.tblData.setHeaderVisible(true);
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayoutData((Object)new GridData(131072, 0, false, false));
        composite.setLayout((Layout)new RowLayout(256));
        Button button = new Button(composite, 0);
        button.setText("Export...");
        button.setImage(AnalysisRCPActivator.getImageDescriptor("icons/folder_go.png").createImage());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    PlotDataTableDialog.this.exportFile();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        Button button2 = new Button(composite, 0);
        button2.setText("Close");
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PlotDataTableDialog.this.shell.dispose();
            }
        });
        this.grey = this.shell.getParent().getDisplay().getSystemColor(15);
        String[] stringArray = new String[]{"X value", "Y value"};
        int n = 0;
        while (n < stringArray.length) {
            object = new TableColumn(this.tblData, 0);
            object.setText(stringArray[n]);
            object.pack();
            object.setWidth(180);
            ++n;
        }
        this.shell.open();
        IDataset iDataset = this.eventObj.getDataSet();
        object = this.eventObj.getAxisValue();
        SelectedWindow selectedWindow = this.eventObj.getDataWindow();
        if (object == null) {
            this.fillTable(iDataset, selectedWindow);
        } else {
            this.fillTable(iDataset, (AxisValues)object, selectedWindow);
        }
        Display display = shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return true;
    }

    protected void exportFile() throws Exception {
        FileDialog fileDialog = new FileDialog(this.shell, 8192);
        fileDialog.setFilterNames(new String[]{"Text Files", "All Files (*)"});
        fileDialog.setFilterExtensions(new String[]{"*.txt;*.dat", "*"});
        fileDialog.setFilterPath(System.getProperty("gda.data"));
        String string = this.eventObj.getDataSet().getName() != null && !"".equals(this.eventObj.getDataSet().getName()) ? this.eventObj.getDataSet().getName() : "Export";
        fileDialog.setFileName(String.valueOf(string) + ".dat");
        String string2 = fileDialog.open();
        if (string2 == null) {
            return;
        }
        File file = new File(string2);
        if (!file.exists()) {
            file.createNewFile();
        } else {
            boolean bl = MessageDialog.openConfirm((Shell)this.shell, (String)"Confirm Overwrite", (String)("Would you like to overwrite the existing file '" + file.getName() + "'?"));
            if (!bl) {
                return;
            }
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        try {
            bufferedWriter.write("# GDA data exported " + DateFormat.getDateTimeInstance().format(new Date()));
            bufferedWriter.newLine();
            bufferedWriter.write("# x\ty");
            bufferedWriter.newLine();
            int n = 0;
            while (n < this.tblData.getItemCount()) {
                TableItem tableItem = this.tblData.getItem(n);
                bufferedWriter.write(tableItem.getText(0));
                bufferedWriter.write("\t");
                bufferedWriter.write(tableItem.getText(1));
                bufferedWriter.newLine();
                ++n;
            }
        }
        finally {
            bufferedWriter.close();
        }
    }
}

