/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.DataSetWithAxisInformation;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IGuiInfoManager;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DAppearance;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DGraphTable;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DUIAdapter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotColorUtility;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotDataTableDialog;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotException;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotWindow;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.SidePlotUtils;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionComplexEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionEvent;
import uk.ac.diamond.scisoft.analysis.rcp.views.SidePlotView;

public class Plot1DUIComplete
extends Plot1DUIAdapter {
    public static final String STATUSITEMID = "uk.ac.dimaond.scisoft.analysis.rcp.plotting.Plot1DUI";
    private static final String STATUSSTRING = "Pos: ";
    private StatusLineContributionItem statusLine;
    private AxisValues xAxis;
    private IWorkbenchPage page;
    private String plotViewID;
    private PlotWindow plotWindow;
    private List<Action> switchToTabs;
    private IGuiInfoManager manager;

    public Plot1DUIComplete(PlotWindow plotWindow, IGuiInfoManager iGuiInfoManager, IActionBars iActionBars, Composite composite, IWorkbenchPage iWorkbenchPage, String string) {
        super(plotWindow.getMainPlotter(), composite, string);
        this.page = iWorkbenchPage;
        this.plotWindow = plotWindow;
        this.plotViewID = string;
        this.xAxis = new AxisValues();
        this.manager = iGuiInfoManager;
        this.initSidePlotView();
        this.buildToolActions(iActionBars.getToolBarManager());
        this.buildMenuActions(iActionBars.getMenuManager());
        this.buildStatusLineItems(iActionBars.getStatusLineManager());
    }

    @Override
    public void initSidePlotView() {
        try {
            SidePlotView sidePlotView = this.getSidePlotView();
            sidePlotView.setPlotView(this.plotWindow.getMainPlotter(), this.manager);
            sidePlotView.setSwitchActions(this.switchToTabs);
            SidePlotUtils.bringToTop(this.page, (IWorkbenchPart)sidePlotView);
        }
        catch (IllegalStateException illegalStateException) {}
    }

    @Override
    public SidePlotView getSidePlotView() {
        return SidePlotUtils.getSidePlotView(this.page, this.plotViewID);
    }

    @Override
    public void deactivate(boolean bl) {
        super.deactivate(bl);
        try {
            this.getSidePlotView().deactivate(bl);
        }
        catch (IllegalStateException illegalStateException) {}
    }

    @Override
    public void buildStatusLineItems(IStatusLineManager iStatusLineManager) {
        this.statusLine = new StatusLineContributionItem(STATUSITEMID);
        this.statusLine.setText(STATUSSTRING);
        iStatusLineManager.add((IContributionItem)this.statusLine);
    }

    @Override
    public void buildMenuActions(IMenuManager iMenuManager) {
        MenuManager menuManager = new MenuManager("X-Axis");
        MenuManager menuManager2 = new MenuManager("Y-Axis");
        iMenuManager.add((IContributionItem)menuManager);
        iMenuManager.add((IContributionItem)menuManager2);
        menuManager.add((IAction)this.xLabelTypeRound);
        menuManager.add((IAction)this.xLabelTypeFloat);
        menuManager.add((IAction)this.xLabelTypeExponent);
        menuManager.add((IAction)this.xLabelTypeSI);
        menuManager2.add((IAction)this.yLabelTypeRound);
        menuManager2.add((IAction)this.yLabelTypeFloat);
        menuManager2.add((IAction)this.yLabelTypeExponent);
        menuManager2.add((IAction)this.yLabelTypeSI);
        iMenuManager.add((IAction)this.yAxisScaleLinear);
        iMenuManager.add((IAction)this.yAxisScaleLog);
    }

    @Override
    public void buildToolActions(IToolBarManager iToolBarManager) {
        try {
            this.switchToTabs = this.getSidePlotView().createSwitchActions(this);
            for (Action action : this.switchToTabs) {
                iToolBarManager.add((IAction)action);
            }
        }
        catch (IllegalStateException illegalStateException) {}
        iToolBarManager.add((IAction)this.addToHistory);
        iToolBarManager.add((IAction)this.removeFromHistory);
        iToolBarManager.add((IAction)this.activateRegionZoom);
        iToolBarManager.add((IAction)this.activateAreaZoom);
        iToolBarManager.add((IAction)this.zoomAction);
        iToolBarManager.add((IAction)this.resetZoomAction);
        iToolBarManager.add((IAction)this.changeColour);
        iToolBarManager.add((IAction)this.activateXgrid);
        iToolBarManager.add((IAction)this.activateYgrid);
        iToolBarManager.add((IAction)this.displayPlotPos);
        iToolBarManager.add((IAction)this.saveGraph);
        iToolBarManager.add((IAction)this.printGraph);
        iToolBarManager.add((IAction)this.rightClickOnGraphAction);
    }

    @Override
    public void plotActionPerformed(final PlotActionEvent plotActionEvent) {
        if (plotActionEvent instanceof PlotActionComplexEvent) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PlotDataTableDialog plotDataTableDialog = new PlotDataTableDialog(Plot1DUIComplete.this.parent.getShell(), (PlotActionComplexEvent)plotActionEvent);
                    plotDataTableDialog.open();
                }
            });
        } else {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    int n = (int)Math.max(-Math.floor(Math.log10(Math.abs(plotActionEvent.getPosition()[0]))), 3.0);
                    String string = String.format("%%.%df", n + 1);
                    String string2 = String.format(string, plotActionEvent.getPosition()[0]);
                    n = (int)Math.max(-Math.floor(Math.log10(Math.abs(plotActionEvent.getPosition()[1]))), 3.0);
                    string = String.format("%%.%df", n + 1);
                    String string3 = String.format(string, plotActionEvent.getPosition()[1]);
                    Plot1DUIComplete.this.statusLine.setText("Pos:  " + string2 + ":" + string3);
                }
            });
        }
    }

    @Override
    public void processPlotUpdate(DataBean dataBean, boolean bl) {
        Collection collection = dataBean.getData();
        if (collection != null) {
            Plot1DAppearance plot1DAppearance;
            Object object;
            Iterator iterator = collection.iterator();
            List<IDataset> list = Collections.synchronizedList(new LinkedList());
            this.xAxis.clear();
            IDataset iDataset = dataBean.getAxis("x-axis");
            if (iDataset != null) {
                object = iDataset.getName();
                if (object != null && ((String)object).length() > 0) {
                    this.plotter.setXAxisLabel((String)object);
                } else {
                    this.plotter.setXAxisLabel("X-Axis");
                }
                int n = 0;
                while (n < iDataset.getShape()[0]) {
                    this.xAxis.addValue(iDataset.getDouble(new int[]{n++}));
                }
            } else {
                this.plotter.setXAxisLabel("X-Axis");
            }
            object = this.plotter.getColourTable();
            ((Plot1DGraphTable)object).clearLegend();
            if (iDataset != null) {
                this.plotter.setAxisModes(AxisMode.CUSTOM, AxisMode.LINEAR, AxisMode.LINEAR);
                this.plotter.setXAxisValues(this.xAxis, collection.size());
            } else {
                this.plotter.setAxisModes(AxisMode.LINEAR, AxisMode.LINEAR, AxisMode.LINEAR);
            }
            while (iterator.hasNext()) {
                DataSetWithAxisInformation dataSetWithAxisInformation = (DataSetWithAxisInformation)iterator.next();
                IDataset iDataset2 = dataSetWithAxisInformation.getData();
                plot1DAppearance = new Plot1DAppearance(PlotColorUtility.getDefaultColour(((Plot1DGraphTable)object).getLegendSize()), PlotColorUtility.getDefaultStyle(((Plot1DGraphTable)object).getLegendSize()), PlotColorUtility.getDefaultLineWidth(((Plot1DGraphTable)object).getLegendSize()), iDataset2.getName());
                ((Plot1DGraphTable)object).addEntryOnLegend(plot1DAppearance);
                list.add(iDataset2);
            }
            int n = this.plotter.getNumHistory();
            int n2 = 0;
            while (n2 < n) {
                plot1DAppearance = new Plot1DAppearance(PlotColorUtility.getDefaultColour(((Plot1DGraphTable)object).getLegendSize()), PlotColorUtility.getDefaultStyle(((Plot1DGraphTable)object).getLegendSize()), PlotColorUtility.getDefaultLineWidth(((Plot1DGraphTable)object).getLegendSize()), "History " + (n2 + 1));
                ((Plot1DGraphTable)object).addEntryOnLegend(plot1DAppearance);
                ++n2;
            }
            this.plotter.setPlotUpdateOperation(bl);
            try {
                this.plotter.replaceAllPlots(list);
            }
            catch (PlotException plotException) {
                plotException.printStackTrace();
            }
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Plot1DUIComplete.this.plotter.refresh(true);
                    Plot1DUIComplete.this.plotter.updateAllAppearance();
                    Plot1DUIComplete.this.getSidePlotView().processPlotUpdate();
                    Plot1DUIComplete.this.plotWindow.notifyUpdateFinished();
                }
            });
        }
    }
}

