/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import de.jreality.shader.DefaultGeometryShader;
import de.jreality.shader.DefaultLineShader;
import de.jreality.shader.DefaultPointShader;
import java.awt.Color;
import java.io.Serializable;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.Plot1DStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.legend.TableCanvas;

public class Plot1DAppearance
implements Serializable {
    private Color plotColour;
    private Plot1DStyles plotStyle;
    private int lineWidth;
    private String plotName;
    private boolean visible;

    public Plot1DAppearance(Color color, Plot1DStyles plot1DStyles, int n, String string, boolean bl) {
        this.plotColour = color;
        this.plotStyle = plot1DStyles;
        this.lineWidth = n;
        this.plotName = string;
        this.visible = bl;
    }

    public Plot1DAppearance(Color color, Plot1DStyles plot1DStyles, int n, String string) {
        this(color, plot1DStyles, n, string, true);
    }

    public Plot1DAppearance(Color color, Plot1DStyles plot1DStyles, String string) {
        this(color, plot1DStyles, 2, string, true);
    }

    public Plot1DAppearance(Color color, String string) {
        this(color, Plot1DStyles.SOLID, 1, string, true);
    }

    public Color getColour() {
        return this.plotColour;
    }

    public void setColour(Color color) {
        this.plotColour = color;
    }

    public Plot1DStyles getStyle() {
        return this.plotStyle;
    }

    public void setStyle(Plot1DStyles plot1DStyles) {
        this.plotStyle = plot1DStyles;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public String getName() {
        return this.plotName;
    }

    public void setName(String string) {
        this.plotName = string;
    }

    public void setLineWidth(int n) {
        this.lineWidth = n;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void updateGraph(DefaultLineShader defaultLineShader, DefaultGeometryShader defaultGeometryShader) {
        defaultLineShader.setDiffuseColor(this.plotColour);
        defaultLineShader.setLineWidth(Double.valueOf(this.lineWidth));
        switch (this.plotStyle) {
            case SOLID: {
                defaultLineShader.setLineStipple(Boolean.valueOf(false));
                defaultGeometryShader.setShowLines(Boolean.valueOf(true));
                defaultGeometryShader.setShowPoints(Boolean.valueOf(false));
                break;
            }
            case DASHED: {
                defaultGeometryShader.setShowLines(Boolean.valueOf(true));
                defaultGeometryShader.setShowPoints(Boolean.valueOf(false));
                defaultLineShader.setLineStipple(Boolean.valueOf(true));
                break;
            }
            case POINT: {
                defaultLineShader.setLineStipple(Boolean.valueOf(false));
                defaultGeometryShader.setShowLines(Boolean.valueOf(false));
                defaultGeometryShader.setShowPoints(Boolean.valueOf(true));
                DefaultPointShader defaultPointShader = (DefaultPointShader)defaultGeometryShader.createPointShader("default");
                defaultPointShader.setSpheresDraw(Boolean.valueOf(false));
                defaultPointShader.setDiffuseColor(defaultLineShader.getDiffuseColor());
                defaultPointShader.setPointSize(Double.valueOf(this.lineWidth));
                break;
            }
            case SOLID_POINT: {
                defaultLineShader.setLineStipple(Boolean.valueOf(false));
                defaultGeometryShader.setShowLines(Boolean.valueOf(true));
                defaultGeometryShader.setShowPoints(Boolean.valueOf(true));
                DefaultPointShader defaultPointShader = (DefaultPointShader)defaultGeometryShader.createPointShader("default");
                defaultPointShader.setSpheresDraw(Boolean.valueOf(false));
                defaultPointShader.setDiffuseColor(defaultLineShader.getDiffuseColor());
                double d = (double)this.lineWidth * 4.0;
                if (d < 4.0) {
                    d = 4.0;
                }
                defaultPointShader.setPointSize(Double.valueOf(d));
                break;
            }
            case DASHED_POINT: {
                defaultLineShader.setLineStipple(Boolean.valueOf(true));
                defaultGeometryShader.setShowLines(Boolean.valueOf(true));
                defaultGeometryShader.setShowPoints(Boolean.valueOf(true));
                DefaultPointShader defaultPointShader = (DefaultPointShader)defaultGeometryShader.createPointShader("default");
                defaultPointShader.setSpheresDraw(Boolean.valueOf(false));
                defaultPointShader.setDiffuseColor(defaultLineShader.getDiffuseColor());
                double d = (double)this.lineWidth * 4.0;
                if (d < 4.0) {
                    d = 4.0;
                }
                defaultPointShader.setPointSize(Double.valueOf(d));
            }
        }
    }

    public void updateCanvas(TableCanvas tableCanvas) {
        RGB rGB = new RGB(this.plotColour.getRed(), this.plotColour.getGreen(), this.plotColour.getBlue());
        org.eclipse.swt.graphics.Color color = new org.eclipse.swt.graphics.Color((Device)tableCanvas.getDisplay(), rGB);
        tableCanvas.setStyle(this.plotStyle);
        tableCanvas.setColour(color);
    }
}

