/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting;

import de.jreality.geometry.IndexedLineSetFactory;
import de.jreality.geometry.PointSetFactory;
import de.jreality.geometry.QuadMeshFactory;
import de.jreality.math.MatrixBuilder;
import de.jreality.scene.Appearance;
import de.jreality.scene.Camera;
import de.jreality.scene.ClippingPlane;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Viewer;
import de.jreality.scene.data.AttributeEntityUtility;
import de.jreality.scene.event.TransformationEvent;
import de.jreality.scene.event.TransformationListener;
import de.jreality.scene.tool.Tool;
import de.jreality.shader.DefaultGeometryShader;
import de.jreality.shader.DefaultLineShader;
import de.jreality.shader.DefaultPointShader;
import de.jreality.shader.DefaultPolygonShader;
import de.jreality.shader.DefaultTextShader;
import de.jreality.shader.GlslProgram;
import de.jreality.shader.ImageData;
import de.jreality.shader.ShaderUtility;
import de.jreality.shader.Texture2D;
import de.jreality.shader.TextureUtility;
import de.jreality.ui.viewerapp.AbstractViewerApp;
import de.jreality.util.CameraUtility;
import de.jreality.util.SceneGraphUtility;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractCompoundDataset;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundByteDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundIntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundShortDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.FloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.RGBDataset;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.ColourImageData;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.ArrayPoolUtility;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IDataSet3DCorePlot;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.ScalingUtility;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Tick;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.TickFactory;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.OverlayType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.PrimitiveType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.ScaleType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.TickFormatting;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.VectorOverlayStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.ArrowPrimitive;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.BoxPrimitive;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.CirclePrimitive;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.CircleSectorPrimitive;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.EllipsePrimitive;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.LabelPrimitive;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.LinePrimitive;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay2DConsumer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay2DProvider;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.OverlayPrimitive;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.PointListPrimitive;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.PointPrimitive;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.RingPrimitive;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.TrianglePrimitive;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.enums.LabelOrientation;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.ImagePositionTool;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PanningTool;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionEventListener;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionTool2D;

public class DataSet3DPlot2D
implements IDataSet3DCorePlot,
Overlay2DProvider,
TransformationListener,
PlotActionEventListener {
    private static final Logger logger = LoggerFactory.getLogger(DataSet3DPlot2D.class);
    private AbstractViewerApp app;
    private Appearance graphAppearance;
    private SceneGraphComponent axis = null;
    private SceneGraphComponent xAxisLabel = null;
    private SceneGraphComponent yAxisLabel = null;
    private DefaultTextShader dtsXAxisLabel;
    private DefaultTextShader dtsYAxisLabel;
    private DefaultTextShader dtsTitleLabel;
    private DefaultTextShader dtsXTicks;
    private DefaultTextShader dtsYTicks;
    private SceneGraphComponent graph = null;
    private SceneGraphComponent graphGroupNode = null;
    private SceneGraphComponent ticksNode = null;
    private SceneGraphComponent xTickNode = null;
    private SceneGraphComponent yTickNode = null;
    private SceneGraphComponent xLabelNode = null;
    private SceneGraphComponent yLabelNode = null;
    private SceneGraphComponent leftClip = null;
    private SceneGraphComponent rightClip = null;
    private SceneGraphComponent topClip = null;
    private SceneGraphComponent bottomClip = null;
    private SceneGraphComponent background = null;
    private SceneGraphComponent titleLabel = null;
    private String titleLabelStr = null;
    private List<SceneGraphComponent> subGraphs = Collections.synchronizedList(new LinkedList());
    private List<Appearance> graphApps = Collections.synchronizedList(new LinkedList());
    private Map<Integer, OverlayPrimitive> prim2DMap = Collections.synchronizedMap(new HashMap(1000));
    private List<PlotActionEventListener> actionListeners = Collections.synchronizedList(new LinkedList());
    String xAxisLabelStr = null;
    String yAxisLabelStr = null;
    private int numGraphs = 0;
    private int maxWidth = 0;
    private int maxHeight = 0;
    private double globalRealXmin = 0.0;
    private double globalRealXmax = 1.0;
    private double globalRealYmin = 0.0;
    private double globalRealYmax = 1.0;
    private double tableMin = 0.0;
    private double tableMax = 0.0;
    private double threshold = 0.0;
    private double xOffset = 0.0;
    private double yOffset = 0.0;
    private boolean hasJOGL;
    private boolean useLogarithmic = false;
    private boolean useCanvasAspect = false;
    private boolean useFeatureEnhancement = false;
    private GlslProgram tableProg = null;
    private TickFactory tickFactory = null;
    private ImageData lookupTableImg = null;
    private ImageData overlayData = null;
    private TickFormatting xLabelMode = TickFormatting.plainMode;
    private TickFormatting yLabelMode = TickFormatting.plainMode;
    private AxisMode xAxis = AxisMode.LINEAR;
    private AxisMode yAxis = AxisMode.LINEAR;
    private AxisValues xAxisValues;
    private AxisValues yAxisValues;
    private ImagePositionTool posTool;
    private PanningTool panTool;
    private PlotActionTool2D actionTool;
    private Composite plotArea;
    private Cursor defaultCursor;
    private boolean overlayInOperation = false;
    private int primKeyID = 0;
    private int canvasWidth = 1;
    private int canvasHeight = 1;
    private byte[] softwareImageRGBAdata = null;
    private Overlay2DConsumer consumer;
    private double inverseScaling = 1.0;
    private double labelScaling = 1.0;
    private static double MINX = 6.0;
    private float[] imageData = null;
    private Texture2D texture = null;
    private ScaleType currentScale = ScaleType.LINEAR;
    private int lastImageType = -1;
    private int currentImageType = -1;
    private static final String FRAGCOLORPASSTHROUGH = "uniform sampler2D sampler;\nuniform sampler2D overlaySampler;\nvoid main(void)\n{\nvec4 image = texture2D(sampler,gl_TexCoord[0].st);\nvec4 overlay = texture2D(overlaySampler,gl_TexCoord[0].st);\ngl_FragColor = image;\n}\n";
    private static final String FRAGLOGPROG = "uniform sampler2D sampler;\nuniform sampler2D tableSampler;\nuniform sampler2D overlaySampler;\nuniform float maxValue;\nuniform float minValue;\nconst float EULER = 2.7182818284590452353602874713527;\n\nfloat scaling(float invalue) {\tbool negValue = (invalue < 0.0);\n\tif (negValue)\n\t\tinvalue = abs(invalue); \n\tif (invalue < EULER) \n\t\tinvalue+=(EULER - invalue) / EULER;\n\tfloat outvalue = log(invalue); \n\treturn (negValue ? -outvalue : outvalue);\n}\nvoid main(void)\n{\n float dataValue = texture2D(sampler,gl_TexCoord[0].st).x;\n dataValue = min(1.0,(scaling(dataValue) - minValue) / (maxValue-minValue));\n vec4 image = texture2D(tableSampler,vec2(dataValue,dataValue));\n vec4 overlay = texture2D(overlaySampler,gl_TexCoord[0].st);\n gl_FragColor = image;\n}\n";
    private static final String FRAGPROG = "uniform sampler2D sampler;\nuniform sampler2D tableSampler;\nuniform sampler2D overlaySampler;\nuniform float maxValue;\nuniform float minValue;\nvoid main(void)\n{\n float dataValue = texture2D(sampler,gl_TexCoord[0].st).x;\n dataValue = min(1.0,(dataValue - minValue) / (maxValue-minValue));\n vec4 image = texture2D(tableSampler,vec2(dataValue,dataValue));\n vec4 overlay = texture2D(overlaySampler,gl_TexCoord[0].st);\n gl_FragColor = image;\n}\n";
    private static final String DIFFRAGPROG = "uniform sampler2D sampler;\nuniform sampler2D tableSampler;\nuniform sampler2D overlaySampler;\nuniform float maxValue;\nuniform float minValue;\nuniform float threshold;\nvoid main(void)\n{\n vec2 delta = vec2(1.0/2463.0,1.0/2527.0);\n float temp_X_Y = texture2D(sampler,gl_TexCoord[0].st - delta).x;\n float temp_Y = texture2D(sampler,gl_TexCoord[0].st + vec2(0,-delta.y)).x;\n float tempX_Y = texture2D(sampler,gl_TexCoord[0].st + vec2(delta.x,-delta.y)).x;\n float temp_X = texture2D(sampler,gl_TexCoord[0].st + vec2(-delta.x,0.0)).x;\n float tempX = texture2D(sampler,gl_TexCoord[0].st + vec2(delta.x,0.0)).x;\n float temp_XY = texture2D(sampler,gl_TexCoord[0].st + vec2(-delta.x,delta.y)).x;\n float tempY = texture2D(sampler,gl_TexCoord[0].st + vec2(0.0,delta.y)).x;\n float tempXY = texture2D(sampler,gl_TexCoord[0].st + delta).x;\n float gy = temp_XY + 2.0 * tempY + tempXY - temp_X_Y - 2.0 * temp_Y - tempX_Y;\n float gx = tempX_Y + 2.0 * tempX + tempXY - temp_X_Y - 2.0 * temp_X - temp_XY;\n float g = sqrt(gx*gx+gy*gy);\n float dataValue = texture2D(sampler,gl_TexCoord[0].st).x;\n float nDataValue = min(1.0,(dataValue - minValue) / (maxValue-minValue));\n vec4 image = texture2D(tableSampler,vec2(nDataValue,nDataValue));\n vec4 overlay = texture2D(overlaySampler,gl_TexCoord[0].st);\n if (dataValue < -1.0) image = vec4(0.3,1.0,0.15,1.0);\n if (g > threshold) image = vec4(1,0,0,1);\ngl_FragColor = image;\n}\n";
    private static /* synthetic */ int[] $SWITCH_TABLE$uk$ac$diamond$scisoft$analysis$rcp$plotting$enums$ScaleType;

    public DataSet3DPlot2D(AbstractViewerApp abstractViewerApp, Composite composite, Cursor cursor, PanningTool panningTool, boolean bl) {
        this.app = abstractViewerApp;
        this.panTool = panningTool;
        this.plotArea = composite;
        this.defaultCursor = cursor;
        this.hasJOGL = bl;
        if (this.hasJOGL) {
            byte[] byArray = new byte[1024];
            int n = 0;
            while (n < 256) {
                byArray[n * 4] = (byte)(n >> 2);
                byArray[n * 4 + 1] = (byte)(255 - n);
                byArray[n * 4 + 2] = (byte)(n >> 3);
                byArray[n * 4 + 3] = -1;
                ++n;
            }
            this.lookupTableImg = new ImageData(byArray, 256, 1);
        }
        this.tickFactory = new TickFactory(this.xLabelMode);
        this.posTool = new ImagePositionTool(this.maxWidth, this.maxHeight, 15.0, 15.0);
        this.actionTool = new PlotActionTool2D();
        this.actionTool.addPlotActionEventListener(this);
    }

    @Override
    public SceneGraphComponent buildBoundingBox() {
        return null;
    }

    private void refresh() {
        try {
            this.app.getCurrentViewer().render();
        }
        catch (SWTException sWTException) {}
    }

    private double[] determineXYsize() {
        double[] dArray = new double[2];
        if (!this.useCanvasAspect) {
            if (this.maxWidth >= this.maxHeight) {
                dArray[0] = 15.0;
                dArray[1] = 15.0 * (double)this.maxHeight / (double)this.maxWidth;
            } else {
                dArray[1] = 15.0;
                dArray[0] = 15.0 * (double)this.maxWidth / (double)this.maxHeight;
            }
            dArray[0] = Math.max(dArray[0], 3.0);
            dArray[1] = Math.max(dArray[1], 3.0);
        } else if (this.canvasWidth >= this.canvasHeight) {
            dArray[0] = 15.0;
            dArray[1] = 15.0 * (double)this.canvasHeight / (double)this.canvasWidth;
        } else {
            dArray[1] = 15.0;
            dArray[0] = 15.0 * (double)this.canvasWidth / (double)this.canvasHeight;
        }
        return dArray;
    }

    private IndexedLineSet createXTicksGeometry() {
        IndexedLineSetFactory indexedLineSetFactory = new IndexedLineSetFactory();
        double d = this.globalRealXmin;
        double d2 = this.globalRealXmax;
        this.tickFactory.setTickMode(this.xLabelMode);
        int n = this.app.getCurrentViewer().getViewingComponentSize().width;
        if (n == 0) {
            n = 490;
        }
        LinkedList<Tick> linkedList = this.tickFactory.generateTicks(n, d, d2, (short)0, false);
        indexedLineSetFactory.setVertexCount(linkedList.size() * 2);
        indexedLineSetFactory.setEdgeCount(linkedList.size());
        double[][] dArray = ArrayPoolUtility.getDoubleArray(linkedList.size() * 2);
        double[] dArray2 = this.determineXYsize();
        int[][] nArray = ArrayPoolUtility.getIntArray(linkedList.size());
        int n2 = 0;
        while (n2 < linkedList.size()) {
            double d3 = this.tickFactory.getTickUnit() * (double)n2;
            dArray[n2 * 2][0] = d3 / (this.globalRealXmax - d) * dArray2[0];
            dArray[n2 * 2][1] = -0.125;
            dArray[n2 * 2][2] = 0.0;
            dArray[n2 * 2 + 1][0] = d3 / (this.globalRealXmax - d) * dArray2[0];
            dArray[n2 * 2 + 1][1] = 0.0;
            dArray[n2 * 2 + 1][2] = 0.0;
            nArray[n2][0] = n2 * 2;
            nArray[n2][1] = n2 * 2 + 1;
            ++n2;
        }
        indexedLineSetFactory.setVertexCoordinates(dArray);
        indexedLineSetFactory.setEdgeIndices(nArray);
        indexedLineSetFactory.update();
        return indexedLineSetFactory.getIndexedLineSet();
    }

    protected IndexedLineSet createYTicksGeometry() {
        IndexedLineSetFactory indexedLineSetFactory = new IndexedLineSetFactory();
        this.tickFactory.setTickMode(this.yLabelMode);
        int n = this.app.getCurrentViewer().getViewingComponentSize().height;
        if (n == 0) {
            n = 475;
        }
        LinkedList<Tick> linkedList = this.tickFactory.generateTicks(n, this.globalRealYmin, this.globalRealYmax, (short)1, false);
        indexedLineSetFactory.setVertexCount(linkedList.size() * 2);
        indexedLineSetFactory.setEdgeCount(linkedList.size());
        double[] dArray = this.determineXYsize();
        double[][] dArray2 = ArrayPoolUtility.getDoubleArray(linkedList.size() * 2);
        int[][] nArray = ArrayPoolUtility.getIntArray(linkedList.size());
        double d = this.globalRealYmax - this.globalRealYmin;
        double d2 = dArray[1] * (this.tickFactory.getTickUnit() * (double)linkedList.size() / d) / (double)linkedList.size();
        int n2 = 0;
        while (n2 < linkedList.size()) {
            dArray2[n2 * 2][0] = -0.125;
            dArray2[n2 * 2][1] = dArray[1] - (double)n2 * d2;
            dArray2[n2 * 2][2] = 0.0;
            dArray2[n2 * 2 + 1][0] = 0.0;
            dArray2[n2 * 2 + 1][1] = dArray[1] - (double)n2 * d2;
            dArray2[n2 * 2 + 1][2] = 0.0;
            nArray[n2][0] = n2 * 2;
            nArray[n2][1] = n2 * 2 + 1;
            ++n2;
        }
        indexedLineSetFactory.setVertexCoordinates(dArray2);
        indexedLineSetFactory.setEdgeIndices(nArray);
        indexedLineSetFactory.update();
        return indexedLineSetFactory.getIndexedLineSet();
    }

    @Override
    public SceneGraphComponent buildCoordAxesTicks() {
        if (this.ticksNode == null) {
            this.ticksNode = SceneGraphUtility.createFullSceneGraphComponent((String)"ticks");
            this.xTickNode = SceneGraphUtility.createFullSceneGraphComponent((String)"xTicks");
            this.yTickNode = SceneGraphUtility.createFullSceneGraphComponent((String)"yTicks");
            this.ticksNode.addChild(this.xTickNode);
            this.ticksNode.addChild(this.yTickNode);
            Appearance appearance = new Appearance();
            this.xTickNode.setAppearance(appearance);
            this.yTickNode.setAppearance(appearance);
            DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
            appearance.setAttribute("lineShader.tubeDraw", false);
            DefaultLineShader defaultLineShader = (DefaultLineShader)defaultGeometryShader.createLineShader("default");
            defaultLineShader.setLineWidth(Double.valueOf(1.0));
            defaultLineShader.setDiffuseColor(Color.black);
            defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
            defaultGeometryShader.setShowLines(Boolean.valueOf(true));
            defaultGeometryShader.setShowPoints(Boolean.valueOf(false));
            this.xTickNode.setGeometry((Geometry)this.createXTicksGeometry());
            this.yTickNode.setGeometry((Geometry)this.createYTicksGeometry());
        }
        return this.ticksNode;
    }

    private IndexedFaceSet createBackground() {
        QuadMeshFactory quadMeshFactory = new QuadMeshFactory();
        double[][][] dArray = new double[2][2][3];
        dArray[0][0][0] = -5.0;
        dArray[0][0][1] = 20.0;
        dArray[0][0][2] = 0.0;
        dArray[0][1][0] = 20.0;
        dArray[0][1][1] = 20.0;
        dArray[0][1][2] = 0.0;
        dArray[1][0][0] = -5.0;
        dArray[1][0][1] = -5.0;
        dArray[1][0][2] = 0.0;
        dArray[1][1][0] = 20.0;
        dArray[1][1][1] = -5.0;
        dArray[1][1][2] = 0.0;
        quadMeshFactory.setVLineCount(2);
        quadMeshFactory.setULineCount(2);
        quadMeshFactory.setClosedInUDirection(false);
        quadMeshFactory.setClosedInVDirection(false);
        quadMeshFactory.setVertexCoordinates(dArray);
        quadMeshFactory.setGenerateFaceNormals(true);
        quadMeshFactory.update();
        dArray = null;
        return quadMeshFactory.getIndexedFaceSet();
    }

    private void buildBackground(SceneGraphComponent sceneGraphComponent) {
        this.background = SceneGraphUtility.createFullSceneGraphComponent((String)"background");
        sceneGraphComponent.addChild(this.background);
        this.background.setGeometry((Geometry)this.createBackground());
        Appearance appearance = new Appearance();
        this.background.setAppearance(appearance);
        appearance.setAttribute("lightingEnabled", false);
        appearance.setAttribute("transparencyEnabled", true);
        appearance.setAttribute("additiveBlendingEnabled", false);
        appearance.setAttribute("polygonShader.transparency", 1.0);
        DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
        defaultGeometryShader.setShowFaces(Boolean.valueOf(true));
        defaultGeometryShader.setShowLines(Boolean.valueOf(false));
        defaultGeometryShader.setShowPoints(Boolean.valueOf(false));
    }

    private IndexedLineSet createAxisGeometry(double d, double d2) {
        IndexedLineSetFactory indexedLineSetFactory = new IndexedLineSetFactory();
        indexedLineSetFactory.setVertexCount(4);
        indexedLineSetFactory.setEdgeCount(2);
        double[][] dArray = ArrayPoolUtility.getDoubleArray(4);
        dArray[0][0] = 0.0;
        dArray[0][1] = 0.0;
        dArray[0][2] = 0.0;
        dArray[1][0] = d;
        dArray[1][1] = 0.0;
        dArray[1][2] = 0.0;
        dArray[2][0] = 0.0;
        dArray[2][1] = 0.0;
        dArray[2][2] = 0.0;
        dArray[3][0] = 0.0;
        dArray[3][1] = d2;
        dArray[3][2] = 0.0;
        int[][] nArray = ArrayPoolUtility.getIntArray(2);
        nArray[0][0] = 0;
        nArray[0][1] = 1;
        nArray[1][0] = 2;
        nArray[1][1] = 3;
        indexedLineSetFactory.setVertexCoordinates(dArray);
        indexedLineSetFactory.setEdgeIndices(nArray);
        indexedLineSetFactory.update();
        return indexedLineSetFactory.getIndexedLineSet();
    }

    @Override
    public SceneGraphComponent buildCoordAxis(SceneGraphComponent sceneGraphComponent) {
        this.axis = sceneGraphComponent;
        this.xAxisLabel = SceneGraphUtility.createFullSceneGraphComponent((String)"xAxisLabel");
        this.yAxisLabel = SceneGraphUtility.createFullSceneGraphComponent((String)"yAxisLabel");
        this.titleLabel = SceneGraphUtility.createFullSceneGraphComponent((String)"titleLabel");
        sceneGraphComponent.addChild(this.xAxisLabel);
        sceneGraphComponent.addChild(this.yAxisLabel);
        sceneGraphComponent.addChild(this.titleLabel);
        Appearance appearance = new Appearance();
        sceneGraphComponent.setAppearance(appearance);
        double[] dArray = this.determineXYsize();
        sceneGraphComponent.setGeometry((Geometry)this.createAxisGeometry(dArray[0], dArray[1]));
        DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
        appearance.setAttribute("lineShader.tubeDraw", false);
        DefaultLineShader defaultLineShader = (DefaultLineShader)defaultGeometryShader.createLineShader("default");
        defaultLineShader.setLineWidth(Double.valueOf(2.0));
        defaultLineShader.setDiffuseColor(Color.black);
        defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader.setShowLines(Boolean.valueOf(true));
        defaultGeometryShader.setShowPoints(Boolean.valueOf(false));
        Appearance appearance2 = new Appearance();
        Appearance appearance3 = new Appearance();
        Appearance appearance4 = new Appearance();
        this.xAxisLabel.setAppearance(appearance2);
        this.yAxisLabel.setAppearance(appearance3);
        this.titleLabel.setAppearance(appearance4);
        appearance2.setAttribute("pointShader.spheresDraw", false);
        appearance3.setAttribute("pointShader.spheresDraw", false);
        appearance4.setAttribute("pointShader.spheresDraw", false);
        DefaultGeometryShader defaultGeometryShader2 = ShaderUtility.createDefaultGeometryShader((Appearance)appearance2, (boolean)true);
        defaultGeometryShader2.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader2.setShowLines(Boolean.valueOf(false));
        defaultGeometryShader2.setShowPoints(Boolean.valueOf(true));
        DefaultPointShader defaultPointShader = (DefaultPointShader)defaultGeometryShader2.createPointShader("default");
        this.dtsXAxisLabel = (DefaultTextShader)defaultPointShader.getTextShader();
        defaultPointShader.setPointSize(Double.valueOf(1.0));
        defaultPointShader.setDiffuseColor(Color.white);
        this.dtsXAxisLabel.setDiffuseColor(Color.black);
        this.dtsXAxisLabel.setTextdirection(Integer.valueOf(0));
        this.dtsXAxisLabel.setScale(Double.valueOf(0.0075));
        defaultGeometryShader2 = ShaderUtility.createDefaultGeometryShader((Appearance)appearance3, (boolean)true);
        defaultGeometryShader2.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader2.setShowLines(Boolean.valueOf(false));
        defaultGeometryShader2.setShowPoints(Boolean.valueOf(true));
        defaultPointShader = (DefaultPointShader)defaultGeometryShader2.createPointShader("default");
        this.dtsYAxisLabel = (DefaultTextShader)defaultPointShader.getTextShader();
        defaultPointShader.setPointSize(Double.valueOf(1.0));
        defaultPointShader.setDiffuseColor(Color.white);
        this.dtsYAxisLabel.setDiffuseColor(Color.black);
        this.dtsYAxisLabel.setTextdirection(Integer.valueOf(1));
        this.dtsYAxisLabel.setScale(Double.valueOf(0.0075));
        defaultGeometryShader2 = ShaderUtility.createDefaultGeometryShader((Appearance)appearance4, (boolean)true);
        defaultGeometryShader2.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader2.setShowLines(Boolean.valueOf(false));
        defaultGeometryShader2.setShowPoints(Boolean.valueOf(true));
        defaultPointShader = (DefaultPointShader)defaultGeometryShader2.createPointShader("default");
        defaultPointShader.setPointSize(Double.valueOf(1.0));
        defaultPointShader.setDiffuseColor(Color.white);
        this.dtsTitleLabel = (DefaultTextShader)defaultPointShader.getTextShader();
        this.dtsTitleLabel.setDiffuseColor(Color.black);
        this.dtsTitleLabel.setTextdirection(Integer.valueOf(0));
        this.dtsTitleLabel.setScale(Double.valueOf(0.0075));
        Dimension dimension = this.app.getCurrentViewer().getViewingComponentSize();
        int n = dimension.width;
        int n2 = dimension.height;
        if (n == 0) {
            n = 490;
        }
        if (n2 == 0) {
            n2 = 475;
        }
        MatrixBuilder.euclidean().translate(-7.5, -7.5, 0.0).assignTo(sceneGraphComponent);
        double d = 1.0;
        if (n < 490) {
            d = 490.0 / (double)dimension.width;
        }
        if (n2 < 475) {
            d = Math.max(d, 475.0 / (double)dimension.height);
        }
        if (d > 1.0) {
            this.dtsXAxisLabel.setScale(Double.valueOf(0.0075 * d));
            this.dtsYAxisLabel.setScale(Double.valueOf(0.0075 * d));
            this.dtsTitleLabel.setScale(Double.valueOf(0.0075 * d));
        }
        return sceneGraphComponent;
    }

    private IndexedFaceSet createGraphGeometry(double d, double d2) {
        QuadMeshFactory quadMeshFactory = new QuadMeshFactory();
        double[][][] dArray = new double[2][2][3];
        dArray[0][0][0] = 0.0;
        dArray[0][0][1] = d2;
        dArray[0][0][2] = 0.0;
        dArray[0][1][0] = d;
        dArray[0][1][1] = d2;
        dArray[0][1][2] = 0.0;
        dArray[1][0][0] = 0.0;
        dArray[1][0][1] = 0.0;
        dArray[1][0][2] = 0.0;
        dArray[1][1][0] = d;
        dArray[1][1][1] = 0.0;
        dArray[1][1][2] = 0.0;
        quadMeshFactory.setVLineCount(2);
        quadMeshFactory.setULineCount(2);
        quadMeshFactory.setClosedInUDirection(false);
        quadMeshFactory.setClosedInVDirection(false);
        quadMeshFactory.setVertexCoordinates(dArray);
        quadMeshFactory.setGenerateFaceNormals(true);
        quadMeshFactory.update();
        dArray = null;
        return quadMeshFactory.getIndexedFaceSet();
    }

    private Texture2D generateSoftwareTexture(Appearance appearance, ImageData imageData) {
        Texture2D texture2D = null;
        texture2D = TextureUtility.createTexture((Appearance)appearance, (String)"polygonShader", (ImageData)imageData);
        texture2D.setRepeatS(Integer.valueOf(33071));
        texture2D.setRepeatT(Integer.valueOf(33071));
        texture2D.setMagFilter(Integer.valueOf(9728));
        texture2D.setMinFilter(Integer.valueOf(9729));
        texture2D.setMipmapMode(Boolean.valueOf(true));
        return texture2D;
    }

    private Texture2D generateOverlayTexture(Appearance appearance) {
        this.overlayData = null;
        Texture2D texture2D = null;
        this.overlayData = new ImageData(new byte[1], 1, 1);
        if (this.hasJOGL) {
            texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[2]", (Appearance)appearance, (boolean)true);
            texture2D.setRepeatS(Integer.valueOf(33071));
            texture2D.setRepeatT(Integer.valueOf(33071));
            texture2D.setMagFilter(Integer.valueOf(9987));
            texture2D.setMinFilter(Integer.valueOf(9987));
            texture2D.setImage(this.overlayData);
            texture2D.setMipmapMode(Boolean.valueOf(true));
        } else {
            byte[] byArray = new byte[1];
            ImageData imageData = new ImageData(byArray, 1, 1);
            this.generateSoftwareTexture(appearance, imageData);
        }
        return texture2D;
    }

    private void generateFloatTexture(IDataset iDataset, Appearance appearance, int n, int n2, boolean bl) {
        if (bl) {
            this.imageData = new float[n * n2];
        }
        FloatDataset floatDataset = (FloatDataset)DatasetUtils.cast((AbstractDataset)DatasetUtils.convertToAbstractDataset((IDataset)iDataset), (int)5);
        this.imageData = floatDataset.getData();
        if (!bl) {
            boolean bl2 = bl = this.texture.getImage().getHeight() != n2 || this.texture.getImage().getWidth() != n;
        }
        if (bl) {
            ImageData imageData = new ImageData(this.imageData, n, n2);
            this.texture = TextureUtility.createTexture((Appearance)appearance, (String)"polygonShader", (ImageData)imageData);
            this.texture.setRepeatS(Integer.valueOf(33071));
            this.texture.setRepeatT(Integer.valueOf(33071));
            this.texture.setMagFilter(Integer.valueOf(9728));
            this.texture.setMinFilter(Integer.valueOf(9729));
            this.texture.setMipmapMode(Boolean.valueOf(true));
            imageData = null;
            System.gc();
        } else {
            ImageData imageData = this.texture.getImage();
            imageData.updateData(this.imageData);
        }
    }

    private void generateRGBTexture(IDataset iDataset, Appearance appearance, int n, int n2, boolean bl) {
        RGBDataset rGBDataset;
        if (bl) {
            this.softwareImageRGBAdata = new byte[n * n2 * 4];
        }
        if (iDataset instanceof RGBDataset) {
            rGBDataset = (RGBDataset)iDataset;
            short[] sArray = rGBDataset.getData();
            int n3 = 0;
            while (n3 < n) {
                int n4 = 0;
                while (n4 < n2) {
                    short s = sArray[(n3 + n4 * n) * 3];
                    short s2 = sArray[(n3 + n4 * n) * 3 + 1];
                    short s3 = sArray[(n3 + n4 * n) * 3 + 2];
                    byte by = (byte)s;
                    byte by2 = (byte)s2;
                    byte by3 = (byte)s3;
                    int n5 = -1;
                    this.softwareImageRGBAdata[(n3 + n4 * n) * 4] = by;
                    this.softwareImageRGBAdata[(n3 + n4 * n) * 4 + 1] = by2;
                    this.softwareImageRGBAdata[(n3 + n4 * n) * 4 + 2] = by3;
                    this.softwareImageRGBAdata[(n3 + n4 * n) * 4 + 3] = n5;
                    ++n4;
                }
                ++n3;
            }
        } else {
            rGBDataset = (AbstractCompoundDataset)iDataset;
            switch (rGBDataset.getDtype()) {
                case 100: {
                    CompoundByteDataset compoundByteDataset = (CompoundByteDataset)rGBDataset;
                    int n6 = 0;
                    while (n6 < n) {
                        int n7 = 0;
                        while (n7 < n2) {
                            byte[] byArray = compoundByteDataset.getByteArray(new int[]{n6 + n7 * n});
                            this.softwareImageRGBAdata[(n6 + n7 * n) * 4] = byArray[0];
                            this.softwareImageRGBAdata[(n6 + n7 * n) * 4 + 1] = byArray[1];
                            this.softwareImageRGBAdata[(n6 + n7 * n) * 4 + 2] = byArray[2];
                            this.softwareImageRGBAdata[(n6 + n7 * n) * 4 + 3] = rGBDataset.getElementsPerItem() > 3 ? byArray[3] : -1;
                            ++n7;
                        }
                        ++n6;
                    }
                    break;
                }
                case 200: {
                    CompoundShortDataset compoundShortDataset = (CompoundShortDataset)rGBDataset;
                    double[] dArray = rGBDataset.minItem();
                    double[] dArray2 = rGBDataset.maxItem();
                    short s = (short)Math.max(1, (short)(dArray2[0] - dArray[0]));
                    short s4 = (short)Math.max(1.0, dArray2[1] - dArray[1]);
                    short s5 = (short)Math.max(1.0, dArray2[2] - dArray[2]);
                    short s6 = 0;
                    if (rGBDataset.getElementsPerItem() > 3) {
                        s6 = (short)(dArray2[3] - dArray[3]);
                    }
                    int n8 = 0;
                    while (n8 < n) {
                        int n9 = 0;
                        while (n9 < n2) {
                            short[] sArray = compoundShortDataset.getShortArray(new int[]{n8, n9});
                            short s7 = sArray[0];
                            short s8 = sArray[1];
                            short s9 = sArray[2];
                            int n10 = 255;
                            if (rGBDataset.getElementsPerItem() > 3) {
                                n10 = sArray[3];
                            }
                            double d = ((double)s7 - dArray[0]) / (double)s;
                            s7 = (short)(255.0 * d);
                            d = ((double)s8 - dArray[1]) / (double)s4;
                            s8 = (short)(255.0 * d);
                            d = ((double)s9 - dArray[2]) / (double)s5;
                            s9 = (short)(255.0 * d);
                            if (s6 != 0) {
                                d = ((double)n10 - dArray[3]) / (double)s6;
                                n10 = (short)(255.0 * d);
                            }
                            byte by = (byte)s7;
                            byte by4 = (byte)s8;
                            byte by5 = (byte)s9;
                            byte by6 = (byte)n10;
                            this.softwareImageRGBAdata[(n8 + n9 * n) * 4] = by;
                            this.softwareImageRGBAdata[(n8 + n9 * n) * 4 + 1] = by4;
                            this.softwareImageRGBAdata[(n8 + n9 * n) * 4 + 2] = by5;
                            this.softwareImageRGBAdata[(n8 + n9 * n) * 4 + 3] = by6;
                            ++n9;
                        }
                        ++n8;
                    }
                    break;
                }
                case 300: {
                    CompoundIntegerDataset compoundIntegerDataset = (CompoundIntegerDataset)rGBDataset;
                    double[] dArray = rGBDataset.minItem();
                    double[] dArray3 = rGBDataset.maxItem();
                    int n11 = (int)Math.max(1.0, dArray3[0] - dArray[0]);
                    int n12 = (int)Math.max(1.0, dArray3[1] - dArray[1]);
                    int n13 = (int)Math.max(1.0, dArray3[2] - dArray[2]);
                    int n14 = 0;
                    if (rGBDataset.getElementsPerItem() > 3) {
                        n14 = (int)(dArray3[3] - dArray[3]);
                    }
                    int n15 = 0;
                    while (n15 < n) {
                        int n16 = 0;
                        while (n16 < n2) {
                            int[] nArray = compoundIntegerDataset.getIntegerArray(new int[]{n15, n16});
                            int n17 = nArray[0];
                            int n18 = nArray[1];
                            int n19 = nArray[2];
                            int n20 = 255;
                            if (rGBDataset.getElementsPerItem() > 3) {
                                n20 = nArray[3];
                            }
                            double d = ((double)n17 - dArray[0]) / (double)n11;
                            n17 = (int)(255.0 * d);
                            d = ((double)n18 - dArray[1]) / (double)n12;
                            n18 = (int)(255.0 * d);
                            d = ((double)n19 - dArray[2]) / (double)n13;
                            n19 = (int)(255.0 * d);
                            if (n14 != 0) {
                                d = ((double)n19 - dArray[2]) / (double)n14;
                                n20 = (int)(255.0 * d);
                            }
                            byte by = (byte)n17;
                            byte by7 = (byte)n18;
                            byte by8 = (byte)n19;
                            byte by9 = (byte)n20;
                            this.softwareImageRGBAdata[(n15 + n16 * n) * 4] = by;
                            this.softwareImageRGBAdata[(n15 + n16 * n) * 4 + 1] = by7;
                            this.softwareImageRGBAdata[(n15 + n16 * n) * 4 + 2] = by8;
                            this.softwareImageRGBAdata[(n15 + n16 * n) * 4 + 3] = by9;
                            ++n16;
                        }
                        ++n15;
                    }
                    break;
                }
                case 500: 
                case 600: {
                    double[] dArray = rGBDataset.minItem();
                    double[] dArray4 = rGBDataset.maxItem();
                    double d = dArray4[0] - dArray[0];
                    double d2 = dArray4[1] - dArray[1];
                    double d3 = dArray4[2] - dArray[2];
                    double d4 = 0.0;
                    if (rGBDataset.getElementsPerItem() > 3) {
                        d4 = dArray4[3] - dArray[3];
                    }
                    double[] dArray5 = new double[4];
                    int n21 = 0;
                    while (n21 < n) {
                        int n22 = 0;
                        while (n22 < n2) {
                            rGBDataset.getDoubleArray(dArray5, new int[]{n21, n22});
                            double d5 = dArray5[0];
                            double d6 = dArray5[1];
                            double d7 = dArray5[2];
                            double d8 = 255.0;
                            if (rGBDataset.getElementsPerItem() > 3) {
                                d8 = dArray5[3];
                            }
                            d5 = 255.0 * ((d5 - dArray[0]) / d);
                            d6 = 255.0 * ((d6 - dArray[1]) / d2);
                            d7 = 255.0 * ((d7 - dArray[2]) / d3);
                            if (d4 != 0.0) {
                                d8 = 255.0 * ((d8 - dArray[3]) / d4);
                            }
                            byte by = (byte)d5;
                            byte by10 = (byte)d6;
                            byte by11 = (byte)d7;
                            byte by12 = (byte)d8;
                            this.softwareImageRGBAdata[(n21 + n22 * n) * 4] = by;
                            this.softwareImageRGBAdata[(n21 + n22 * n) * 4 + 1] = by10;
                            this.softwareImageRGBAdata[(n21 + n22 * n) * 4 + 2] = by11;
                            this.softwareImageRGBAdata[(n21 + n22 * n) * 4 + 3] = by12;
                            ++n22;
                        }
                        ++n21;
                    }
                    break;
                }
            }
        }
        if (!bl) {
            boolean bl2 = bl = this.texture.getImage().getHeight() != n2 || this.texture.getImage().getWidth() != n;
        }
        if (bl) {
            rGBDataset = new ImageData(this.softwareImageRGBAdata, n, n2);
            this.texture = TextureUtility.createTexture((Appearance)appearance, (String)"polygonShader", (ImageData)rGBDataset);
            this.texture.setRepeatS(Integer.valueOf(33071));
            this.texture.setRepeatT(Integer.valueOf(33071));
            this.texture.setMagFilter(Integer.valueOf(9728));
            this.texture.setMinFilter(Integer.valueOf(9729));
            this.texture.setMipmapMode(Boolean.valueOf(true));
            rGBDataset = null;
            System.gc();
        } else {
            rGBDataset = this.texture.getImage();
            rGBDataset.updateData(this.softwareImageRGBAdata);
        }
    }

    private void generateTexture(IDataset iDataset, Appearance appearance, int n, int n2) {
        if (this.hasJOGL) {
            boolean bl;
            boolean bl2 = false;
            boolean bl3 = bl = iDataset instanceof RGBDataset || iDataset instanceof AbstractCompoundDataset && (((AbstractCompoundDataset)iDataset).getElementsPerItem() == 3 || ((AbstractCompoundDataset)iDataset).getElementsPerItem() == 4);
            if (!bl) {
                this.currentImageType = 0;
                if (this.imageData == null || this.imageData.length != n * n2 || this.currentImageType != this.lastImageType) {
                    bl2 = true;
                }
                this.generateFloatTexture(iDataset, appearance, n, n2, bl2);
            } else {
                this.currentImageType = 1;
                if (this.softwareImageRGBAdata == null || this.softwareImageRGBAdata.length != n * n2 * 4 || this.currentImageType != this.lastImageType) {
                    bl2 = true;
                }
                this.generateRGBTexture(iDataset, appearance, n, n2, bl2);
            }
            if (this.lastImageType != this.currentImageType) {
                this.loadGLSLProgram(this.tableMin, this.tableMax);
            }
            this.lastImageType = this.currentImageType;
        } else {
            double d = iDataset.max().doubleValue();
            double d2 = iDataset.min().doubleValue();
            this.softwareImageRGBAdata = new byte[n * n2 * 4];
            if (!(iDataset instanceof RGBDataset)) {
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = 0;
                    while (n4 < n) {
                        double d3 = iDataset.getDouble(new int[]{n3, n4});
                        byte by = (byte)(255.0 * d3 / (d - d2));
                        byte by2 = (byte)(255.0 * d3 / (d - d2));
                        byte by3 = (byte)(255.0 * d3 / (d - d2));
                        int n5 = -1;
                        this.softwareImageRGBAdata[(n4 + n3 * n) * 4] = by;
                        this.softwareImageRGBAdata[(n4 + n3 * n) * 4 + 1] = by2;
                        this.softwareImageRGBAdata[(n4 + n3 * n) * 4 + 2] = by3;
                        this.softwareImageRGBAdata[(n4 + n3 * n) * 4 + 3] = n5;
                        ++n4;
                    }
                    ++n3;
                }
            } else {
                RGBDataset rGBDataset = (RGBDataset)iDataset;
                short[] sArray = rGBDataset.getData();
                int n6 = 0;
                while (n6 < n) {
                    int n7 = 0;
                    while (n7 < n2) {
                        short s = sArray[(n6 + n7 * n) * 3];
                        short s2 = sArray[(n6 + n7 * n) * 3 + 1];
                        short s3 = sArray[(n6 + n7 * n) * 3 + 2];
                        byte by = (byte)s;
                        byte by4 = (byte)s2;
                        byte by5 = (byte)s3;
                        int n8 = -1;
                        this.softwareImageRGBAdata[(n6 + n7 * n) * 4] = by;
                        this.softwareImageRGBAdata[(n6 + n7 * n) * 4 + 1] = by4;
                        this.softwareImageRGBAdata[(n6 + n7 * n) * 4 + 2] = by5;
                        this.softwareImageRGBAdata[(n6 + n7 * n) * 4 + 3] = n8;
                        ++n7;
                    }
                    ++n6;
                }
            }
            ImageData imageData = new ImageData(this.softwareImageRGBAdata, n, n2);
            this.texture = this.generateSoftwareTexture(appearance, imageData);
            imageData = null;
        }
    }

    private void determineRanges(List<IDataset> list) {
        Iterator<IDataset> iterator = list.iterator();
        this.globalRealXmin = 3.4028234663852886E38;
        this.globalRealXmax = 1.4E-45f;
        this.globalRealYmin = 3.4028234663852886E38;
        this.globalRealYmax = 1.4E-45f;
        while (iterator.hasNext()) {
            IDataset iDataset = iterator.next();
            switch (this.xAxis) {
                case LINEAR: {
                    this.globalRealXmin = 0.0;
                    this.globalRealXmax = Math.max(this.globalRealXmax, (double)iDataset.getShape()[1]);
                    break;
                }
                case LINEAR_WITH_OFFSET: {
                    this.globalRealXmin = this.xOffset;
                    this.globalRealXmax = Math.max(this.globalRealXmax, (double)iDataset.getShape()[1]);
                    break;
                }
                case CUSTOM: {
                    this.globalRealXmin = Math.min(this.globalRealXmin, this.xAxisValues.getMin());
                    this.globalRealXmax = Math.max(this.globalRealXmax, this.xAxisValues.getMax());
                }
            }
            switch (this.yAxis) {
                case LINEAR: {
                    this.globalRealYmin = 0.0;
                    this.globalRealYmax = Math.max(this.globalRealYmax, (double)iDataset.getShape()[0]);
                    break;
                }
                case LINEAR_WITH_OFFSET: {
                    this.globalRealYmin = this.yOffset;
                    this.globalRealYmax = Math.max(this.globalRealYmax, (double)iDataset.getShape()[0]);
                    break;
                }
                case CUSTOM: {
                    this.globalRealYmin = Math.min(this.globalRealYmin, this.yAxisValues.getMin());
                    this.globalRealYmax = Math.max(this.globalRealYmax, this.yAxisValues.getMax());
                }
            }
        }
    }

    private void determineRanges(IDataset iDataset) {
        switch (this.xAxis) {
            case LINEAR: {
                this.globalRealXmin = 0.0;
                this.globalRealXmax = Math.max(this.globalRealXmax, (double)iDataset.getShape()[1]);
                break;
            }
            case LINEAR_WITH_OFFSET: {
                this.globalRealXmin = this.xOffset;
                this.globalRealXmax = Math.max(this.globalRealXmax, (double)iDataset.getShape()[1]);
                break;
            }
            case CUSTOM: {
                this.globalRealXmin = this.xAxisValues.getMin();
                this.globalRealXmax = this.xAxisValues.getMax();
            }
        }
        switch (this.yAxis) {
            case LINEAR: {
                this.globalRealYmin = 0.0;
                this.globalRealYmax = Math.max(this.globalRealYmax, (double)iDataset.getShape()[0]);
                break;
            }
            case LINEAR_WITH_OFFSET: {
                this.globalRealYmin = this.yOffset;
                this.globalRealYmax = Math.max(this.globalRealYmax, (double)iDataset.getShape()[0]);
                break;
            }
            case CUSTOM: {
                this.globalRealYmin = this.yAxisValues.getMin();
                this.globalRealYmax = this.yAxisValues.getMax();
            }
        }
    }

    private void updateClipPlanePositions(double[] dArray) {
        MatrixBuilder.euclidean().rotateY(-1.5707963267948966).assignTo(this.leftClip);
        MatrixBuilder.euclidean().rotateY(1.5707963267948966).rotateX(1.5707963267948966).assignTo(this.bottomClip);
        MatrixBuilder.euclidean().rotateX(-1.5707963267948966).translate(0.0, dArray[1], 0.0).rotateX(-1.5707963267948966).assignTo(this.topClip);
        MatrixBuilder.euclidean().rotateX(1.5707963267948966).translate(dArray[0], -dArray[1], 0.0).rotateY(1.5707963267948966).assignTo(this.rightClip);
        MatrixBuilder.euclidean().rotateY(-1.5707963267948966).translate(-dArray[0], 0.0, 0.0).assignTo(this.graphGroupNode);
    }

    private void buildClipPlanes(SceneGraphComponent sceneGraphComponent) {
        Object object;
        if (this.leftClip == null) {
            object = new ClippingPlane();
            object.setLocal(true);
            this.leftClip = new SceneGraphComponent("leftClipBorder");
            this.leftClip.setGeometry((Geometry)object);
            sceneGraphComponent.addChild(this.leftClip);
        }
        if (this.bottomClip == null) {
            object = new ClippingPlane();
            object.setLocal(true);
            this.bottomClip = new SceneGraphComponent("bottomClipBorder");
            this.bottomClip.setGeometry((Geometry)object);
            this.leftClip.addChild(this.bottomClip);
        }
        if (this.topClip == null) {
            object = new ClippingPlane();
            object.setLocal(true);
            this.topClip = new SceneGraphComponent("topClipBorder");
            this.topClip.setGeometry((Geometry)object);
            this.bottomClip.addChild(this.topClip);
        }
        if (this.rightClip == null) {
            this.rightClip = new SceneGraphComponent("rightClipBorder");
            object = new ClippingPlane();
            object.setLocal(true);
            this.rightClip.setGeometry((Geometry)object);
            this.topClip.addChild(this.rightClip);
            this.rightClip.addChild(this.graphGroupNode);
        }
        object = this.determineXYsize();
        this.updateClipPlanePositions((double[])object);
    }

    private void loadGLSLProgram(double d, double d2) {
        if (this.currentImageType == 0) {
            this.tableProg = new GlslProgram(this.graphAppearance, "polygonShader", null, this.useLogarithmic ? FRAGLOGPROG : FRAGPROG);
            if (this.tableProg != null) {
                this.tableProg.setUniform("sampler", 0);
                this.tableProg.setUniform("tableSampler", 1);
                this.tableProg.setUniform("overlaySampler", 2);
                if (this.useLogarithmic) {
                    ScalingUtility.setSmallLogFlag(false);
                    this.tableProg.setUniform("maxValue", ScalingUtility.valueScaler(d2, ScaleType.LN));
                    this.tableProg.setUniform("minValue", ScalingUtility.valueScaler(d, ScaleType.LN));
                } else {
                    this.tableProg.setUniform("maxValue", d2);
                    this.tableProg.setUniform("minValue", d);
                }
            }
        } else {
            this.tableProg = new GlslProgram(this.graphAppearance, "polygonShader", null, FRAGCOLORPASSTHROUGH);
            this.tableProg.setUniform("sampler", 0);
            this.tableProg.setUniform("overlaySampler", 2);
        }
    }

    @Override
    public SceneGraphComponent buildGraph(List<IDataset> list, SceneGraphComponent sceneGraphComponent) {
        assert (list.size() > 0);
        this.maxHeight = 0;
        this.maxWidth = 0;
        if (sceneGraphComponent != null) {
            IDataset iDataset;
            this.graphGroupNode = new SceneGraphComponent("Graph Group node");
            this.graph = sceneGraphComponent;
            Iterator<IDataset> iterator = list.iterator();
            this.numGraphs = 0;
            while (iterator.hasNext()) {
                iDataset = iterator.next();
                int n = iDataset.getShape()[1];
                int n2 = iDataset.getShape()[0];
                this.maxWidth = Math.max(n, this.maxWidth);
                this.maxHeight = Math.max(n2, this.maxHeight);
                double[] dArray = this.determineXYsize();
                SceneGraphComponent sceneGraphComponent2 = SceneGraphUtility.createFullSceneGraphComponent((String)("graph.subGraph" + this.numGraphs));
                this.subGraphs.add(sceneGraphComponent2);
                this.graphGroupNode.addChild(sceneGraphComponent2);
                sceneGraphComponent2.setGeometry((Geometry)this.createGraphGeometry(dArray[0], dArray[1]));
                this.graphAppearance = new Appearance();
                this.graphApps.add(this.graphAppearance);
                this.graphAppearance.setAttribute("lightingEnabled", false);
                if (iDataset instanceof AbstractCompoundDataset) {
                    this.tableMin = 0.0;
                    this.tableMax = 0.0;
                } else {
                    this.tableMin = iDataset.min().doubleValue();
                    this.tableMax = iDataset.max().doubleValue();
                }
                this.generateTexture(iDataset, this.graphAppearance, n, n2);
                sceneGraphComponent2.setAppearance(this.graphAppearance);
                DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)this.graphAppearance, (boolean)true);
                DefaultPolygonShader defaultPolygonShader = (DefaultPolygonShader)defaultGeometryShader.createPolygonShader("default");
                defaultPolygonShader.setDiffuseColor(Color.white);
                defaultGeometryShader.setShowFaces(Boolean.valueOf(true));
                defaultGeometryShader.setShowLines(Boolean.valueOf(false));
                defaultGeometryShader.setShowPoints(Boolean.valueOf(false));
                if (this.hasJOGL && this.tableProg != null) {
                    this.graphAppearance.setAttribute("useGLSL", true);
                    Texture2D texture2D = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[1]", (Appearance)this.graphAppearance, (boolean)true);
                    texture2D.setImage(this.lookupTableImg);
                    texture2D.setMagFilter(Integer.valueOf(9987));
                    texture2D.setMinFilter(Integer.valueOf(9987));
                    texture2D.setRepeatS(Integer.valueOf(33071));
                    texture2D.setRepeatT(Integer.valueOf(33071));
                }
                ++this.numGraphs;
            }
            this.determineRanges(list);
            MatrixBuilder.euclidean().translate(-7.5, -7.5, 0.0).assignTo(sceneGraphComponent);
            if (this.xTickNode != null) {
                this.xTickNode.setGeometry((Geometry)this.createXTicksGeometry());
            }
            if (this.yTickNode != null) {
                this.yTickNode.setGeometry((Geometry)this.createYTicksGeometry());
            }
            if (this.xLabelNode != null) {
                this.xLabelNode.setGeometry((Geometry)this.createXLabelsGeometry());
            }
            if (this.yLabelNode != null) {
                this.yLabelNode.setGeometry((Geometry)this.createYLabelsGeometry());
            }
            if (this.ticksNode != null) {
                MatrixBuilder.euclidean().translate(-7.5, -7.5, 0.0).assignTo(this.ticksNode);
            }
            if (this.xLabelNode != null) {
                MatrixBuilder.euclidean().translate(-7.5, -7.5, 0.0).assignTo(this.xLabelNode);
            }
            if (this.yLabelNode != null) {
                MatrixBuilder.euclidean().translate(-7.5, -7.5, 0.0).assignTo(this.yLabelNode);
            }
            iDataset = CameraUtility.getCamera((Viewer)this.app.getCurrentViewer());
            iDataset.setFieldOfView(52.5);
            this.posTool.setImageHeight(this.maxHeight);
            this.posTool.setImageWidth(this.maxWidth);
            double[] dArray = this.determineXYsize();
            if (this.axis != null) {
                this.axis.setGeometry((Geometry)this.createAxisGeometry(dArray[0], dArray[1]));
            }
            this.panTool.setDataDimension(dArray[0], dArray[1]);
            this.posTool.setMaxXY(dArray[0], dArray[1]);
            sceneGraphComponent.addTool((Tool)this.posTool);
            this.buildBackground(sceneGraphComponent);
            this.buildClipPlanes(sceneGraphComponent);
        }
        return sceneGraphComponent;
    }

    private PointSet createYLabelsGeometry() {
        PointSetFactory pointSetFactory = new PointSetFactory();
        this.tickFactory.setTickMode(this.yLabelMode);
        int n = this.app.getCurrentViewer().getViewingComponentSize().height;
        if (n == 0) {
            n = 475;
        }
        LinkedList<Tick> linkedList = this.tickFactory.generateTicks(n, this.globalRealYmin, this.globalRealYmax, (short)1, false);
        double d = this.globalRealYmax - this.globalRealYmin;
        double[] dArray = this.determineXYsize();
        double d2 = dArray[1] * (this.tickFactory.getTickUnit() * (double)linkedList.size() / d) / (double)linkedList.size();
        String[] stringArray = new String[linkedList.size()];
        pointSetFactory.setVertexCount(linkedList.size());
        double[][] dArray2 = ArrayPoolUtility.getDoubleArray(linkedList.size());
        if (this.yAxis == AxisMode.CUSTOM) {
            boolean bl = this.yAxisValues.isAscending();
            int n2 = 0;
            while (n2 < linkedList.size()) {
                Tick tick = null;
                tick = bl ? linkedList.get(n2) : linkedList.get(linkedList.size() - 1 - n2);
                dArray2[n2][0] = -0.7;
                dArray2[n2][1] = dArray[1] - (double)n2 * d2;
                dArray2[n2][2] = 0.0;
                stringArray[n2] = tick.getTickName();
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < linkedList.size()) {
                Tick tick = linkedList.get(n3);
                dArray2[n3][0] = -0.7;
                dArray2[n3][1] = dArray[1] - (double)n3 * d2;
                dArray2[n3][2] = 0.0;
                stringArray[n3] = tick.getTickName();
                ++n3;
            }
        }
        pointSetFactory.setVertexCoordinates(dArray2);
        pointSetFactory.setVertexLabels(stringArray);
        pointSetFactory.update();
        return pointSetFactory.getPointSet();
    }

    private PointSet createXLabelsGeometry() {
        PointSetFactory pointSetFactory = new PointSetFactory();
        double d = this.globalRealXmin;
        double d2 = this.globalRealXmax;
        this.tickFactory.setTickMode(this.xLabelMode);
        int n = this.app.getCurrentViewer().getViewingComponentSize().width;
        if (n == 0) {
            n = 490;
        }
        LinkedList<Tick> linkedList = this.tickFactory.generateTicks((int)(this.labelScaling * (double)n), d, d2, (short)0, false);
        String[] stringArray = new String[linkedList.size()];
        pointSetFactory.setVertexCount(linkedList.size());
        double[][] dArray = ArrayPoolUtility.getDoubleArray(linkedList.size());
        double[] dArray2 = this.determineXYsize();
        if (this.xAxis == AxisMode.CUSTOM) {
            boolean bl = this.xAxisValues.isAscending();
            int n2 = 0;
            while (n2 < linkedList.size()) {
                double d3 = this.tickFactory.getTickUnit() * (double)n2;
                Tick tick = null;
                tick = bl ? linkedList.get(n2) : linkedList.get(linkedList.size() - 1 - n2);
                dArray[n2][0] = d3 / (this.globalRealXmax - this.globalRealXmin) * dArray2[0];
                dArray[n2][1] = -0.275;
                dArray[n2][2] = 0.0;
                stringArray[n2] = tick.getTickName();
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < linkedList.size()) {
                double d4 = this.tickFactory.getTickUnit() * (double)n3;
                Tick tick = linkedList.get(n3);
                dArray[n3][0] = d4 / (this.globalRealXmax - this.globalRealXmin) * dArray2[0];
                dArray[n3][1] = -0.275;
                dArray[n3][2] = 0.0;
                stringArray[n3] = tick.getTickName();
                ++n3;
            }
        }
        pointSetFactory.setVertexCoordinates(dArray);
        pointSetFactory.setVertexLabels(stringArray);
        pointSetFactory.update();
        return pointSetFactory.getPointSet();
    }

    @Override
    public void buildXCoordLabeling(SceneGraphComponent sceneGraphComponent) {
        this.xLabelNode = sceneGraphComponent;
        Appearance appearance = new Appearance();
        sceneGraphComponent.setAppearance(appearance);
        DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
        appearance.setAttribute("pointShader.spheresDraw", false);
        DefaultPointShader defaultPointShader = (DefaultPointShader)defaultGeometryShader.createPointShader("default");
        defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader.setShowLines(Boolean.valueOf(false));
        defaultGeometryShader.setShowPoints(Boolean.valueOf(true));
        defaultPointShader.setPointSize(Double.valueOf(1.0));
        defaultPointShader.setDiffuseColor(Color.white);
        this.dtsXTicks = (DefaultTextShader)defaultPointShader.getTextShader();
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        this.dtsXTicks.setOffset(dArray);
        this.dtsXTicks.setScale(Double.valueOf(0.0075));
        this.dtsXTicks.setDiffuseColor(Color.black);
        this.dtsXTicks.setAlignment(Integer.valueOf(0));
        sceneGraphComponent.setGeometry((Geometry)this.createXLabelsGeometry());
    }

    @Override
    public void buildYCoordLabeling(SceneGraphComponent sceneGraphComponent) {
        this.yLabelNode = sceneGraphComponent;
        Appearance appearance = new Appearance();
        sceneGraphComponent.setAppearance(appearance);
        DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
        appearance.setAttribute("pointShader.spheresDraw", false);
        DefaultPointShader defaultPointShader = (DefaultPointShader)defaultGeometryShader.createPointShader("default");
        defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader.setShowLines(Boolean.valueOf(false));
        defaultGeometryShader.setShowPoints(Boolean.valueOf(true));
        defaultPointShader.setPointSize(Double.valueOf(1.0));
        defaultPointShader.setDiffuseColor(Color.white);
        this.dtsYTicks = (DefaultTextShader)defaultPointShader.getTextShader();
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        this.dtsYTicks.setOffset(dArray);
        this.dtsYTicks.setScale(Double.valueOf(0.0075));
        this.dtsYTicks.setDiffuseColor(Color.black);
        this.dtsYTicks.setAlignment(Integer.valueOf(0));
        sceneGraphComponent.setGeometry((Geometry)this.createYLabelsGeometry());
    }

    @Override
    public void buildZCoordLabeling(SceneGraphComponent sceneGraphComponent) {
    }

    @Override
    public void handleColourCast(ColourImageData colourImageData, SceneGraphComponent sceneGraphComponent, double d, double d2) {
        if (this.hasJOGL && this.tableProg != null) {
            this.tableMin = d;
            this.tableMax = d2;
            byte[] byArray = new byte[colourImageData.getWidth() * 4];
            int n = 0;
            while (n < colourImageData.getWidth()) {
                int n2 = colourImageData.get(n, 0);
                byte by = (byte)(n2 >> 16 & 0xFF);
                byte by2 = (byte)(n2 >> 8 & 0xFF);
                byte by3 = (byte)(n2 & 0xFF);
                byArray[n * 4] = by;
                byArray[n * 4 + 1] = by2;
                byArray[n * 4 + 2] = by3;
                byArray[n * 4 + 3] = -1;
                ++n;
            }
            this.lookupTableImg = null;
            this.lookupTableImg = new ImageData(byArray, colourImageData.getWidth(), 1);
            for (Appearance appearance : this.graphApps) {
                Texture2D texture2D = (Texture2D)AttributeEntityUtility.getAttributeEntity(Texture2D.class, (String)"polygonShader.texture2d[1]", (Appearance)appearance, (boolean)true);
                texture2D.setMagFilter(Integer.valueOf(9987));
                texture2D.setMinFilter(Integer.valueOf(9987));
                texture2D.setRepeatS(Integer.valueOf(33071));
                texture2D.setRepeatT(Integer.valueOf(33071));
                texture2D.setImage(this.lookupTableImg);
            }
            if (this.useLogarithmic) {
                ScalingUtility.setSmallLogFlag(false);
                this.tableProg.setUniform("maxValue", ScalingUtility.valueScaler(d2, ScaleType.LN));
                this.tableProg.setUniform("minValue", ScalingUtility.valueScaler(d, ScaleType.LN));
            } else {
                this.tableProg.setUniform("maxValue", d2);
                this.tableProg.setUniform("minValue", d);
            }
        } else {
            int n = colourImageData.getWidth();
            int n3 = colourImageData.getHeight();
            this.softwareImageRGBAdata = new byte[n * n3 * 4];
            int n4 = 0;
            while (n4 < n3) {
                int n5 = 0;
                while (n5 < n) {
                    int n6 = colourImageData.get(n5, n4);
                    byte by = (byte)(n6 >> 24 & 0xFF);
                    byte by4 = (byte)(n6 >> 16 & 0xFF);
                    byte by5 = (byte)(n6 >> 8 & 0xFF);
                    byte by6 = (byte)(n6 & 0xFF);
                    this.softwareImageRGBAdata[(n5 + n4 * n) * 4] = by4;
                    this.softwareImageRGBAdata[(n5 + n4 * n) * 4 + 1] = by5;
                    this.softwareImageRGBAdata[(n5 + n4 * n) * 4 + 2] = by6;
                    this.softwareImageRGBAdata[(n5 + n4 * n) * 4 + 3] = by;
                    ++n5;
                }
                ++n4;
            }
            ImageData imageData = new ImageData(this.softwareImageRGBAdata, n, n3);
            this.generateSoftwareTexture(this.graphApps.get(0), imageData);
        }
    }

    @Override
    public void notifyComponentResize(int n, int n2) {
        double d = 1.0;
        this.canvasWidth = n;
        this.canvasHeight = n2;
        if (n < 490) {
            d = 490.0 / (double)n;
        }
        if (n2 < 475) {
            d = Math.max(d, 475.0 / (double)n2);
        }
        d = Math.max(d, 0.5);
        if (this.dtsXAxisLabel != null) {
            this.dtsXAxisLabel.setScale(Double.valueOf(0.0075 * d));
        }
        if (this.dtsYAxisLabel != null) {
            this.dtsYAxisLabel.setScale(Double.valueOf(0.0075 * d));
        }
        if (this.dtsTitleLabel != null) {
            this.dtsTitleLabel.setScale(Double.valueOf(0.0075 * d));
        }
        if (this.dtsXTicks != null) {
            if (this.hasJOGL) {
                this.dtsXTicks.setScale(Double.valueOf(0.0075 * d * 0.85));
            } else {
                this.dtsXTicks.setScale(Double.valueOf(0.0075 * d));
            }
        }
        if (this.dtsYTicks != null) {
            if (this.hasJOGL) {
                this.dtsYTicks.setScale(Double.valueOf(0.0075 * d * 0.85));
            } else {
                this.dtsYTicks.setScale(Double.valueOf(0.0075 * d));
            }
        }
    }

    @Override
    public void setAxisModes(AxisMode axisMode, AxisMode axisMode2, AxisMode axisMode3) {
        this.xAxis = axisMode;
        this.yAxis = axisMode2;
    }

    @Override
    public void setScaling(ScaleType scaleType) {
        block10: {
            block9: {
                if (this.graph == null) break block9;
                this.currentScale = scaleType;
                switch (DataSet3DPlot2D.$SWITCH_TABLE$uk$ac$diamond$scisoft$analysis$rcp$plotting$enums$ScaleType()[scaleType.ordinal()]) {
                    case 1: {
                        if (this.useLogarithmic) {
                            this.useLogarithmic = false;
                            if (this.hasJOGL) {
                                this.loadGLSLProgram(this.tableMin, this.tableMax);
                                break;
                            }
                        }
                        break block10;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        if (this.useLogarithmic) break block10;
                        this.useLogarithmic = true;
                        if (!this.hasJOGL) break block10;
                        this.loadGLSLProgram(this.tableMin, this.tableMax);
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block10;
            }
            this.useLogarithmic = scaleType != ScaleType.LINEAR;
        }
    }

    private void createXAxisLabelGeom() {
        if (this.xAxisLabelStr != null) {
            double[] dArray = this.determineXYsize();
            PointSetFactory pointSetFactory = new PointSetFactory();
            pointSetFactory.setVertexCount(1);
            double[][] dArray2 = ArrayPoolUtility.getDoubleArray(1);
            String[] stringArray = new String[]{this.xAxisLabelStr};
            dArray2[0][0] = dArray[0] * 0.5;
            dArray2[0][1] = -0.5;
            dArray2[0][2] = 0.0;
            pointSetFactory.setVertexCoordinates(dArray2);
            pointSetFactory.setVertexLabels(stringArray);
            pointSetFactory.update();
            this.xAxisLabel.setGeometry((Geometry)pointSetFactory.getPointSet());
        }
    }

    @Override
    public void setXAxisLabel(String string) {
        if (this.xAxisLabelStr == null || !string.equals(this.xAxisLabelStr)) {
            this.xAxisLabelStr = string;
            this.createXAxisLabelGeom();
        }
    }

    @Override
    public void setXAxisOffset(double d) {
        this.xOffset = d;
    }

    @Override
    public void setXAxisValues(AxisValues axisValues, int n) {
        this.xAxisValues = axisValues;
    }

    private void createYAxisLabelGeom() {
        if (this.yAxisLabelStr != null) {
            double[] dArray = this.determineXYsize();
            PointSetFactory pointSetFactory = new PointSetFactory();
            pointSetFactory.setVertexCount(1);
            double[][] dArray2 = ArrayPoolUtility.getDoubleArray(1);
            String[] stringArray = new String[]{this.yAxisLabelStr};
            dArray2[0][0] = -0.5;
            dArray2[0][1] = dArray[1] * 0.5;
            dArray2[0][2] = 0.0;
            pointSetFactory.setVertexCoordinates(dArray2);
            pointSetFactory.setVertexLabels(stringArray);
            pointSetFactory.update();
            this.yAxisLabel.setGeometry((Geometry)pointSetFactory.getPointSet());
        }
    }

    @Override
    public void setYAxisLabel(String string) {
        if (this.yAxisLabelStr == null || !string.equals(this.yAxisLabelStr)) {
            this.yAxisLabelStr = string;
            this.createYAxisLabelGeom();
        }
    }

    @Override
    public void setYAxisOffset(double d) {
        this.yOffset = d;
    }

    @Override
    public void setYAxisValues(AxisValues axisValues) {
        this.yAxisValues = axisValues;
    }

    @Override
    public void setZAxisLabel(String string) {
    }

    @Override
    public void setZAxisOffset(double d) {
    }

    private void cleanUpOverlay() {
        if (this.consumer != null) {
            this.consumer.removePrimitives();
            this.consumer = null;
        }
        this.overlayInOperation = false;
        Iterator<Integer> iterator = this.prim2DMap.keySet().iterator();
        while (iterator.hasNext()) {
            this.unregisterPrimitive(iterator.next());
        }
        this.prim2DMap.clear();
    }

    @Override
    public void updateGraph(IDataset iDataset) {
        this.maxHeight = 0;
        this.maxWidth = 0;
        SceneGraphComponent sceneGraphComponent = this.subGraphs.get(0);
        int n = iDataset.getShape()[1];
        int n2 = iDataset.getShape()[0];
        this.maxWidth = Math.max(n, this.maxWidth);
        this.maxHeight = Math.max(n2, this.maxHeight);
        double[] dArray = this.determineXYsize();
        sceneGraphComponent.setGeometry((Geometry)this.createGraphGeometry(dArray[0], dArray[1]));
        this.axis.setGeometry((Geometry)this.createAxisGeometry(dArray[0], dArray[1]));
        this.determineRanges(iDataset);
        this.updateClipPlanePositions(dArray);
        this.posTool.setImageHeight(this.maxHeight);
        this.posTool.setImageWidth(this.maxWidth);
        this.posTool.setMaxXY(dArray[0], dArray[1]);
        this.panTool.setDataDimension(dArray[0], dArray[1]);
        if (this.xTickNode != null) {
            this.xTickNode.setGeometry((Geometry)this.createXTicksGeometry());
        }
        if (this.yTickNode != null) {
            this.yTickNode.setGeometry((Geometry)this.createYTicksGeometry());
        }
        if (this.xLabelNode != null) {
            this.xLabelNode.setGeometry((Geometry)this.createXLabelsGeometry());
        }
        if (this.yLabelNode != null) {
            this.yLabelNode.setGeometry((Geometry)this.createYLabelsGeometry());
        }
        this.createYAxisLabelGeom();
        this.createXAxisLabelGeom();
    }

    @Override
    public void updateGraph(List<IDataset> list) {
        if (list.size() > 0 && this.subGraphs.size() > 0) {
            Object object;
            Iterator<IDataset> iterator = list.iterator();
            Iterator<SceneGraphComponent> iterator2 = this.subGraphs.iterator();
            this.maxWidth = 0;
            this.maxHeight = 0;
            while (iterator2.hasNext()) {
                double d;
                double d2;
                object = iterator.next();
                SceneGraphComponent sceneGraphComponent = iterator2.next();
                int n = object.getShape()[1];
                int n2 = object.getShape()[0];
                this.maxWidth = Math.max(n, this.maxWidth);
                this.maxHeight = Math.max(n2, this.maxHeight);
                if (n >= n2) {
                    d2 = 15.0;
                    d = 15.0 * (double)n2 / (double)n;
                } else {
                    d = 15.0;
                    d2 = 15.0 * (double)n / (double)n2;
                }
                d2 = Math.max(d2, 3.0);
                d = Math.max(d, 3.0);
                sceneGraphComponent.setGeometry((Geometry)this.createGraphGeometry(d2, d));
                this.generateTexture((IDataset)object, sceneGraphComponent.getAppearance(), n, n2);
            }
            this.posTool.setImageHeight(this.maxHeight);
            this.posTool.setImageWidth(this.maxWidth);
            object = this.determineXYsize();
            this.updateClipPlanePositions((double[])object);
            this.posTool.setMaxXY((double)object[0], (double)object[1]);
            this.panTool.setDataDimension((double)object[0], (double)object[1]);
            this.determineRanges(list);
            if (this.xTickNode != null) {
                this.xTickNode.setGeometry((Geometry)this.createXTicksGeometry());
            }
            if (this.yTickNode != null) {
                this.yTickNode.setGeometry((Geometry)this.createYTicksGeometry());
            }
            if (this.xLabelNode != null) {
                this.xLabelNode.setGeometry((Geometry)this.createXLabelsGeometry());
            }
            if (this.yLabelNode != null) {
                this.yLabelNode.setGeometry((Geometry)this.createYLabelsGeometry());
            }
            this.axis.setGeometry((Geometry)this.createAxisGeometry((double)object[0], (double)object[1]));
            this.createYAxisLabelGeom();
            this.createXAxisLabelGeom();
        } else {
            logger.warn("Tried to plot altough there is either no data or no graph nodes");
        }
    }

    @Override
    public void setXAxisLabelMode(TickFormatting tickFormatting) {
        this.xLabelMode = tickFormatting;
        if (this.xLabelNode != null) {
            this.xLabelNode.setGeometry((Geometry)this.createXLabelsGeometry());
        }
    }

    @Override
    public void setYAxisLabelMode(TickFormatting tickFormatting) {
        this.yLabelMode = tickFormatting;
        if (this.yLabelNode != null) {
            this.yLabelNode.setGeometry((Geometry)this.createYLabelsGeometry());
        }
    }

    @Override
    public void setZAxisLabelMode(TickFormatting tickFormatting) {
    }

    @Override
    public void cleanUpGraphNode() {
        if (this.graph != null) {
            if (this.graphGroupNode != null) {
                Iterator<SceneGraphComponent> iterator = this.subGraphs.iterator();
                while (iterator.hasNext()) {
                    this.graphGroupNode.removeChild(iterator.next());
                }
                this.subGraphs.clear();
            }
            if (this.leftClip != null) {
                this.graph.removeChild(this.leftClip);
            }
            if (this.background != null) {
                this.graph.removeChild(this.background);
            }
            this.cleanUpOverlay();
        }
        if (this.axis != null) {
            this.axis.removeChild(this.xAxisLabel);
            this.axis.removeChild(this.yAxisLabel);
            this.axis.removeChild(this.titleLabel);
        }
        if (this.graph != null) {
            this.graph.removeTool((Tool)this.actionTool);
        }
        this.softwareImageRGBAdata = null;
        this.imageData = null;
        this.actionListeners.clear();
    }

    @Override
    public boolean begin(OverlayType overlayType) {
        if (!this.overlayInOperation) {
            this.overlayInOperation = true;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void end(OverlayType overlayType) {
        this.overlayInOperation = false;
        switch (overlayType) {
            case IMAGE: {
                for (Appearance appearance : this.graphApps) {
                    this.generateOverlayTexture(appearance);
                }
                break;
            }
            case VECTOR2D: {
                Iterator<Integer> iterator = this.prim2DMap.keySet().iterator();
                while (iterator.hasNext()) {
                    OverlayPrimitive overlayPrimitive = this.prim2DMap.get(iterator.next());
                    overlayPrimitive.updateNode();
                    if (!overlayPrimitive.isFixedSize()) continue;
                    this.updateScaledPrimitive(overlayPrimitive, 1.0 / this.inverseScaling);
                }
                break;
            }
        }
        this.refresh();
    }

    public void registerOverlay(Overlay2DConsumer overlay2DConsumer) {
        this.consumer = overlay2DConsumer;
        this.posTool.addImagePositionListener(overlay2DConsumer);
        overlay2DConsumer.registerProvider(this);
    }

    public void unRegisterOverlay(Overlay2DConsumer overlay2DConsumer) {
        this.posTool.removeImagePositionListener(overlay2DConsumer);
        overlay2DConsumer.unregisterProvider();
        Iterator<Integer> iterator = this.prim2DMap.keySet().iterator();
        while (iterator.hasNext()) {
            OverlayPrimitive overlayPrimitive = this.prim2DMap.get(iterator.next());
            if (overlayPrimitive == null || this.subGraphs.get(0) == null) continue;
            this.subGraphs.get(0).removeChild(overlayPrimitive.getNode());
        }
        this.prim2DMap.clear();
        this.overlayInOperation = false;
    }

    @Override
    public void drawLine(int n, double d, double d2, double d3, double d4) {
        LinePrimitive linePrimitive;
        if (this.overlayInOperation && (linePrimitive = (LinePrimitive)this.prim2DMap.get(n)) != null) {
            double[] dArray = this.determineXYsize();
            double d5 = d / (double)this.maxWidth * dArray[0];
            double d6 = dArray[1] - d2 / (double)this.maxHeight * dArray[1];
            double d7 = d3 / (double)this.maxWidth * dArray[0];
            double d8 = dArray[1] - d4 / (double)this.maxHeight * dArray[1];
            linePrimitive.setLinePoints(d5, d6, d7, d8);
        }
    }

    @Override
    public void drawArrow(int n, double d, double d2, double d3, double d4) {
        ArrowPrimitive arrowPrimitive;
        if (this.overlayInOperation && (arrowPrimitive = (ArrowPrimitive)this.prim2DMap.get(n)) != null) {
            double[] dArray = this.determineXYsize();
            double d5 = d / (double)this.maxWidth * dArray[0];
            double d6 = dArray[1] - d2 / (double)this.maxHeight * dArray[1];
            double d7 = d3 / (double)this.maxWidth * dArray[0];
            double d8 = dArray[1] - d4 / (double)this.maxHeight * dArray[1];
            arrowPrimitive.setArrowPoints(d5, d6, d7, d8, 1.0);
        }
    }

    @Override
    public void drawArrow(int n, double d, double d2, double d3, double d4, double d5) {
        ArrowPrimitive arrowPrimitive;
        if (this.overlayInOperation && (arrowPrimitive = (ArrowPrimitive)this.prim2DMap.get(n)) != null) {
            double[] dArray = this.determineXYsize();
            double d6 = d / (double)this.maxWidth * dArray[0];
            double d7 = dArray[1] - d2 / (double)this.maxHeight * dArray[1];
            double d8 = d3 / (double)this.maxWidth * dArray[0];
            double d9 = dArray[1] - d4 / (double)this.maxHeight * dArray[1];
            arrowPrimitive.setArrowPoints(d6, d7, d8, d9, d5);
        }
    }

    @Override
    public void drawBox(int n, double d, double d2, double d3, double d4) {
        BoxPrimitive boxPrimitive;
        if (this.overlayInOperation && (boxPrimitive = (BoxPrimitive)this.prim2DMap.get(n)) != null) {
            double[] dArray = this.determineXYsize();
            double d5 = d / (double)this.maxWidth * dArray[0];
            double d6 = dArray[1] - d2 / (double)this.maxHeight * dArray[1];
            double d7 = d3 / (double)this.maxWidth * dArray[0];
            double d8 = dArray[1] - d4 / (double)this.maxHeight * dArray[1];
            boxPrimitive.setBoxPoints(d5, d6, d7, d8);
        }
    }

    @Override
    public void drawCircle(int n, double d, double d2, double d3) {
        CirclePrimitive circlePrimitive;
        if (this.overlayInOperation && (circlePrimitive = (CirclePrimitive)this.prim2DMap.get(n)) != null) {
            double[] dArray = this.determineXYsize();
            double d4 = d / (double)this.maxWidth * dArray[0];
            double d5 = dArray[1] - d2 / (double)this.maxHeight * dArray[1];
            double d6 = d3 / Math.sqrt(this.maxWidth * this.maxWidth + this.maxHeight * this.maxHeight) * Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
            circlePrimitive.setCircleParameters(d4, d5, d6);
        }
    }

    @Override
    public void drawSector(int n, double d, double d2, double d3, double d4, double d5, double d6) {
        CircleSectorPrimitive circleSectorPrimitive;
        if (this.overlayInOperation && (circleSectorPrimitive = (CircleSectorPrimitive)this.prim2DMap.get(n)) != null) {
            double[] dArray = this.determineXYsize();
            double d7 = d / (double)this.maxWidth * dArray[0];
            double d8 = dArray[1] - d2 / (double)this.maxHeight * dArray[1];
            double d9 = d3 / Math.sqrt(this.maxWidth * this.maxWidth + this.maxHeight * this.maxHeight) * Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
            double d10 = d4 / Math.sqrt(this.maxWidth * this.maxWidth + this.maxHeight * this.maxHeight) * Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
            circleSectorPrimitive.setSectorParameters(d7, d8, d10, d9, d5, d6);
        }
    }

    @Override
    public void drawTriangle(int n, double d, double d2, double d3, double d4, double d5, double d6) {
        TrianglePrimitive trianglePrimitive;
        if (this.overlayInOperation && (trianglePrimitive = (TrianglePrimitive)this.prim2DMap.get(n)) != null) {
            double[] dArray = this.determineXYsize();
            double d7 = d / (double)this.maxWidth * dArray[0];
            double d8 = dArray[1] - d2 / (double)this.maxHeight * dArray[1];
            double d9 = d3 / (double)this.maxWidth * dArray[0];
            double d10 = dArray[1] - d4 / (double)this.maxHeight * dArray[1];
            double d11 = d5 / (double)this.maxWidth * dArray[0];
            double d12 = dArray[1] - d6 / (double)this.maxHeight * dArray[1];
            trianglePrimitive.setTriangleCoords(d7, d8, d9, d10, d11, d12);
        }
    }

    @Override
    public synchronized int registerPrimitive(PrimitiveType primitiveType) {
        return this.registerPrimitive(primitiveType, false);
    }

    @Override
    public void setColour(int n, Color color) {
        OverlayPrimitive overlayPrimitive;
        if (this.overlayInOperation && (overlayPrimitive = this.prim2DMap.get(n)) != null) {
            overlayPrimitive.setColour(color);
        }
    }

    @Override
    public synchronized void unregisterPrimitive(int n) {
        OverlayPrimitive overlayPrimitive = this.prim2DMap.remove(n);
        if (overlayPrimitive != null && this.subGraphs.get(0) != null) {
            this.subGraphs.get(0).removeChild(overlayPrimitive.getNode());
        }
        if (!this.overlayInOperation) {
            this.refresh();
        }
    }

    @Override
    public synchronized void unregisterPrimitive(List<Integer> list) {
        Iterator<Integer> iterator = list.iterator();
        while (iterator.hasNext()) {
            OverlayPrimitive overlayPrimitive = this.prim2DMap.remove(iterator.next());
            if (overlayPrimitive == null || this.subGraphs.get(0) == null) continue;
            this.subGraphs.get(0).removeChild(overlayPrimitive.getNode());
        }
        if (!this.overlayInOperation) {
            this.refresh();
        }
    }

    @Override
    public void setStyle(int n, VectorOverlayStyles vectorOverlayStyles) {
        OverlayPrimitive overlayPrimitive = this.prim2DMap.get(n);
        if (overlayPrimitive != null) {
            overlayPrimitive.setStyle(vectorOverlayStyles);
        }
    }

    @Override
    public void setOutlineColour(int n, Color color) {
        OverlayPrimitive overlayPrimitive = this.prim2DMap.get(n);
        if (overlayPrimitive != null) {
            overlayPrimitive.setOutlineColour(color);
        }
    }

    @Override
    public void translatePrimitive(int n, double d, double d2) {
        OverlayPrimitive overlayPrimitive;
        if (this.overlayInOperation && (overlayPrimitive = this.prim2DMap.get(n)) != null) {
            double[] dArray = new double[2];
            double[] dArray2 = this.determineXYsize();
            dArray[0] = d / (double)this.maxWidth * dArray2[0];
            dArray[1] = -(d2 / (double)this.maxHeight) * dArray2[1];
            overlayPrimitive.translate(dArray);
        }
    }

    @Override
    public void rotatePrimitive(int n, double d, double d2, double d3) {
        OverlayPrimitive overlayPrimitive;
        if (this.overlayInOperation && (overlayPrimitive = this.prim2DMap.get(n)) != null) {
            double[] dArray = new double[2];
            double[] dArray2 = this.determineXYsize();
            dArray[0] = d2 / (double)this.maxWidth * dArray2[0];
            dArray[1] = dArray2[1] - d3 / (double)this.maxHeight * dArray2[1];
            overlayPrimitive.rotate(d, dArray);
        }
    }

    @Override
    public boolean setTransparency(int n, double d) {
        OverlayPrimitive overlayPrimitive;
        boolean bl = false;
        if (this.overlayInOperation && (overlayPrimitive = this.prim2DMap.get(n)) != null) {
            overlayPrimitive.setTransparency(d);
            bl = true;
        }
        return bl;
    }

    @Override
    public void setTitle(String string) {
        if (this.titleLabelStr == null || !string.equals(this.titleLabelStr)) {
            this.titleLabelStr = string;
            PointSetFactory pointSetFactory = new PointSetFactory();
            pointSetFactory.setVertexCount(1);
            double[] dArray = new double[3];
            String[] stringArray = new String[]{string};
            dArray[0] = 0.5;
            dArray[1] = 14.9;
            dArray[2] = 0.0;
            pointSetFactory.setVertexCoordinates(dArray);
            pointSetFactory.setVertexLabels(stringArray);
            pointSetFactory.update();
            this.titleLabel.setGeometry((Geometry)pointSetFactory.getPointSet());
        }
    }

    @Override
    public void setTickGridLinesActive(boolean bl, boolean bl2, boolean bl3) {
    }

    @Override
    public void setZAxisValues(AxisValues axisValues) {
    }

    @Override
    public void setLineThickness(int n, double d) {
        OverlayPrimitive overlayPrimitive = this.prim2DMap.get(n);
        if (overlayPrimitive != null) {
            overlayPrimitive.setLineThickness(d);
        }
    }

    @Override
    public boolean setOutlineTransparency(int n, double d) {
        OverlayPrimitive overlayPrimitive;
        boolean bl = false;
        if (this.overlayInOperation && (overlayPrimitive = this.prim2DMap.get(n)) != null) {
            overlayPrimitive.setOutlineTransparency(d);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean setPrimitiveVisible(int n, boolean bl) {
        boolean bl2 = false;
        OverlayPrimitive overlayPrimitive = this.prim2DMap.get(n);
        if (overlayPrimitive != null) {
            if (bl) {
                if (overlayPrimitive.isHidden() && this.subGraphs.get(0) != null) {
                    this.subGraphs.get(0).addChild(overlayPrimitive.getNode());
                    bl2 = true;
                    overlayPrimitive.unhide();
                }
            } else if (!overlayPrimitive.isHidden() && this.subGraphs.get(0) != null) {
                this.subGraphs.get(0).removeChild(overlayPrimitive.getNode());
                overlayPrimitive.hide();
                bl2 = true;
            }
        }
        return bl2;
    }

    @Override
    public void resetView() {
        Camera camera = CameraUtility.getCamera((Viewer)this.app.getCurrentViewer());
        camera.setFieldOfView(52.5);
        this.labelScaling = 1.0;
        if (this.xLabelNode != null) {
            this.xLabelNode.setGeometry((Geometry)this.createXLabelsGeometry());
        }
    }

    private void updateScaledPrimitive(OverlayPrimitive overlayPrimitive, double d) {
        double[] dArray = overlayPrimitive.getAnchorPoint();
        double d2 = dArray[0] * d - dArray[0];
        double d3 = dArray[1] * d - dArray[1];
        if (overlayPrimitive.getTransformationMatrix() != null) {
            MatrixBuilder.euclidean().scale(this.inverseScaling).translate(d2, d3, 0.0).times(overlayPrimitive.getTransformationMatrix()).assignTo(overlayPrimitive.getNode());
        } else {
            MatrixBuilder.euclidean().scale(this.inverseScaling).translate(d2, d3, 0.0).assignTo(overlayPrimitive.getNode());
        }
    }

    public void transformationMatrixChanged(TransformationEvent transformationEvent) {
        double[] dArray = transformationEvent.getTransformationMatrix();
        double[] dArray2 = this.determineXYsize();
        if (dArray2[0] * dArray[0] < MINX) {
            this.labelScaling = dArray2[0] * dArray[0] / MINX;
            if (this.xLabelNode != null) {
                this.xLabelNode.setGeometry((Geometry)this.createXLabelsGeometry());
            }
        }
        this.inverseScaling = 1.0 / dArray[0];
        double d = dArray[0];
        Iterator<Integer> iterator = this.prim2DMap.keySet().iterator();
        while (iterator.hasNext()) {
            OverlayPrimitive overlayPrimitive = this.prim2DMap.get(iterator.next());
            if (overlayPrimitive == null || !overlayPrimitive.isFixedSize()) continue;
            this.updateScaledPrimitive(overlayPrimitive, d);
        }
    }

    @Override
    public synchronized int registerPrimitive(PrimitiveType primitiveType, boolean bl) {
        if (this.subGraphs.size() != 0) {
            ++this.primKeyID;
            while (this.prim2DMap.containsKey(this.primKeyID)) {
                this.primKeyID = (this.primKeyID + 1) % Integer.MAX_VALUE;
            }
            OverlayPrimitive overlayPrimitive = null;
            SceneGraphComponent sceneGraphComponent = SceneGraphUtility.createFullSceneGraphComponent((String)("overlayPrim" + this.primKeyID));
            this.subGraphs.get(0).addChild(sceneGraphComponent);
            switch (primitiveType) {
                case LINE: {
                    overlayPrimitive = new LinePrimitive(sceneGraphComponent, bl);
                    break;
                }
                case BOX: {
                    overlayPrimitive = new BoxPrimitive(sceneGraphComponent, bl);
                    break;
                }
                case ARROW: {
                    overlayPrimitive = new ArrowPrimitive(sceneGraphComponent, bl);
                    break;
                }
                case CIRCLE: {
                    overlayPrimitive = new CirclePrimitive(sceneGraphComponent, bl);
                    break;
                }
                case TRIANGLE: {
                    overlayPrimitive = new TrianglePrimitive(sceneGraphComponent, bl);
                    break;
                }
                case SECTOR: {
                    overlayPrimitive = new CircleSectorPrimitive(sceneGraphComponent, bl);
                    break;
                }
                case LABEL: {
                    overlayPrimitive = new LabelPrimitive(sceneGraphComponent, bl);
                    break;
                }
                case POINT: {
                    overlayPrimitive = new PointPrimitive(sceneGraphComponent, bl);
                    break;
                }
                case POINTLIST: {
                    overlayPrimitive = new PointListPrimitive(sceneGraphComponent, bl);
                    break;
                }
                case RING: {
                    overlayPrimitive = new RingPrimitive(sceneGraphComponent, bl);
                    break;
                }
                case ELLIPSE: {
                    overlayPrimitive = new EllipsePrimitive(sceneGraphComponent, bl);
                }
            }
            this.prim2DMap.put(this.primKeyID, overlayPrimitive);
            return this.primKeyID;
        }
        return -1;
    }

    @Override
    public void setAnchorPoints(int n, double d, double d2) {
        OverlayPrimitive overlayPrimitive = this.prim2DMap.get(n);
        if (overlayPrimitive != null && overlayPrimitive.isFixedSize()) {
            double[] dArray = this.determineXYsize();
            double d3 = d / (double)this.maxWidth * dArray[0];
            double d4 = dArray[1] - d2 / (double)this.maxHeight * dArray[1];
            overlayPrimitive.setAnchorPoint(d3, d4);
        }
    }

    public void addPlotActionEventListener(PlotActionEventListener plotActionEventListener) {
        this.actionListeners.add(plotActionEventListener);
    }

    public void removePlotActionEventListener(PlotActionEventListener plotActionEventListener) {
        this.actionListeners.remove(plotActionEventListener);
    }

    @Override
    public void plotActionPerformed(PlotActionEvent plotActionEvent) {
        int n;
        double d = plotActionEvent.getPosition()[0];
        double d2 = plotActionEvent.getPosition()[1];
        int n2 = 0;
        int n3 = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        switch (this.xAxis) {
            case LINEAR: {
                d3 = d * (double)this.maxWidth;
                n2 = (int)Math.round(d3);
                break;
            }
            case LINEAR_WITH_OFFSET: {
                d3 = (double)this.maxWidth * d;
                n2 = (int)Math.round(d3);
                d3 += this.xOffset;
                break;
            }
            case CUSTOM: {
                n2 = n = (int)((double)this.maxWidth * d);
                d3 = this.xAxisValues.getValue(n);
            }
        }
        switch (this.yAxis) {
            case LINEAR: {
                d4 = (double)this.maxHeight * d2;
                n3 = (int)Math.round(d4);
                break;
            }
            case LINEAR_WITH_OFFSET: {
                d4 = (double)this.maxHeight * d2;
                n3 = (int)Math.round(d4);
                d4 += this.yOffset;
                break;
            }
            case CUSTOM: {
                n3 = n = (int)((double)this.maxHeight * d2);
                d4 = this.yAxisValues.getValue(n);
            }
        }
        Iterator<PlotActionEventListener> iterator = this.actionListeners.iterator();
        double[] dArray = new double[]{d3, d4};
        int[] nArray = new int[]{n2, n3};
        PlotActionEvent plotActionEvent2 = new PlotActionEvent(this.actionTool, dArray);
        plotActionEvent2.setDataPosition(nArray);
        while (iterator.hasNext()) {
            PlotActionEventListener plotActionEventListener = iterator.next();
            plotActionEventListener.plotActionPerformed(plotActionEvent2);
        }
    }

    public void enablePlotActionTool(boolean bl) {
        if (this.graph != null) {
            if (bl) {
                this.graph.addTool((Tool)this.actionTool);
            } else {
                this.graph.removeTool((Tool)this.actionTool);
            }
        }
    }

    @Override
    public void drawLabel(int n, double d, double d2) {
        LabelPrimitive labelPrimitive;
        if (this.overlayInOperation && (labelPrimitive = (LabelPrimitive)this.prim2DMap.get(n)) != null) {
            double[] dArray = this.determineXYsize();
            double d3 = d / (double)this.maxWidth * dArray[0];
            double d4 = dArray[1] - d2 / (double)this.maxHeight * dArray[1];
            labelPrimitive.setLabelPosition(d3, d4);
        }
    }

    @Override
    public boolean setLabelFont(int n, Font font) {
        LabelPrimitive labelPrimitive;
        boolean bl = false;
        if (this.overlayInOperation && (labelPrimitive = (LabelPrimitive)this.prim2DMap.get(n)) != null) {
            labelPrimitive.setLabelFont(font);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean setLabelOrientation(int n, LabelOrientation labelOrientation) {
        LabelPrimitive labelPrimitive;
        boolean bl = false;
        if (this.overlayInOperation && (labelPrimitive = (LabelPrimitive)this.prim2DMap.get(n)) != null) {
            labelPrimitive.setLabelDirection(labelOrientation);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean setLabelText(int n, String string, int n2) {
        LabelPrimitive labelPrimitive;
        boolean bl = false;
        if (this.overlayInOperation && (labelPrimitive = (LabelPrimitive)this.prim2DMap.get(n)) != null) {
            labelPrimitive.setLabelString(string);
            labelPrimitive.setLabelAlignment(n2);
            bl = true;
        }
        return bl;
    }

    @Override
    public void drawPoint(int n, double d, double d2) {
        PointPrimitive pointPrimitive;
        if (this.overlayInOperation && (pointPrimitive = (PointPrimitive)this.prim2DMap.get(n)) != null) {
            double[] dArray = this.determineXYsize();
            double d3 = d / (double)this.maxWidth * dArray[0];
            double d4 = dArray[1] - d2 / (double)this.maxHeight * dArray[1];
            pointPrimitive.setPoint(d3, d4);
        }
    }

    @Override
    public void setThickPoints(int n, boolean bl) {
        PointPrimitive pointPrimitive;
        if (this.overlayInOperation && (pointPrimitive = (PointPrimitive)this.prim2DMap.get(n)) != null) {
            pointPrimitive.setPhat(bl);
        }
    }

    @Override
    public void drawPoints(int n, double[] dArray, double[] dArray2) {
        PointListPrimitive pointListPrimitive;
        if (this.overlayInOperation && dArray.length == dArray2.length && (pointListPrimitive = (PointListPrimitive)this.prim2DMap.get(n)) != null) {
            double[] dArray3 = this.determineXYsize();
            double[] dArray4 = new double[dArray.length];
            double[] dArray5 = new double[dArray2.length];
            int n2 = 0;
            while (n2 < dArray.length) {
                dArray4[n2] = dArray[n2] / (double)this.maxWidth * dArray3[0];
                dArray5[n2] = dArray3[1] - dArray2[n2] / (double)this.maxHeight * dArray3[1];
                ++n2;
            }
            pointListPrimitive.setPoints(dArray4, dArray5);
        }
    }

    @Override
    public void drawRing(int n, double d, double d2, double d3, double d4) {
        RingPrimitive ringPrimitive;
        if (this.overlayInOperation && (ringPrimitive = (RingPrimitive)this.prim2DMap.get(n)) != null) {
            double[] dArray = this.determineXYsize();
            double d5 = d / (double)this.maxWidth * dArray[0];
            double d6 = dArray[1] - d2 / (double)this.maxHeight * dArray[1];
            double d7 = d3 / Math.sqrt(this.maxWidth * this.maxWidth + this.maxHeight * this.maxHeight) * Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
            double d8 = d4 / Math.sqrt(this.maxWidth * this.maxWidth + this.maxHeight * this.maxHeight) * Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
            ringPrimitive.setRingParameters(d5, d6, d7, d8);
        }
    }

    @Override
    public void drawEllipse(int n, double d, double d2, double d3, double d4, double d5) {
        EllipsePrimitive ellipsePrimitive;
        if (this.overlayInOperation && (ellipsePrimitive = (EllipsePrimitive)this.prim2DMap.get(n)) != null) {
            double[] dArray = this.determineXYsize();
            double d6 = d / (double)this.maxWidth * dArray[0];
            double d7 = dArray[1] - d2 / (double)this.maxHeight * dArray[1];
            double d8 = d3 / Math.sqrt(this.maxWidth * this.maxWidth + this.maxHeight * this.maxHeight) * Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
            double d9 = d4 / Math.sqrt(this.maxWidth * this.maxWidth + this.maxHeight * this.maxHeight) * Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
            ellipsePrimitive.setEllipseParameters(d6, d7, d8, d9, d5);
        }
    }

    @Override
    public ScaleType getScaling() {
        return this.currentScale;
    }

    public void setCanvasAspectRation(boolean bl) {
        this.useCanvasAspect = bl;
        double[] dArray = this.determineXYsize();
        for (SceneGraphComponent sceneGraphComponent : this.subGraphs) {
            sceneGraphComponent.setGeometry((Geometry)this.createGraphGeometry(dArray[0], dArray[1]));
        }
        this.updateClipPlanePositions(dArray);
        this.posTool.setMaxXY(dArray[0], dArray[1]);
        this.panTool.setDataDimension(dArray[0], dArray[1]);
        if (this.xTickNode != null) {
            this.xTickNode.setGeometry((Geometry)this.createXTicksGeometry());
        }
        if (this.yTickNode != null) {
            this.yTickNode.setGeometry((Geometry)this.createYTicksGeometry());
        }
        if (this.xLabelNode != null) {
            this.xLabelNode.setGeometry((Geometry)this.createXLabelsGeometry());
        }
        if (this.yLabelNode != null) {
            this.yLabelNode.setGeometry((Geometry)this.createYLabelsGeometry());
        }
        this.axis.setGeometry((Geometry)this.createAxisGeometry(dArray[0], dArray[1]));
        this.createYAxisLabelGeom();
        this.createXAxisLabelGeom();
    }

    @Override
    public List<AxisValues> getAxisValues() {
        return null;
    }

    @Override
    public void restoreDefaultPlotAreaCursor() {
        this.plotArea.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DataSet3DPlot2D.this.plotArea.setCursor(DataSet3DPlot2D.this.defaultCursor);
            }
        });
    }

    @Override
    public void setPlotAreaCursor(final int n) {
        this.plotArea.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Cursor cursor = DataSet3DPlot2D.this.plotArea.getDisplay().getSystemCursor(n);
                if (cursor != null) {
                    DataSet3DPlot2D.this.plotArea.setCursor(cursor);
                }
            }
        });
    }

    public void setFeatureDetection(boolean bl) {
        if (this.currentImageType == 0 && this.graph != null) {
            this.useFeatureEnhancement = bl;
            if (bl) {
                this.tableProg = new GlslProgram(this.graphAppearance, "polygonShader", null, DIFFRAGPROG);
                if (this.tableProg != null) {
                    this.tableProg.setUniform("sampler", 0);
                    this.tableProg.setUniform("tableSampler", 1);
                    this.tableProg.setUniform("overlaySampler", 2);
                    this.tableProg.setUniform("maxValue", this.tableMax);
                    this.tableProg.setUniform("minValue", this.tableMin);
                    this.threshold = this.tableMax * 1.25;
                    this.tableProg.setUniform("threshold", this.threshold);
                }
            } else {
                this.loadGLSLProgram(this.tableMin, this.tableMax);
            }
        }
    }

    public void changeFeatureSensitivity(double d) {
        if (this.useFeatureEnhancement && this.tableProg != null) {
            this.threshold *= d;
            this.tableProg.setUniform("threshold", this.threshold);
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$uk$ac$diamond$scisoft$analysis$rcp$plotting$enums$ScaleType() {
        if ($SWITCH_TABLE$uk$ac$diamond$scisoft$analysis$rcp$plotting$enums$ScaleType != null) {
            return $SWITCH_TABLE$uk$ac$diamond$scisoft$analysis$rcp$plotting$enums$ScaleType;
        }
        int[] nArray = new int[ScaleType.values().length];
        try {
            nArray[ScaleType.LINEAR.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScaleType.LN.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScaleType.LOG10.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ScaleType.LOG2.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$uk$ac$diamond$scisoft$analysis$rcp$plotting$enums$ScaleType = nArray;
        return nArray;
    }
}

