/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.nexus;

import gda.data.nexus.extractor.NexusExtractor;
import gda.data.nexus.extractor.NexusGroupData;
import gda.data.nexus.tree.INexusTree;
import gda.observable.IObserver;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.PlotServer;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Nexus;
import uk.ac.diamond.scisoft.analysis.dataset.NexusDataset;
import uk.ac.diamond.scisoft.analysis.plotserver.AxisMapBean;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBeanException;
import uk.ac.diamond.scisoft.analysis.plotserver.DataSetWithAxisInformation;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiPlotMode;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiUpdate;
import uk.ac.diamond.scisoft.analysis.rcp.nexus.NexusTableTree;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.axis.AxisChoice;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.axis.AxisSelection;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.axis.AxisSelectionTable;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.axis.AxisSliders;
import uk.ac.diamond.scisoft.analysis.rcp.views.PlotServerProvider;
import uk.ac.diamond.scisoft.analysis.rcp.views.PlotView;

public class NexusTreeExplorer
extends Composite
implements IObserver,
ICellEditorListener {
    private static final Logger logger = LoggerFactory.getLogger(NexusTreeExplorer.class);
    private Display display = null;
    private IWorkbenchPartSite site;
    private PlotServer plotServer;
    private GuiBean guiBean;
    private static final String NAME = "nexusTreeViewer";
    private static final String PLOTNAME = "NT1";
    private UUID plotID;
    private INexusTree tree;
    private NexusDataset cData;
    private List<AbstractDataset> cAxes;
    private int[] cSliceStart;
    private int[] cSliceStop;
    private int[] cOrder;
    ArrayList<AxisSelection> axes;
    List<String> plotAxes;
    NexusTableTree tableTree = null;
    Group axesSelGroup;
    Label dsDetails;
    private AxisSelectionTable axisSelector;
    TabFolder plotTabs;
    List<TabItem> tabPlots;
    private static final String[] tabTexts = new String[]{"1D", "1D stack", "2D", "2D surface"};
    private static final int TAB1D = 0;
    private static final int TAB1DSTACK = 1;
    private static final int TAB2D = 2;
    private static final int TAB2DSURFACE = 3;
    private static final int TABEND = 4;
    private int tabVisible = 0;
    private static final String[][] axesTexts = new String[][]{{"x-axis"}, {"x-axis", "z-axis"}, {"x-axis", "y-axis"}, {"x-axis", "y-axis"}};
    private static final int STACKPLOTLIMIT = 100;
    private AxisCombos[] axisComboLists;
    private AxisSliders[] plotSliderLists;
    private SliderListener[] psListeners;

    public NexusTreeExplorer(Composite composite, int n, IWorkbenchPartSite iWorkbenchPartSite) {
        super(composite, n);
        this.site = iWorkbenchPartSite;
        this.plotID = UUID.randomUUID();
        this.plotServer = PlotServerProvider.getPlotServer();
        this.plotServer.addIObserver((IObserver)this);
        this.guiBean = new GuiBean();
        try {
            this.plotServer.updateGui(NAME, this.guiBean);
        }
        catch (Exception exception) {
            logger.error("Problem pushing initial GUI bean to plot server");
            exception.printStackTrace();
        }
        this.cAxes = new ArrayList<AbstractDataset>();
        this.display = composite.getDisplay();
        this.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm((Composite)this, 512);
        this.tableTree = new NexusTableTree((Composite)sashForm, null, new Listener(){

            public void handleEvent(Event event) {
                NexusTreeExplorer.this.handleDoubleClick();
            }
        });
        Composite composite2 = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout = new GridLayout(2, true);
        composite2.setLayout((Layout)gridLayout);
        this.axesSelGroup = new Group(composite2, 0);
        this.axesSelGroup.setText("Data axes selection");
        GridData gridData = new GridData(4, 4, true, true);
        this.axesSelGroup.setLayoutData((Object)gridData);
        this.axesSelGroup.setLayout((Layout)new GridLayout(1, false));
        this.createAxesSelection((Composite)this.axesSelGroup);
        this.plotTabs = new TabFolder(composite2, 0);
        gridData = new GridData(0x1000008, 4, true, true);
        this.plotTabs.setLayoutData((Object)gridData);
        this.plotTabs.setLayout((Layout)new FillLayout());
        this.tabPlots = new ArrayList<TabItem>();
        int n2 = 0;
        while (n2 < tabTexts.length) {
            this.tabPlots.add(new TabItem(this.plotTabs, 0));
            this.tabPlots.get(n2).setText(tabTexts[n2]);
            ++n2;
        }
        this.axisComboLists = new AxisCombos[4];
        this.plotSliderLists = new AxisSliders[4];
        this.psListeners = new SliderListener[4];
        this.createPlotTab(0);
        this.plotTabs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (NexusTreeExplorer.this.tabPlots.contains(selectionEvent.item)) {
                    NexusTreeExplorer.this.tabVisible = NexusTreeExplorer.this.tabPlots.indexOf(selectionEvent.item);
                    NexusTreeExplorer.this.redrawPlotTabs();
                }
            }
        });
        this.plotTabs.setSelection(0);
        sashForm.setWeights(new int[]{65, 35});
        this.axisSelector.setInput(this.axes);
        this.getTreeFromServer();
        iWorkbenchPartSite.setSelectionProvider((ISelectionProvider)this.tableTree.getViewer());
    }

    private PlotView getPlotView() {
        PlotView plotView = null;
        try {
            plotView = (PlotView)this.site.getPage().showView("uk.ac.diamond.scisoft.analysis.rcp.plotViewNT1");
        }
        catch (PartInitException partInitException) {
            logger.error("All over now! Cannot find plotview: {} ", (Object)PLOTNAME);
            logger.error(partInitException.toString());
        }
        return plotView;
    }

    private void createAxesSelection(Composite composite) {
        GridData gridData = new GridData(4, 0x1000000, true, true);
        this.dsDetails = new Label(composite, 0);
        this.dsDetails.setText("");
        this.dsDetails.setLayoutData((Object)gridData);
        gridData = new GridData(4, 4, true, true, 1, 5);
        gridData.heightHint = 150;
        this.axes = new ArrayList();
        this.axisSelector = new AxisSelectionTable(composite, this.axes, this);
        this.axisSelector.setLayoutData(gridData);
    }

    private void createPlotTab(final int n) {
        AxisCombos axisCombos;
        String[] stringArray = axesTexts[n];
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.plotTabs, 768);
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        this.axisComboLists[n] = axisCombos = new AxisCombos();
        int n2 = 0;
        while (n2 < stringArray.length) {
            new Label(composite2, 0).setText(stringArray[n2]);
            axisCombos.add(new Combo(composite2, 8));
            ((Combo)axisCombos.get(n2)).add("               ");
            ((Combo)axisCombos.get(n2)).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    NexusTreeExplorer.this.redrawTab(n, false);
                }
            });
            new Label(composite2, 0);
            ++n2;
        }
        composite2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayout((Layout)new GridLayout(3, false));
        this.plotSliderLists[n] = new AxisSliders(composite3);
        this.psListeners[n] = new SliderListener(n);
        this.plotSliderLists[n].createSliders(3, this.psListeners[n]);
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        scrolledComposite.setContent((Control)composite);
        composite.setSize(composite.computeSize(-1, -1));
        this.tabPlots.get(n).setControl((Control)scrolledComposite);
    }

    private void sliceDataAndPlot() {
        AbstractDataset abstractDataset = this.cData.getSlice(this.cSliceStart, this.cSliceStop, null);
        AbstractDataset abstractDataset2 = DatasetUtils.transpose((AbstractDataset)abstractDataset, (int[])this.cOrder);
        abstractDataset2.setName(this.cData.getName());
        abstractDataset2.squeeze();
        if (abstractDataset2.getSize() > 1) {
            this.pushToPlotView(abstractDataset2, this.cAxes, this.tabVisible);
        }
    }

    private void redrawPlotTabs() {
        this.regeneratePlotAxes();
        int n = this.getCompatibleTab();
        if (n != this.tabVisible && n >= 0) {
            this.tabVisible = n;
            this.plotTabs.setSelection(this.tabVisible);
        }
        this.redrawTab(this.tabVisible, true);
    }

    private int getCompatibleTab() {
        String[] stringArray;
        int n = this.cData.getRank();
        int n2 = 0;
        while (n2 < 4) {
            stringArray = axesTexts[n2];
            Control control = this.plotTabs.getItem(n2).getControl();
            if (control != null) {
                if (n < stringArray.length) {
                    control.setEnabled(false);
                } else {
                    control.setEnabled(true);
                }
            }
            ++n2;
        }
        n2 = this.tabVisible;
        while (n2 < 4) {
            stringArray = axesTexts[n2];
            if (n >= stringArray.length) {
                return n2;
            }
            ++n2;
        }
        if (n2 == 4) {
            n2 = this.tabVisible - 1;
            while (n2 >= 0) {
                stringArray = axesTexts[n2];
                if (n >= stringArray.length) {
                    return n2;
                }
                --n2;
            }
        }
        logger.error("No tabs compatible with dataset!");
        return n2;
    }

    public void applyEditorValue() {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                NexusTreeExplorer.this.redrawPlotTabs();
            }
        });
    }

    public void cancelEditor() {
    }

    public void editorValueChanged(boolean bl, boolean bl2) {
    }

    private void redrawTab(int n, boolean bl) {
        Object object2;
        if (this.tabPlots.get(n).getControl() == null) {
            this.createPlotTab(n);
        }
        if (this.plotAxes == null) {
            return;
        }
        AxisCombos axisCombos = this.axisComboLists[n];
        AxisSliders axisSliders = this.plotSliderLists[n];
        int n2 = axisCombos.size();
        int[] nArray = new int[n2];
        if (bl) {
            this.regeneratePlotAxes();
            if (this.plotAxes.size() == 0) {
                return;
            }
            int n3 = 0;
            while (n3 < n2) {
                nArray[n3] = 0;
                ++n3;
            }
            axisSliders.createSliders(this.plotAxes.size(), this.psListeners[n]);
            Composite composite = axisSliders.getComposite().getParent();
            composite.setSize(composite.computeSize(-1, -1));
            this.populateCombos(axisCombos);
        } else {
            int n4 = 0;
            while (n4 < n2) {
                nArray[n4] = ((Combo)axisCombos.get(n4)).getSelectionIndex();
                ++n4;
            }
            this.repopulateCombos(axisCombos, nArray);
        }
        HashSet<String> hashSet = new HashSet<String>();
        this.cAxes.clear();
        int n5 = 0;
        while (n5 < n2) {
            object2 = ((Combo)axisCombos.get(n5)).getText();
            hashSet.add((String)object2);
            AbstractDataset abstractDataset = null;
            for (AxisSelection object3 : this.axes) {
                int n3;
                if (!object3.getName(n3 = object3.getSelectedIndex()).equals(object2)) continue;
                abstractDataset = object3.getAxis(n3);
                break;
            }
            if (abstractDataset == null) {
                return;
            }
            abstractDataset.setName((String)object2);
            this.cAxes.add(abstractDataset);
            ++n5;
        }
        n5 = 0;
        while (n5 < this.plotAxes.size()) {
            object2 = this.axes.get(n5).getSelectedAxis();
            int n7 = this.axes.get(n5).getLength();
            axisSliders.setSliderParameters(n5, n7, object2.getString(new int[]{0}), object2.getString(new int[]{n7 - 1}));
            if (hashSet.contains(this.plotAxes.get(n5))) {
                this.cSliceStart[n5] = 0;
                this.cSliceStop[n5] = this.cData.getShape()[n5];
                axisSliders.clear(n5);
                axisSliders.enableActiveSlider(n5, false);
            } else {
                this.cSliceStart[n5] = 0;
                this.cSliceStop[n5] = 1;
                axisSliders.setValue(n5, "0:" + object2.getString(new int[]{0}));
                axisSliders.enableActiveSlider(n5, true);
            }
            ++n5;
        }
        n5 = this.cOrder.length;
        object2 = new HashSet();
        int n8 = 0;
        while (n8 < n5) {
            ((HashSet)object2).add(n8);
            ++n8;
        }
        n8 = 0;
        while (n8 < n2) {
            String string = ((Combo)axisCombos.get(n8)).getText();
            this.cOrder[n8] = this.plotAxes.indexOf(string);
            ((HashSet)object2).remove(this.cOrder[n8]);
            ++n8;
        }
        if (((HashSet)object2).size() + n2 != n5) {
            logger.warn("Number of combo boxes mismatch!");
            return;
        }
        n8 = n2;
        Iterator<AxisSelection> iterator = ((HashSet)object2).iterator();
        while (iterator.hasNext()) {
            Integer n4 = (Integer)((Object)iterator.next());
            this.cOrder[n8++] = n4;
        }
        this.sliceDataAndPlot();
    }

    private void populateCombos(AxisCombos axisCombos) {
        int n = axisCombos.size();
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addAll(this.plotAxes);
        int n2 = 0;
        while (n2 < n) {
            Combo combo = (Combo)axisCombos.get(n2);
            combo.removeAll();
            String string = (String)linkedList.getFirst();
            for (String string2 : linkedList) {
                combo.add(string2);
            }
            combo.setText(string);
            linkedList.removeFirst();
            ++n2;
        }
    }

    private void repopulateCombos(AxisCombos axisCombos, int[] nArray) {
        int n = nArray.length;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.addAll(this.plotAxes);
        int n2 = 0;
        while (n2 < n) {
            String string;
            int n3 = nArray[n2];
            Combo combo = (Combo)axisCombos.get(n2);
            if (n3 >= combo.getItemCount()) {
                logger.warn("Index {} in entry {} is greater than number of items in combo box", (Object)n3, (Object)n2);
                string = this.plotAxes.get(n3);
            } else {
                string = combo.getItem(n3);
            }
            combo.removeAll();
            if (!linkedHashSet.contains(string)) {
                int n4 = this.plotAxes.size();
                if (n < n4) {
                    n4 = n;
                }
                n3 = 0;
                while (n3 < n4) {
                    string = this.plotAxes.get(n3);
                    if (linkedHashSet.contains(string)) break;
                    ++n3;
                }
                if (n3 >= n) {
                    logger.error("Could not find a free axis name");
                    return;
                }
            }
            for (String string2 : linkedHashSet) {
                combo.add(string2);
            }
            combo.setText(string);
            nArray[n2] = combo.indexOf(string);
            linkedHashSet.remove(string);
            ++n2;
        }
    }

    private void regeneratePlotAxes() {
        if (this.plotAxes == null) {
            this.plotAxes = new ArrayList<String>();
        }
        this.plotAxes.clear();
        int n = 0;
        while (n < this.axes.size()) {
            AxisSelection axisSelection = this.axes.get(n);
            int n2 = axisSelection.getSelectedIndex();
            this.plotAxes.add(axisSelection.getName(n2));
            ++n;
        }
    }

    private void processGUIUpdate(GuiBean guiBean) {
        String string;
        INexusTree iNexusTree;
        if (guiBean.containsKey((Object)GuiParameters.METADATANODEPATH) && (iNexusTree = this.tree.getNode(string = (String)guiBean.get((Object)GuiParameters.METADATANODEPATH))) != null && !this.handleSelectedNode(iNexusTree)) {
            logger.error("Could not process update of selected node: {}", (Object)string);
        }
    }

    public void update(Object object, Object object2) {
        String string;
        if (object2 instanceof GuiUpdate) {
            GuiUpdate guiUpdate = (GuiUpdate)object2;
            if (guiUpdate.getGuiName().contains(NAME)) {
                this.guiBean = guiUpdate.getGuiData();
                this.syncGuiToBean();
                GuiBean guiBean = guiUpdate.getGuiData();
                UUID uUID = (UUID)guiBean.get((Object)GuiParameters.PLOTID);
                if (uUID == null || this.plotID.compareTo(uUID) != 0) {
                    if (this.guiBean == null) {
                        this.guiBean = guiBean.copy();
                    } else {
                        this.guiBean.merge(guiBean);
                    }
                    logger.debug("Processing update received from {}: {}", object, object2);
                    this.processGUIUpdate(guiBean);
                }
            }
        } else if (object2 instanceof String && (string = (String)object2).equals(NAME)) {
            this.getTreeFromServer();
        }
    }

    private void getTreeFromServer() {
        try {
            logger.debug("Pulling data to client");
            long l = System.nanoTime();
            DataBean dataBean = this.plotServer.getData(NAME);
            l = System.nanoTime() - l;
            logger.debug("Data pushed to client: {} in {} s", (Object)dataBean, (Object)String.format("%.3g", (double)l * 1.0E-9));
            this.syncTreeToBean(dataBean);
        }
        catch (Exception exception) {
            logger.error("Problem pushing data to plot server");
            exception.printStackTrace();
        }
    }

    private void syncGuiToBean() {
        if (this.display != null) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    NexusTreeExplorer.this.display.update();
                }
            });
        }
    }

    private void syncTreeToBean(DataBean dataBean) {
        if (dataBean == null) {
            logger.warn("Plot server has no info for NTV");
            return;
        }
        List list = (List)dataBean.getNexusTrees();
        if (list == null) {
            logger.warn("Plot server did not push a list of trees");
            return;
        }
        if (list.size() == 0) {
            logger.warn("Plot server pushed an empty list of trees");
            return;
        }
        this.setNexusTree((INexusTree)list.get(0));
    }

    public void setNexusTree(INexusTree iNexusTree) {
        this.tree = iNexusTree;
        if (this.display != null) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    NexusTreeExplorer.this.tableTree.setInput(NexusTreeExplorer.this.tree);
                    NexusTreeExplorer.this.display.update();
                }
            });
        }
    }

    private void handleDoubleClick() {
        IStructuredSelection iStructuredSelection = this.tableTree.getSelection();
        if (iStructuredSelection != null) {
            INexusTree iNexusTree = (INexusTree)iStructuredSelection.getFirstElement();
            if (iNexusTree == null) {
                return;
            }
            if (!this.handleSelectedNode(iNexusTree)) {
                logger.error("Could not process update of selected node: {}", (Object)iNexusTree.getName());
                return;
            }
            this.pushGUIUpdate(GuiParameters.METADATANODEPATH, (Serializable)((Object)iNexusTree.getNodePath()));
        }
    }

    private boolean handleSelectedNode(INexusTree iNexusTree) {
        if (!this.processSelectedNode(iNexusTree)) {
            return false;
        }
        if (this.cData == null) {
            return false;
        }
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                StringBuilder stringBuilder = new StringBuilder(String.format("Name: %s, Rank: %d, Dims: ", NexusTreeExplorer.this.cData.getName(), NexusTreeExplorer.this.cData.getRank()));
                int[] nArray = NexusTreeExplorer.this.cData.getShape();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int n3 = nArray[n2];
                    stringBuilder.append(n3);
                    stringBuilder.append(", ");
                    ++n2;
                }
                if (stringBuilder.length() > 2) {
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                }
                NexusTreeExplorer.this.dsDetails.setText(stringBuilder.toString());
                NexusTreeExplorer.this.axisSelector.redrawASTable();
                NexusTreeExplorer.this.axesSelGroup.redraw();
                NexusTreeExplorer.this.redrawPlotTabs();
            }
        });
        return true;
    }

    public Integer getIntAttribute(INexusTree iNexusTree, String string) {
        Serializable serializable = iNexusTree.getAttribute(string);
        if (serializable instanceof Integer) {
            return (Integer)serializable;
        }
        return null;
    }

    private boolean processSelectedNode(INexusTree iNexusTree) {
        INexusTree iNexusTree2;
        Integer n;
        String[] stringArray;
        NexusGroupData nexusGroupData;
        INexusTree iNexusTree3 = iNexusTree;
        boolean bl = false;
        ArrayList<AxisChoice> arrayList = new ArrayList<AxisChoice>();
        String string = null;
        if (iNexusTree3.getNxClass().equals("NXdata")) {
            int n2 = 0;
            while (n2 < iNexusTree3.getNumberOfChildNodes()) {
                nexusGroupData = iNexusTree3.getChildNode(n2);
                stringArray = nexusGroupData.getData();
                if (stringArray != null && (n = this.getIntAttribute((INexusTree)nexusGroupData, "signal")) != null) {
                    bl = true;
                    try {
                        this.cData = new NexusDataset((INexusTree)nexusGroupData);
                    }
                    catch (Exception exception) {
                        logger.error("Could not convert NeXus item {} to a dataset", (Object)nexusGroupData.getName(), (Object)exception);
                        bl = false;
                    }
                    string = (String)((Object)nexusGroupData.getAttribute("axes"));
                    break;
                }
                ++n2;
            }
        } else if (iNexusTree3.getNxClass().equals("SDS") && (nexusGroupData = (iNexusTree2 = iNexusTree3).getData()) != null) {
            bl = true;
            try {
                this.cData = new NexusDataset(iNexusTree2);
            }
            catch (Exception exception) {
                logger.error("Could not convert NeXus item {} to a dataset", (Object)iNexusTree2.getName());
                bl = false;
            }
            string = (String)((Object)iNexusTree2.getAttribute("axes"));
            iNexusTree3 = iNexusTree.getParentNode();
        }
        if (bl) {
            Object object2;
            this.cData.squeeze(true);
            int n3 = this.cData.getRank();
            this.cSliceStart = new int[n3];
            this.cSliceStop = new int[n3];
            this.cOrder = new int[n3];
            if (iNexusTree3 != null) {
                int n4 = 0;
                int n5 = iNexusTree3.getNumberOfChildNodes();
                while (n4 < n5) {
                    HashMap object3;
                    n = iNexusTree3.getChildNode(n4);
                    object2 = n.getData();
                    if (object2 != null && (object3 = n.getAttributes()) != null && !object3.containsKey("signal")) {
                        try {
                            AbstractDataset abstractDataset = Nexus.createDataset((NexusGroupData)NexusExtractor.getNexusGroupDataWithBuffer((INexusTree)n, (boolean)true), (boolean)false);
                            abstractDataset.squeeze(true);
                            if (abstractDataset.getRank() <= 1) {
                                abstractDataset.setName(n.getName());
                                AxisChoice axisChoice = new AxisChoice(n.getName(), abstractDataset);
                                if (object3.containsKey("axis")) {
                                    axisChoice.setDimension((Integer)object3.get("axis"));
                                }
                                if (object3.containsKey("primary")) {
                                    axisChoice.setOrder((Integer)object3.get("primary"));
                                }
                                arrayList.add(axisChoice);
                            }
                        }
                        catch (Exception exception) {
                            logger.error("Could not convert NeXus item {} to a dataset", (Object)n.getName(), (Object)exception);
                        }
                    }
                    ++n4;
                }
            }
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            if (string != null) {
                if ((string = string.trim()).startsWith("[")) {
                    string = string.substring(1, string.length() - 1);
                }
                stringArray = null;
                stringArray = string.split(",");
                int n6 = 0;
                while (n6 < stringArray.length) {
                    object2 = stringArray[n6];
                    if (!arrayList.contains(object2)) {
                        logger.warn("Referenced axis {} does not exist in NeXus tree node {}", new Object[]{object2, iNexusTree3});
                        arrayList2.add(null);
                    } else {
                        arrayList2.add(object2);
                    }
                    ++n6;
                }
            }
            this.axes.clear();
            int n7 = 0;
            while (n7 < n3) {
                int n8 = this.cData.getShape()[n7];
                object2 = new AxisSelection(n8);
                this.axes.add(n7, null);
                for (AxisChoice axisChoice : arrayList) {
                    if (axisChoice.getDimension() != n7 + 1) continue;
                    if (axisChoice.getLength() == n8) {
                        ((AxisSelection)object2).addSelection(axisChoice.getName(), axisChoice.getValues(), axisChoice.getOrder());
                        continue;
                    }
                    logger.warn("Ignoring axis {} as its length ({}) does not match data dimension ({})", new Object[]{axisChoice.getName(), axisChoice.getLength(), n8});
                }
                for (AxisChoice axisChoice : arrayList) {
                    if (axisChoice.getDimension() == n7 + 1 || axisChoice.getLength() != n8) continue;
                    ((AxisSelection)object2).addSelection(axisChoice.getName(), axisChoice.getValues(), 0);
                }
                if (n7 < arrayList2.size()) {
                    for (AxisChoice axisChoice : arrayList) {
                        if (!axisChoice.getName().equals(arrayList2.get(n7))) continue;
                        if (axisChoice.getLength() == n8) {
                            ((AxisSelection)object2).addSelection(axisChoice.getName(), axisChoice.getValues(), 1);
                            continue;
                        }
                        logger.warn("Ignoring specified axis {} as its length ({}) does not match data dimension ({})", new Object[]{arrayList2.get(n7), axisChoice.getLength(), n8});
                    }
                }
                AbstractDataset abstractDataset = AbstractDataset.arange((double)n8, (int)3);
                ((AxisSelection)object2).addSelection("autoaxis:" + (n7 + 1), abstractDataset, ((AxisSelection)object2).getMaxOrder() + 1);
                ((AxisSelection)object2).reorderNames();
                ((AxisSelection)object2).selectAxis(0);
                this.axes.set(n7, (AxisSelection)object2);
                ++n7;
            }
        }
        return bl;
    }

    private void pushToPlotView(AbstractDataset abstractDataset, List<AbstractDataset> list, int n) {
        DataBean dataBean = new DataBean();
        DataSetWithAxisInformation dataSetWithAxisInformation = new DataSetWithAxisInformation();
        AxisMapBean axisMapBean = new AxisMapBean(AxisMapBean.DIRECT);
        PlotView plotView = this.getPlotView();
        if (plotView == null) {
            return;
        }
        switch (n) {
            case 0: {
                if (abstractDataset.getRank() != 1) {
                    return;
                }
                plotView.updatePlotMode(GuiPlotMode.ONED);
                dataBean.addAxis("x-axis", (IDataset)list.get(0));
                axisMapBean.setAxisID(new String[]{"x-axis"});
                dataSetWithAxisInformation.setData((IDataset)abstractDataset);
                dataSetWithAxisInformation.setAxisMap(axisMapBean);
                try {
                    dataBean.addData(dataSetWithAxisInformation);
                }
                catch (DataBeanException dataBeanException) {
                    logger.debug("Could not add data to bean");
                    dataBeanException.printStackTrace();
                }
                break;
            }
            case 1: {
                if (abstractDataset.getRank() != 2) {
                    return;
                }
                plotView.updatePlotMode(GuiPlotMode.ONED_THREED);
                int[] nArray = abstractDataset.getShape();
                dataBean.addAxis("x-axis", (IDataset)list.get(0));
                int n2 = nArray[1];
                if (n2 > 100) {
                    logger.warn("Try plot too many lines in stack plot: reduced from {} lines to {}", (Object)n2, (Object)100);
                    n2 = 100;
                    AbstractDataset abstractDataset2 = list.get(1).getSlice(null, new int[]{n2}, null);
                    dataBean.addAxis("z-axis", (IDataset)abstractDataset2);
                } else {
                    dataBean.addAxis("z-axis", (IDataset)list.get(1));
                }
                int n3 = 0;
                while (n3 < n2) {
                    int[] nArray2 = new int[2];
                    nArray2[1] = n3;
                    AbstractDataset abstractDataset3 = abstractDataset.getSlice(nArray2, new int[]{nArray[0], n3 + 1}, null);
                    abstractDataset3.squeeze();
                    dataSetWithAxisInformation = new DataSetWithAxisInformation();
                    dataSetWithAxisInformation.setData((IDataset)abstractDataset3);
                    dataSetWithAxisInformation.setAxisMap(axisMapBean);
                    try {
                        dataBean.addData(dataSetWithAxisInformation);
                    }
                    catch (DataBeanException dataBeanException) {
                        logger.debug("Could not add data to bean");
                        dataBeanException.printStackTrace();
                    }
                    ++n3;
                }
                break;
            }
            case 2: {
                if (abstractDataset.getRank() != 2) {
                    return;
                }
                plotView.updatePlotMode(GuiPlotMode.TWOD);
                dataBean.addAxis("x-axis", (IDataset)list.get(0));
                dataBean.addAxis("y-axis", (IDataset)list.get(1));
                int[] nArray = new int[2];
                nArray[0] = 1;
                dataSetWithAxisInformation.setData((IDataset)DatasetUtils.transpose((AbstractDataset)abstractDataset, (int[])nArray));
                dataSetWithAxisInformation.setAxisMap(axisMapBean);
                try {
                    dataBean.addData(dataSetWithAxisInformation);
                }
                catch (DataBeanException dataBeanException) {
                    logger.debug("Could not add data to bean");
                    dataBeanException.printStackTrace();
                }
                break;
            }
            case 3: {
                if (abstractDataset.getRank() != 2) {
                    return;
                }
                plotView.updatePlotMode(GuiPlotMode.SURF2D);
                dataBean.addAxis("x-axis", (IDataset)list.get(0));
                dataBean.addAxis("y-axis", (IDataset)list.get(1));
                int[] nArray = new int[2];
                nArray[0] = 1;
                dataSetWithAxisInformation.setData((IDataset)DatasetUtils.transpose((AbstractDataset)abstractDataset, (int[])nArray));
                dataSetWithAxisInformation.setAxisMap(axisMapBean);
                try {
                    dataBean.addData(dataSetWithAxisInformation);
                    break;
                }
                catch (DataBeanException dataBeanException) {
                    logger.debug("Could not add data to bean");
                    dataBeanException.printStackTrace();
                }
            }
        }
        plotView.processPlotUpdate(dataBean);
    }

    public void pushGUIUpdate(GuiParameters guiParameters, Serializable serializable) {
        if (this.guiBean == null) {
            try {
                this.guiBean = this.plotServer.getGuiState(NAME);
            }
            catch (Exception exception) {
                logger.error("Problem with getting GUI data from plot server");
            }
            if (this.guiBean == null) {
                this.guiBean = new GuiBean();
            }
        }
        if (!this.guiBean.containsKey((Object)GuiParameters.PLOTID)) {
            this.guiBean.put((Object)GuiParameters.PLOTID, (Object)this.plotID);
        }
        this.guiBean.put((Object)guiParameters, (Object)serializable);
        try {
            this.plotServer.updateGui(NAME, this.guiBean);
        }
        catch (Exception exception) {
            logger.error("Problem with updating plot server with GUI data");
            exception.printStackTrace();
        }
    }

    public void expandAll() {
        this.tableTree.expandAll();
    }

    class AxisCombos
    extends ArrayList<Combo> {
        AxisCombos() {
        }
    }

    class SliderListener
    implements SelectionListener {
        int tabNumber;

        public SliderListener(int n) {
            this.tabNumber = n;
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            int n;
            if (selectionEvent == null) {
                return;
            }
            if (selectionEvent.widget == null) {
                return;
            }
            int n2 = NexusTreeExplorer.this.plotSliderLists[this.tabNumber].getSlider((Slider)selectionEvent.widget);
            ((NexusTreeExplorer)NexusTreeExplorer.this).cSliceStart[n2] = n = ((Slider)selectionEvent.widget).getSelection();
            ((NexusTreeExplorer)NexusTreeExplorer.this).cSliceStop[n2] = n + 1;
            AbstractDataset abstractDataset = NexusTreeExplorer.this.axes.get(n2).getSelectedAxis();
            if (abstractDataset != null) {
                NexusTreeExplorer.this.plotSliderLists[this.tabNumber].setValue(n2, String.format("%d:%s", n, abstractDataset.getString(new int[]{n})));
            } else {
                NexusTreeExplorer.this.plotSliderLists[this.tabNumber].setValue(n2, String.valueOf(n));
            }
            NexusTreeExplorer.this.sliceDataAndPlot();
        }
    }
}

