/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.nexus;

import gda.data.nexus.extractor.NexusExtractor;
import gda.data.nexus.extractor.NexusGroupData;
import gda.data.nexus.tree.INexusTree;
import java.io.Serializable;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NexusLabelProvider
implements ITableLabelProvider {
    private static final Logger logger = LoggerFactory.getLogger(NexusLabelProvider.class);

    NexusLabelProvider() {
    }

    public Image getColumnImage(Object object, int n) {
        return null;
    }

    public String getColumnText(Object object, int n) {
        String string = "";
        INexusTree iNexusTree = (INexusTree)object;
        switch (n) {
            case 0: {
                string = iNexusTree.getName();
                break;
            }
            case 1: {
                string = iNexusTree.getNxClass();
            }
        }
        NexusGroupData nexusGroupData = iNexusTree.getData();
        if (nexusGroupData != null) {
            block5 : switch (n) {
                case 2: {
                    int[] nArray = nexusGroupData.dimensions;
                    int n2 = nexusGroupData.dimensions.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        int n4 = nArray[n3];
                        string = String.valueOf(string) + n4 + ", ";
                        ++n3;
                    }
                    if (string.length() <= 2) break;
                    string = string.substring(0, string.length() - 2);
                    break;
                }
                case 3: {
                    switch (nexusGroupData.type) {
                        case 4: {
                            string = "CHAR";
                            break block5;
                        }
                        case 6: {
                            string = "FLT64";
                            break block5;
                        }
                        case 5: {
                            string = "FLT32";
                            break block5;
                        }
                        case 26: {
                            string = "INT64";
                            break block5;
                        }
                        case 27: {
                            string = "UINT64";
                            break block5;
                        }
                        case 24: {
                            string = "INT32";
                            break block5;
                        }
                        case 25: {
                            string = "UINT32";
                            break block5;
                        }
                        case 22: {
                            string = "INT16";
                            break block5;
                        }
                        case 23: {
                            string = "UINT16";
                            break block5;
                        }
                        case 20: {
                            string = "INT8";
                            break block5;
                        }
                        case 21: {
                            string = "UINT8";
                            break block5;
                        }
                    }
                    string = "type = " + nexusGroupData.type;
                    break;
                }
                case 4: {
                    string = "click to view";
                    if (nexusGroupData.type == 4) {
                        try {
                            NexusGroupData nexusGroupData2 = NexusExtractor.getNexusGroupDataWithBuffer((INexusTree)iNexusTree, (boolean)true);
                            Serializable serializable = nexusGroupData2.getBuffer();
                            string = new String((byte[])serializable, "UTF-8");
                        }
                        catch (Exception exception) {
                            logger.error("Error getting data", (Throwable)exception);
                            string = "Error getting data";
                        }
                        break;
                    }
                    if (nexusGroupData.dimensions.length != 1 || nexusGroupData.dimensions[0] != 1) break;
                    string = nexusGroupData.dataToTxt(false, true, false);
                }
            }
        }
        return string;
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object object, String string) {
        return false;
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
    }
}

