/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions;

import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.AbstractMapFunction;

public class GeoRedMapFunction
extends AbstractMapFunction {
    private static final double region1 = 0.14285714285714285;
    private static final double region2 = 0.4;
    private static final double region3 = 0.75;

    @Override
    public String getMapFunctionName() {
        return "GeoRed";
    }

    @Override
    public double mapFunction(double d) {
        if (d < 0.14285714285714285) {
            return 0.0;
        }
        if (d >= 0.14285714285714285 && d < 0.4) {
            return (d - 0.14285714285714285) * 4.0;
        }
        if (d >= 0.4 && d < 0.75) {
            return 1.0 - 0.5 * (d - 0.4);
        }
        if (d >= 0.75) {
            return 0.825 + 3.75 * (d - 0.75) * (d - 0.75);
        }
        return 1.0;
    }
}

