/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions;

import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.AbstractMapFunction;

public class GeoBlueMapFunction
extends AbstractMapFunction {
    private static final double region1 = 0.16666666666666666;
    private static final double region2 = 0.2;
    private static final double region3 = 0.3333333333333333;
    private static final double region4 = 0.75;
    private static final double region5 = 0.8;

    @Override
    public String getMapFunctionName() {
        return "GeoBlue";
    }

    @Override
    public double mapFunction(double d) {
        if (d < 0.16666666666666666) {
            return Math.sin(1.5707963267948966 * (d / 0.16666666666666666));
        }
        if (d >= 0.16666666666666666 && d < 0.2) {
            return 1.0;
        }
        if (d >= 0.2 && d < 0.3333333333333333) {
            return 1.0 - (d - 0.2) * 6.0;
        }
        if (d >= 0.3333333333333333 && d < 0.75) {
            return 0.15;
        }
        if (d >= 0.75 && d < 0.8) {
            return 0.15 + 3.125 * Math.sqrt(d - 0.75);
        }
        if (d >= 0.8) {
            return 0.15 + 3.125 * Math.sqrt(0.050000000000000044) + 6.25 * (d - 0.8) * (d - 0.8);
        }
        return 0.0;
    }
}

