/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.histogram;

import gda.observable.IObserver;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.ui.IActionBars;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.ISidePlotView;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.AreaSelectEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionEvent;
import uk.ac.diamond.scisoft.analysis.rcp.views.HistogramView;

public class HistogramUI
implements IPlotUI {
    private List<IObserver> observers = Collections.synchronizedList(new LinkedList());
    private Action zoomAction;
    private Action activateZoom;
    private Action lockScale;
    private Action autoScale;
    private Action showGraphLines;
    private HistogramView histoView;

    public HistogramUI(HistogramView histogramView, IActionBars iActionBars, DataSetPlotter dataSetPlotter) {
        this.histoView = histogramView;
        this.buildToolActions(iActionBars.getToolBarManager(), dataSetPlotter);
    }

    private void buildToolActions(IToolBarManager iToolBarManager, final DataSetPlotter dataSetPlotter) {
        this.zoomAction = new Action(){

            public void run() {
                dataSetPlotter.undoZoom();
            }
        };
        this.zoomAction.setText("Undo zoom");
        this.zoomAction.setToolTipText("Undo a zoom level");
        this.zoomAction.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/minify.png"));
        this.activateZoom = new Action("", 2){

            public void run() {
                dataSetPlotter.setZoomEnabled(HistogramUI.this.activateZoom.isChecked());
            }
        };
        this.activateZoom.setText("Zoom");
        this.activateZoom.setToolTipText("Zoom mode");
        this.activateZoom.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/magnify.png"));
        this.autoScale = new Action("", 2){

            public void run() {
                if (!HistogramUI.this.lockScale.isChecked()) {
                    HistogramUI.this.histoView.setAutoHistogramScaling(HistogramUI.this.autoScale.isChecked());
                    HistogramUI.this.histoView.createInitialHistogram();
                } else {
                    HistogramUI.this.autoScale.setChecked(false);
                }
            }
        };
        this.autoScale.setText("Autohistogram");
        this.autoScale.setToolTipText("Auto stretch histogram");
        this.autoScale.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/computer_edit.png"));
        this.autoScale.setChecked(true);
        this.lockScale = new Action("", 2){

            public void run() {
                HistogramUI.this.histoView.setHistogramLock(HistogramUI.this.lockScale.isChecked());
                if (HistogramUI.this.lockScale.isChecked()) {
                    HistogramUI.this.histoView.setAutoHistogramScaling(false);
                    HistogramUI.this.autoScale.setChecked(false);
                }
            }
        };
        this.lockScale.setText("Lock histogram");
        this.lockScale.setToolTipText("Lock the histogram region for subsequent images");
        this.lockScale.setChecked(false);
        this.lockScale.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/lock.png"));
        this.showGraphLines = new Action("", 2){

            public void run() {
                HistogramUI.this.histoView.setGraphLines(HistogramUI.this.showGraphLines.isChecked());
            }
        };
        this.showGraphLines.setText("Show channel graphs");
        this.showGraphLines.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/chart_curve.png"));
        this.showGraphLines.setToolTipText("Active/Deactivate channel graphs");
        this.showGraphLines.setChecked(true);
        iToolBarManager.add((IAction)this.activateZoom);
        iToolBarManager.add((IAction)this.zoomAction);
        iToolBarManager.add((IAction)this.autoScale);
        iToolBarManager.add((IAction)this.lockScale);
        iToolBarManager.add((IAction)this.showGraphLines);
    }

    public void addIObserver(IObserver iObserver) {
        this.observers.add(iObserver);
    }

    public void deleteIObserver(IObserver iObserver) {
        this.observers.remove(iObserver);
    }

    public void deleteIObservers() {
        this.observers.clear();
    }

    @Override
    public void plotActionPerformed(PlotActionEvent plotActionEvent) {
    }

    private void notifyObservers(Object object) {
        for (IObserver iObserver : this.observers) {
            iObserver.update((Object)this, object);
        }
    }

    @Override
    public void areaSelected(AreaSelectEvent areaSelectEvent) {
        this.notifyObservers(areaSelectEvent);
    }

    @Override
    public void processPlotUpdate(DataBean dataBean, boolean bl) {
    }

    @Override
    public void disposeOverlays() {
    }

    @Override
    public void deactivate(boolean bl) {
    }

    @Override
    public void processGUIUpdate(GuiBean guiBean) {
    }

    @Override
    public ISidePlotView getSidePlotView() {
        return null;
    }

    @Override
    public void initSidePlotView() {
    }
}

