/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.sessions;

import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.internal.identitymaps.IdentityMapManager;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.IsolatedClientSessionIdentityMapAccessor;
import oracle.toplink.essentials.queryframework.Call;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.threetier.ClientSession;
import oracle.toplink.essentials.threetier.ConnectionPolicy;
import oracle.toplink.essentials.threetier.ServerSession;

public class IsolatedClientSession
extends ClientSession {
    public IsolatedClientSession(ServerSession parent, ConnectionPolicy connectionPolicy) {
        super(parent, connectionPolicy);
    }

    public void initializeIdentityMapAccessor() {
        this.identityMapAccessor = new IsolatedClientSessionIdentityMapAccessor(this, new IdentityMapManager(this));
    }

    protected boolean shouldExecuteLocally(DatabaseQuery query) {
        if (this.isIsolatedQuery(query)) {
            return true;
        }
        return this.isInTransaction();
    }

    protected boolean isIsolatedQuery(DatabaseQuery query) {
        query.checkDescriptor(this);
        return query.isDataModifyQuery() || query.getDescriptor() != null && query.getDescriptor().isIsolated();
    }

    public AbstractSession getParentIdentityMapSession(DatabaseQuery query, boolean canReturnSelf, boolean terminalOnly) {
        if (query != null && this.isIsolatedQuery(query)) {
            return this;
        }
        return this.getParent().getParentIdentityMapSession(query, canReturnSelf, terminalOnly);
    }

    public AbstractSession getExecutionSession(DatabaseQuery query) {
        if (this.shouldExecuteLocally(query)) {
            return this;
        }
        return this.getParent().getExecutionSession(query);
    }

    public Object executeCall(Call call, AbstractRecord translationRow, DatabaseQuery query) throws DatabaseException {
        if (this.isInTransaction()) {
            return super.executeCall(call, translationRow, query);
        }
        return this.getParent().executeCall(call, translationRow, query);
    }
}

