/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.wizards.rename;

import com.python.pydev.refactoring.wizards.rename.AbstractRenameRefactorProcess;
import com.rc.retroweaver.runtime.Autobox;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IProjectModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.editor.codecompletion.revisited.CompletionCache;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.editor.refactoring.PyRefactoringFindDefinition;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.plugin.nature.PythonNature;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRenameWorkspaceRefactorProcess
extends AbstractRenameRefactorProcess {
    public static final boolean DEBUG_FILTERED_MODULES = false;

    protected abstract boolean getRecheckWhereDefinitionWasFound();

    protected abstract List<ASTEntry> findReferencesOnOtherModule(RefactoringStatus var1, String var2, SourceModule var3);

    protected AbstractRenameWorkspaceRefactorProcess() {
    }

    public AbstractRenameWorkspaceRefactorProcess(Definition definition) {
        super(definition);
    }

    protected List<ASTEntry> getOccurrencesInOtherModule(RefactoringStatus status, String initialName, SourceModule module, PythonNature nature) {
        CompletionCache completionCache = new CompletionCache();
        List<ASTEntry> entryOccurrences = this.findReferencesOnOtherModule(status, initialName, module);
        if (this.getRecheckWhereDefinitionWasFound()) {
            for (ASTEntry entry : entryOccurrences) {
                int line = entry.node.beginLine;
                int col = entry.node.beginColumn;
                try {
                    ArrayList definitions = new ArrayList();
                    PyRefactoringFindDefinition.findActualDefinition((RefactoringRequest)this.request, (IModule)module, (String)initialName, definitions, (int)line, (int)col, (IPythonNature)nature, (ICompletionCache)completionCache);
                    for (IDefinition def : definitions) {
                        if (!(def instanceof Definition)) continue;
                        Definition localDefinition = (Definition)def;
                        String foundModName = localDefinition.module.getName();
                        if (foundModName == null || foundModName.equals(this.definition.module.getName())) continue;
                        return new ArrayList<ASTEntry>();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return entryOccurrences;
    }

    @Override
    protected void findReferencesToRenameOnWorkspace(RefactoringRequest request, RefactoringStatus status) {
        request.pushMonitor((IProgressMonitor)new SubProgressMonitor(request.getMonitor(), 50));
        try {
            this.findReferencesToRenameOnLocalScope(request, status);
        }
        finally {
            request.getMonitor().done();
            request.popMonitor();
        }
        boolean onlyInLocalScope = (Boolean)request.getAdditionalInfo("findReferencesOnlyOnLocalScope", (Object)Autobox.valueOf((boolean)false));
        if (!onlyInLocalScope && !status.hasFatalError()) {
            this.doCheckInitialOnWorkspace(status, request);
        }
    }

    protected void doCheckInitialOnWorkspace(RefactoringStatus status, RefactoringRequest request) {
        request.pushMonitor((IProgressMonitor)new SubProgressMonitor(request.getMonitor(), 50));
        try {
            try {
                HashSet<IFile> references = new HashSet<IFile>(this.findFilesWithPossibleReferences(request));
                int total = references.size();
                request.getMonitor().beginTask(new StringBuffer("Possible references to analyze:").append(total).toString(), total);
                request.getMonitor().setTaskName(StringUtils.format((String)"Analyzing: %s files", (Object[])new Object[]{Autobox.valueOf((int)total)}));
                int i = 0;
                for (IFile file : references) {
                    request.communicateWork(StringUtils.format((String)"Analyzing %s (%s of %s)", (Object[])new Object[]{file.getName(), Autobox.valueOf((int)(++i)), Autobox.valueOf((int)total)}));
                    IProject project = file.getProject();
                    PythonNature nature = PythonNature.getPythonNature((IProject)project);
                    if (nature == null || !nature.startRequests()) continue;
                    try {
                        IProjectModulesManager modulesManager = (IProjectModulesManager)nature.getAstManager().getModulesManager();
                        request.checkCancelled();
                        String modName = modulesManager.resolveModuleInDirectManager(file);
                        if (modName == null || request.moduleName.equals(modName)) continue;
                        request.checkCancelled();
                        IModule module = nature.getAstManager().getModule(modName, (IPythonNature)nature, true, false);
                        if (!(module instanceof SourceModule)) continue;
                        request.checkCancelled();
                        List<ASTEntry> entryOccurrences = this.getOccurrencesInOtherModule(status, request.initialName, (SourceModule)module, nature);
                        if (entryOccurrences.size() <= 0) continue;
                        this.addOccurrences(entryOccurrences, file, modName);
                    }
                    finally {
                        nature.endRequests();
                    }
                }
            }
            catch (OperationCanceledException operationCanceledException) {
                request.getMonitor().done();
                request.popMonitor();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            request.getMonitor().done();
            request.popMonitor();
        }
    }
}

