/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.refactorer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import org.eclipse.swt.widgets.Shell;
import org.python.pydev.core.REF;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefactorerFindReferences {
    public static List<IFile> FORCED_RETURN;

    public List<IFile> findPossibleReferences(RefactoringRequest request) {
        if (FORCED_RETURN != null) {
            ArrayList<IFile> ret = new ArrayList<IFile>();
            for (IFile f : FORCED_RETURN) {
                String object = (String)REF.invoke((Object)f, (String)"getFileContents", (Object[])new Object[0]);
                if (object.indexOf(request.initialName) == -1) continue;
                ret.add(f);
            }
            return ret;
        }
        ArrayList<IFile> l = new ArrayList<IFile>();
        try {
            Object[] elements;
            TextSearchQueryProvider searchQueryProvider = TextSearchQueryProvider.getPreferred();
            ArrayList<IProject> resourcesToSearch = new ArrayList<IProject>();
            IProject project = request.nature.getProject();
            if (project == null) {
                return l;
            }
            resourcesToSearch.addAll(Arrays.asList(project.getReferencingProjects()));
            resourcesToSearch.addAll(Arrays.asList(project.getReferencedProjects()));
            resourcesToSearch.add(project);
            PyTextSearchInput textSearchInput = new PyTextSearchInput(request.initialName, true, false, FileTextSearchScope.newSearchScope((IResource[])((IResource[])resourcesToSearch.toArray(new IProject[0])), (String[])FileTypesPreferencesPage.getWildcardValidSourceFiles(), (boolean)true));
            ISearchQuery query = searchQueryProvider.createQuery((TextSearchQueryProvider.TextSearchInput)textSearchInput);
            IStatus status = query.run(request.getMonitor());
            if (status.matches(8)) {
                return l;
            }
            if (!status.isOK()) {
                PydevPlugin.log((IStatus)status);
                if (status.getSeverity() == 4) {
                    ErrorDialog.openError((Shell)PyAction.getShell(), (String)"Error when searching for references", (String)"Error when searching for references", (IStatus)status);
                }
                return l;
            }
            AbstractTextSearchResult searchResult = (AbstractTextSearchResult)query.getSearchResult();
            Object[] objectArray = elements = searchResult.getElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof IFile) {
                    l.add((IFile)object);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        return l;
    }

    public static class PyTextSearchInput
    extends TextSearchQueryProvider.TextSearchInput {
        private final String fSearchText;
        private final boolean fIsCaseSensitive;
        private final boolean fIsRegEx;
        private final FileTextSearchScope fScope;

        public PyTextSearchInput(String searchText, boolean isCaseSensitive, boolean isRegEx, FileTextSearchScope scope) {
            this.fSearchText = searchText;
            this.fIsCaseSensitive = isCaseSensitive;
            this.fIsRegEx = isRegEx;
            this.fScope = scope;
        }

        public String getSearchText() {
            return this.fSearchText;
        }

        public boolean isCaseSensitiveSearch() {
            return this.fIsCaseSensitive;
        }

        public boolean isRegExSearch() {
            return this.fIsRegEx;
        }

        public FileTextSearchScope getScope() {
            return this.fScope;
        }
    }
}

