/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.ui.launch;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaunchShortcut
implements ILaunchShortcut {
    public static final String CONFIG_ATTRIBUTE_MODEL_FILENAME = "modelfilename";
    public static final String CONFIG_ATTRIBUTE_ABSOLUTE_MODEL_FILENAME = "absolute_modelfilename";
    private static final Logger logger = LoggerFactory.getLogger(LaunchShortcut.class);

    public Logger getLogger() {
        return logger;
    }

    public void launch(IEditorPart iEditorPart, String string) {
        IFile iFile = null;
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        iFile = (IFile)iEditorInput.getAdapter(IFile.class);
        if (iFile != null) {
            this.searchAndLaunch(iFile, string);
        }
    }

    public void launch(ISelection iSelection, String string) {
        if (iSelection instanceof IStructuredSelection) {
            this.searchAndLaunch(((IStructuredSelection)iSelection).getFirstElement(), string);
        }
    }

    protected void searchAndLaunch(Object object, String string) {
        if (object instanceof IFile) {
            IFile iFile = (IFile)object;
            IPath iPath = iFile.getFullPath();
            String string2 = iPath.lastSegment();
            this.getLogger().debug("Launching : " + string2);
            ILaunchConfiguration iLaunchConfiguration = this.createConfiguration(string2, iFile.getLocation().toPortableString());
            DebugUITools.launch((ILaunchConfiguration)iLaunchConfiguration, (String)string);
        }
    }

    protected ILaunchConfiguration createConfiguration(String string, String string2) {
        ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = null;
        ILaunchConfiguration iLaunchConfiguration = null;
        ILaunchConfiguration iLaunchConfiguration2 = null;
        try {
            ILaunchConfigurationType iLaunchConfigurationType = this.getPasserelleLaunchConfigType();
            ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(iLaunchConfigurationType);
            int n = 0;
            while (n < iLaunchConfigurationArray.length) {
                ILaunchConfiguration iLaunchConfiguration3 = iLaunchConfigurationArray[n];
                if (iLaunchConfiguration3.getName().equals(string)) {
                    iLaunchConfiguration = iLaunchConfiguration3;
                    break;
                }
                ++n;
            }
            iLaunchConfigurationWorkingCopy = iLaunchConfiguration != null ? iLaunchConfigurationType.newInstance(null, string) : iLaunchConfigurationType.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(string));
            iLaunchConfigurationWorkingCopy.setAttribute(CONFIG_ATTRIBUTE_MODEL_FILENAME, string);
            iLaunchConfigurationWorkingCopy.setAttribute(CONFIG_ATTRIBUTE_ABSOLUTE_MODEL_FILENAME, string2);
            this.initializeJavaProject(null, iLaunchConfigurationWorkingCopy);
            iLaunchConfiguration2 = iLaunchConfigurationWorkingCopy.doSave();
        }
        catch (CoreException coreException) {
            this.getLogger().error("Error creating passerelle launchconfig", (Throwable)coreException);
        }
        return iLaunchConfiguration2;
    }

    protected ILaunchConfigurationType getPasserelleLaunchConfigType() {
        ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        return iLaunchManager.getLaunchConfigurationType("com.isencia.passerelle.workbench.model.ui.launch.launchConfigurationType");
    }

    protected void initializeJavaProject(IJavaElement iJavaElement, ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        if (iJavaElement == null) {
            return;
        }
        IJavaProject iJavaProject = iJavaElement.getJavaProject();
        String string = null;
        if (iJavaProject != null && iJavaProject.exists()) {
            string = iJavaProject.getElementName();
        }
        iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, string);
    }
}

