/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.server;

import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.services.server.AbstractSkeleton;
import com.caucho.services.server.ServiceContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HessianSkeleton
extends AbstractSkeleton {
    private static final Logger log = Logger.getLogger(HessianSkeleton.class.getName());
    private Object _service;

    public HessianSkeleton(Object service, Class apiClass) {
        super(apiClass);
        if (service == null) {
            service = this;
        }
        this._service = service;
        if (!apiClass.isAssignableFrom(service.getClass())) {
            throw new IllegalArgumentException("Service " + service + " must be an instance of " + apiClass.getName());
        }
    }

    public HessianSkeleton(Class apiClass) {
        super(apiClass);
    }

    public void invoke(AbstractHessianInput in, AbstractHessianOutput out) throws Exception {
        this.invoke(this._service, in, out);
    }

    public void invoke(Object service, AbstractHessianInput in, AbstractHessianOutput out) throws Exception {
        String header;
        ServiceContext context = ServiceContext.getContext();
        in.skipOptionalCall();
        while ((header = in.readHeader()) != null) {
            Object value = in.readObject();
            context.addHeader(header, value);
        }
        String methodName = in.readMethod();
        int argLength = in.readMethodArgLength();
        Method method = this.getMethod(methodName + "__" + argLength);
        if (method == null) {
            method = this.getMethod(methodName);
        }
        if (method == null) {
            out.writeFault("NoSuchMethodException", "The service has no method named: " + in.getMethod(), null);
            out.close();
            return;
        }
        if ("_hessian_getAttribute".equals(methodName)) {
            String attrName = in.readString();
            in.completeCall();
            String value = null;
            if ("java.api.class".equals(attrName)) {
                value = this.getAPIClassName();
            } else if ("java.home.class".equals(attrName)) {
                value = this.getHomeClassName();
            } else if ("java.object.class".equals(attrName)) {
                value = this.getObjectClassName();
            }
            out.writeReply(value);
            out.close();
            return;
        }
        Class<?>[] args = method.getParameterTypes();
        if (argLength != args.length && argLength >= 0) {
            out.writeFault("NoSuchMethod", "method " + method + " argument length mismatch, received length=" + argLength, null);
            out.close();
            return;
        }
        Object[] values = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            values[i] = in.readObject(args[i]);
        }
        Object result = null;
        try {
            result = method.invoke(service, values);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            log.log(Level.FINE, this + " " + e.toString(), e);
            out.writeFault("ServiceException", e.getMessage(), e);
            out.close();
            return;
        }
        in.completeCall();
        out.writeReply(result);
        out.close();
    }
}

