/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.moml;

import java.net.URL;
import java.util.List;
import ptolemy.kernel.InstantiableNamedObj;
import ptolemy.kernel.undo.UndoStackAttribute;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.ErrorHandler;
import ptolemy.moml.MoMLParser;
import ptolemy.moml.ParserAttribute;

public class MoMLChangeRequest
extends ChangeRequest {
    private URL _base;
    private NamedObj _context;
    private static boolean _DEBUG = false;
    private boolean _mergeWithPreviousUndo = false;
    private MoMLParser _parser;
    private boolean _reportToHandler = false;
    private boolean _undoable = false;

    public MoMLChangeRequest(Object originator, String request) {
        this(originator, null, request, null);
    }

    public MoMLChangeRequest(Object originator, NamedObj context, String request) {
        this(originator, context, request, null);
    }

    public MoMLChangeRequest(Object originator, NamedObj context, String request, URL base) {
        super(originator, request);
        this._context = context;
        this._base = base;
    }

    public NamedObj getContext() {
        return this._context;
    }

    public static NamedObj getDeferredToParent(NamedObj object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof InstantiableNamedObj)) {
            return MoMLChangeRequest.getDeferredToParent(object.getContainer());
        }
        List deferList = ((InstantiableNamedObj)object).getChildren();
        if (deferList != null && deferList.size() > 0) {
            return object;
        }
        return MoMLChangeRequest.getDeferredToParent(object.getContainer());
    }

    public void setUndoable(boolean undoable) {
        this._undoable = undoable;
    }

    public void setMergeWithPreviousUndo(boolean mergeWithPrevious) {
        this._mergeWithPreviousUndo = mergeWithPrevious;
    }

    public void setReportErrorsToHandler(boolean report) {
        this._reportToHandler = report;
    }

    protected void _execute() throws Exception {
        if (_DEBUG) {
            System.out.println("****** Executing MoML change:");
            System.out.println(this.getDescription());
            if (this._context != null) {
                System.out.println("------ in context " + this._context.getFullName());
            }
        }
        if (this._context != null) {
            this._parser = ParserAttribute.getParser(this._context);
            this._parser.reset();
        }
        if (this._parser == null) {
            this._parser = new MoMLParser();
        }
        if (this._context != null) {
            this._parser.setContext(this._context);
        }
        if (this._undoable) {
            this._parser.setUndoable(true);
        }
        ErrorHandler handler = MoMLParser.getErrorHandler();
        if (!this._reportToHandler) {
            MoMLParser.setErrorHandler(null);
        }
        this._preParse(this._parser);
        try {
            this._parser.parse(this._base, this.getDescription());
        }
        finally {
            if (!this._reportToHandler) {
                MoMLParser.setErrorHandler(handler);
            }
        }
        if (this._undoable && this._mergeWithPreviousUndo) {
            UndoStackAttribute undoInfo = UndoStackAttribute.getUndoInfo(this._context);
            undoInfo.mergeTopTwo();
        }
        this._postParse(this._parser);
    }

    protected void _postParse(MoMLParser parser) {
    }

    protected void _preParse(MoMLParser parser) {
    }
}

