/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.math;

import ptolemy.math.Complex;
import ptolemy.math.DoubleArrayMath;
import ptolemy.math.DoubleBinaryOperation;
import ptolemy.math.DoubleUnaryOperation;

public class DoubleMatrixMath {
    private DoubleMatrixMath() {
    }

    public static final double[][] add(double[][] matrix, double z) {
        double[][] returnValue = new double[DoubleMatrixMath._rows(matrix)][DoubleMatrixMath._columns(matrix)];
        int i = 0;
        while (i < DoubleMatrixMath._rows(matrix)) {
            int j = 0;
            while (j < DoubleMatrixMath._columns(matrix)) {
                returnValue[i][j] = matrix[i][j] + z;
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final double[][] add(double[][] matrix1, double[][] matrix2) {
        DoubleMatrixMath._checkSameDimension("add", matrix1, matrix2);
        double[][] returnValue = new double[DoubleMatrixMath._rows(matrix1)][DoubleMatrixMath._columns(matrix1)];
        int i = 0;
        while (i < DoubleMatrixMath._rows(matrix1)) {
            int j = 0;
            while (j < DoubleMatrixMath._columns(matrix1)) {
                returnValue[i][j] = matrix1[i][j] + matrix2[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final double[][] allocCopy(double[][] matrix) {
        return DoubleMatrixMath.crop(matrix, 0, 0, DoubleMatrixMath._rows(matrix), DoubleMatrixMath._columns(matrix));
    }

    public static final double[][] applyBinaryOperation(DoubleBinaryOperation op, double z, double[][] matrix) {
        int rows = DoubleMatrixMath._rows(matrix);
        int columns = DoubleMatrixMath._columns(matrix);
        double[][] returnValue = new double[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = op.operate(z, matrix[i][j]);
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final double[][] applyBinaryOperation(DoubleBinaryOperation op, double[][] matrix, double z) {
        int rows = DoubleMatrixMath._rows(matrix);
        int columns = DoubleMatrixMath._columns(matrix);
        double[][] returnValue = new double[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = op.operate(matrix[i][j], z);
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final double[][] applyBinaryOperation(DoubleBinaryOperation op, double[][] matrix1, double[][] matrix2) {
        int rows = DoubleMatrixMath._rows(matrix1);
        int columns = DoubleMatrixMath._columns(matrix1);
        DoubleMatrixMath._checkSameDimension("applyBinaryOperation", matrix1, matrix2);
        double[][] returnValue = new double[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = op.operate(matrix1[i][j], matrix2[i][j]);
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final double[][] applyUnaryOperation(DoubleUnaryOperation op, double[][] matrix) {
        int rows = DoubleMatrixMath._rows(matrix);
        int columns = DoubleMatrixMath._columns(matrix);
        double[][] returnValue = new double[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = op.operate(matrix[i][j]);
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final double[][] crop(double[][] matrix, int rowStart, int colStart, int rowSpan, int colSpan) {
        double[][] returnValue = new double[rowSpan][colSpan];
        int i = 0;
        while (i < rowSpan) {
            System.arraycopy(matrix[rowStart + i], colStart, returnValue[i], 0, colSpan);
            ++i;
        }
        return returnValue;
    }

    public static final double determinant(double[][] matrix) {
        DoubleMatrixMath._checkSquare("determinant", matrix);
        double det = 1.0;
        int n = DoubleMatrixMath._rows(matrix);
        double[][] a = DoubleMatrixMath.allocCopy(matrix);
        int pivot = 0;
        while (pivot < n - 1) {
            double big = Math.abs(a[pivot][pivot]);
            int swapRow = 0;
            int row = pivot + 1;
            while (row < n) {
                double absElement = Math.abs(a[row][pivot]);
                if (absElement > big) {
                    swapRow = row;
                    big = absElement;
                }
                ++row;
            }
            if (swapRow != 0) {
                double[] aPtr = a[pivot];
                a[pivot] = a[swapRow];
                a[swapRow] = aPtr;
                det *= -a[pivot][pivot];
            } else {
                det *= a[pivot][pivot];
            }
            if (Math.abs(det) <= Complex.EPSILON) {
                return det;
            }
            double pivotInverse = 1.0 / a[pivot][pivot];
            int col = pivot + 1;
            while (col < n) {
                double[] dArray = a[pivot];
                int n2 = col++;
                dArray[n2] = dArray[n2] * pivotInverse;
            }
            int row2 = pivot + 1;
            while (row2 < n) {
                double temp = a[row2][pivot];
                int col2 = pivot + 1;
                while (col2 < n) {
                    double[] dArray = a[row2];
                    int n3 = col2;
                    dArray[n3] = dArray[n3] - a[pivot][col2] * temp;
                    ++col2;
                }
                ++row2;
            }
            ++pivot;
        }
        return det *= a[n - 1][n - 1];
    }

    public static final double[][] diag(double[] array) {
        int n = array.length;
        double[][] returnValue = new double[n][n];
        int i = 0;
        while (i < n) {
            returnValue[i][i] = array[i];
            ++i;
        }
        return returnValue;
    }

    public static final double[][] divide(double[][] matrix, double z) {
        double[][] returnValue = new double[DoubleMatrixMath._rows(matrix)][DoubleMatrixMath._columns(matrix)];
        int i = 0;
        while (i < DoubleMatrixMath._rows(matrix)) {
            int j = 0;
            while (j < DoubleMatrixMath._columns(matrix)) {
                returnValue[i][j] = matrix[i][j] / z;
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final double[][] divideElements(double[][] matrix1, double[][] matrix2) {
        int rows = DoubleMatrixMath._rows(matrix1);
        int columns = DoubleMatrixMath._columns(matrix1);
        DoubleMatrixMath._checkSameDimension("divideElements", matrix1, matrix2);
        double[][] returnValue = new double[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = matrix1[i][j] / matrix2[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final double[] fromMatrixToArray(double[][] matrix) {
        return DoubleMatrixMath.fromMatrixToArray(matrix, DoubleMatrixMath._rows(matrix), DoubleMatrixMath._columns(matrix));
    }

    public static final double[] fromMatrixToArray(double[][] matrix, int maxRow, int maxCol) {
        double[] returnValue = new double[maxRow * maxCol];
        int i = 0;
        while (i < maxRow) {
            System.arraycopy(matrix[i], 0, returnValue, i * maxCol, maxCol);
            ++i;
        }
        return returnValue;
    }

    public static final double[][] hilbert(int dim) {
        double[][] returnValue = new double[dim][dim];
        int i = 0;
        while (i < dim) {
            int j = 0;
            while (j < dim) {
                returnValue[i][j] = 1.0 / (double)(i + j + 1);
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final double[][] identity(int dim) {
        double[][] returnValue = new double[dim][dim];
        int i = 0;
        while (i < dim) {
            returnValue[i][i] = 1.0;
            ++i;
        }
        return returnValue;
    }

    public static final double[][] identityMatrixDouble(int dim) {
        return DoubleMatrixMath.identity(dim);
    }

    public static final double[][] inverse(double[][] A) {
        DoubleMatrixMath._checkSquare("inverse", A);
        int n = DoubleMatrixMath._rows(A);
        double[][] Ai = DoubleMatrixMath.allocCopy(A);
        int[] pivotFlag = new int[n];
        int[] swapCol = new int[n];
        int[] swapRow = new int[n];
        int irow = 0;
        int icol = 0;
        int i = 0;
        while (i < n) {
            double big = 0.0;
            int row = 0;
            while (row < n) {
                if (pivotFlag[row] == 0) {
                    int col = 0;
                    while (col < n) {
                        double absElement;
                        if (pivotFlag[col] == 0 && (absElement = Math.abs(Ai[row][col])) >= big) {
                            big = absElement;
                            irow = row;
                            icol = col;
                        }
                        ++col;
                    }
                }
                ++row;
            }
            int n2 = icol;
            pivotFlag[n2] = pivotFlag[n2] + 1;
            if (irow != icol) {
                int col = 0;
                while (col < n) {
                    double temp = Ai[irow][col];
                    Ai[irow][col] = Ai[icol][col];
                    Ai[icol][col] = temp;
                    ++col;
                }
            }
            swapRow[i] = irow;
            swapCol[i] = icol;
            if (Ai[icol][icol] == 0.0) {
                throw new IllegalArgumentException("Attempt to invert a singular matrix.");
            }
            double pivotInverse = 1.0 / Ai[icol][icol];
            Ai[icol][icol] = 1.0;
            int col = 0;
            while (col < n) {
                double[] dArray = Ai[icol];
                int n3 = col++;
                dArray[n3] = dArray[n3] * pivotInverse;
            }
            int row2 = 0;
            while (row2 < n) {
                if (row2 != icol) {
                    double temp = Ai[row2][icol];
                    Ai[row2][icol] = 0.0;
                    int col2 = 0;
                    while (col2 < n) {
                        double[] dArray = Ai[row2];
                        int n4 = col2;
                        dArray[n4] = dArray[n4] - Ai[icol][col2] * temp;
                        ++col2;
                    }
                }
                ++row2;
            }
            ++i;
        }
        int swap = n - 1;
        while (swap >= 0) {
            if (swapRow[swap] != swapCol[swap]) {
                int row = 0;
                while (row < n) {
                    double temp = Ai[row][swapRow[swap]];
                    Ai[row][swapRow[swap]] = Ai[row][swapCol[swap]];
                    Ai[row][swapCol[swap]] = temp;
                    ++row;
                }
            }
            --swap;
        }
        return Ai;
    }

    public static final void matrixCopy(double[][] sourceMatrix, double[][] destinationMatrix) {
        DoubleMatrixMath.matrixCopy(sourceMatrix, 0, 0, destinationMatrix, 0, 0, DoubleMatrixMath._rows(sourceMatrix), DoubleMatrixMath._columns(sourceMatrix));
    }

    public static final void matrixCopy(double[][] sourceMatrix, int sourceRowStart, int sourceColStart, double[][] destinationMatrix, int destinationRowStart, int destinationColumnStart, int rowSpan, int columnSpan) {
        int i = 0;
        while (i < rowSpan) {
            System.arraycopy(sourceMatrix[sourceRowStart + i], sourceColStart, destinationMatrix[destinationRowStart + i], destinationColumnStart, columnSpan);
            ++i;
        }
    }

    public static final double[][] modulo(double[][] matrix, double z) {
        double[][] returnValue = new double[DoubleMatrixMath._rows(matrix)][DoubleMatrixMath._columns(matrix)];
        int i = 0;
        while (i < DoubleMatrixMath._rows(matrix)) {
            int j = 0;
            while (j < DoubleMatrixMath._columns(matrix)) {
                returnValue[i][j] = matrix[i][j] % z;
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final double[][] multiply(double[][] matrix, double scaleFactor) {
        int rows = DoubleMatrixMath._rows(matrix);
        int columns = DoubleMatrixMath._columns(matrix);
        double[][] returnValue = new double[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = matrix[i][j] * scaleFactor;
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final double[] multiply(double[][] matrix, double[] array) {
        int rows = DoubleMatrixMath._rows(matrix);
        int columns = DoubleMatrixMath._columns(matrix);
        if (rows != array.length) {
            throw new IllegalArgumentException("preMultiply : array does not have the same number of elements (" + array.length + ") as the number of rows " + "of the matrix (" + rows + ")");
        }
        double[] returnValue = new double[columns];
        int i = 0;
        while (i < columns) {
            double sum = 0.0;
            int j = 0;
            while (j < rows) {
                sum += matrix[j][i] * array[j];
                ++j;
            }
            returnValue[i] = sum;
            ++i;
        }
        return returnValue;
    }

    public static final double[] multiply(double[] array, double[][] matrix) {
        int rows = DoubleMatrixMath._rows(matrix);
        int columns = DoubleMatrixMath._columns(matrix);
        if (columns != array.length) {
            throw new IllegalArgumentException("postMultiply() : array does not have the same number of elements (" + array.length + ") as the number of " + "columns of the matrix (" + columns + ")");
        }
        double[] returnValue = new double[rows];
        int i = 0;
        while (i < rows) {
            double sum = 0.0;
            int j = 0;
            while (j < columns) {
                sum += matrix[i][j] * array[j];
                ++j;
            }
            returnValue[i] = sum;
            ++i;
        }
        return returnValue;
    }

    public static final double[][] multiply(double[][] matrix1, double[][] matrix2) {
        double[][] returnValue = new double[DoubleMatrixMath._rows(matrix1)][matrix2[0].length];
        int i = 0;
        while (i < DoubleMatrixMath._rows(matrix1)) {
            int j = 0;
            while (j < matrix2[0].length) {
                double sum = 0.0;
                int k = 0;
                while (k < matrix2.length) {
                    sum += matrix1[i][k] * matrix2[k][j];
                    ++k;
                }
                returnValue[i][j] = sum;
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final double[][] multiplyElements(double[][] matrix1, double[][] matrix2) {
        int rows = DoubleMatrixMath._rows(matrix1);
        int columns = DoubleMatrixMath._columns(matrix1);
        DoubleMatrixMath._checkSameDimension("multiplyElements", matrix1, matrix2);
        double[][] returnValue = new double[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = matrix1[i][j] * matrix2[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final double[][] negative(double[][] matrix) {
        int rows = DoubleMatrixMath._rows(matrix);
        int columns = DoubleMatrixMath._columns(matrix);
        double[][] returnValue = new double[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = -matrix[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final double[][] orthogonalizeColumns(double[][] matrix) {
        Object[] orthoInfo = DoubleMatrixMath._orthogonalizeRows(DoubleMatrixMath.transpose(matrix));
        return DoubleMatrixMath.transpose((double[][])orthoInfo[0]);
    }

    public static final double[][] orthogonalizeRows(double[][] matrix) {
        Object[] orthoInfo = DoubleMatrixMath._orthogonalizeRows(matrix);
        return (double[][])orthoInfo[0];
    }

    public static final double[][] orthonormalizeColumns(double[][] matrix) {
        return DoubleMatrixMath.transpose(DoubleMatrixMath.orthogonalizeRows(DoubleMatrixMath.transpose(matrix)));
    }

    public static final double[][] orthonormalizeRows(double[][] matrix) {
        int rows = DoubleMatrixMath._rows(matrix);
        Object[] orthoInfo = DoubleMatrixMath._orthogonalizeRows(matrix);
        double[][] orthogonalMatrix = (double[][])orthoInfo[0];
        double[] oneOverNormSquaredArray = (double[])orthoInfo[2];
        int i = 0;
        while (i < rows) {
            orthogonalMatrix[i] = DoubleArrayMath.scale(orthogonalMatrix[i], Math.sqrt(oneOverNormSquaredArray[i]));
            ++i;
        }
        return orthogonalMatrix;
    }

    public static final double[][][] qr(double[][] matrix) {
        int columns = DoubleMatrixMath._columns(matrix);
        Object[] orthoRowInfo = DoubleMatrixMath._orthogonalizeRows(DoubleMatrixMath.transpose(matrix));
        double[][] qT = (double[][])orthoRowInfo[0];
        double[][] dotProducts = (double[][])orthoRowInfo[1];
        double[] oneOverNormSquaredArray = (double[])orthoRowInfo[2];
        Integer nullity = (Integer)orthoRowInfo[3];
        if (nullity > 0) {
            throw new IllegalArgumentException("qr() : not all column vectors are linearly independent.");
        }
        int i = 0;
        while (i < columns) {
            double oneOverNorm = Math.sqrt(oneOverNormSquaredArray[i]);
            qT[i] = DoubleArrayMath.scale(qT[i], oneOverNorm);
            int j = i;
            while (j < columns) {
                double[] dArray = dotProducts[i];
                int n = j++;
                dArray[n] = dArray[n] * oneOverNorm;
            }
            ++i;
        }
        return new double[][][]{DoubleMatrixMath.transpose(qT), dotProducts};
    }

    public static final double[][] subtract(double[][] matrix1, double[][] matrix2) {
        DoubleMatrixMath._checkSameDimension("subtract", matrix1, matrix2);
        int rows = DoubleMatrixMath._rows(matrix1);
        int columns = DoubleMatrixMath._columns(matrix1);
        double[][] returnValue = new double[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = matrix1[i][j] - matrix2[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final double sum(double[][] matrix) {
        double sum = 0.0;
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[i].length) {
                sum += matrix[i][j];
                ++j;
            }
            ++i;
        }
        return sum;
    }

    public static final Complex[][] toComplexMatrix(double[][] matrix) {
        int rows = DoubleMatrixMath._rows(matrix);
        int columns = DoubleMatrixMath._columns(matrix);
        Complex[][] returnValue = new Complex[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = new Complex(matrix[i][j], 0.0);
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final float[][] toFloatMatrix(double[][] matrix) {
        int rows = DoubleMatrixMath._rows(matrix);
        int columns = DoubleMatrixMath._columns(matrix);
        float[][] returnValue = new float[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = (float)matrix[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final int[][] toIntegerMatrix(double[][] matrix) {
        int rows = DoubleMatrixMath._rows(matrix);
        int columns = DoubleMatrixMath._columns(matrix);
        int[][] returnValue = new int[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = (int)matrix[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final long[][] toLongMatrix(double[][] matrix) {
        int rows = DoubleMatrixMath._rows(matrix);
        int columns = DoubleMatrixMath._columns(matrix);
        long[][] returnValue = new long[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = (long)matrix[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final double[][] toMatrixFromArray(double[] array, int rows, int cols) {
        double[][] returnValue = new double[rows][cols];
        int i = 0;
        while (i < rows) {
            System.arraycopy(array, i * cols, returnValue[i], 0, cols);
            ++i;
        }
        return returnValue;
    }

    public static final String toString(double[][] matrix) {
        return DoubleMatrixMath.toString(matrix, ", ", "{", "}", "{", ", ", "}");
    }

    public static final String toString(double[][] matrix, String elementDelimiter, String matrixBegin, String matrixEnd, String vectorBegin, String vectorDelimiter, String vectorEnd) {
        StringBuffer sb = new StringBuffer();
        sb.append(matrixBegin);
        int i = 0;
        while (i < DoubleMatrixMath._rows(matrix)) {
            sb.append(vectorBegin);
            int j = 0;
            while (j < DoubleMatrixMath._columns(matrix)) {
                sb.append(Double.toString(matrix[i][j]));
                if (j < DoubleMatrixMath._columns(matrix) - 1) {
                    sb.append(elementDelimiter);
                }
                ++j;
            }
            sb.append(vectorEnd);
            if (i < DoubleMatrixMath._rows(matrix) - 1) {
                sb.append(vectorDelimiter);
            }
            ++i;
        }
        sb.append(matrixEnd);
        return new String(sb);
    }

    public static final double trace(double[][] matrix) {
        int dim = DoubleMatrixMath._checkSquare("trace", matrix);
        double sum = 0.0;
        int i = 0;
        while (i < dim) {
            sum += matrix[i][i];
            ++i;
        }
        return sum;
    }

    public static final double[][] transpose(double[][] matrix) {
        int rows = DoubleMatrixMath._rows(matrix);
        int columns = DoubleMatrixMath._columns(matrix);
        double[][] returnValue = new double[columns][rows];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[j][i] = matrix[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final boolean within(double[][] matrix1, double[][] matrix2, double distance) {
        int rows = DoubleMatrixMath._rows(matrix1);
        int columns = DoubleMatrixMath._columns(matrix1);
        DoubleMatrixMath._checkSameDimension("within", matrix1, matrix2);
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                if (matrix1[i][j] > matrix2[i][j] + distance || matrix1[i][j] < matrix2[i][j] - distance) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static final boolean within(double[][] matrix1, double[][] matrix2, double[][] errorMatrix) {
        int rows = DoubleMatrixMath._rows(matrix1);
        int columns = DoubleMatrixMath._columns(matrix1);
        DoubleMatrixMath._checkSameDimension("within", matrix1, matrix2);
        DoubleMatrixMath._checkSameDimension("within", matrix1, errorMatrix);
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                if (matrix1[i][j] > matrix2[i][j] + errorMatrix[i][j] || matrix1[i][j] < matrix2[i][j] - errorMatrix[i][j]) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    protected static final void _checkSameDimension(String caller, double[][] matrix1, double[][] matrix2) throws IllegalArgumentException {
        int rows = DoubleMatrixMath._rows(matrix1);
        int columns = DoubleMatrixMath._columns(matrix1);
        if (rows != DoubleMatrixMath._rows(matrix2) || columns != DoubleMatrixMath._columns(matrix2)) {
            throw new IllegalArgumentException("ptolemy.math.DoubleMatrixMath." + caller + "() : one matrix " + DoubleMatrixMath._dimensionString(matrix1) + " is not the same size as another matrix " + DoubleMatrixMath._dimensionString(matrix2) + ".");
        }
    }

    protected static final int _checkSquare(String caller, double[][] matrix) throws IllegalArgumentException {
        if (DoubleMatrixMath._rows(matrix) != DoubleMatrixMath._columns(matrix)) {
            throw new IllegalArgumentException("ptolemy.math.DoubleMatrixMath." + caller + "() : matrix argument " + DoubleMatrixMath._dimensionString(matrix) + " is not a square matrix.");
        }
        return DoubleMatrixMath._rows(matrix);
    }

    protected static final int _columns(double[][] matrix) {
        return matrix[0].length;
    }

    protected static final String _dimensionString(double[][] matrix) {
        return "[" + DoubleMatrixMath._rows(matrix) + " x " + DoubleMatrixMath._columns(matrix) + "]";
    }

    protected static final Object[] _orthogonalizeRows(double[][] rowArrays) {
        int rows = rowArrays.length;
        int columns = rowArrays[0].length;
        int nullity = 0;
        double[][] orthogonalMatrix = new double[rows][];
        double[] oneOverNormSquaredArray = new double[rows];
        double[][] dotProductMatrix = new double[rows][rows];
        int i = 0;
        while (i < rows) {
            double[] refArray;
            double[] rowArray = refArray = rowArrays[i];
            int j = 0;
            while (j < i) {
                double dotProduct;
                dotProductMatrix[j][i] = dotProduct = DoubleArrayMath.dotProduct(refArray, orthogonalMatrix[j]);
                rowArray = DoubleArrayMath.subtract(rowArray, DoubleArrayMath.scale(orthogonalMatrix[j], dotProduct * oneOverNormSquaredArray[j]));
                ++j;
            }
            dotProductMatrix[i][i] = DoubleArrayMath.dotProduct(refArray, rowArray);
            double normSquared = DoubleArrayMath.sumOfSquares(rowArray);
            if (normSquared == 0.0) {
                orthogonalMatrix[i] = i == 0 ? new double[columns] : rowArray;
                oneOverNormSquaredArray[i] = 0.0;
                ++nullity;
            } else {
                orthogonalMatrix[i] = rowArray;
                oneOverNormSquaredArray[i] = 1.0 / normSquared;
            }
            ++i;
        }
        return new Object[]{orthogonalMatrix, dotProductMatrix, oneOverNormSquaredArray, nullity};
    }

    protected static final int _rows(double[][] matrix) {
        return matrix.length;
    }
}

