/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.kernel.util;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import ptolemy.kernel.util.AbstractSettableAttribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.ValueListener;
import ptolemy.kernel.util.Workspace;
import ptolemy.util.StringUtilities;

public class StringAttribute
extends AbstractSettableAttribute {
    private String _value = "";
    private List _valueListeners;
    private Settable.Visibility _visibility = Settable.FULL;

    public StringAttribute() {
    }

    public StringAttribute(Workspace workspace) {
        super(workspace);
    }

    public StringAttribute(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public void addValueListener(ValueListener listener) {
        if (this._valueListeners == null) {
            this._valueListeners = new LinkedList();
        }
        if (!this._valueListeners.contains(listener)) {
            this._valueListeners.add(listener);
        }
    }

    public void exportMoML(Writer output, int depth, String name) throws IOException {
        if (this._isMoMLSuppressed(depth)) {
            return;
        }
        String value = this.getExpression();
        String valueTerm = "";
        if (value != null && !value.equals("")) {
            valueTerm = " value=\"" + StringUtilities.escapeForXML(value) + "\"";
        }
        output.write(String.valueOf(StringAttribute._getIndentPrefix(depth)) + "<" + this._elementName + " name=\"" + name + "\" class=\"" + this.getClassName() + "\"" + valueTerm + ">\n");
        this._exportMoMLContents(output, depth + 1);
        output.write(String.valueOf(StringAttribute._getIndentPrefix(depth)) + "</" + this._elementName + ">\n");
    }

    public String getExpression() {
        return this._value;
    }

    public Settable.Visibility getVisibility() {
        return this._visibility;
    }

    public void removeValueListener(ValueListener listener) {
        if (this._valueListeners != null) {
            this._valueListeners.remove(listener);
        }
    }

    public void setExpression(String expression) throws IllegalActionException {
        super.setExpression(expression);
        this._value = expression;
        NamedObj container = this.getContainer();
        if (container != null) {
            container.attributeChanged(this);
        }
        if (this._valueListeners != null) {
            for (ValueListener listener : this._valueListeners) {
                listener.valueChanged(this);
            }
        }
    }

    public void setVisibility(Settable.Visibility visibility) {
        this._visibility = visibility;
    }

    public Collection validate() throws IllegalActionException {
        return null;
    }

    protected void _propagateValue(NamedObj destination) throws IllegalActionException {
        ((Settable)((Object)destination)).setExpression(this.getExpression());
    }
}

