/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.kernel.util;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.Locatable;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.SingletonAttribute;
import ptolemy.kernel.util.ValueListener;
import ptolemy.kernel.util.Workspace;
import ptolemy.util.StringUtilities;

public class Location
extends SingletonAttribute
implements Locatable {
    private String _default = null;
    private String _expression;
    private boolean _expressionSet = false;
    private double[] _location = new double[]{0.0, 0.0};
    private List _valueListeners;
    private Settable.Visibility _visibility = Settable.NONE;

    public Location(Workspace workspace) {
        super(workspace);
    }

    public Location(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public void addValueListener(ValueListener listener) {
        if (this._valueListeners == null) {
            this._valueListeners = new LinkedList();
        }
        if (!this._valueListeners.contains(listener)) {
            this._valueListeners.add(listener);
        }
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        Location newObject = (Location)super.clone(workspace);
        int length = this._location.length;
        newObject._location = new double[length];
        System.arraycopy(this._location, 0, newObject._location, 0, length);
        newObject._valueListeners = null;
        return newObject;
    }

    public void exportMoML(Writer output, int depth, String name) throws IOException {
        if (this._isMoMLSuppressed(depth)) {
            return;
        }
        String value = this.getExpression();
        String valueTerm = "";
        if (value != null && !value.equals("")) {
            valueTerm = " value=\"" + StringUtilities.escapeForXML(value) + "\"";
        }
        output.write(String.valueOf(Location._getIndentPrefix(depth)) + "<" + this._elementName + " name=\"" + name + "\" class=\"" + this.getClassName() + "\"" + valueTerm + ">\n");
        this._exportMoMLContents(output, depth + 1);
        output.write(String.valueOf(Location._getIndentPrefix(depth)) + "</" + this._elementName + ">\n");
    }

    public String getDefaultExpression() {
        try {
            List prototypeList = this.getPrototypeList();
            if (prototypeList.size() > 0) {
                return ((Settable)prototypeList.get(0)).getExpression();
            }
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
        return this._default;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getExpression() {
        if (this._expressionSet) {
            return this._expression;
        }
        if (this._location == null || this._location.length == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer("{");
        int i = 0;
        while (i < this._location.length - 1) {
            result.append(this._location[i]);
            result.append(", ");
            ++i;
        }
        result.append(String.valueOf(this._location[this._location.length - 1]) + "}");
        return result.toString();
    }

    public double[] getLocation() {
        return this._location;
    }

    public String getValueAsString() {
        return this.getExpression();
    }

    public Settable.Visibility getVisibility() {
        return this._visibility;
    }

    public void removeValueListener(ValueListener listener) {
        if (this._valueListeners != null) {
            this._valueListeners.remove(listener);
        }
    }

    public void setExpression(String expression) {
        if (this._default == null) {
            this._default = expression;
        }
        this._expression = expression;
        this._expressionSet = true;
    }

    public void setLocation(double[] location) throws IllegalActionException {
        this._expressionSet = false;
        if (this._setLocation(location)) {
            this.setPersistent(true);
        }
        this.propagateValue();
    }

    public void setVisibility(Settable.Visibility visibility) {
        this._visibility = visibility;
    }

    public String toString() {
        String className = this.getClass().getName();
        if (this._location == null) {
            return "(" + className + ", Location = null)";
        }
        return "(" + className + ", Location = " + this.getExpression() + ")";
    }

    public Collection validate() throws IllegalActionException {
        double[] location;
        if (!this._expressionSet) {
            return null;
        }
        if (this._expression == null) {
            location = new double[]{0.0, 0.0};
        } else {
            StringTokenizer tokenizer = new StringTokenizer(this._expression, ",[]{}");
            location = new double[tokenizer.countTokens()];
            int count = tokenizer.countTokens();
            int i = 0;
            while (i < count) {
                String next = tokenizer.nextToken().trim();
                location[i] = Double.parseDouble(next);
                ++i;
            }
        }
        this._setLocation(location);
        return null;
    }

    protected void _propagateValue(NamedObj destination) throws IllegalActionException {
        ((Location)destination).setExpression(this.getExpression());
    }

    private boolean _setLocation(double[] location) throws IllegalActionException {
        if (this._location != null) {
            if (this._location.length == location.length) {
                boolean match = true;
                int i = 0;
                while (i < location.length) {
                    if (this._location[i] != location[i]) {
                        match = false;
                        break;
                    }
                    ++i;
                }
                if (match) {
                    return false;
                }
            } else {
                this._location = new double[location.length];
            }
        } else {
            this._location = new double[location.length];
        }
        int i = 0;
        while (i < location.length) {
            this._location[i] = location[i];
            ++i;
        }
        NamedObj container = this.getContainer();
        if (container != null) {
            container.attributeChanged(this);
        }
        if (this._valueListeners != null) {
            for (ValueListener listener : this._valueListeners) {
                listener.valueChanged(this);
            }
        }
        return true;
    }
}

