/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class LabeledList
implements List {
    private ArrayList _elements;
    private HashMap _labels;

    public LabeledList() {
        this._elements = new ArrayList(0);
        this._labels = new HashMap(0);
    }

    public LabeledList(int size) {
        this._elements = new ArrayList(size);
        this._labels = new HashMap(size);
    }

    public boolean add(Object element) {
        if (element == null) {
            throw new IllegalArgumentException("Attempt to insert a null element");
        }
        if (this._labels.containsKey(element)) {
            throw new IllegalArgumentException("Attempt to insert a duplicate element." + this._elementDump(element));
        }
        this._labels.put(element, this._elements.size());
        this._elements.add(element);
        return true;
    }

    public void add(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index, Collection collection) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        this._elements.clear();
        this._labels.clear();
    }

    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        return this._labels.containsKey(object);
    }

    public boolean containsAll(Collection collection) {
        Iterator elements = collection.iterator();
        while (elements.hasNext()) {
            if (this.contains(elements.next())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        return this._elements.equals(object);
    }

    public Object get(int label) {
        if (label < 0 || label >= this._elements.size()) {
            throw new IndexOutOfBoundsException("Invalid label: " + label);
        }
        return this._elements.get(label);
    }

    public int hashCode() {
        return this._elements.hashCode();
    }

    public int indexOf(Object element) {
        if (element == null) {
            return -1;
        }
        Integer label = (Integer)this._labels.get(element);
        if (label == null) {
            return -1;
        }
        return label;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        return Collections.unmodifiableList(this._elements).iterator();
    }

    public final int label(Object element) {
        if (element == null) {
            throw new NullPointerException("Null element specified.");
        }
        Integer label = (Integer)this._labels.get(element);
        if (label == null) {
            throw new IllegalArgumentException("The specified object is not an element of this list. " + this._elementDump(element));
        }
        return label;
    }

    public int lastIndexOf(Object element) {
        return this._elements.indexOf(element);
    }

    public ListIterator listIterator() {
        return Collections.unmodifiableList(this._elements).listIterator();
    }

    public ListIterator listIterator(int index) {
        return Collections.unmodifiableList(this._elements).listIterator(index);
    }

    public boolean remove(Object element) {
        int label;
        try {
            label = this.label(element);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Attempt to remove a non-existent element. " + this._elementDump(element));
        }
        this._labels.remove(element);
        this._elements.remove(label);
        this._labelElements(label);
        return true;
    }

    public Object remove(int label) {
        Object element = this.get(label);
        this._labels.remove(element);
        Object removed = this._elements.remove(label);
        this._labelElements(label);
        return removed;
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public Object set(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this._elements.size();
    }

    public List subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    public Object[] toArray() {
        return this._elements.toArray();
    }

    public Object[] toArray(Object[] array) {
        return this._elements.toArray(array);
    }

    public String toString(String delimiter, boolean includeLabels) {
        Iterator elements = this.iterator();
        StringBuffer result = new StringBuffer();
        while (elements.hasNext()) {
            Object element = elements.next();
            result.append(String.valueOf(includeLabels ? String.valueOf(this.label(element)) + ": " : "") + element + (elements.hasNext() ? delimiter : ""));
        }
        return result.toString();
    }

    public String toString() {
        return this.toString("\n", false);
    }

    private String _elementDump(Object element) {
        return "The offending element follows:\n" + (element == null ? "null" : element) + "\n";
    }

    private void _labelElements(int startIndex) {
        int i = startIndex;
        while (i < this._elements.size()) {
            this._labels.put(this._elements.get(i), i);
            ++i;
        }
    }
}

