/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.graph;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import ptolemy.graph.CPO;
import ptolemy.graph.Inequality;
import ptolemy.graph.InequalityTerm;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InvalidStateException;
import ptolemy.kernel.util.NamedObj;

public class InequalitySolver {
    private CPO _cpo = null;
    private ArrayList _Ilist = new ArrayList();
    private Hashtable _Clist = new Hashtable();

    public InequalitySolver(CPO cpo) {
        this._cpo = cpo;
    }

    public void addInequalities(Iterator inequalities) {
        while (inequalities.hasNext()) {
            this.addInequality((Inequality)inequalities.next());
        }
    }

    public void addInequality(Inequality ineq) {
        Integer indexWrap = this._Ilist.size();
        Info info = new Info(ineq);
        this._Ilist.add(info);
        this._addToClist(ineq.getLesserTerm().getVariables(), indexWrap);
        this._addToClist(ineq.getGreaterTerm().getVariables(), indexWrap);
    }

    public Iterator bottomVariables() throws IllegalActionException {
        Object bottom = this._cpo.bottom();
        if (bottom == null) {
            throw new InvalidStateException("The underlying CPO does not have a bottom element.");
        }
        return this._filterVariables(bottom);
    }

    public String description() {
        StringBuffer results = new StringBuffer("{_Ilist:\n ");
        int i = 0;
        while (i < this._Ilist.size()) {
            Info info = (Info)this._Ilist.get(i);
            results.append("{_ineq: " + info._ineq + " _inCvar: " + info._inCvar + " _inserted: " + info._inserted + "}\n  ");
            ++i;
        }
        results.append("}\n{Clist:\n ");
        Enumeration e = this._Clist.keys();
        while (e.hasMoreElements()) {
            InequalityTerm variable = (InequalityTerm)e.nextElement();
            results.append("{" + (variable == null ? "variable == null" : variable.toString()) + "}\n ");
        }
        results.append("}\n");
        return results.toString();
    }

    public boolean solveGreatest() throws IllegalActionException {
        return this._solve(false);
    }

    public boolean solveLeast() throws IllegalActionException {
        return this._solve(true);
    }

    public Iterator topVariables() throws IllegalActionException {
        Object top = this._cpo.top();
        if (top == null) {
            throw new InvalidStateException("The underlying CPO does not have a top element.");
        }
        return this._filterVariables(top);
    }

    public Iterator unsatisfiedInequalities() throws IllegalActionException {
        LinkedList<Inequality> result = new LinkedList<Inequality>();
        int i = 0;
        while (i < this._Ilist.size()) {
            Info info = (Info)this._Ilist.get(i);
            if (!info._ineq.isSatisfied(this._cpo)) {
                result.addLast(info._ineq);
            }
            ++i;
        }
        return result.iterator();
    }

    public Iterator variables() {
        LinkedList<InequalityTerm> result = new LinkedList<InequalityTerm>();
        Enumeration e = this._Clist.keys();
        while (e.hasMoreElements()) {
            InequalityTerm variable = (InequalityTerm)e.nextElement();
            result.addLast(variable);
        }
        return result.iterator();
    }

    private void _addToClist(InequalityTerm[] variables, Integer indexWrap) {
        int i = 0;
        while (i < variables.length) {
            if (!variables[i].isSettable()) {
                Object variableValue = null;
                try {
                    variableValue = variables[i].getValue();
                }
                catch (IllegalActionException ex) {
                    variableValue = ex.toString();
                }
                Object variableObject = null;
                try {
                    variableObject = variables[i].getAssociatedObject();
                    if (variableObject instanceof NamedObj) {
                        variableObject = ((NamedObj)variableObject).getFullName();
                    }
                }
                catch (Exception ex) {
                    variableObject = ex.toString();
                }
                throw new InvalidStateException("Port \" " + variableObject + "\" of type \"" + variableValue + "\" in an InequalityTerm is not settable." + " If the port is an input and has a type constraint," + " try removing the type constraint and possibly" + " placing it on the output.");
            }
            ArrayList<Integer> entry = (ArrayList<Integer>)this._Clist.get(variables[i]);
            if (entry == null) {
                entry = new ArrayList<Integer>();
                this._Clist.put(variables[i], entry);
            }
            entry.add(indexWrap);
            ++i;
        }
    }

    private Iterator _filterVariables(Object value) throws IllegalActionException {
        LinkedList<InequalityTerm> result = new LinkedList<InequalityTerm>();
        Enumeration e = this._Clist.keys();
        while (e.hasMoreElements()) {
            InequalityTerm variable = (InequalityTerm)e.nextElement();
            if (value != null && !variable.getValue().equals(value)) continue;
            result.addLast(variable);
        }
        return result.iterator();
    }

    /*
     * Unable to fully structure code
     */
    private boolean _solve(boolean least) throws IllegalActionException {
        v0 = init = least != false ? this._cpo.bottom() : this._cpo.top();
        if (init == null) {
            throw new InvalidStateException("The underlying CPO is not a lattice because the CPO has no " + (least != false ? "bottom" : "top") + ". The CPO was a " + this._cpo.getClass().getName());
        }
        e = this._Clist.keys();
        while (e.hasMoreElements()) {
            variable = (InequalityTerm)e.nextElement();
            try {
                variable.initialize(init);
            }
            catch (IllegalActionException ex) {
                throw new InvalidStateException(null, null, ex, "Cannot initialize variable.");
            }
        }
        _NS = new LinkedList<Integer>();
        i = 0;
        while (i < this._Ilist.size()) {
            info = (Info)this._Ilist.get(i);
            Info.access$4(info, least != false ? Info.access$1(info).getGreaterTerm().isSettable() : Info.access$1(info).getLesserTerm().isSettable());
            if (Info.access$2(info)) {
                if (Info.access$1(info).isSatisfied(this._cpo)) {
                    Info.access$5(info, false);
                } else {
                    _NS.addLast(i);
                    Info.access$5(info, true);
                }
            }
            ++i;
        }
        allSatisfied = false;
        ** GOTO lbl76
        {
            index = (Integer)_NS.removeFirst();
            info = (Info)this._Ilist.get(index);
            Info.access$5(info, false);
            value = null;
            updateTerm = null;
            if (least) {
                updateTerm = Info.access$1(info).getGreaterTerm();
                value = this._cpo.leastUpperBound(Info.access$1(info).getLesserTerm().getValue(), updateTerm.getValue());
            } else {
                updateTerm = Info.access$1(info).getLesserTerm();
                value = this._cpo.greatestLowerBound(updateTerm.getValue(), Info.access$1(info).getGreaterTerm().getValue());
            }
            if (value == null) {
                throw new InvalidStateException("The CPO over which the inequalities are defined is not a lattice.");
            }
            try {
                updateTerm.setValue(value);
            }
            catch (IllegalActionException ex) {
                throw new InvalidStateException(null, null, ex, "Can't update variable.\n");
            }
            affected = (ArrayList)this._Clist.get(updateTerm);
            i = 0;
            while (i < affected.size()) {
                index1Wrap = (Integer)affected.get(i);
                index1 = index1Wrap;
                affectedInfo = (Info)this._Ilist.get(index1);
                if (index1 != index && Info.access$2(affectedInfo)) {
                    if (Info.access$1(affectedInfo).isSatisfied(this._cpo)) {
                        if (Info.access$3(affectedInfo)) {
                            _NS.remove(index1Wrap);
                        }
                    } else if (!Info.access$3(affectedInfo)) {
                        _NS.addFirst(index1Wrap);
                    }
                }
                ++i;
            }
            do {
                if (_NS.size() > 0) continue block6;
                allSatisfied = true;
                i = 0;
                while (i < this._Ilist.size()) {
                    info = (Info)this._Ilist.get(i);
                    if (Info.access$2(info)) {
                        if (Info.access$1(info).isSatisfied(this._cpo)) {
                            Info.access$5(info, false);
                        } else {
                            _NS.addLast(i);
                            Info.access$5(info, true);
                            allSatisfied = false;
                        }
                    }
                    ++i;
                }
lbl76:
                // 2 sources

            } while (!allSatisfied);
        }
        i = 0;
        while (i < this._Ilist.size()) {
            info = (Info)this._Ilist.get(i);
            if (!Info.access$2(info) && !Info.access$1(info).isSatisfied(this._cpo)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static class Info {
        private Inequality _ineq;
        private boolean _inCvar = false;
        private boolean _inserted = false;

        private Info(Inequality ineq) {
            this._ineq = ineq;
        }

        static /* synthetic */ void access$4(Info info, boolean bl) {
            info._inCvar = bl;
        }

        static /* synthetic */ void access$5(Info info, boolean bl) {
            info._inserted = bl;
        }
    }
}

