/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.graph;

import ptolemy.graph.Element;
import ptolemy.graph.Graph;

public class GraphException
extends RuntimeException {
    public GraphException() {
        this((String)null);
    }

    public GraphException(String message) {
        super(message);
    }

    public static String graphDump(Graph graph) {
        return "\nA Dump of the offending graph follows.\n" + graph.toString() + "\n";
    }

    public static String elementDump(Element element, Graph graph) {
        String descriptor = element == null ? "element" : element.descriptor();
        return GraphException._elementDump(element, graph, descriptor);
    }

    public static String weightDump(Object weight) {
        if (weight == null) {
            return "\nThe weight was null?";
        }
        String dump = "\nThe weight is of class " + weight.getClass().getName() + " and its description follows:\n" + weight.toString();
        return dump;
    }

    protected static String _elementDump(Object element, Graph graph, String elementDescriptor) {
        String elementString = element == null ? "<null>" : element.toString();
        return "\nDumps of the offending " + elementDescriptor + " and graph follow.\n" + "The offending " + elementDescriptor + ":\n" + elementString + "\nThe offending graph:\n" + graph.toString() + "\n";
    }
}

