/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data;

import ptolemy.data.AbstractNotConvertibleToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.data.expr.PtParser;
import ptolemy.data.type.Type;
import ptolemy.data.type.UnionType;
import ptolemy.kernel.util.IllegalActionException;

public class UnionToken
extends AbstractNotConvertibleToken {
    private String _label;
    private Token _value;

    public UnionToken(String label, Token value) throws IllegalActionException {
        if (label == null || value == null) {
            throw new IllegalActionException("UnionToken: The label or the value is null.");
        }
        this._label = label;
        this._value = value;
    }

    public UnionToken(String init) throws IllegalActionException {
        PtParser parser = new PtParser();
        ASTPtRootNode tree = parser.generateParseTree(init);
        ParseTreeEvaluator evaluator = new ParseTreeEvaluator();
        Token token = evaluator.evaluateParseTree(tree);
        if (token instanceof UnionToken) {
            UnionToken unionToken = (UnionToken)token;
            this._label = unionToken.label();
            this._value = unionToken.value();
            if (this._label == null || this._value == null) {
                throw new IllegalActionException("UnionToken: The label or the value is null.");
            }
        } else {
            throw new IllegalActionException("An union token cannot be created from the expression '" + init + "'");
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        UnionToken unionToken = (UnionToken)object;
        return this._label.equals(unionToken.label()) && this._value.equals(unionToken.value());
    }

    public Type getType() {
        String[] labels = new String[]{this._label};
        Type[] types = new Type[]{this._value.getType()};
        return new UnionType(labels, types);
    }

    public int hashCode() {
        return this._value.hashCode();
    }

    public String label() {
        return this._label;
    }

    public Token one() throws IllegalActionException {
        return new UnionToken(this._label, this._value.one());
    }

    public String toString() {
        return "{|" + this._label + " = " + this._value.toString() + "|}";
    }

    public Token value() {
        return this._value;
    }

    public Token zero() throws IllegalActionException {
        return new UnionToken(this._label, this._value.zero());
    }

    protected Token _add(Token rightArgument) throws IllegalActionException {
        UnionToken unionToken = (UnionToken)rightArgument;
        if (!this._label.equals(unionToken.label())) {
            throw new IllegalActionException("UnionToken._add: The label of the argument token (" + unionToken.label() + ") is different from that of this token (" + this._label + ".");
        }
        Token value = this._value.add(unionToken.value());
        return new UnionToken(this._label, value);
    }

    protected Token _divide(Token rightArgument) throws IllegalActionException {
        UnionToken unionToken = (UnionToken)rightArgument;
        if (!this._label.equals(unionToken.label())) {
            throw new IllegalActionException("UnionToken._divide: The label of the argument token (" + unionToken.label() + ") is different from that of this token (" + this._label + ".");
        }
        Token value = this._value.divide(unionToken.value());
        return new UnionToken(this._label, value);
    }

    protected BooleanToken _isCloseTo(Token rightArgument, double epsilon) throws IllegalActionException {
        UnionToken unionToken = (UnionToken)rightArgument;
        if (!this._label.equals(unionToken.label())) {
            return new BooleanToken(false);
        }
        return this._value.isCloseTo(unionToken.value(), epsilon);
    }

    protected BooleanToken _isEqualTo(Token rightArgument) throws IllegalActionException {
        UnionToken unionToken = (UnionToken)rightArgument;
        if (!this._label.equals(unionToken.label())) {
            return new BooleanToken(false);
        }
        return this._value.isEqualTo(unionToken.value());
    }

    protected Token _modulo(Token rightArgument) throws IllegalActionException {
        UnionToken unionToken = (UnionToken)rightArgument;
        if (!this._label.equals(unionToken.label())) {
            throw new IllegalActionException("UnionToken._modulo: The label of the argument token (" + unionToken.label() + ") is different from that of this token (" + this._label + ".");
        }
        Token value = this._value.modulo(unionToken.value());
        return new UnionToken(this._label, value);
    }

    protected Token _multiply(Token rightArgument) throws IllegalActionException {
        UnionToken unionToken = (UnionToken)rightArgument;
        if (!this._label.equals(unionToken.label())) {
            throw new IllegalActionException("UnionToken._multiply: The label of the argument token (" + unionToken.label() + ") is different from that of this token (" + this._label + ".");
        }
        Token value = this._value.multiply(unionToken.value());
        return new UnionToken(this._label, value);
    }

    protected Token _subtract(Token rightArgument) throws IllegalActionException {
        UnionToken unionToken = (UnionToken)rightArgument;
        if (!this._label.equals(unionToken.label())) {
            throw new IllegalActionException("UnionToken._subtract: The label of the argument token (" + unionToken.label() + ") is different from that of this token (" + this._label + ".");
        }
        Token value = this._value.subtract(unionToken.value());
        return new UnionToken(this._label, value);
    }
}

