/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data;

import ptolemy.data.DoubleToken;
import ptolemy.data.IntMatrixToken;
import ptolemy.data.MatrixToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.Token;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.data.expr.PtParser;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.math.Complex;
import ptolemy.math.ComplexMatrixMath;
import ptolemy.math.DoubleArrayMath;
import ptolemy.math.DoubleMatrixMath;

public class DoubleMatrixToken
extends MatrixToken {
    private double[] _value;
    private int _rowCount;
    private int _columnCount;

    public DoubleMatrixToken() {
        this._value = new double[1];
        this._value[0] = 0.0;
        this._rowCount = 1;
        this._columnCount = 1;
    }

    public DoubleMatrixToken(double[] value, int rows, int columns) throws IllegalActionException {
        this(value, rows, columns, 0);
    }

    public DoubleMatrixToken(double[] value, int rows, int columns, int copy) throws IllegalActionException {
        if (value == null) {
            throw new IllegalActionException("DoubleMatrixToken: The specified matrix is null.");
        }
        this._rowCount = rows;
        this._columnCount = columns;
        this._value = copy == 0 ? DoubleArrayMath.allocCopy(value) : value;
    }

    public DoubleMatrixToken(double[][] value) throws IllegalActionException {
        this(value, 0);
    }

    public DoubleMatrixToken(double[][] value, int copy) throws IllegalActionException {
        if (value == null) {
            throw new IllegalActionException("DoubleMatrixToken: The specified matrix is null.");
        }
        this._initialize(value);
    }

    public DoubleMatrixToken(String init) throws IllegalActionException {
        PtParser parser = new PtParser();
        ASTPtRootNode tree = parser.generateParseTree(init);
        Token token = new ParseTreeEvaluator().evaluateParseTree(tree);
        if (!(token instanceof DoubleMatrixToken)) {
            throw new IllegalActionException("A matrix token cannot be created from the expression '" + init + "'");
        }
        double[][] value = ((DoubleMatrixToken)token).doubleMatrix();
        this._initialize(value);
    }

    public DoubleMatrixToken(Token[] tokens, int rows, int columns) throws IllegalActionException {
        int elements = rows * columns;
        if (tokens == null) {
            throw new IllegalActionException("DoubleMatrixToken: The specified array is null.");
        }
        if (tokens.length != rows * columns) {
            throw new IllegalActionException("DoubleMatrixToken: The specified array is not of the correct length");
        }
        this._rowCount = rows;
        this._columnCount = columns;
        this._value = new double[elements];
        int i = 0;
        while (i < elements) {
            Token token = tokens[i];
            if (!(token instanceof ScalarToken)) {
                throw new IllegalActionException("DoubleMatrixToken: Element " + i + " in the array with value " + token + " is not a ScalarToken");
            }
            this._value[i] = ((ScalarToken)token).doubleValue();
            ++i;
        }
    }

    public final Complex[][] complexMatrix() {
        return ComplexMatrixMath.toMatrixFromArray(DoubleArrayMath.toComplexArray(this._value), this._rowCount, this._columnCount);
    }

    public static DoubleMatrixToken convert(Token token) throws IllegalActionException {
        if (token instanceof DoubleMatrixToken) {
            return (DoubleMatrixToken)token;
        }
        int compare = TypeLattice.compare((Type)BaseType.DOUBLE_MATRIX, token);
        if (compare == -1 || compare == 2) {
            throw new IllegalActionException(DoubleMatrixToken.notSupportedIncomparableConversionMessage(token, "[double]"));
        }
        compare = TypeLattice.compare((Type)BaseType.INT_MATRIX, token);
        if (compare == 0 || compare == 1) {
            IntMatrixToken intMatrix = IntMatrixToken.convert(token);
            double[][] result = intMatrix.doubleMatrix();
            return new DoubleMatrixToken(result);
        }
        throw new IllegalActionException(DoubleMatrixToken.notSupportedConversionMessage(token, "[double]"));
    }

    public MatrixToken crop(int rowStart, int colStart, int rowSpan, int colSpan) throws IllegalActionException {
        double[][] value = this.doubleMatrix();
        try {
            double[][] result = DoubleMatrixMath.crop(value, rowStart, colStart, rowSpan, colSpan);
            return new DoubleMatrixToken(result);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalActionException("Matrix crop indices out of bounds (rowStart = " + rowStart + ", colStart = " + colStart + ", rowSpan = " + rowSpan + ", colSpan = " + colSpan + ").");
        }
    }

    public final double[][] doubleMatrix() {
        return DoubleMatrixMath.toMatrixFromArray(this._value, this._rowCount, this._columnCount);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        DoubleMatrixToken matrixArgument = (DoubleMatrixToken)object;
        if (this._rowCount != matrixArgument.getRowCount()) {
            return false;
        }
        if (this._columnCount != matrixArgument.getColumnCount()) {
            return false;
        }
        double[] value = matrixArgument._value;
        int elements = this._rowCount * this._columnCount;
        int i = 0;
        while (i < elements) {
            if (this._value[i] != value[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final int getColumnCount() {
        return this._columnCount;
    }

    public final Token getElementAsToken(int row, int column) throws ArrayIndexOutOfBoundsException {
        return new DoubleToken(this._value[row * this._columnCount + column]);
    }

    public final double getElementAt(int row, int column) {
        return this._value[row * this._columnCount + column];
    }

    public Type getElementType() {
        return BaseType.DOUBLE;
    }

    public final int getRowCount() {
        return this._rowCount;
    }

    public final Type getType() {
        return BaseType.DOUBLE_MATRIX;
    }

    public int hashCode() {
        double code = 0.0;
        int elements = this._rowCount * this._columnCount;
        int i = 0;
        while (i < elements) {
            code += this._value[i];
            ++i;
        }
        return (int)code;
    }

    public MatrixToken join(MatrixToken[][] matrices) throws IllegalActionException {
        if (matrices == null || matrices.length == 0 || matrices[0].length == 0) {
            throw new IllegalActionException("matrixJoin: No input matrices.");
        }
        int rows = 0;
        int columns = 0;
        int i = 0;
        while (i < matrices.length) {
            rows += matrices[i][0].getRowCount();
            ++i;
        }
        int j = 0;
        while (j < matrices[0].length) {
            columns += matrices[0][j].getColumnCount();
            ++j;
        }
        double[][] tiled = new double[rows][columns];
        int row = 0;
        int i2 = 0;
        while (i2 < matrices.length) {
            int column = 0;
            int j2 = 0;
            while (j2 < matrices[i2].length) {
                int columnCount;
                if (!(matrices[i2][j2] instanceof DoubleMatrixToken)) {
                    throw new IllegalActionException("matrixJoin: matrices not all of the same type.");
                }
                int rowCount = matrices[i2][j2].getRowCount();
                if (row + rowCount > rows) {
                    rowCount = rows - row;
                }
                if (column + (columnCount = matrices[i2][j2].getColumnCount()) > columns) {
                    columnCount = columns - column;
                }
                DoubleMatrixMath.matrixCopy(matrices[i2][j2].doubleMatrix(), 0, 0, tiled, row, column, rowCount, columnCount);
                column += matrices[0][j2].getColumnCount();
                ++j2;
            }
            row += matrices[i2][0].getRowCount();
            ++i2;
        }
        return new DoubleMatrixToken(tiled);
    }

    public final Token one() {
        try {
            return new DoubleMatrixToken(DoubleMatrixMath.identity(this._rowCount), 1);
        }
        catch (IllegalActionException illegalActionException) {
            throw new InternalErrorException("DoubleMatrixToken.one: Cannot create identity matrix.");
        }
    }

    public final Token oneRight() {
        try {
            return new DoubleMatrixToken(DoubleMatrixMath.identity(this._columnCount), 1);
        }
        catch (IllegalActionException illegalActionException) {
            throw new InternalErrorException("DoubleMatrixToken.oneRight: Cannot create identity matrix.");
        }
    }

    public MatrixToken[][] split(int[] rows, int[] columns) {
        MatrixToken[][] result = new MatrixToken[rows.length][columns.length];
        double[][] source = this.doubleMatrix();
        int row = 0;
        int i = 0;
        while (i < rows.length) {
            int column = 0;
            int j = 0;
            while (j < columns.length) {
                int columnspan;
                double[][] contents = new double[rows[i]][columns[j]];
                int rowspan = rows[i];
                if (row + rowspan > source.length) {
                    rowspan = source.length - row;
                }
                if (column + (columnspan = columns[j]) > source[0].length) {
                    columnspan = source[0].length - column;
                }
                if (columnspan > 0 && rowspan > 0) {
                    DoubleMatrixMath.matrixCopy(source, row, column, contents, 0, 0, rowspan, columnspan);
                }
                column += columns[j];
                try {
                    result[i][j] = new DoubleMatrixToken(contents);
                }
                catch (IllegalActionException e) {
                    throw new InternalErrorException(e);
                }
                ++j;
            }
            row += rows[i];
            ++i;
        }
        return result;
    }

    public final Token zero() {
        try {
            return new DoubleMatrixToken(new double[this._rowCount * this._columnCount], this._rowCount, this._columnCount, 1);
        }
        catch (IllegalActionException illegalActionException) {
            throw new InternalErrorException("DoubleMatrixToken.zero: Cannot create zero matrix.");
        }
    }

    protected MatrixToken _add(MatrixToken rightArgument) throws IllegalActionException {
        DoubleMatrixToken convertedArgument = (DoubleMatrixToken)rightArgument;
        double[] result = DoubleArrayMath.add(convertedArgument._getInternalDoubleArray(), this._value);
        return new DoubleMatrixToken(result, this._rowCount, this._columnCount, 1);
    }

    protected MatrixToken _addElement(Token rightArgument) throws IllegalActionException {
        double scalar;
        if (rightArgument instanceof DoubleMatrixToken) {
            if (((DoubleMatrixToken)rightArgument).getRowCount() != 1 || ((DoubleMatrixToken)rightArgument).getColumnCount() != 1) {
                return super._moduloElement(rightArgument);
            }
            scalar = ((DoubleMatrixToken)rightArgument).getElementAt(0, 0);
        } else {
            scalar = ((DoubleToken)rightArgument).doubleValue();
        }
        double[] result = DoubleArrayMath.add(this._value, scalar);
        return new DoubleMatrixToken(result, this._rowCount, this._columnCount, 1);
    }

    protected MatrixToken _divideElement(Token rightArgument) throws IllegalActionException {
        double scalar;
        if (rightArgument instanceof DoubleMatrixToken) {
            if (((DoubleMatrixToken)rightArgument).getRowCount() != 1 || ((DoubleMatrixToken)rightArgument).getColumnCount() != 1) {
                return super._moduloElement(rightArgument);
            }
            scalar = ((DoubleMatrixToken)rightArgument).getElementAt(0, 0);
        } else {
            scalar = ((DoubleToken)rightArgument).doubleValue();
        }
        double[] result = DoubleArrayMath.divide(this._value, scalar);
        return new DoubleMatrixToken(result, this._rowCount, this._columnCount, 1);
    }

    protected double[] _getInternalDoubleArray() {
        return this._value;
    }

    protected MatrixToken _moduloElement(Token rightArgument) throws IllegalActionException {
        double scalar;
        if (rightArgument instanceof DoubleMatrixToken) {
            if (((DoubleMatrixToken)rightArgument).getRowCount() != 1 || ((DoubleMatrixToken)rightArgument).getColumnCount() != 1) {
                return super._moduloElement(rightArgument);
            }
            scalar = ((DoubleMatrixToken)rightArgument).getElementAt(0, 0);
        } else {
            scalar = ((DoubleToken)rightArgument).doubleValue();
        }
        double[] result = DoubleArrayMath.modulo(this._value, scalar);
        return new DoubleMatrixToken(result, this._rowCount, this._columnCount, 1);
    }

    protected MatrixToken _multiply(MatrixToken rightArgument) throws IllegalActionException {
        DoubleMatrixToken convertedArgument = (DoubleMatrixToken)rightArgument;
        double[] A = this._value;
        double[] B = convertedArgument._getInternalDoubleArray();
        int m = this._rowCount;
        int n = this._columnCount;
        int p = convertedArgument.getColumnCount();
        double[] newMatrix = new double[m * p];
        int in = 0;
        int ta = 0;
        int i = 0;
        while (i < m) {
            ta += n;
            int j = 0;
            while (j < p) {
                double sum = 0.0;
                int ib = j;
                int ia = i * n;
                while (ia < ta) {
                    sum += A[ia] * B[ib];
                    ++ia;
                    ib += p;
                }
                newMatrix[in++] = sum;
                ++j;
            }
            ++i;
        }
        return new DoubleMatrixToken(newMatrix, m, p, 1);
    }

    protected MatrixToken _multiplyElement(Token rightArgument) throws IllegalActionException {
        double scalar;
        if (rightArgument instanceof DoubleMatrixToken) {
            if (((DoubleMatrixToken)rightArgument).getRowCount() != 1 || ((DoubleMatrixToken)rightArgument).getColumnCount() != 1) {
                return super._moduloElement(rightArgument);
            }
            scalar = ((DoubleMatrixToken)rightArgument).getElementAt(0, 0);
        } else {
            scalar = ((DoubleToken)rightArgument).doubleValue();
        }
        double[] result = DoubleArrayMath.multiply(this._value, scalar);
        return new DoubleMatrixToken(result, this._rowCount, this._columnCount, 1);
    }

    protected MatrixToken _subtract(MatrixToken rightArgument) throws IllegalActionException {
        DoubleMatrixToken convertedArgument = (DoubleMatrixToken)rightArgument;
        double[] result = DoubleArrayMath.subtract(this._value, convertedArgument._getInternalDoubleArray());
        return new DoubleMatrixToken(result, this._rowCount, this._columnCount, 1);
    }

    protected MatrixToken _subtractElement(Token rightArgument) throws IllegalActionException {
        double scalar;
        if (rightArgument instanceof DoubleMatrixToken) {
            if (((DoubleMatrixToken)rightArgument).getRowCount() != 1 || ((DoubleMatrixToken)rightArgument).getColumnCount() != 1) {
                return super._moduloElement(rightArgument);
            }
            scalar = ((DoubleMatrixToken)rightArgument).getElementAt(0, 0);
        } else {
            scalar = ((DoubleToken)rightArgument).doubleValue();
        }
        double[] result = DoubleArrayMath.add(this._value, -scalar);
        return new DoubleMatrixToken(result, this._rowCount, this._columnCount, 1);
    }

    protected MatrixToken _subtractElementReverse(Token rightArgument) throws IllegalActionException {
        double scalar;
        if (rightArgument instanceof DoubleMatrixToken) {
            if (((DoubleMatrixToken)rightArgument).getRowCount() != 1 || ((DoubleMatrixToken)rightArgument).getColumnCount() != 1) {
                return super._moduloElement(rightArgument);
            }
            scalar = ((DoubleMatrixToken)rightArgument).getElementAt(0, 0);
        } else {
            scalar = ((DoubleToken)rightArgument).doubleValue();
        }
        double[] result = DoubleArrayMath.negative(DoubleArrayMath.add(this._value, -scalar));
        return new DoubleMatrixToken(result, this._rowCount, this._columnCount, 1);
    }

    private void _initialize(double[][] value) {
        this._rowCount = value.length;
        this._columnCount = value[0].length;
        this._value = DoubleMatrixMath.fromMatrixToArray(value);
    }
}

