/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data;

import ptolemy.data.BooleanToken;
import ptolemy.data.MatrixToken;
import ptolemy.data.Token;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.data.expr.PtParser;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;

public class BooleanMatrixToken
extends MatrixToken {
    private boolean[][] _value = null;
    private int _rowCount = 0;
    private int _columnCount = 0;

    public BooleanMatrixToken() {
        this._rowCount = 1;
        this._columnCount = 1;
        this._value = new boolean[1][1];
        this._value[0][0] = false;
    }

    public BooleanMatrixToken(boolean[][] value) throws IllegalActionException {
        if (value == null) {
            throw new IllegalActionException("BooleanMatrixToken: The specified matrix is null.");
        }
        this._initialize(value);
    }

    public BooleanMatrixToken(String init) throws IllegalActionException {
        PtParser parser = new PtParser();
        ASTPtRootNode tree = parser.generateParseTree(init);
        Token token = new ParseTreeEvaluator().evaluateParseTree(tree);
        if (!(token instanceof BooleanMatrixToken)) {
            throw new IllegalActionException("A BooleanMatrixToken cannot be created from the expression '" + init + "'");
        }
        boolean[][] value = ((BooleanMatrixToken)token).booleanMatrix();
        this._initialize(value);
    }

    public BooleanMatrixToken(Token[] tokens, int rows, int columns) throws IllegalActionException {
        if (tokens == null) {
            throw new IllegalActionException("BooleanMatrixToken: The specified array is null.");
        }
        if (tokens.length != rows * columns) {
            throw new IllegalActionException("BooleanMatrixToken: The specified array is not of the correct length");
        }
        this._rowCount = rows;
        this._columnCount = columns;
        this._value = new boolean[rows][columns];
        int i = 0;
        while (i < tokens.length) {
            Token token = tokens[i];
            if (!(token instanceof BooleanToken)) {
                throw new IllegalActionException("BooleanMatrixToken: Element " + i + " in the array with value " + token + " is not a ScalarToken");
            }
            this._value[i / columns][i % columns] = ((BooleanToken)token).booleanValue();
            ++i;
        }
    }

    public boolean[][] booleanMatrix() {
        boolean[][] result = new boolean[this._rowCount][this._columnCount];
        int i = 0;
        while (i < this._rowCount) {
            int j = 0;
            while (j < this._columnCount) {
                result[i][j] = this._value[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static BooleanMatrixToken convert(Token token) throws IllegalActionException {
        if (token instanceof BooleanMatrixToken) {
            return (BooleanMatrixToken)token;
        }
        int compare = TypeLattice.compare((Type)BaseType.BOOLEAN_MATRIX, token);
        if (compare == -1 || compare == 2) {
            throw new IllegalActionException(BooleanMatrixToken.notSupportedIncomparableConversionMessage(token, "[boolean]"));
        }
        throw new IllegalActionException(BooleanMatrixToken.notSupportedConversionMessage(token, "[boolean]"));
    }

    public MatrixToken crop(int rowStart, int colStart, int rowSpan, int colSpan) throws IllegalActionException {
        boolean[][] value = this.booleanMatrix();
        try {
            boolean[][] result = new boolean[rowSpan][colSpan];
            int i = 0;
            while (i < rowSpan) {
                System.arraycopy(value[rowStart + i], colStart, result[i], 0, colSpan);
                ++i;
            }
            return new BooleanMatrixToken(result);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalActionException("Matrix crop indices out of bounds (rowStart = " + rowStart + ", colStart = " + colStart + ", rowSpan = " + rowSpan + ", colSpan = " + colSpan + ").");
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        BooleanMatrixToken matrixArgument = (BooleanMatrixToken)object;
        if (this._rowCount != matrixArgument.getRowCount()) {
            return false;
        }
        if (this._columnCount != matrixArgument.getColumnCount()) {
            return false;
        }
        boolean[][] matrix = matrixArgument.booleanMatrix();
        int i = 0;
        while (i < this._rowCount) {
            int j = 0;
            while (j < this._columnCount) {
                if (this._value[i][j] != matrix[i][j]) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public int getColumnCount() {
        return this._columnCount;
    }

    public Token getElementAsToken(int row, int column) throws ArrayIndexOutOfBoundsException {
        return BooleanToken.getInstance(this._value[row][column]);
    }

    public boolean getElementAt(int row, int column) {
        return this._value[row][column];
    }

    public Type getElementType() {
        return BaseType.INT;
    }

    public int getRowCount() {
        return this._rowCount;
    }

    public Type getType() {
        return BaseType.BOOLEAN_MATRIX;
    }

    public int hashCode() {
        int code = 0;
        int i = 0;
        while (i < this._rowCount) {
            int j = 0;
            while (j < this._columnCount) {
                if (this._value[i][j]) {
                    ++code;
                }
                ++j;
            }
            ++i;
        }
        return code;
    }

    public MatrixToken join(MatrixToken[][] matrices) throws IllegalActionException {
        if (matrices == null || matrices.length == 0 || matrices[0].length == 0) {
            throw new IllegalActionException("matrixJoin: No input matrices.");
        }
        int rows = 0;
        int columns = 0;
        int i = 0;
        while (i < matrices.length) {
            rows += matrices[i][0].getRowCount();
            ++i;
        }
        int j = 0;
        while (j < matrices[0].length) {
            columns += matrices[0][j].getColumnCount();
            ++j;
        }
        boolean[][] tiled = new boolean[rows][columns];
        int row = 0;
        int i2 = 0;
        while (i2 < matrices.length) {
            int column = 0;
            int j2 = 0;
            while (j2 < matrices[i2].length) {
                int columnCount;
                if (!(matrices[i2][j2] instanceof BooleanMatrixToken)) {
                    throw new IllegalActionException("matrixJoin: matrices not all of the same type.");
                }
                int rowCount = matrices[i2][j2].getRowCount();
                if (row + rowCount > rows) {
                    rowCount = rows - row;
                }
                if (column + (columnCount = matrices[i2][j2].getColumnCount()) > columns) {
                    columnCount = columns - column;
                }
                int ii = 0;
                while (ii < rowCount) {
                    System.arraycopy(matrices[i2][j2].booleanMatrix()[ii], 0, tiled[row + ii], column, columnCount);
                    ++ii;
                }
                column += matrices[0][j2].getColumnCount();
                ++j2;
            }
            row += matrices[i2][0].getRowCount();
            ++i2;
        }
        return new BooleanMatrixToken(tiled);
    }

    public MatrixToken[][] split(int[] rows, int[] columns) {
        MatrixToken[][] result = new MatrixToken[rows.length][columns.length];
        boolean[][] source = this.booleanMatrix();
        int row = 0;
        int i = 0;
        while (i < rows.length) {
            int column = 0;
            int j = 0;
            while (j < columns.length) {
                int columnspan;
                boolean[][] contents = new boolean[rows[i]][columns[j]];
                int rowspan = rows[i];
                if (row + rowspan > source.length) {
                    rowspan = source.length - row;
                }
                if (column + (columnspan = columns[j]) > source[0].length) {
                    columnspan = source[0].length - column;
                }
                if (columnspan > 0 && rowspan > 0) {
                    int ii = 0;
                    while (ii < rowspan) {
                        System.arraycopy(source[row + ii], column, contents[ii], 0, columnspan);
                        ++ii;
                    }
                }
                column += columns[j];
                try {
                    result[i][j] = new BooleanMatrixToken(contents);
                }
                catch (IllegalActionException e) {
                    throw new InternalErrorException(e);
                }
                ++j;
            }
            row += rows[i];
            ++i;
        }
        return result;
    }

    public Token one() {
        try {
            return new BooleanMatrixToken(this._createIdentity(this._rowCount));
        }
        catch (IllegalActionException illegalActionException) {
            throw new InternalErrorException("BooleanMatrixToken.one: Cannot create identity matrix.");
        }
    }

    public Token oneRight() {
        try {
            return new BooleanMatrixToken(this._createIdentity(this._columnCount));
        }
        catch (IllegalActionException illegalActionException) {
            throw new InternalErrorException("BooleanMatrixToken.oneRight: Cannot create identity matrix.");
        }
    }

    public Token zero() {
        try {
            return new BooleanMatrixToken(new boolean[this._rowCount][this._columnCount]);
        }
        catch (IllegalActionException illegalActionException) {
            throw new InternalErrorException("BooleanMatrixToken.zero: Cannot create zero matrix.");
        }
    }

    protected boolean[][] _createIdentity(int dim) {
        boolean[][] a = new boolean[dim][dim];
        int i = 0;
        while (i < dim) {
            a[i][i] = true;
            ++i;
        }
        return a;
    }

    private void _initialize(boolean[][] value) {
        this._rowCount = value.length;
        this._columnCount = value[0].length;
        this._value = new boolean[this._rowCount][this._columnCount];
        int i = 0;
        while (i < this._rowCount) {
            int j = 0;
            while (j < this._columnCount) {
                this._value[i][j] = value[i][j];
                ++j;
            }
            ++i;
        }
    }
}

