/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data;

import java.io.Serializable;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.type.Type;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.IllegalActionException;

public class ActorToken
extends Token {
    public static final Type TYPE = new ActorType();
    private Entity _entity;

    public ActorToken(Entity entity) throws IllegalActionException {
        try {
            this._entity = (Entity)entity.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalActionException(null, ex, "Failed to create actor token");
        }
    }

    public Entity getEntity() {
        try {
            return (Entity)this._entity.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Failed to clone actor, but I already cloned it once!!!");
        }
    }

    public Type getType() {
        return TYPE;
    }

    public BooleanToken isEqualTo(Token token) throws IllegalActionException {
        if (token instanceof ActorToken) {
            return new BooleanToken(this == token);
        }
        throw new IllegalActionException("Equality test not supported between " + this.getClass().getName() + " and " + token.getClass().getName() + ".");
    }

    public String toString() {
        return "ActorToken(" + this._entity + ")";
    }

    public static class ActorType
    implements Type,
    Serializable {
        public Type add(Type rightArgumentType) {
            return this;
        }

        public Object clone() {
            return this;
        }

        public Token convert(Token token) throws IllegalActionException {
            if (token instanceof ActorToken) {
                return token;
            }
            throw new IllegalActionException("Attempt to convert token " + token + " into a test token, which is not possible.");
        }

        public Type divide(Type rightArgumentType) {
            return this;
        }

        public Class getTokenClass() {
            return ActorToken.class;
        }

        public boolean isAbstract() {
            return false;
        }

        public boolean isCompatible(Type type) {
            return type == this;
        }

        public boolean isConstant() {
            return true;
        }

        public boolean equals(Type t) {
            return this == t;
        }

        public int getTypeHash() {
            return Integer.MIN_VALUE;
        }

        public boolean isInstantiable() {
            return true;
        }

        public boolean isSubstitutionInstance(Type type) {
            return this == type;
        }

        public Type modulo(Type rightArgumentType) {
            return this;
        }

        public Type multiply(Type rightArgumentType) {
            return this;
        }

        public Type one() {
            return this;
        }

        public Type subtract(Type rightArgumentType) {
            return this;
        }

        public String toString() {
            return "Actor";
        }

        public Type zero() {
            return this;
        }
    }
}

