/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.parameters;

import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class IntRangeParameter
extends Parameter {
    public Parameter max;
    public Parameter min = new Parameter(this, "min");
    private boolean _inCheck = false;

    public IntRangeParameter(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.min.setExpression("0");
        this.min.setTypeEquals(BaseType.INT);
        this.max = new Parameter(this, "max");
        this.max.setExpression("100");
        this.max.setTypeEquals(BaseType.INT);
        this.setExpression("50");
        this.setTypeEquals(BaseType.INT);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-30\" y=\"-2\" width=\"60\" height=\"4\" style=\"fill:white\"/>\n<rect x=\"15\" y=\"-10\" width=\"4\" height=\"20\" style=\"fill:grey\"/>\n</svg>\n");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.max && !this._inCheck) {
            try {
                this._inCheck = true;
                int maxValue = ((IntToken)this.max.getToken()).intValue();
                if (this.getCurrentValue() <= maxValue) return;
                this.setToken(this.max.getToken());
                return;
            }
            finally {
                this._inCheck = false;
            }
        } else if (attribute == this.min && !this._inCheck) {
            try {
                this._inCheck = true;
                int minValue = ((IntToken)this.min.getToken()).intValue();
                if (this.getCurrentValue() >= minValue) return;
                this.setToken(this.min.getToken());
                return;
            }
            finally {
                this._inCheck = false;
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    public int getCurrentValue() throws IllegalActionException {
        return ((IntToken)this.getToken()).intValue();
    }

    public int getMaxValue() throws IllegalActionException {
        return ((IntToken)this.max.getToken()).intValue();
    }

    public int getMinValue() throws IllegalActionException {
        return ((IntToken)this.min.getToken()).intValue();
    }

    protected void _setTokenAndNotify(Token newToken) throws IllegalActionException {
        if (this._inCheck) {
            super._setTokenAndNotify(newToken);
            return;
        }
        if (newToken instanceof IntToken) {
            try {
                this._inCheck = true;
                int minValue = ((IntToken)this.min.getToken()).intValue();
                int maxValue = ((IntToken)this.max.getToken()).intValue();
                int currentValue = ((IntToken)newToken).intValue();
                if (minValue <= currentValue && currentValue <= maxValue) {
                    super._setTokenAndNotify(newToken);
                    return;
                }
                throw new IllegalActionException((Nameable)this, "Value is required to lie between " + this.min + " and " + this.max + ".");
            }
            finally {
                this._inCheck = false;
            }
        }
        throw new IllegalActionException((Nameable)this, "Value is required to be an integer token.");
    }
}

