/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.data.BooleanToken;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.ExceptionHandler;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.SharedParameter;
import ptolemy.util.StringUtilities;

public class TestExceptionHandler
extends TypedAtomicActor
implements ExceptionHandler {
    public SharedParameter trainingMode;
    public StringParameter correctExceptionMessage = new StringParameter(this, "correctExceptionMessage");
    public static final String TRAINING_MODE_ERROR_MESSAGE = "Training Mode set for test actor and isRunningNightlyBuild()\n  returned true, indicating that the\n  ptolemy.ptII.isRunningNightlyBuild property is set.\n  The trainingMode parameter should not be set in files\n  that are checked into the nightly build!  To run the tests in nightly build mode, use     make nightly";
    private boolean _invoked = false;

    public TestExceptionHandler(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.correctExceptionMessage.setExpression("");
        this.trainingMode = new SharedParameter((NamedObj)this, "trainingMode", this.getClass(), "false");
        this.trainingMode.setTypeEquals(BaseType.BOOLEAN);
        this._invoked = false;
    }

    public boolean handleException(NamedObj context, Throwable exception) throws IllegalActionException {
        if (!(exception instanceof IllegalActionException)) {
            return false;
        }
        this._invoked = true;
        boolean training = ((BooleanToken)this.trainingMode.getToken()).booleanValue();
        if (training) {
            this.correctExceptionMessage.setExpression(exception.getMessage());
            this.correctExceptionMessage.setPersistent(true);
        } else if (!exception.getMessage().equals(this.correctExceptionMessage.stringValue())) {
            throw new IllegalActionException((Nameable)this, exception, null);
        }
        return true;
    }

    public static boolean isRunningNightlyBuild() {
        return StringUtilities.getProperty("ptolemy.ptII.isRunningNightlyBuild").length() > 0;
    }

    public void wrapup() throws IllegalActionException {
        super.wrapup();
        if (((BooleanToken)this.trainingMode.getToken()).booleanValue()) {
            if (TestExceptionHandler.isRunningNightlyBuild()) {
                throw new IllegalActionException((Nameable)this, TRAINING_MODE_ERROR_MESSAGE);
            }
            System.err.println("Warning: '" + this.getFullName() + "' is in training mode, set the trainingMode " + "parameter to false before checking in");
        }
        if (!this._invoked) {
            throw new IllegalActionException((Nameable)this, " should have handled an exception but did not see any.");
        }
        this._invoked = false;
    }
}

