/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.ArrayToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.Token;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.math.SignalProcessing;

public class LevinsonDurbin
extends TypedAtomicActor {
    public TypedIOPort autocorrelation = new TypedIOPort(this, "autocorrelation", true, false);
    public TypedIOPort errorPower = new TypedIOPort(this, "errorPower", false, true);
    public TypedIOPort linearPredictor = new TypedIOPort(this, "linearPredictor", false, true);
    public TypedIOPort reflectionCoefficients = new TypedIOPort(this, "reflectionCoefficients", false, true);

    public LevinsonDurbin(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.autocorrelation.setTypeEquals(new ArrayType(BaseType.DOUBLE));
        this.errorPower.setTypeEquals(new ArrayType(BaseType.DOUBLE));
        this.linearPredictor.setTypeEquals(new ArrayType(BaseType.DOUBLE));
        this.reflectionCoefficients.setTypeEquals(new ArrayType(BaseType.DOUBLE));
    }

    public void fire() throws IllegalActionException {
        super.fire();
        ArrayToken autocorrelationValue = (ArrayToken)this.autocorrelation.get(0);
        int autocorrelationValueLength = autocorrelationValue.length();
        int order = autocorrelationValueLength / 2;
        Token[] power = new DoubleToken[order + 1];
        Token[] refl = new DoubleToken[order];
        Token[] lp = new DoubleToken[order];
        double[] a = new double[order + 1];
        double[] aP = new double[order + 1];
        double[] r = new double[order + 1];
        a[0] = 1.0;
        aP[0] = 1.0;
        int i = 0;
        while (i <= order) {
            r[i] = ((DoubleToken)autocorrelationValue.getElement(autocorrelationValueLength - order + i - 1)).doubleValue();
            ++i;
        }
        double P = r[0];
        power[0] = new DoubleToken(P);
        int M = 0;
        while (M < order) {
            double gamma;
            double deltaM = 0.0;
            int m = 0;
            while (m < M + 1) {
                deltaM += a[m] * r[M + 1 - m];
                ++m;
            }
            if (SignalProcessing.close(P, 0.0)) {
                gamma = 0.0;
                aP[M + 1] = 0.0;
            } else {
                aP[M + 1] = gamma = -deltaM / P;
            }
            refl[M] = new DoubleToken(-gamma);
            m = 1;
            while (m < M + 1) {
                aP[m] = a[m] + gamma * a[M + 1 - m];
                ++m;
            }
            if ((P *= 1.0 - gamma * gamma) < 0.0 || SignalProcessing.close(P, 0.0)) {
                P = 0.0;
            }
            power[M + 1] = new DoubleToken(P);
            double[] temp = a;
            a = aP;
            aP = temp;
            ++M;
        }
        int m = 1;
        while (m <= order) {
            lp[m - 1] = new DoubleToken(-a[m]);
            ++m;
        }
        this.linearPredictor.broadcast(new ArrayToken(BaseType.DOUBLE, lp));
        this.reflectionCoefficients.broadcast(new ArrayToken(BaseType.DOUBLE, refl));
        this.errorPower.broadcast(new ArrayToken(BaseType.DOUBLE, power));
    }

    public boolean prefire() throws IllegalActionException {
        if (!this.autocorrelation.hasToken(0)) {
            return false;
        }
        return super.prefire();
    }
}

