/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.BooleanToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.math.SignalProcessing;

public class DB
extends Transformer {
    public Parameter inputIsPower;
    public Parameter min;
    private DoubleToken[] _resultArray = new DoubleToken[1];

    public DB(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setTypeEquals(BaseType.DOUBLE);
        this.output.setTypeEquals(BaseType.DOUBLE);
        this.inputIsPower = new Parameter((NamedObj)this, "inputIsPower", new BooleanToken(false));
        this.inputIsPower.setTypeEquals(BaseType.BOOLEAN);
        this.min = new Parameter((NamedObj)this, "min", new DoubleToken(-100.0));
        this.min.setTypeEquals(BaseType.DOUBLE);
    }

    public void fire() throws IllegalActionException {
        super.fire();
        if (this.input.hasToken(0)) {
            DoubleToken in = (DoubleToken)this.input.get(0);
            double number = in.doubleValue();
            double minValue = ((DoubleToken)this.min.getToken()).doubleValue();
            this.output.send(0, this._doFunction(number, minValue));
        }
    }

    public int iterate(int count) throws IllegalActionException {
        if (count > this._resultArray.length) {
            this._resultArray = new DoubleToken[count];
        }
        if (this.input.hasToken(0, count)) {
            double minValue = ((DoubleToken)this.min.getToken()).doubleValue();
            Token[] inArray = this.input.get(0, count);
            int i = 0;
            while (i < count) {
                double input = ((DoubleToken)inArray[i]).doubleValue();
                this._resultArray[i] = this._doFunction(input, minValue);
                ++i;
            }
            this.output.send(0, this._resultArray, count);
            return 0;
        }
        return 1;
    }

    private DoubleToken _doFunction(double number, double minValue) throws IllegalActionException {
        double outNumber;
        if (number <= 0.0) {
            outNumber = minValue;
        } else {
            outNumber = SignalProcessing.toDecibels(number);
            if (((BooleanToken)this.inputIsPower.getToken()).booleanValue()) {
                outNumber /= 2.0;
            }
            if (outNumber < minValue) {
                outNumber = minValue;
            }
        }
        return new DoubleToken(outNumber);
    }
}

