/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import ptolemy.actor.Actor;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Executable;
import ptolemy.actor.FiringEvent;
import ptolemy.actor.IOPort;
import ptolemy.actor.Initializable;
import ptolemy.actor.Mailbox;
import ptolemy.actor.Manager;
import ptolemy.actor.NoTokenException;
import ptolemy.actor.Receiver;
import ptolemy.actor.util.Time;
import ptolemy.data.DoubleToken;
import ptolemy.data.Token;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.Workspace;
import ptolemy.math.ExtendedMath;
import ptolemy.moml.SharedParameter;

public class Director
extends Attribute
implements Executable {
    public SharedParameter timeResolution;
    protected Set _actorsFinishedExecution;
    protected Time _currentTime;
    protected transient List<Initializable> _initializables;
    protected boolean _stopRequested = false;
    private double _timeResolution = 1.0E-10;

    public Director() {
        this._addIcon();
        this._initializeParameters();
    }

    public Director(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this._addIcon();
        this._initializeParameters();
    }

    public Director(Workspace workspace) {
        super(workspace);
        this._addIcon();
        this._initializeParameters();
    }

    public void addInitializable(Initializable initializable) {
        if (this._initializables == null) {
            this._initializables = new LinkedList<Initializable>();
        }
        this._initializables.add(initializable);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        double newResolution;
        if (attribute == this.timeResolution && (newResolution = ((DoubleToken)this.timeResolution.getToken()).doubleValue()) != this._timeResolution) {
            Manager.State state;
            Manager manager;
            NamedObj container = this.getContainer();
            if (container instanceof Actor && (manager = ((Actor)((Object)container)).getManager()) != null && (state = manager.getState()) != Manager.IDLE && state != Manager.PREINITIALIZING) {
                throw new IllegalActionException((Nameable)this, "Cannot change timePrecision during a run.");
            }
            if (newResolution <= ExtendedMath.DOUBLE_PRECISION_SMALLEST_NORMALIZED_POSITIVE_DOUBLE) {
                throw new IllegalActionException((Nameable)this, "Invalid timeResolution: " + newResolution + "\n The value must be " + "greater than the smallest, normalized, " + "positive, double value with a double " + "precision: " + ExtendedMath.DOUBLE_PRECISION_SMALLEST_NORMALIZED_POSITIVE_DOUBLE);
            }
            this._timeResolution = newResolution;
        }
        super.attributeChanged(attribute);
    }

    public void fire() throws IllegalActionException {
        NamedObj container;
        if (this._debugging) {
            this._debug("Director: Called fire().");
        }
        if ((container = this.getContainer()) instanceof CompositeActor) {
            Iterator actors = ((CompositeActor)container).deepEntityList().iterator();
            int iterationCount = 1;
            while (actors.hasNext() && !this._stopRequested) {
                Actor actor = (Actor)actors.next();
                if (this._debugging) {
                    this._debug(new FiringEvent(this, actor, FiringEvent.BEFORE_ITERATE, iterationCount));
                }
                if (actor.iterate(1) == 2) {
                    if (!this._debugging) break;
                    this._debug("Actor requests halt: " + actor.getFullName());
                    break;
                }
                if (!this._debugging) continue;
                this._debug(new FiringEvent(this, actor, FiringEvent.AFTER_ITERATE, iterationCount));
            }
        }
    }

    public void fireAt(Actor actor, double time) throws IllegalActionException {
        this.fireAt(actor, new Time(this, time));
    }

    public void fireAt(Actor actor, Time time) throws IllegalActionException {
    }

    public void fireAtCurrentTime(Actor actor) throws IllegalActionException {
        this.fireAt(actor, this.getModelTime());
        if (this._isEmbedded()) {
            CompositeActor container = (CompositeActor)this.getContainer();
            container.getExecutiveDirector().fireAtCurrentTime(container);
        }
    }

    public double getCurrentTime() {
        return this.getModelTime().getDoubleValue();
    }

    public double getErrorTolerance() {
        return 0.0;
    }

    public Time getModelNextIterationTime() {
        Director executiveDirector;
        NamedObj container = this.getContainer();
        if (container instanceof CompositeActor && (executiveDirector = ((CompositeActor)container).getExecutiveDirector()) != null) {
            return executiveDirector.getModelNextIterationTime();
        }
        return this._currentTime;
    }

    public Time getModelStartTime() throws IllegalActionException {
        return new Time(this);
    }

    public Time getModelStopTime() throws IllegalActionException {
        return new Time(this, Double.POSITIVE_INFINITY);
    }

    public Time getModelTime() {
        return this._currentTime;
    }

    public double getNextIterationTime() {
        return this.getModelNextIterationTime().getDoubleValue();
    }

    public double getStartTime() throws IllegalActionException {
        return 0.0;
    }

    public double getStopTime() throws IllegalActionException {
        return this.getModelStopTime().getDoubleValue();
    }

    public final double getTimeResolution() {
        return this._timeResolution;
    }

    public void initialize() throws IllegalActionException {
        if (this._debugging) {
            this._debug("Called initialize().");
        }
        if (this._initializables != null) {
            for (Initializable initializable : this._initializables) {
                initializable.initialize();
            }
        }
        this._actorsFinishedExecution = new HashSet();
        NamedObj container = this.getContainer();
        if (container instanceof CompositeActor) {
            Time currentTime;
            NamedObj containersContainer = container.getContainer();
            this._currentTime = containersContainer instanceof CompositeActor ? (currentTime = ((CompositeActor)containersContainer).getDirector().getModelTime()) : this.getModelStartTime();
            Iterator actors = ((CompositeActor)container).deepEntityList().iterator();
            while (actors.hasNext() && !this._stopRequested) {
                Actor actor = (Actor)actors.next();
                if (this._debugging) {
                    this._debug("Invoking initialize(): ", ((NamedObj)((Object)actor)).getFullName());
                }
                this.initialize(actor);
            }
        }
    }

    public void initialize(Actor actor) throws IllegalActionException {
        if (this._debugging) {
            this._debug("Initializing actor: " + actor.getFullName() + ".");
        }
        actor.initialize();
    }

    public void invalidateResolvedTypes() {
        Manager manager;
        NamedObj container = this.getContainer();
        if (container instanceof CompositeActor && (manager = ((CompositeActor)container).getManager()) != null) {
            manager.invalidateResolvedTypes();
        }
    }

    public void invalidateSchedule() {
    }

    public boolean isFireFunctional() {
        return false;
    }

    public boolean isStrict() {
        return true;
    }

    public boolean isStopRequested() {
        return this._stopRequested;
    }

    public int iterate(int count) throws IllegalActionException {
        int n = 0;
        while (n++ < count && !this._stopRequested) {
            if (this.prefire()) {
                this.fire();
                if (this.postfire()) continue;
                return 2;
            }
            return 1;
        }
        if (this._stopRequested) {
            return 2;
        }
        return 0;
    }

    public Receiver newReceiver() {
        return new Mailbox();
    }

    public boolean postfire() throws IllegalActionException {
        if (this._debugging) {
            this._debug("Director: Called postfire().");
        }
        return !this._stopRequested;
    }

    public boolean prefire() throws IllegalActionException {
        Time outTime;
        Director executiveDirector;
        NamedObj container;
        if (this._debugging) {
            this._debug("Director: Called prefire().");
        }
        if ((container = this.getContainer()) instanceof Actor && (executiveDirector = ((Actor)((Object)container)).getExecutiveDirector()) != null && this._currentTime.compareTo(outTime = executiveDirector.getModelTime()) < 0) {
            this.setModelTime(outTime);
        }
        return true;
    }

    public void preinitialize() throws IllegalActionException {
        if (this._debugging) {
            this._debug(this.getFullName(), "Preinitializing ...");
        }
        if (this._initializables != null) {
            for (Initializable initializable : this._initializables) {
                initializable.preinitialize();
            }
        }
        for (Settable attribute : this.attributeList(Settable.class)) {
            attribute.validate();
        }
        this._currentTime = this.getModelStartTime();
        this._stopRequested = false;
        NamedObj container = this.getContainer();
        if (container instanceof CompositeActor) {
            for (Actor actor : ((CompositeActor)container).deepEntityList()) {
                if (this._debugging) {
                    this._debug("Invoking preinitialize(): ", ((NamedObj)((Object)actor)).getFullName());
                }
                actor.preinitialize();
            }
        }
        if (this._debugging) {
            this._debug(this.getFullName(), "Finished preinitialize().");
        }
    }

    public void removeInitializable(Initializable initializable) {
        if (this._initializables != null) {
            this._initializables.remove(initializable);
            if (this._initializables.size() == 0) {
                this._initializables = null;
            }
        }
    }

    public void requestInitialization(Actor actor) {
        Manager manager;
        NamedObj container = this.getContainer();
        if (container instanceof CompositeActor && (manager = ((CompositeActor)container).getManager()) != null) {
            manager.requestInitialization(actor);
        }
    }

    public void setContainer(NamedObj container) throws IllegalActionException, NameDuplicationException {
        try {
            this._workspace.getWriteAccess();
            NamedObj oldContainer = this.getContainer();
            if (oldContainer instanceof CompositeActor && oldContainer != container) {
                Director previous = null;
                CompositeActor castContainer = (CompositeActor)oldContainer;
                for (Director altDirector : castContainer.attributeList(Director.class)) {
                    if (altDirector == this) continue;
                    previous = altDirector;
                }
                castContainer._setDirector(previous);
            }
            super.setContainer(container);
            if (container instanceof CompositeActor) {
                ((CompositeActor)container)._setDirector(this);
            }
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    public void setCurrentTime(double newTime) throws IllegalActionException {
        this.setModelTime(new Time(this, newTime));
    }

    public void setModelTime(Time newTime) throws IllegalActionException {
        int comparisonResult = this._currentTime.compareTo(newTime);
        if (comparisonResult > 0) {
            throw new IllegalActionException((Nameable)this, "Attempt to move current time backwards. (new time = " + newTime + ") < (current time = " + this.getModelTime() + ")");
        }
        if (comparisonResult < 0) {
            if (this._debugging) {
                this._debug("==== Set current time to: " + newTime);
            }
            this._currentTime = newTime;
        }
    }

    public void stop() {
        this._stopRequested = true;
        NamedObj container = this.getContainer();
        if (container instanceof CompositeActor) {
            for (Actor actor : ((CompositeActor)container).deepEntityList()) {
                actor.stop();
            }
        }
    }

    public void stopFire() {
        NamedObj container = this.getContainer();
        if (container instanceof CompositeActor) {
            for (Actor actor : ((CompositeActor)container).deepEntityList()) {
                actor.stopFire();
            }
        }
    }

    public String[] suggestedModalModelDirectors() {
        String[] defaultSuggestions = new String[]{"ptolemy.domains.fsm.kernel.FSMDirector"};
        return defaultSuggestions;
    }

    public boolean supportMultirateFiring() {
        return false;
    }

    public void terminate() {
        NamedObj container = this.getContainer();
        if (container instanceof CompositeActor) {
            for (Actor actor : ((CompositeActor)container).deepEntityList()) {
                actor.terminate();
            }
        }
    }

    public boolean transferInputs(IOPort port) throws IllegalActionException {
        return this._transferInputs(port);
    }

    public boolean transferOutputs(IOPort port) throws IllegalActionException {
        return this._transferOutputs(port);
    }

    public void wrapup() throws IllegalActionException {
        NamedObj container;
        if (this._debugging) {
            this._debug("Director: Called wrapup().");
        }
        if (this._initializables != null) {
            for (Initializable initializable : this._initializables) {
                initializable.wrapup();
            }
        }
        if ((container = this.getContainer()) instanceof CompositeActor) {
            for (Actor actor : ((CompositeActor)container).deepEntityList()) {
                actor.wrapup();
            }
        }
    }

    protected String _description(int detail, int indent, int bracket) {
        try {
            this._workspace.getReadAccess();
            String result = bracket == 1 || bracket == 2 ? super._description(detail, indent, 1) : super._description(detail, indent, 0);
            if (bracket == 2) {
                result = String.valueOf(result) + "}";
            }
            String string = result;
            return string;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    protected boolean _isEmbedded() {
        return !this._isTopLevel();
    }

    protected boolean _isTopLevel() {
        NamedObj container = this.getContainer();
        if (container instanceof CompositeActor) {
            return ((CompositeActor)container).getExecutiveDirector() == null;
        }
        return true;
    }

    protected boolean _transferInputs(IOPort port) throws IllegalActionException {
        if (this._debugging) {
            this._debug("Calling transferInputs on port: " + port.getFullName());
        }
        if (!port.isInput() || !port.isOpaque()) {
            throw new IllegalActionException((Nameable)this, port, "Attempted to transferInputs on a port is not an opaqueinput port.");
        }
        boolean wasTransferred = false;
        int i = 0;
        while (i < port.getWidth()) {
            try {
                if (i < port.getWidthInside()) {
                    if (port.hasToken(i)) {
                        Token t = port.get(i);
                        if (this._debugging) {
                            this._debug(this.getName(), "transferring input from " + port.getName());
                        }
                        port.sendInside(i, t);
                        wasTransferred = true;
                    }
                } else {
                    if (this._debugging) {
                        this._debug(this.getName(), "Dropping single input from " + port.getName());
                    }
                    if (port.hasToken(i)) {
                        port.get(i);
                    }
                }
            }
            catch (NoTokenException ex) {
                throw new InternalErrorException(this, (Throwable)ex, null);
            }
            ++i;
        }
        return wasTransferred;
    }

    protected boolean _transferOutputs(IOPort port) throws IllegalActionException {
        boolean result = false;
        if (this._debugging) {
            this._debug("Calling transferOutputs on port: " + port.getFullName());
        }
        if (!port.isOutput() || !port.isOpaque()) {
            throw new IllegalActionException((Nameable)this, port, "Attempted to transferOutputs on a port that is not an opaque input port.");
        }
        int i = 0;
        while (i < port.getWidthInside()) {
            try {
                if (port.hasTokenInside(i)) {
                    Token t = port.getInside(i);
                    if (this._debugging) {
                        this._debug(this.getName(), "transferring output from " + port.getName());
                    }
                    port.send(i, t);
                    result = true;
                }
            }
            catch (NoTokenException ex) {
                throw new InternalErrorException(this, (Throwable)ex, null);
            }
            ++i;
        }
        return result;
    }

    private void _addIcon() {
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-50\" y=\"-15\" width=\"100\" height=\"30\" style=\"fill:green\"/>\n</svg>\n");
    }

    private void _initializeParameters() {
        try {
            this.timeResolution = new SharedParameter((NamedObj)this, "timeResolution", Director.class, "1E-10");
            this.timeResolution.setVisibility(Settable.NONE);
            this._currentTime = new Time(this, Double.NEGATIVE_INFINITY);
        }
        catch (Throwable throwable) {
            throw new InternalErrorException(this, throwable, "Cannot set timeResolution parameter");
        }
    }
}

