/*
 * Decompiled with CFR 0.152.
 */
package diva.gui.toolbox;

import diva.canvas.CanvasLayer;
import diva.canvas.CanvasUtilities;
import diva.canvas.JCanvas;
import diva.canvas.demo.SimplePane;
import diva.util.java2d.ShapeUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class JCanvasPanner
extends JPanel {
    private JCanvas _target = null;

    public JCanvasPanner() {
        this((JCanvas)null);
    }

    public JCanvasPanner(JCanvas target) {
        this.setCanvas(target);
        this.addMouseListener(new PanMouseListener());
        this.addMouseMotionListener(new PanMouseListener());
    }

    public Rectangle2D getViewSize() {
        Rectangle2D viewRect = null;
        Iterator layers = this._target.getCanvasPane().layers();
        while (layers.hasNext()) {
            CanvasLayer layer = (CanvasLayer)layers.next();
            Rectangle2D rect = layer.getLayerBounds();
            if (rect.isEmpty()) continue;
            if (viewRect == null) {
                viewRect = rect;
                continue;
            }
            viewRect.add(rect);
        }
        if (viewRect == null) {
            return this.getVisibleSize();
        }
        return viewRect;
    }

    public Rectangle2D getVisibleSize() {
        AffineTransform inverse;
        AffineTransform current = this._target.getCanvasPane().getTransformContext().getTransform();
        try {
            inverse = current.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException(e.toString());
        }
        Dimension size = this._target.getSize();
        Rectangle2D.Double visibleRect = new Rectangle2D.Double(0.0, 0.0, size.getWidth(), size.getHeight());
        return ShapeUtilities.transformBounds(visibleRect, inverse);
    }

    public void setPosition(int x, int y) {
        AffineTransform inverse;
        Rectangle2D viewRect = this.getViewSize();
        Rectangle2D visibleRect = this.getVisibleSize();
        Rectangle myRect = this._getInsetBounds();
        AffineTransform forward = CanvasUtilities.computeFitTransform(viewRect, myRect);
        try {
            inverse = forward.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException(e.toString());
        }
        Point2D.Double newCenter = new Point2D.Double(x, y);
        inverse.transform(newCenter, newCenter);
        AffineTransform newTransform = this._target.getCanvasPane().getTransformContext().getTransform();
        newTransform.translate(visibleRect.getCenterX() - ((Point2D)newCenter).getX(), visibleRect.getCenterY() - ((Point2D)newCenter).getY());
        this._target.getCanvasPane().setTransform(newTransform);
        this.repaint();
    }

    public void setCanvas(JCanvas target) {
        this._target = target;
        this.repaint();
    }

    public JCanvas getCanvas() {
        return this._target;
    }

    public void paintComponent(Graphics g) {
        if (this._target != null) {
            AffineTransform inverse;
            JCanvas canvas = this._target;
            Rectangle2D viewRect = this.getViewSize();
            Rectangle myRect = this._getInsetBounds();
            AffineTransform forward = CanvasUtilities.computeFitTransform(viewRect, myRect);
            AffineTransform current = canvas.getCanvasPane().getTransformContext().getTransform();
            try {
                forward.concatenate(current.createInverse());
                inverse = forward.createInverse();
            }
            catch (NoninvertibleTransformException e) {
                throw new RuntimeException(e.toString());
            }
            Graphics2D g2d = (Graphics2D)g;
            g2d.transform(forward);
            canvas.paint(g);
            g2d.transform(inverse);
            Dimension size = this._target.getSize();
            Rectangle2D visibleRect = new Rectangle2D.Double(0.0, 0.0, size.getWidth(), size.getHeight());
            visibleRect = ShapeUtilities.transformBounds(visibleRect, forward);
            g.setColor(Color.red);
            g.drawRect((int)visibleRect.getX(), (int)visibleRect.getY(), (int)visibleRect.getWidth(), (int)visibleRect.getHeight());
        } else {
            Rectangle r = this._getInsetBounds();
            g.clearRect(r.x, r.y, r.width, r.height);
        }
    }

    private Rectangle _getInsetBounds() {
        Dimension mySize = this.getSize();
        Insets insets = this.getInsets();
        int border = 2;
        Rectangle myRect = new Rectangle(insets.left + border, insets.top + border, mySize.width - insets.top - insets.bottom - border, mySize.height - insets.left - insets.right - border);
        return myRect;
    }

    public static void main(String[] argv) {
        try {
            Runnable doActions = new Runnable(){

                public void run() {
                    try {
                        JFrame f = new JFrame();
                        SimplePane rootPane = new SimplePane();
                        JCanvas canvas = new JCanvas(rootPane);
                        canvas.setSize(200, 200);
                        JCanvasPanner pan = new JCanvasPanner(canvas);
                        pan.setSize(50, 50);
                        pan.setPreferredSize(new Dimension(50, 50));
                        f.getContentPane().setLayout(new GridLayout(2, 1));
                        f.getContentPane().add(canvas);
                        f.getContentPane().add(pan);
                        f.pack();
                        f.setVisible(true);
                    }
                    catch (Exception ex) {
                        System.err.println(ex.toString());
                        ex.printStackTrace();
                    }
                }
            };
            SwingUtilities.invokeAndWait(doActions);
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
            ex.printStackTrace();
        }
    }

    private class PanMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private PanMouseListener() {
        }

        public void mousePressed(MouseEvent evt) {
            if (JCanvasPanner.this._target != null && (evt.getModifiers() & 0x10) != 0) {
                JCanvasPanner.this.setPosition(evt.getX(), evt.getY());
            }
        }

        public void mouseMoved(MouseEvent evt) {
        }

        public void mouseDragged(MouseEvent evt) {
            if (JCanvasPanner.this._target != null && (evt.getModifiers() & 0x10) != 0) {
                JCanvasPanner.this.setPosition(evt.getX(), evt.getY());
            }
        }
    }
}

